/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.serialization.standard.io.surrogates;

import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import com.alachisoft.ncache.serialization.core.io.surrogates.BuiltinSerializationSurrogate;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheIOException;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheInstantiationException;
import com.alachisoft.ncache.serialization.core.io.surrogates.SerializationSurrogateImpl;
import java.io.IOException;
import java.util.Collection;

public abstract class CollectionSerializationSurrogate<E>
extends SerializationSurrogateImpl
implements BuiltinSerializationSurrogate {
    public CollectionSerializationSurrogate(Class<? extends Collection<E>> cls) {
        super(cls);
    }

    @Override
    public Object readDirect(NCacheObjectInput input, Object graph) throws NCacheInstantiationException, NCacheIOException {
        Collection object = (Collection)graph;
        Object item = null;
        try {
            int len = input.readInt();
            for (int i = 0; i < len; ++i) {
                item = input.readObject();
                object.add(item);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new NCacheIOException(ex);
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
        return graph;
    }

    @Override
    public void writeDirect(NCacheObjectOutput output, Object graph) throws NCacheIOException {
        Collection object = (Collection)graph;
        int len = object.size();
        try {
            output.writeInt(len);
            if (len > 0) {
                Object[] obj = object.toArray();
                for (int i = 0; i < obj.length; ++i) {
                    output.writeObject(obj[i]);
                }
            }
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }

    @Override
    public void skipDirect(NCacheObjectInput input, Object graph) throws NCacheInstantiationException, NCacheIOException {
        try {
            int len = input.readInt();
            for (int i = 0; i < len; ++i) {
                input.skipObject();
            }
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }
}

