/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.serialization.standard.io.surrogates;

import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import com.alachisoft.ncache.serialization.core.io.surrogates.BuiltinSerializationSurrogate;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheIOException;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheInstantiationException;
import com.alachisoft.ncache.serialization.core.io.surrogates.SerializationSurrogate;
import com.alachisoft.ncache.serialization.core.io.surrogates.SerializationSurrogateImpl;
import com.alachisoft.ncache.serialization.standard.io.TypeSurrogateSelectorImpl;
import java.io.IOException;
import java.lang.reflect.Array;

public class ObjectArraySerializationSurrogate
extends SerializationSurrogateImpl
implements BuiltinSerializationSurrogate {
    public static final short HARD_HANDLE = -32765;

    public ObjectArraySerializationSurrogate() {
        super(Object[].class);
    }

    @Override
    public Object instantiate(NCacheObjectInput input) throws NCacheInstantiationException {
        try {
            int length = input.readInt();
            return new Object[length];
        }
        catch (IOException ex) {
            throw new NCacheInstantiationException(ex);
        }
    }

    @Override
    public Object readDirect(NCacheObjectInput input, Object graph) throws NCacheInstantiationException, NCacheIOException {
        try {
            Object[] array = (Object[])graph;
            TypeSurrogateSelectorImpl mSelector = TypeSurrogateSelectorImpl.getDefault();
            short typeHandle = input.readShort();
            SerializationSurrogate surrogate = mSelector.getSurrogateForTypeHandle(typeHandle, input.getCacheContext());
            if (surrogate == null) {
                surrogate = mSelector.GetSurrogateForSubTypeHandle(typeHandle, input.readShort(), input.getCacheContext());
            }
            Class className = surrogate.getRealClass();
            Object obj = Array.newInstance(className, array.length);
            int len = array.length;
            for (int i = 0; i < len; ++i) {
                Array.set(obj, i, input.readObject());
            }
            return obj;
        }
        catch (ClassNotFoundException ex) {
            throw new NCacheInstantiationException(ex);
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }

    @Override
    public void writeDirect(NCacheObjectOutput output, Object graph) throws NCacheIOException {
        try {
            Object[] array = (Object[])graph;
            int len = array.length;
            output.writeInt(len);
            TypeSurrogateSelectorImpl mSelector = TypeSurrogateSelectorImpl.getDefault();
            Object[] o = (Object[])graph;
            Object[] tempObject = new Object[2];
            if (graph.getClass() != tempObject.getClass()) {
                Object obj = null;
                for (int i = 0; i < o.length; ++i) {
                    if (o[i] == null) continue;
                    obj = o[i];
                    break;
                }
                SerializationSurrogate surrogateTemp = mSelector.getSurrogateForObject(obj, output.getCacheContext());
                surrogateTemp.writeHandle(output, obj);
                if (surrogateTemp.getSubHandle() > 0) {
                    surrogateTemp.writeSubHandle(output, obj);
                }
            } else {
                SerializationSurrogate surrogateTemp = mSelector.getDefaultSurrogate();
                surrogateTemp.writeHandle(output, new Object());
            }
            for (int i = 0; i < len; ++i) {
                try {
                    output.writeObject(array[i]);
                    continue;
                }
                catch (IOException ex) {
                    throw new NCacheIOException(ex);
                }
            }
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }

    @Override
    public void skipDirect(NCacheObjectInput input, Object graph) throws NCacheInstantiationException, NCacheIOException {
        try {
            Object[] array = (Object[])graph;
            TypeSurrogateSelectorImpl mSelector = TypeSurrogateSelectorImpl.getDefault();
            short typeHandle = input.readShort();
            SerializationSurrogate surrogate = mSelector.getSurrogateForTypeHandle(typeHandle, input.getCacheContext());
            if (surrogate == null) {
                surrogate = mSelector.GetSurrogateForSubTypeHandle(typeHandle, input.readShort(), input.getCacheContext());
            }
            Class className = surrogate.getRealClass();
            int len = array.length;
            for (int i = 0; i < len; ++i) {
                input.skipObject();
            }
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }
}

