/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.serialization.standard.io.surrogates;

import com.alachisoft.ncache.serialization.core.io.ExtendedObjectInputStream;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import com.alachisoft.ncache.serialization.core.io.surrogates.BuiltinSerializationSurrogate;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheIOException;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheInstantiationException;
import com.alachisoft.ncache.serialization.core.io.surrogates.SerializationSurrogate;
import com.alachisoft.ncache.serialization.core.io.surrogates.SerializationSurrogateBase;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class ObjectSerializationSurrogate
extends SerializationSurrogateBase
implements SerializationSurrogate,
BuiltinSerializationSurrogate {
    public static final short HARD_HANDLE = Short.MIN_VALUE;

    public ObjectSerializationSurrogate(Class type) {
        super(type);
    }

    @Override
    public Object readObject(NCacheObjectInput input) throws NCacheInstantiationException, NCacheIOException {
        try {
            Integer cookie = input.readInt();
            Object custom = input.getContext().getObject(cookie);
            if (custom == null) {
                int length = input.readInt();
                byte check = input.readByte();
                if (check == 1 || check == 0 && length == 0) {
                    ExtendedObjectInputStream nativeReader = new ExtendedObjectInputStream(input.getBaseStream());
                    custom = nativeReader.readObject();
                    input.getContext().rememberForRead(custom);
                } else {
                    input.skipBytes(length);
                }
            }
            return custom;
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
        catch (ClassNotFoundException ex) {
            throw new NCacheInstantiationException(ex);
        }
    }

    @Override
    public void writeObject(NCacheObjectOutput output, Object graph) throws NCacheIOException {
        try {
            Integer cookie = output.getContext().getCookie(graph);
            if (cookie != -1) {
                output.writeInt(cookie);
                return;
            }
            cookie = output.getContext().rememberForWrite(graph);
            output.writeInt(cookie);
            ByteArrayOutputStream val = new ByteArrayOutputStream();
            ObjectOutputStream nativeWriter = new ObjectOutputStream(val);
            nativeWriter.writeObject(graph);
            nativeWriter.flush();
            output.writeInt(val.toByteArray().length);
            output.writeByte(1);
            output.write(val.toByteArray());
            output.flush();
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }

    @Override
    public void skipObject(NCacheObjectInput input) throws NCacheInstantiationException, NCacheIOException {
        try {
            Integer cookie = input.readInt();
            Object custom = input.getContext().getObject(cookie);
            if (custom == null) {
                int length = input.readInt();
                byte check = input.readByte();
                if (check == 1 || check == 0 && length == 0) {
                    ObjectInputStream nativeReader = new ObjectInputStream(input.getBaseStream());
                    custom = nativeReader.readObject();
                    input.getContext().rememberForRead(custom);
                } else {
                    input.skipBytes(length);
                }
            }
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
        catch (ClassNotFoundException ex) {
            throw new NCacheInstantiationException(ex);
        }
    }
}

