/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.serialization.standard.io.surrogates;

import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import com.alachisoft.ncache.serialization.core.io.surrogates.BuiltinSerializationSurrogate;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheIOException;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheInstantiationException;
import com.alachisoft.ncache.serialization.core.io.surrogates.SerializationSurrogateImpl;
import java.io.IOException;
import java.math.BigInteger;

public class UInt64ArraySerializationSurrogate
extends SerializationSurrogateImpl
implements BuiltinSerializationSurrogate {
    public UInt64ArraySerializationSurrogate() {
        super(UInt64ArraySerializationSurrogate.class);
    }

    @Override
    public Object instantiate(NCacheObjectInput input) throws NCacheInstantiationException {
        try {
            int length = input.readInt();
            return new BigInteger[length];
        }
        catch (IOException ex) {
            throw new NCacheInstantiationException(ex);
        }
    }

    @Override
    public Object readDirect(NCacheObjectInput input, Object graph) throws NCacheInstantiationException, NCacheIOException {
        try {
            BigInteger[] bigInteger = (BigInteger[])graph;
            for (int i = 0; i < bigInteger.length; ++i) {
                bigInteger[i] = input.readUInt64();
            }
            return bigInteger;
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }

    @Override
    public void writeDirect(NCacheObjectOutput output, Object graph) throws NCacheIOException {
        try {
            BigInteger[] bigIntger = (BigInteger[])graph;
            output.writeInt(bigIntger.length);
            for (int i = 0; i < bigIntger.length; ++i) {
                output.writeUInt64(bigIntger[i]);
            }
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }

    @Override
    public void skipDirect(NCacheObjectInput input, Object graph) throws NCacheInstantiationException, NCacheIOException {
        try {
            BigInteger[] bigInteger = (BigInteger[])graph;
            for (int i = 0; i < bigInteger.length; ++i) {
                input.skipUInt64();
            }
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }
}

