/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.serialization.standard.io.surrogates;

import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import com.alachisoft.ncache.serialization.core.io.surrogates.BuiltinSerializationSurrogate;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheIOException;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheInstantiationException;
import com.alachisoft.ncache.serialization.core.io.surrogates.SerializationSurrogateImpl;
import java.io.IOException;

public class UnsignedByteArraySerializationSurrogate
extends SerializationSurrogateImpl
implements BuiltinSerializationSurrogate {
    public UnsignedByteArraySerializationSurrogate() {
        super(UnsignedByteArraySerializationSurrogate.class);
    }

    @Override
    public Object instantiate(NCacheObjectInput input) throws NCacheInstantiationException {
        try {
            int length = input.readInt();
            return new short[length];
        }
        catch (IOException ex) {
            throw new NCacheInstantiationException(ex);
        }
    }

    @Override
    public Object readDirect(NCacheObjectInput input, Object graph) throws NCacheInstantiationException, NCacheIOException {
        try {
            short[] array = (short[])graph;
            for (int i = 0; i < array.length; ++i) {
                array[i] = input.readUByte();
            }
            return array;
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }

    @Override
    public void writeDirect(NCacheObjectOutput output, Object graph) throws NCacheIOException {
        try {
            short[] array = (short[])graph;
            output.writeInt(array.length);
            for (int i = 0; i < array.length; ++i) {
                output.writeUByte(array[i]);
            }
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }

    @Override
    public void skipDirect(NCacheObjectInput input, Object graph) throws NCacheInstantiationException, NCacheIOException {
        try {
            short[] array = (short[])graph;
            for (int i = 0; i < array.length; ++i) {
                input.skipUByte();
            }
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }
}

