
# Autogenerated by mlir-tblgen; don't manually edit.

from ._ods_common import _cext as _ods_cext
from ._ods_common import (
    equally_sized_accessor as _ods_equally_sized_accessor,
    get_default_loc_context as _ods_get_default_loc_context,
    get_op_result_or_op_results as _get_op_result_or_op_results,
    get_op_result_or_value as _get_op_result_or_value,
    get_op_results_or_values as _get_op_results_or_values,
    segmented_accessor as _ods_segmented_accessor,
)
_ods_ir = _ods_cext.ir

import builtins
from typing import Sequence as _Sequence, Union as _Union


@_ods_cext.register_dialect
class _Dialect(_ods_ir.Dialect):
  DIALECT_NAMESPACE = "vector"

@_ods_cext.register_operation(_Dialect)
class VectorScaleOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.vscale"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def res(self):
    return self.operation.results[0]

def vscale(*, loc=None, ip=None) -> _ods_ir.Value:
  return VectorScaleOp(loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BitCastOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.bitcast"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, source, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def bitcast(result, source, *, loc=None, ip=None) -> _ods_ir.Value:
  return BitCastOp(result=result, source=source, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BroadcastOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.broadcast"

  _ODS_REGIONS = (0, True)

  def __init__(self, vector, source, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(vector)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def vector(self):
    return self.operation.results[0]

def broadcast(vector, source, *, loc=None, ip=None) -> _ods_ir.Value:
  return BroadcastOp(vector=vector, source=source, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class CompressStoreOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.compressstore"

  _ODS_REGIONS = (0, True)

  def __init__(self, base, indices, mask, valueToStore, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(base))
    operands.extend(_get_op_results_or_values(indices))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(valueToStore))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def base(self):
    return self.operation.operands[0]

  @builtins.property
  def indices(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def mask(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[2 + _ods_variadic_group_length - 1]

  @builtins.property
  def valueToStore(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[3 + _ods_variadic_group_length - 1]

def compressstore(base, indices, mask, value_to_store, *, loc=None, ip=None) -> _ods_ir.Operation:
  return CompressStoreOp(base=base, indices=indices, mask=mask, valueToStore=value_to_store, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class ConstantMaskOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.constant_mask"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, mask_dim_sizes, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["mask_dim_sizes"] = (mask_dim_sizes if (
    isinstance(mask_dim_sizes, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(mask_dim_sizes, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def mask_dim_sizes(self):
    return self.operation.attributes["mask_dim_sizes"]

  @mask_dim_sizes.setter
  def mask_dim_sizes(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["mask_dim_sizes"] = value

def constant_mask(result, mask_dim_sizes, *, loc=None, ip=None) -> _ods_ir.Value:
  return ConstantMaskOp(result=result, mask_dim_sizes=mask_dim_sizes, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ContractionOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.contract"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, lhs, rhs, acc, indexing_maps, iterator_types, *, kind=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    operands.append(_get_op_result_or_value(acc))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["indexing_maps"] = (indexing_maps if (
    isinstance(indexing_maps, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('ArrayAttr')) else
      _ods_ir.AttrBuilder.get('ArrayAttr')(indexing_maps, context=_ods_context))
    attributes["iterator_types"] = (iterator_types if (
    isinstance(iterator_types, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('Vector_IteratorTypeArrayAttr')) else
      _ods_ir.AttrBuilder.get('Vector_IteratorTypeArrayAttr')(iterator_types, context=_ods_context))
    if kind is not None: attributes["kind"] = (kind if (
        isinstance(kind, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Vector_CombiningKindAttr')) else
          _ods_ir.AttrBuilder.get('Vector_CombiningKindAttr')(kind, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def acc(self):
    return self.operation.operands[2]

  @builtins.property
  def indexing_maps(self):
    return self.operation.attributes["indexing_maps"]

  @indexing_maps.setter
  def indexing_maps(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["indexing_maps"] = value

  @builtins.property
  def iterator_types(self):
    return self.operation.attributes["iterator_types"]

  @iterator_types.setter
  def iterator_types(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["iterator_types"] = value

  @builtins.property
  def kind(self):
    return self.operation.attributes["kind"]

  @kind.setter
  def kind(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["kind"] = value

def contract(result, lhs, rhs, acc, indexing_maps, iterator_types, *, kind=None, loc=None, ip=None) -> _ods_ir.Value:
  return ContractionOp(result=result, lhs=lhs, rhs=rhs, acc=acc, indexing_maps=indexing_maps, iterator_types=iterator_types, kind=kind, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class CreateMaskOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.create_mask"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, operands_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(operands_))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operands_(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

def create_mask(result, operands_, *, loc=None, ip=None) -> _ods_ir.Value:
  return CreateMaskOp(result=result, operands_=operands_, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class DeinterleaveOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.deinterleave"

  _ODS_REGIONS = (0, True)

  def __init__(self, source, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def res1(self):
    return self.operation.results[0]

  @builtins.property
  def res2(self):
    return self.operation.results[1]

def deinterleave(source, *, loc=None, ip=None) -> _Sequence[_ods_ir.Value]:
  return DeinterleaveOp(source=source, loc=loc, ip=ip).results

@_ods_cext.register_operation(_Dialect)
class ExpandLoadOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.expandload"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, base, indices, mask, pass_thru, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(base))
    operands.extend(_get_op_results_or_values(indices))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(pass_thru))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def base(self):
    return self.operation.operands[0]

  @builtins.property
  def indices(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def mask(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[2 + _ods_variadic_group_length - 1]

  @builtins.property
  def pass_thru(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[3 + _ods_variadic_group_length - 1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def expandload(result, base, indices, mask, pass_thru, *, loc=None, ip=None) -> _ods_ir.Value:
  return ExpandLoadOp(result=result, base=base, indices=indices, mask=mask, pass_thru=pass_thru, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ExtractElementOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.extractelement"

  _ODS_REGIONS = (0, True)

  def __init__(self, vector, *, position=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(vector))
    if position is not None: operands.append(_get_op_result_or_value(position))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def vector(self):
    return self.operation.operands[0]

  @builtins.property
  def position(self):
    return None if len(self.operation.operands) < 2 else self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def extractelement(vector, *, position=None, loc=None, ip=None) -> _ods_ir.Value:
  return ExtractElementOp(vector=vector, position=position, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ExtractOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.extract"

  _ODS_REGIONS = (0, True)

  def __init__(self, vector, dynamic_position, static_position, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(vector))
    operands.extend(_get_op_results_or_values(dynamic_position))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["static_position"] = (static_position if (
    isinstance(static_position, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(static_position, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def vector(self):
    return self.operation.operands[0]

  @builtins.property
  def dynamic_position(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def static_position(self):
    return self.operation.attributes["static_position"]

  @static_position.setter
  def static_position(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["static_position"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def extract(vector, dynamic_position, static_position, *, loc=None, ip=None) -> _ods_ir.Value:
  return ExtractOp(vector=vector, dynamic_position=dynamic_position, static_position=static_position, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ExtractStridedSliceOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.extract_strided_slice"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, vector, offsets, sizes, strides, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(vector))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["offsets"] = (offsets if (
    isinstance(offsets, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('I64ArrayAttr')(offsets, context=_ods_context))
    attributes["sizes"] = (sizes if (
    isinstance(sizes, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('I64ArrayAttr')(sizes, context=_ods_context))
    attributes["strides"] = (strides if (
    isinstance(strides, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('I64ArrayAttr')(strides, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def vector(self):
    return self.operation.operands[0]

  @builtins.property
  def offsets(self):
    return self.operation.attributes["offsets"]

  @offsets.setter
  def offsets(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["offsets"] = value

  @builtins.property
  def sizes(self):
    return self.operation.attributes["sizes"]

  @sizes.setter
  def sizes(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sizes"] = value

  @builtins.property
  def strides(self):
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["strides"] = value

def extract_strided_slice(result, vector, offsets, sizes, strides, *, loc=None, ip=None) -> _ods_ir.Value:
  return ExtractStridedSliceOp(result=result, vector=vector, offsets=offsets, sizes=sizes, strides=strides, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class FMAOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.fma"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, acc, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    operands.append(_get_op_result_or_value(acc))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def acc(self):
    return self.operation.operands[2]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def fma(lhs, rhs, acc, *, loc=None, ip=None) -> _ods_ir.Value:
  return FMAOp(lhs=lhs, rhs=rhs, acc=acc, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class FlatTransposeOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.flat_transpose"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, matrix, rows, columns, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(matrix))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["rows"] = (rows if (
    isinstance(rows, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(rows, context=_ods_context))
    attributes["columns"] = (columns if (
    isinstance(columns, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(columns, context=_ods_context))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def matrix(self):
    return self.operation.operands[0]

  @builtins.property
  def rows(self):
    return self.operation.attributes["rows"]

  @rows.setter
  def rows(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["rows"] = value

  @builtins.property
  def columns(self):
    return self.operation.attributes["columns"]

  @columns.setter
  def columns(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["columns"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def flat_transpose(res, matrix, rows, columns, *, loc=None, ip=None) -> _ods_ir.Value:
  return FlatTransposeOp(res=res, matrix=matrix, rows=rows, columns=columns, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class FromElementsOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.from_elements"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, elements, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(elements))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def elements(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def from_elements(result, elements, *, loc=None, ip=None) -> _ods_ir.Value:
  return FromElementsOp(result=result, elements=elements, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class GatherOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.gather"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, base, indices, index_vec, mask, pass_thru, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(base))
    operands.extend(_get_op_results_or_values(indices))
    operands.append(_get_op_result_or_value(index_vec))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(pass_thru))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def base(self):
    return self.operation.operands[0]

  @builtins.property
  def indices(self):
    _ods_variadic_group_length = len(self.operation.operands) - 5 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def index_vec(self):
    _ods_variadic_group_length = len(self.operation.operands) - 5 + 1
    return self.operation.operands[2 + _ods_variadic_group_length - 1]

  @builtins.property
  def mask(self):
    _ods_variadic_group_length = len(self.operation.operands) - 5 + 1
    return self.operation.operands[3 + _ods_variadic_group_length - 1]

  @builtins.property
  def pass_thru(self):
    _ods_variadic_group_length = len(self.operation.operands) - 5 + 1
    return self.operation.operands[4 + _ods_variadic_group_length - 1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def gather(result, base, indices, index_vec, mask, pass_thru, *, loc=None, ip=None) -> _ods_ir.Value:
  return GatherOp(result=result, base=base, indices=indices, index_vec=index_vec, mask=mask, pass_thru=pass_thru, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class InsertElementOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.insertelement"

  _ODS_REGIONS = (0, True)

  def __init__(self, source, dest, *, position=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    operands.append(_get_op_result_or_value(dest))
    if position is not None: operands.append(_get_op_result_or_value(position))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def dest(self):
    return self.operation.operands[1]

  @builtins.property
  def position(self):
    return None if len(self.operation.operands) < 3 else self.operation.operands[2]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def insertelement(source, dest, *, position=None, loc=None, ip=None) -> _ods_ir.Value:
  return InsertElementOp(source=source, dest=dest, position=position, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class InsertOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.insert"

  _ODS_REGIONS = (0, True)

  def __init__(self, source, dest, dynamic_position, static_position, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    operands.append(_get_op_result_or_value(dest))
    operands.extend(_get_op_results_or_values(dynamic_position))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["static_position"] = (static_position if (
    isinstance(static_position, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(static_position, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def dest(self):
    return self.operation.operands[1]

  @builtins.property
  def dynamic_position(self):
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[2:2 + _ods_variadic_group_length]

  @builtins.property
  def static_position(self):
    return self.operation.attributes["static_position"]

  @static_position.setter
  def static_position(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["static_position"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def insert(source, dest, dynamic_position, static_position, *, loc=None, ip=None) -> _ods_ir.Value:
  return InsertOp(source=source, dest=dest, dynamic_position=dynamic_position, static_position=static_position, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class InsertStridedSliceOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.insert_strided_slice"

  _ODS_REGIONS = (0, True)

  def __init__(self, source, dest, offsets, strides, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    operands.append(_get_op_result_or_value(dest))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["offsets"] = (offsets if (
    isinstance(offsets, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('I64ArrayAttr')(offsets, context=_ods_context))
    attributes["strides"] = (strides if (
    isinstance(strides, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('I64ArrayAttr')(strides, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def dest(self):
    return self.operation.operands[1]

  @builtins.property
  def offsets(self):
    return self.operation.attributes["offsets"]

  @offsets.setter
  def offsets(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["offsets"] = value

  @builtins.property
  def strides(self):
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["strides"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def insert_strided_slice(source, dest, offsets, strides, *, loc=None, ip=None) -> _ods_ir.Value:
  return InsertStridedSliceOp(source=source, dest=dest, offsets=offsets, strides=strides, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class InterleaveOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.interleave"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def interleave(lhs, rhs, *, loc=None, ip=None) -> _ods_ir.Value:
  return InterleaveOp(lhs=lhs, rhs=rhs, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class LoadOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.load"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, base, indices, *, nontemporal=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(base))
    operands.extend(_get_op_results_or_values(indices))
    _ods_context = _ods_get_default_loc_context(loc)
    if nontemporal is not None: attributes["nontemporal"] = (nontemporal if (
        isinstance(nontemporal, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(nontemporal, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def base(self):
    return self.operation.operands[0]

  @builtins.property
  def indices(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def nontemporal(self):
    if "nontemporal" not in self.operation.attributes:
      return None
    return self.operation.attributes["nontemporal"]

  @nontemporal.setter
  def nontemporal(self, value):
    if value is not None:
      self.operation.attributes["nontemporal"] = value
    elif "nontemporal" in self.operation.attributes:
      del self.operation.attributes["nontemporal"]

  @nontemporal.deleter
  def nontemporal(self):
    del self.operation.attributes["nontemporal"]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def load(result, base, indices, *, nontemporal=None, loc=None, ip=None) -> _ods_ir.Value:
  return LoadOp(result=result, base=base, indices=indices, nontemporal=nontemporal, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MaskOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.mask"

  _ODS_REGIONS = (1, True)

  def __init__(self, results_, mask, *, passthru=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(mask))
    if passthru is not None: operands.append(_get_op_result_or_value(passthru))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(results_)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def mask(self):
    return self.operation.operands[0]

  @builtins.property
  def passthru(self):
    return None if len(self.operation.operands) < 2 else self.operation.operands[1]

  @builtins.property
  def results_(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def maskRegion(self):
    return self.regions[0]

def mask(results_, mask, *, passthru=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(MaskOp(results_=results_, mask=mask, passthru=passthru, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class MaskedLoadOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.maskedload"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, base, indices, mask, pass_thru, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(base))
    operands.extend(_get_op_results_or_values(indices))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(pass_thru))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def base(self):
    return self.operation.operands[0]

  @builtins.property
  def indices(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def mask(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[2 + _ods_variadic_group_length - 1]

  @builtins.property
  def pass_thru(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[3 + _ods_variadic_group_length - 1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def maskedload(result, base, indices, mask, pass_thru, *, loc=None, ip=None) -> _ods_ir.Value:
  return MaskedLoadOp(result=result, base=base, indices=indices, mask=mask, pass_thru=pass_thru, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MaskedStoreOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.maskedstore"

  _ODS_REGIONS = (0, True)

  def __init__(self, base, indices, mask, valueToStore, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(base))
    operands.extend(_get_op_results_or_values(indices))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(valueToStore))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def base(self):
    return self.operation.operands[0]

  @builtins.property
  def indices(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def mask(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[2 + _ods_variadic_group_length - 1]

  @builtins.property
  def valueToStore(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[3 + _ods_variadic_group_length - 1]

def maskedstore(base, indices, mask, value_to_store, *, loc=None, ip=None) -> _ods_ir.Operation:
  return MaskedStoreOp(base=base, indices=indices, mask=mask, valueToStore=value_to_store, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class MatmulOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.matrix_multiply"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, lhs, rhs, lhs_rows, lhs_columns, rhs_columns, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["lhs_rows"] = (lhs_rows if (
    isinstance(lhs_rows, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(lhs_rows, context=_ods_context))
    attributes["lhs_columns"] = (lhs_columns if (
    isinstance(lhs_columns, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(lhs_columns, context=_ods_context))
    attributes["rhs_columns"] = (rhs_columns if (
    isinstance(rhs_columns, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(rhs_columns, context=_ods_context))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def lhs_rows(self):
    return self.operation.attributes["lhs_rows"]

  @lhs_rows.setter
  def lhs_rows(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["lhs_rows"] = value

  @builtins.property
  def lhs_columns(self):
    return self.operation.attributes["lhs_columns"]

  @lhs_columns.setter
  def lhs_columns(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["lhs_columns"] = value

  @builtins.property
  def rhs_columns(self):
    return self.operation.attributes["rhs_columns"]

  @rhs_columns.setter
  def rhs_columns(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["rhs_columns"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def matrix_multiply(res, lhs, rhs, lhs_rows, lhs_columns, rhs_columns, *, loc=None, ip=None) -> _ods_ir.Value:
  return MatmulOp(res=res, lhs=lhs, rhs=rhs, lhs_rows=lhs_rows, lhs_columns=lhs_columns, rhs_columns=rhs_columns, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MultiDimReductionOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.multi_reduction"

  _ODS_REGIONS = (0, True)

  def __init__(self, kind, source, acc, reduction_dims, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    operands.append(_get_op_result_or_value(acc))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["kind"] = (kind if (
    isinstance(kind, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('Vector_CombiningKindAttr')) else
      _ods_ir.AttrBuilder.get('Vector_CombiningKindAttr')(kind, context=_ods_context))
    attributes["reduction_dims"] = (reduction_dims if (
    isinstance(reduction_dims, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(reduction_dims, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def acc(self):
    return self.operation.operands[1]

  @builtins.property
  def kind(self):
    return self.operation.attributes["kind"]

  @kind.setter
  def kind(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["kind"] = value

  @builtins.property
  def reduction_dims(self):
    return self.operation.attributes["reduction_dims"]

  @reduction_dims.setter
  def reduction_dims(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["reduction_dims"] = value

  @builtins.property
  def dest(self):
    return self.operation.results[0]

def multi_reduction(kind, source, acc, reduction_dims, *, loc=None, ip=None) -> _ods_ir.Value:
  return MultiDimReductionOp(kind=kind, source=source, acc=acc, reduction_dims=reduction_dims, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class OuterProductOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.outerproduct"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, lhs, rhs, *, acc=None, kind=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    if acc is not None: operands.append(_get_op_result_or_value(acc))
    _ods_context = _ods_get_default_loc_context(loc)
    if kind is not None: attributes["kind"] = (kind if (
        isinstance(kind, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Vector_CombiningKindAttr')) else
          _ods_ir.AttrBuilder.get('Vector_CombiningKindAttr')(kind, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def acc(self):
    return None if len(self.operation.operands) < 3 else self.operation.operands[2]

  @builtins.property
  def kind(self):
    return self.operation.attributes["kind"]

  @kind.setter
  def kind(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["kind"] = value

def outerproduct(result, lhs, rhs, *, acc=None, kind=None, loc=None, ip=None) -> _ods_ir.Value:
  return OuterProductOp(result=result, lhs=lhs, rhs=rhs, acc=acc, kind=kind, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class PrintOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.print"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, source=None, punctuation=None, stringLiteral=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    if source is not None: operands.append(_get_op_result_or_value(source))
    _ods_context = _ods_get_default_loc_context(loc)
    if punctuation is not None: attributes["punctuation"] = (punctuation if (
        isinstance(punctuation, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Vector_PrintPunctuation')) else
          _ods_ir.AttrBuilder.get('Vector_PrintPunctuation')(punctuation, context=_ods_context))
    if stringLiteral is not None: attributes["stringLiteral"] = (stringLiteral if (
        isinstance(stringLiteral, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Builtin_StringAttr')) else
          _ods_ir.AttrBuilder.get('Builtin_StringAttr')(stringLiteral, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return None if len(self.operation.operands) < 1 else self.operation.operands[0]

  @builtins.property
  def punctuation(self):
    return self.operation.attributes["punctuation"]

  @punctuation.setter
  def punctuation(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["punctuation"] = value

  @builtins.property
  def stringLiteral(self):
    if "stringLiteral" not in self.operation.attributes:
      return None
    return self.operation.attributes["stringLiteral"]

  @stringLiteral.setter
  def stringLiteral(self, value):
    if value is not None:
      self.operation.attributes["stringLiteral"] = value
    elif "stringLiteral" in self.operation.attributes:
      del self.operation.attributes["stringLiteral"]

  @stringLiteral.deleter
  def stringLiteral(self):
    del self.operation.attributes["stringLiteral"]

def print_(*, source=None, punctuation=None, string_literal=None, loc=None, ip=None) -> _ods_ir.Operation:
  return PrintOp(source=source, punctuation=punctuation, stringLiteral=string_literal, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class ReductionOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.reduction"

  _ODS_REGIONS = (0, True)

  def __init__(self, dest, kind, vector, *, acc=None, fastmath=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(vector))
    if acc is not None: operands.append(_get_op_result_or_value(acc))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["kind"] = (kind if (
    isinstance(kind, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('Vector_CombiningKindAttr')) else
      _ods_ir.AttrBuilder.get('Vector_CombiningKindAttr')(kind, context=_ods_context))
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    results.append(dest)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def vector(self):
    return self.operation.operands[0]

  @builtins.property
  def acc(self):
    return None if len(self.operation.operands) < 2 else self.operation.operands[1]

  @builtins.property
  def kind(self):
    return self.operation.attributes["kind"]

  @kind.setter
  def kind(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["kind"] = value

  @builtins.property
  def fastmath(self):
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def dest(self):
    return self.operation.results[0]

def reduction(dest, kind, vector, *, acc=None, fastmath=None, loc=None, ip=None) -> _ods_ir.Value:
  return ReductionOp(dest=dest, kind=kind, vector=vector, acc=acc, fastmath=fastmath, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ScalableExtractOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.scalable.extract"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, source, pos, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["pos"] = (pos if (
    isinstance(pos, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(pos, context=_ods_context))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def pos(self):
    return self.operation.attributes["pos"]

  @pos.setter
  def pos(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["pos"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def scalable_extract(res, source, pos, *, loc=None, ip=None) -> _ods_ir.Value:
  return ScalableExtractOp(res=res, source=source, pos=pos, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ScalableInsertOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.scalable.insert"

  _ODS_REGIONS = (0, True)

  def __init__(self, source, dest, pos, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    operands.append(_get_op_result_or_value(dest))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["pos"] = (pos if (
    isinstance(pos, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(pos, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def dest(self):
    return self.operation.operands[1]

  @builtins.property
  def pos(self):
    return self.operation.attributes["pos"]

  @pos.setter
  def pos(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["pos"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def scalable_insert(source, dest, pos, *, loc=None, ip=None) -> _ods_ir.Value:
  return ScalableInsertOp(source=source, dest=dest, pos=pos, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ScanOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.scan"

  _ODS_REGIONS = (0, True)

  def __init__(self, kind, source, initial_value, reduction_dim, inclusive, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    operands.append(_get_op_result_or_value(initial_value))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["kind"] = (kind if (
    isinstance(kind, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('Vector_CombiningKindAttr')) else
      _ods_ir.AttrBuilder.get('Vector_CombiningKindAttr')(kind, context=_ods_context))
    attributes["reduction_dim"] = (reduction_dim if (
    isinstance(reduction_dim, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(reduction_dim, context=_ods_context))
    attributes["inclusive"] = (inclusive if (
    isinstance(inclusive, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('BoolAttr')) else
      _ods_ir.AttrBuilder.get('BoolAttr')(inclusive, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def initial_value(self):
    return self.operation.operands[1]

  @builtins.property
  def kind(self):
    return self.operation.attributes["kind"]

  @kind.setter
  def kind(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["kind"] = value

  @builtins.property
  def reduction_dim(self):
    return self.operation.attributes["reduction_dim"]

  @reduction_dim.setter
  def reduction_dim(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["reduction_dim"] = value

  @builtins.property
  def inclusive(self):
    return self.operation.attributes["inclusive"]

  @inclusive.setter
  def inclusive(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["inclusive"] = value

  @builtins.property
  def dest(self):
    return self.operation.results[0]

  @builtins.property
  def accumulated_value(self):
    return self.operation.results[1]

def scan(kind, source, initial_value, reduction_dim, inclusive, *, loc=None, ip=None) -> _Sequence[_ods_ir.Value]:
  return ScanOp(kind=kind, source=source, initial_value=initial_value, reduction_dim=reduction_dim, inclusive=inclusive, loc=loc, ip=ip).results

@_ods_cext.register_operation(_Dialect)
class ScatterOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.scatter"

  _ODS_REGIONS = (0, True)

  def __init__(self, base, indices, index_vec, mask, valueToStore, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(base))
    operands.extend(_get_op_results_or_values(indices))
    operands.append(_get_op_result_or_value(index_vec))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(valueToStore))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def base(self):
    return self.operation.operands[0]

  @builtins.property
  def indices(self):
    _ods_variadic_group_length = len(self.operation.operands) - 5 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def index_vec(self):
    _ods_variadic_group_length = len(self.operation.operands) - 5 + 1
    return self.operation.operands[2 + _ods_variadic_group_length - 1]

  @builtins.property
  def mask(self):
    _ods_variadic_group_length = len(self.operation.operands) - 5 + 1
    return self.operation.operands[3 + _ods_variadic_group_length - 1]

  @builtins.property
  def valueToStore(self):
    _ods_variadic_group_length = len(self.operation.operands) - 5 + 1
    return self.operation.operands[4 + _ods_variadic_group_length - 1]

def scatter(base, indices, index_vec, mask, value_to_store, *, loc=None, ip=None) -> _ods_ir.Operation:
  return ScatterOp(base=base, indices=indices, index_vec=index_vec, mask=mask, valueToStore=value_to_store, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class ShapeCastOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.shape_cast"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, source, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def shape_cast(result, source, *, loc=None, ip=None) -> _ods_ir.Value:
  return ShapeCastOp(result=result, source=source, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ShuffleOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.shuffle"

  _ODS_REGIONS = (0, True)

  def __init__(self, v1, v2, mask, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(v1))
    operands.append(_get_op_result_or_value(v2))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["mask"] = (mask if (
    isinstance(mask, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(mask, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def v1(self):
    return self.operation.operands[0]

  @builtins.property
  def v2(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.attributes["mask"]

  @mask.setter
  def mask(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["mask"] = value

  @builtins.property
  def vector(self):
    return self.operation.results[0]

def shuffle(v1, v2, mask, *, loc=None, ip=None) -> _ods_ir.Value:
  return ShuffleOp(v1=v1, v2=v2, mask=mask, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class SplatOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.splat"

  _ODS_REGIONS = (0, True)

  def __init__(self, aggregate, input, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(input))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(aggregate)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def aggregate(self):
    return self.operation.results[0]

def splat(aggregate, input, *, loc=None, ip=None) -> _ods_ir.Value:
  return SplatOp(aggregate=aggregate, input=input, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class StepOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.step"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def result(self):
    return self.operation.results[0]

def step(result, *, loc=None, ip=None) -> _ods_ir.Value:
  return StepOp(result=result, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class StoreOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.store"

  _ODS_REGIONS = (0, True)

  def __init__(self, valueToStore, base, indices, *, nontemporal=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(valueToStore))
    operands.append(_get_op_result_or_value(base))
    operands.extend(_get_op_results_or_values(indices))
    _ods_context = _ods_get_default_loc_context(loc)
    if nontemporal is not None: attributes["nontemporal"] = (nontemporal if (
        isinstance(nontemporal, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(nontemporal, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def valueToStore(self):
    return self.operation.operands[0]

  @builtins.property
  def base(self):
    return self.operation.operands[1]

  @builtins.property
  def indices(self):
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[2:2 + _ods_variadic_group_length]

  @builtins.property
  def nontemporal(self):
    if "nontemporal" not in self.operation.attributes:
      return None
    return self.operation.attributes["nontemporal"]

  @nontemporal.setter
  def nontemporal(self, value):
    if value is not None:
      self.operation.attributes["nontemporal"] = value
    elif "nontemporal" in self.operation.attributes:
      del self.operation.attributes["nontemporal"]

  @nontemporal.deleter
  def nontemporal(self):
    del self.operation.attributes["nontemporal"]

def store(value_to_store, base, indices, *, nontemporal=None, loc=None, ip=None) -> _ods_ir.Operation:
  return StoreOp(valueToStore=value_to_store, base=base, indices=indices, nontemporal=nontemporal, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class TransferReadOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.transfer_read"

  _ODS_OPERAND_SEGMENTS = [1,-1,1,0,]

  _ODS_REGIONS = (0, True)

  def __init__(self, vector, source, indices, permutation_map, padding, in_bounds, *, mask=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    operands.append(_get_op_results_or_values(indices))
    operands.append(_get_op_result_or_value(padding))
    operands.append(_get_op_result_or_value(mask) if mask is not None else None)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["permutation_map"] = (permutation_map if (
    isinstance(permutation_map, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('AffineMapAttr')) else
      _ods_ir.AttrBuilder.get('AffineMapAttr')(permutation_map, context=_ods_context))
    attributes["in_bounds"] = (in_bounds if (
    isinstance(in_bounds, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('BoolArrayAttr')) else
      _ods_ir.AttrBuilder.get('BoolArrayAttr')(in_bounds, context=_ods_context))
    results.append(vector)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def indices(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def padding(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range[0]

  @builtins.property
  def mask(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def permutation_map(self):
    return self.operation.attributes["permutation_map"]

  @permutation_map.setter
  def permutation_map(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["permutation_map"] = value

  @builtins.property
  def in_bounds(self):
    return self.operation.attributes["in_bounds"]

  @in_bounds.setter
  def in_bounds(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["in_bounds"] = value

  @builtins.property
  def vector(self):
    return self.operation.results[0]

def transfer_read(vector, source, indices, permutation_map, padding, in_bounds, *, mask=None, loc=None, ip=None) -> _ods_ir.Value:
  return TransferReadOp(vector=vector, source=source, indices=indices, permutation_map=permutation_map, padding=padding, in_bounds=in_bounds, mask=mask, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class TransferWriteOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.transfer_write"

  _ODS_OPERAND_SEGMENTS = [1,1,-1,0,]

  _ODS_REGIONS = (0, True)

  def __init__(self, result, vector, source, indices, permutation_map, in_bounds, *, mask=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(vector))
    operands.append(_get_op_result_or_value(source))
    operands.append(_get_op_results_or_values(indices))
    operands.append(_get_op_result_or_value(mask) if mask is not None else None)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["permutation_map"] = (permutation_map if (
    isinstance(permutation_map, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('AffineMapAttr')) else
      _ods_ir.AttrBuilder.get('AffineMapAttr')(permutation_map, context=_ods_context))
    attributes["in_bounds"] = (in_bounds if (
    isinstance(in_bounds, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('BoolArrayAttr')) else
      _ods_ir.AttrBuilder.get('BoolArrayAttr')(in_bounds, context=_ods_context))
    if result is not None: results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def vector(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def source(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0]

  @builtins.property
  def indices(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def mask(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def permutation_map(self):
    return self.operation.attributes["permutation_map"]

  @permutation_map.setter
  def permutation_map(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["permutation_map"] = value

  @builtins.property
  def in_bounds(self):
    return self.operation.attributes["in_bounds"]

  @in_bounds.setter
  def in_bounds(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["in_bounds"] = value

  @builtins.property
  def result(self):
    return None if len(self.operation.results) < 1 else self.operation.results[0]

def transfer_write(result, vector, source, indices, permutation_map, in_bounds, *, mask=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(TransferWriteOp(result=result, vector=vector, source=source, indices=indices, permutation_map=permutation_map, in_bounds=in_bounds, mask=mask, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class TransposeOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.transpose"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, vector, permutation, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(vector))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["permutation"] = (permutation if (
    isinstance(permutation, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(permutation, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def vector(self):
    return self.operation.operands[0]

  @builtins.property
  def permutation(self):
    return self.operation.attributes["permutation"]

  @permutation.setter
  def permutation(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["permutation"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def transpose(result, vector, permutation, *, loc=None, ip=None) -> _ods_ir.Value:
  return TransposeOp(result=result, vector=vector, permutation=permutation, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class TypeCastOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.type_cast"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, memref, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(memref))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def memref(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def type_cast(result, memref, *, loc=None, ip=None) -> _ods_ir.Value:
  return TypeCastOp(result=result, memref=memref, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class YieldOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.yield"

  _ODS_REGIONS = (0, True)

  def __init__(self, operands_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(operands_))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operands_(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

def yield_(operands_, *, loc=None, ip=None) -> _ods_ir.Operation:
  return YieldOp(operands_=operands_, loc=loc, ip=ip)
