# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import List
from typing_extensions import Literal, Required, TypedDict

__all__ = ["TrainingCreateParams"]


class TrainingCreateParams(TypedDict, total=False):
    model_owner: Required[str]

    model_name: Required[str]

    version_id: Required[str]

    destination: Required[str]
    """
    A string representing the desired model to push to in the format
    `{destination_model_owner}/{destination_model_name}`. This should be an existing
    model owned by the user or organization making the API request. If the
    destination is invalid, the server will return an appropriate 4XX response.
    """

    input: Required[object]
    """An object containing inputs to the Cog model's `train()` function."""

    webhook: str
    """An HTTPS URL for receiving a webhook when the training completes.

    The webhook will be a POST request where the request body is the same as the
    response body of the [get training](#trainings.get) operation. If there are
    network problems, we will retry the webhook a few times, so make sure it can be
    safely called more than once. Replicate will not follow redirects when sending
    webhook requests to your service, so be sure to specify a URL that will resolve
    without redirecting.
    """

    webhook_events_filter: List[Literal["start", "output", "logs", "completed"]]
    """
    By default, we will send requests to your webhook URL whenever there are new
    outputs or the training has finished. You can change which events trigger
    webhook requests by specifying `webhook_events_filter` in the training request:

    - `start`: immediately on training start
    - `output`: each time a training generates an output (note that trainings can
      generate multiple outputs)
    - `logs`: each time log output is generated by a training
    - `completed`: when the training reaches a terminal state
      (succeeded/canceled/failed)

    For example, if you only wanted requests to be sent at the start and end of the
    training, you would provide:

    ```json
    {
      "destination": "my-organization/my-model",
      "input": {
        "text": "Alice"
      },
      "webhook": "https://example.com/my-webhook",
      "webhook_events_filter": ["start", "completed"]
    }
    ```

    Requests for event types `output` and `logs` will be sent at most once every
    500ms. If you request `start` and `completed` webhooks, then they'll always be
    sent regardless of throttling.
    """
