"""Towerpy: an open-source toolbox for processing polarimetric radar data."""

"""
This file contains a dictionary listing different colour gradients.
"""

towerpy_colours = {
    'ref': ['#967BB6', '#A690C4', '#B6A6D1', '#C6BBDF', '#D6D1EC',
            # Lavender Gradient Color (R)
            '#51D8FF', '#46C7FF', '#3DB5FF', '#239BFE', '#1672F9', '#044EE3',
            # Russian Blues Color Scheme
            '#FFF480', '#FFDF00', '#F6D108', '#EDC211', '#E3B419', '#DAA521',
            # Golden Yellow Gradient Color Scheme
            '#FF9533', '#FF7F34', '#FE6D35', '#FF5836', '#FF4137', '#B31B1B',
            # NAME: SoundCloud Colors
            '#5E0400', '#F8E8EC'],
    'pvars': ['#D2ECFA', '#51D8FF', '#46C7FF', '#3DB5FF', '#239BFE', '#1672F9',
              '#044EE3',  # Russian Blues Color Scheme
              '#FFFF00', '#FFF480', '#FFE961', '#FFDF41', '#FFD422', '#FFC903',
              # Vivid Yellow Gradient Color Scheme
              '#FFB829', '#F98A2C', '#ED5B45', '#B64262', '#633663', '#402852',
              # Towerpy
              '#C6BFCB'],
    'rainrt': ['#D2ECFA', '#51D8FF', '#46C7FF', '#3DB5FF', '#239BFE',
               '#1672F9', '#044EE3',  # Russian Blues Color Scheme
               '#44AEB3', '#249EA0', '#008B8B', '#007979', '#006767',
               # Dark Cyan Monochromatic
               '#FFFF00', '#FFF480', '#FFE961', '#FFDF41', '#FFD422',
               '#FFC903',  # Vivid Yellow Gradient Color Scheme
               '#FFB829', '#F98A2C', '#ED5B45', '#B64262', '#633663',
               '#402852',  # Towerpy
               '#C6BFCB'],
    'pvars_g': ['#D2ECFA', '#51D8FF', '#46C7FF', '#3DB5FF', '#239BFE',
                '#1672F9', '#044EE3',  # Russian Blues Color Scheme
                '#1A724C', '#A9FC02',  # Spring Greens
                '#FFFF00', '#FFF480', '#FFE961', '#FFDF41', '#FFD422',
                '#FFC903',  # Vivid Yellow Gradient Color Scheme
                '#FFB829', '#F98A2C', '#ED5B45', '#B64262', '#633663',
                '#402852',  # Towerpy
                '#C6BFCB'],
    'grey': ['#505050', '#696969', '#BBBBBB', '#CFCFCF', '#D2ECFA'],
    'yw_gy_bu': ['#509AE8', '#505050', '#FFBA01'],
    'dbu_rd': ['#DA2C43', '#E15566', '#E97E88', '#F0A8AB', '#F8D1CD',
               '#AFC6D9', '#83A3BE', '#5880A2', '#2C5D87', '#003A6B'],
    'lbu_w_rd': ['#DA2C43', '#E15566', '#E97E88', '#F0A8AB', '#F8D1CD',
                 '#FFFAF0', '#F0FFFE', '#C0E5FE', '#90CCFE', '#60B2FE',
                 '#3099FE', '#007FFE'],
    'dbu_w_rd': ['#DA2C43', '#E15566', '#E97E88', '#F0A8AB', '#F8D1CD',
                 '#FFFAF0', '#F0FFFE', '#AFC6D9', '#83A3BE', '#5880A2',
                 '#2C5D87', '#003A6B'],
    'dbu_w_k': ['#2B2B2B', '#545454', '#808080', '#AFAFAF', '#E1E1E1',
                '#FCFFFA', '#F0FFFE', '#AFC6D9', '#83A3BE', '#5880A2',
                '#2C5D87', '#003A6B'],
    'rd_w_k': ['#2B2B2B', '#545454', '#808080', '#AFAFAF', '#E1E1E1',
               '#FCFFFA', '#FFFAF0', '#F8D1CD', '#F0A8AB', '#E97E88',
               '#E15566', '#DA2C43'],
    'grad_ywbu': ['#FFBA01', '#d0a819', '#99872B', '#666D41', '#335456',
                  '#003A6B'],
    'grad_bupkyw': ['#3F3A81', '#954698', '#D65A94', '#F76385', '#F9B357',
                    '#F8F658'],
    'grad_morning': ['#F6BD73', '#F9D69E', '#CBB6B0', '#9DA3B7', '#5373A1',
                     '#3D5688'],
    'grad_wblk': ['#F2F3F4', '#B3BDD4', '#7587B4', '#365194', '#253354',
                  '#141414'],
    'grad_fiery': ['#FCD988', '#F9A622', '#F55E01', '#EB2701', '#C40000',
                   '#292929'],
    'grad_tec': ['#B0F7FF', '#9BCFE3', '#86A7C7', '#7080AA', '#5B588E',
                 '#463072'],
    'grad_pastel': ['#FCF5E3', '#FCD4B8', '#F3AE9C', '#D799A7', '#9A7DA7',
                    '#4E60A4'],
    'grad_wk': ['#F8F8FF', '#CAC9CD', '#9B9A9C', '#6D6A6A', '#3E3B39',
                '#100C07'],
    'grad_sun': ['#FFF673', '#FFDB02', '#FFBC11', '#FF9D1F', '#FF7E2E',
                 '#FF6352'],
    'grad_calm': ['#F6EEAB', '#C9DD94', '#9DCF94', '#7EC796', '#5EBD96',
                  '#11A797'],
    }
