/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDnsSrvRecordSetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Service to look up.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/dns/3.4.3/docs/data-sources/srv_record_set#service DataDnsSrvRecordSet#service}
    */
    readonly service: string;
}
export interface DataDnsSrvRecordSetSrv {
}
export declare function dataDnsSrvRecordSetSrvToTerraform(struct?: DataDnsSrvRecordSetSrv): any;
export declare function dataDnsSrvRecordSetSrvToHclTerraform(struct?: DataDnsSrvRecordSetSrv): any;
export declare class DataDnsSrvRecordSetSrvOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDnsSrvRecordSetSrv | undefined;
    set internalValue(value: DataDnsSrvRecordSetSrv | undefined);
    get port(): number;
    get priority(): number;
    get target(): string;
    get weight(): number;
}
export declare class DataDnsSrvRecordSetSrvList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDnsSrvRecordSetSrvOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/dns/3.4.3/docs/data-sources/srv_record_set dns_srv_record_set}
*/
export declare class DataDnsSrvRecordSet extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "dns_srv_record_set";
    /**
    * Generates CDKTF code for importing a DataDnsSrvRecordSet resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataDnsSrvRecordSet to import
    * @param importFromId The id of the existing DataDnsSrvRecordSet that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/dns/3.4.3/docs/data-sources/srv_record_set#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataDnsSrvRecordSet to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/dns/3.4.3/docs/data-sources/srv_record_set dns_srv_record_set} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDnsSrvRecordSetConfig
    */
    constructor(scope: Construct, id: string, config: DataDnsSrvRecordSetConfig);
    get id(): string;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _srv;
    get srv(): DataDnsSrvRecordSetSrvList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
