# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AccessPolicyRuleArgs',
    'AccessPolicyRuleArgsDict',
    'AccessPolicyRuleDestinationArgs',
    'AccessPolicyRuleDestinationArgsDict',
    'AccessPolicyRuleSourceArgs',
    'AccessPolicyRuleSourceArgsDict',
    'IngressGatewayAccessLoggingArgs',
    'IngressGatewayAccessLoggingArgsDict',
    'IngressGatewayHostArgs',
    'IngressGatewayHostArgsDict',
    'IngressGatewayHostListenerArgs',
    'IngressGatewayHostListenerArgsDict',
    'IngressGatewayHostListenerTlsArgs',
    'IngressGatewayHostListenerTlsArgsDict',
    'IngressGatewayHostListenerTlsClientValidationArgs',
    'IngressGatewayHostListenerTlsClientValidationArgsDict',
    'IngressGatewayHostListenerTlsClientValidationTrustedCaBundleArgs',
    'IngressGatewayHostListenerTlsClientValidationTrustedCaBundleArgsDict',
    'IngressGatewayHostListenerTlsServerCertificateArgs',
    'IngressGatewayHostListenerTlsServerCertificateArgsDict',
    'IngressGatewayMtlsArgs',
    'IngressGatewayMtlsArgsDict',
    'IngressGatewayRouteTableRouteRuleArgs',
    'IngressGatewayRouteTableRouteRuleArgsDict',
    'IngressGatewayRouteTableRouteRuleDestinationArgs',
    'IngressGatewayRouteTableRouteRuleDestinationArgsDict',
    'IngressGatewayRouteTableRouteRuleIngressGatewayHostArgs',
    'IngressGatewayRouteTableRouteRuleIngressGatewayHostArgsDict',
    'MeshCertificateAuthorityArgs',
    'MeshCertificateAuthorityArgsDict',
    'MeshMtlsArgs',
    'MeshMtlsArgsDict',
    'VirtualDeploymentAccessLoggingArgs',
    'VirtualDeploymentAccessLoggingArgsDict',
    'VirtualDeploymentListenerArgs',
    'VirtualDeploymentListenerArgsDict',
    'VirtualDeploymentServiceDiscoveryArgs',
    'VirtualDeploymentServiceDiscoveryArgsDict',
    'VirtualServiceDefaultRoutingPolicyArgs',
    'VirtualServiceDefaultRoutingPolicyArgsDict',
    'VirtualServiceMtlsArgs',
    'VirtualServiceMtlsArgsDict',
    'VirtualServiceRouteTableRouteRuleArgs',
    'VirtualServiceRouteTableRouteRuleArgsDict',
    'VirtualServiceRouteTableRouteRuleDestinationArgs',
    'VirtualServiceRouteTableRouteRuleDestinationArgsDict',
    'GetAccessPoliciesFilterArgs',
    'GetAccessPoliciesFilterArgsDict',
    'GetIngressGatewayRouteTablesFilterArgs',
    'GetIngressGatewayRouteTablesFilterArgsDict',
    'GetIngressGatewaysFilterArgs',
    'GetIngressGatewaysFilterArgsDict',
    'GetMeshesFilterArgs',
    'GetMeshesFilterArgsDict',
    'GetVirtualDeploymentsFilterArgs',
    'GetVirtualDeploymentsFilterArgsDict',
    'GetVirtualServiceRouteTablesFilterArgs',
    'GetVirtualServiceRouteTablesFilterArgsDict',
    'GetVirtualServicesFilterArgs',
    'GetVirtualServicesFilterArgsDict',
]

MYPY = False

if not MYPY:
    class AccessPolicyRuleArgsDict(TypedDict):
        action: pulumi.Input[str]
        """
        (Updatable) Action for the traffic between the source and the destination.
        """
        destination: pulumi.Input['AccessPolicyRuleDestinationArgsDict']
        """
        (Updatable) Target of the access policy. This can either be the source or the destination of the traffic.
        """
        source: pulumi.Input['AccessPolicyRuleSourceArgsDict']
        """
        (Updatable) Target of the access policy. This can either be the source or the destination of the traffic.
        """
elif False:
    AccessPolicyRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccessPolicyRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[str],
                 destination: pulumi.Input['AccessPolicyRuleDestinationArgs'],
                 source: pulumi.Input['AccessPolicyRuleSourceArgs']):
        """
        :param pulumi.Input[str] action: (Updatable) Action for the traffic between the source and the destination.
        :param pulumi.Input['AccessPolicyRuleDestinationArgs'] destination: (Updatable) Target of the access policy. This can either be the source or the destination of the traffic.
        :param pulumi.Input['AccessPolicyRuleSourceArgs'] source: (Updatable) Target of the access policy. This can either be the source or the destination of the traffic.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[str]:
        """
        (Updatable) Action for the traffic between the source and the destination.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Input['AccessPolicyRuleDestinationArgs']:
        """
        (Updatable) Target of the access policy. This can either be the source or the destination of the traffic.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input['AccessPolicyRuleDestinationArgs']):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input['AccessPolicyRuleSourceArgs']:
        """
        (Updatable) Target of the access policy. This can either be the source or the destination of the traffic.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input['AccessPolicyRuleSourceArgs']):
        pulumi.set(self, "source", value)


if not MYPY:
    class AccessPolicyRuleDestinationArgsDict(TypedDict):
        type: pulumi.Input[str]
        """
        (Updatable) Traffic type of the target.
        """
        hostnames: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        (Updatable) The hostnames of the external service. Only applicable for HTTP and HTTPS protocols. Wildcard hostnames are supported in the prefix form. Examples of valid hostnames are "www.example.com", "*.example.com", "*.com", "*". Hostname "*" can be used to allow all hosts.
        """
        ingress_gateway_id: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The OCID of the ingress gateway resource.
        """
        ip_addresses: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        (Updatable) The ipAddresses of the external service in CIDR notation. Only applicable for TCP protocol. All requests matching the given CIDR notation will pass through. In case a wildcard CIDR "0.0.0.0/0" is provided, the same port cannot be used for a virtual service communication.
        """
        ports: NotRequired[pulumi.Input[Sequence[pulumi.Input[int]]]]
        """
        (Updatable) Ports exposed by an external service. If left empty all ports will be allowed.
        """
        protocol: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Protocol of the external service
        """
        virtual_service_id: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The OCID of the virtual service resource.
        """
elif False:
    AccessPolicyRuleDestinationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccessPolicyRuleDestinationArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ingress_gateway_id: Optional[pulumi.Input[str]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 virtual_service_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: (Updatable) Traffic type of the target.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] hostnames: (Updatable) The hostnames of the external service. Only applicable for HTTP and HTTPS protocols. Wildcard hostnames are supported in the prefix form. Examples of valid hostnames are "www.example.com", "*.example.com", "*.com", "*". Hostname "*" can be used to allow all hosts.
        :param pulumi.Input[str] ingress_gateway_id: (Updatable) The OCID of the ingress gateway resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_addresses: (Updatable) The ipAddresses of the external service in CIDR notation. Only applicable for TCP protocol. All requests matching the given CIDR notation will pass through. In case a wildcard CIDR "0.0.0.0/0" is provided, the same port cannot be used for a virtual service communication.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] ports: (Updatable) Ports exposed by an external service. If left empty all ports will be allowed.
        :param pulumi.Input[str] protocol: (Updatable) Protocol of the external service
        :param pulumi.Input[str] virtual_service_id: (Updatable) The OCID of the virtual service resource.
        """
        pulumi.set(__self__, "type", type)
        if hostnames is not None:
            pulumi.set(__self__, "hostnames", hostnames)
        if ingress_gateway_id is not None:
            pulumi.set(__self__, "ingress_gateway_id", ingress_gateway_id)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if virtual_service_id is not None:
            pulumi.set(__self__, "virtual_service_id", virtual_service_id)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        (Updatable) Traffic type of the target.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def hostnames(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The hostnames of the external service. Only applicable for HTTP and HTTPS protocols. Wildcard hostnames are supported in the prefix form. Examples of valid hostnames are "www.example.com", "*.example.com", "*.com", "*". Hostname "*" can be used to allow all hosts.
        """
        return pulumi.get(self, "hostnames")

    @hostnames.setter
    def hostnames(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "hostnames", value)

    @property
    @pulumi.getter(name="ingressGatewayId")
    def ingress_gateway_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the ingress gateway resource.
        """
        return pulumi.get(self, "ingress_gateway_id")

    @ingress_gateway_id.setter
    def ingress_gateway_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ingress_gateway_id", value)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The ipAddresses of the external service in CIDR notation. Only applicable for TCP protocol. All requests matching the given CIDR notation will pass through. In case a wildcard CIDR "0.0.0.0/0" is provided, the same port cannot be used for a virtual service communication.
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_addresses", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        (Updatable) Ports exposed by an external service. If left empty all ports will be allowed.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Protocol of the external service
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="virtualServiceId")
    def virtual_service_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the virtual service resource.
        """
        return pulumi.get(self, "virtual_service_id")

    @virtual_service_id.setter
    def virtual_service_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_service_id", value)


if not MYPY:
    class AccessPolicyRuleSourceArgsDict(TypedDict):
        type: pulumi.Input[str]
        """
        (Updatable) Traffic type of the target.
        """
        hostnames: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        (Updatable) The hostnames of the external service. Only applicable for HTTP and HTTPS protocols. Wildcard hostnames are supported in the prefix form. Examples of valid hostnames are "www.example.com", "*.example.com", "*.com", "*". Hostname "*" can be used to allow all hosts.
        """
        ingress_gateway_id: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The OCID of the ingress gateway resource.
        """
        ip_addresses: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        (Updatable) The ipAddresses of the external service in CIDR notation. Only applicable for TCP protocol. All requests matching the given CIDR notation will pass through. In case a wildcard CIDR "0.0.0.0/0" is provided, the same port cannot be used for a virtual service communication.
        """
        ports: NotRequired[pulumi.Input[Sequence[pulumi.Input[int]]]]
        """
        (Updatable) Ports exposed by an external service. If left empty all ports will be allowed.
        """
        protocol: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Protocol of the external service
        """
        virtual_service_id: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The OCID of the virtual service resource.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
elif False:
    AccessPolicyRuleSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccessPolicyRuleSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ingress_gateway_id: Optional[pulumi.Input[str]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 virtual_service_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: (Updatable) Traffic type of the target.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] hostnames: (Updatable) The hostnames of the external service. Only applicable for HTTP and HTTPS protocols. Wildcard hostnames are supported in the prefix form. Examples of valid hostnames are "www.example.com", "*.example.com", "*.com", "*". Hostname "*" can be used to allow all hosts.
        :param pulumi.Input[str] ingress_gateway_id: (Updatable) The OCID of the ingress gateway resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_addresses: (Updatable) The ipAddresses of the external service in CIDR notation. Only applicable for TCP protocol. All requests matching the given CIDR notation will pass through. In case a wildcard CIDR "0.0.0.0/0" is provided, the same port cannot be used for a virtual service communication.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] ports: (Updatable) Ports exposed by an external service. If left empty all ports will be allowed.
        :param pulumi.Input[str] protocol: (Updatable) Protocol of the external service
        :param pulumi.Input[str] virtual_service_id: (Updatable) The OCID of the virtual service resource.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "type", type)
        if hostnames is not None:
            pulumi.set(__self__, "hostnames", hostnames)
        if ingress_gateway_id is not None:
            pulumi.set(__self__, "ingress_gateway_id", ingress_gateway_id)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if virtual_service_id is not None:
            pulumi.set(__self__, "virtual_service_id", virtual_service_id)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        (Updatable) Traffic type of the target.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def hostnames(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The hostnames of the external service. Only applicable for HTTP and HTTPS protocols. Wildcard hostnames are supported in the prefix form. Examples of valid hostnames are "www.example.com", "*.example.com", "*.com", "*". Hostname "*" can be used to allow all hosts.
        """
        return pulumi.get(self, "hostnames")

    @hostnames.setter
    def hostnames(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "hostnames", value)

    @property
    @pulumi.getter(name="ingressGatewayId")
    def ingress_gateway_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the ingress gateway resource.
        """
        return pulumi.get(self, "ingress_gateway_id")

    @ingress_gateway_id.setter
    def ingress_gateway_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ingress_gateway_id", value)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The ipAddresses of the external service in CIDR notation. Only applicable for TCP protocol. All requests matching the given CIDR notation will pass through. In case a wildcard CIDR "0.0.0.0/0" is provided, the same port cannot be used for a virtual service communication.
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_addresses", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        (Updatable) Ports exposed by an external service. If left empty all ports will be allowed.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Protocol of the external service
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="virtualServiceId")
    def virtual_service_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the virtual service resource.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "virtual_service_id")

    @virtual_service_id.setter
    def virtual_service_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_service_id", value)


if not MYPY:
    class IngressGatewayAccessLoggingArgsDict(TypedDict):
        is_enabled: NotRequired[pulumi.Input[bool]]
        """
        (Updatable) Determines if the logging configuration is enabled.
        """
elif False:
    IngressGatewayAccessLoggingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IngressGatewayAccessLoggingArgs:
    def __init__(__self__, *,
                 is_enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] is_enabled: (Updatable) Determines if the logging configuration is enabled.
        """
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Determines if the logging configuration is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enabled", value)


if not MYPY:
    class IngressGatewayHostArgsDict(TypedDict):
        listeners: pulumi.Input[Sequence[pulumi.Input['IngressGatewayHostListenerArgsDict']]]
        """
        (Updatable) The listeners for the ingress gateway.
        """
        name: pulumi.Input[str]
        """
        (Updatable) A user-friendly name for the host. The name must be unique within the same ingress gateway. This name can be used in the ingress gateway route table resource to attach a route to this host.  Example: `MyExampleHost`
        """
        hostnames: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        (Updatable) Hostnames of the host. Applicable only for HTTP and TLS_PASSTHROUGH listeners. Wildcard hostnames are supported in the prefix form. Examples of valid hostnames are "www.example.com", "*.example.com", "*.com".
        """
elif False:
    IngressGatewayHostArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IngressGatewayHostArgs:
    def __init__(__self__, *,
                 listeners: pulumi.Input[Sequence[pulumi.Input['IngressGatewayHostListenerArgs']]],
                 name: pulumi.Input[str],
                 hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['IngressGatewayHostListenerArgs']]] listeners: (Updatable) The listeners for the ingress gateway.
        :param pulumi.Input[str] name: (Updatable) A user-friendly name for the host. The name must be unique within the same ingress gateway. This name can be used in the ingress gateway route table resource to attach a route to this host.  Example: `MyExampleHost`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] hostnames: (Updatable) Hostnames of the host. Applicable only for HTTP and TLS_PASSTHROUGH listeners. Wildcard hostnames are supported in the prefix form. Examples of valid hostnames are "www.example.com", "*.example.com", "*.com".
        """
        pulumi.set(__self__, "listeners", listeners)
        pulumi.set(__self__, "name", name)
        if hostnames is not None:
            pulumi.set(__self__, "hostnames", hostnames)

    @property
    @pulumi.getter
    def listeners(self) -> pulumi.Input[Sequence[pulumi.Input['IngressGatewayHostListenerArgs']]]:
        """
        (Updatable) The listeners for the ingress gateway.
        """
        return pulumi.get(self, "listeners")

    @listeners.setter
    def listeners(self, value: pulumi.Input[Sequence[pulumi.Input['IngressGatewayHostListenerArgs']]]):
        pulumi.set(self, "listeners", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        (Updatable) A user-friendly name for the host. The name must be unique within the same ingress gateway. This name can be used in the ingress gateway route table resource to attach a route to this host.  Example: `MyExampleHost`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def hostnames(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Hostnames of the host. Applicable only for HTTP and TLS_PASSTHROUGH listeners. Wildcard hostnames are supported in the prefix form. Examples of valid hostnames are "www.example.com", "*.example.com", "*.com".
        """
        return pulumi.get(self, "hostnames")

    @hostnames.setter
    def hostnames(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "hostnames", value)


if not MYPY:
    class IngressGatewayHostListenerArgsDict(TypedDict):
        port: pulumi.Input[int]
        """
        (Updatable) Port on which ingress gateway is listening.
        """
        protocol: pulumi.Input[str]
        """
        (Updatable) Type of protocol used.
        """
        tls: NotRequired[pulumi.Input['IngressGatewayHostListenerTlsArgsDict']]
        """
        (Updatable) TLS enforcement config for the ingress listener.
        """
elif False:
    IngressGatewayHostListenerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IngressGatewayHostListenerArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[int],
                 protocol: pulumi.Input[str],
                 tls: Optional[pulumi.Input['IngressGatewayHostListenerTlsArgs']] = None):
        """
        :param pulumi.Input[int] port: (Updatable) Port on which ingress gateway is listening.
        :param pulumi.Input[str] protocol: (Updatable) Type of protocol used.
        :param pulumi.Input['IngressGatewayHostListenerTlsArgs'] tls: (Updatable) TLS enforcement config for the ingress listener.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        (Updatable) Port on which ingress gateway is listening.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        (Updatable) Type of protocol used.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def tls(self) -> Optional[pulumi.Input['IngressGatewayHostListenerTlsArgs']]:
        """
        (Updatable) TLS enforcement config for the ingress listener.
        """
        return pulumi.get(self, "tls")

    @tls.setter
    def tls(self, value: Optional[pulumi.Input['IngressGatewayHostListenerTlsArgs']]):
        pulumi.set(self, "tls", value)


if not MYPY:
    class IngressGatewayHostListenerTlsArgsDict(TypedDict):
        mode: pulumi.Input[str]
        """
        (Updatable) DISABLED: Connection can only be plaintext. PERMISSIVE: Connection can be either plaintext or TLS/mTLS. If the clientValidation.trustedCaBundle property is configured for the listener, mTLS is performed and the client's certificates are validated by the gateway. TLS: Connection can only be TLS.  MUTUAL_TLS: Connection can only be MTLS.
        """
        client_validation: NotRequired[pulumi.Input['IngressGatewayHostListenerTlsClientValidationArgsDict']]
        """
        (Updatable) Resource representing the TLS configuration used for validating client certificates.
        """
        server_certificate: NotRequired[pulumi.Input['IngressGatewayHostListenerTlsServerCertificateArgsDict']]
        """
        (Updatable) Resource representing the location of the TLS certificate.
        """
elif False:
    IngressGatewayHostListenerTlsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IngressGatewayHostListenerTlsArgs:
    def __init__(__self__, *,
                 mode: pulumi.Input[str],
                 client_validation: Optional[pulumi.Input['IngressGatewayHostListenerTlsClientValidationArgs']] = None,
                 server_certificate: Optional[pulumi.Input['IngressGatewayHostListenerTlsServerCertificateArgs']] = None):
        """
        :param pulumi.Input[str] mode: (Updatable) DISABLED: Connection can only be plaintext. PERMISSIVE: Connection can be either plaintext or TLS/mTLS. If the clientValidation.trustedCaBundle property is configured for the listener, mTLS is performed and the client's certificates are validated by the gateway. TLS: Connection can only be TLS.  MUTUAL_TLS: Connection can only be MTLS.
        :param pulumi.Input['IngressGatewayHostListenerTlsClientValidationArgs'] client_validation: (Updatable) Resource representing the TLS configuration used for validating client certificates.
        :param pulumi.Input['IngressGatewayHostListenerTlsServerCertificateArgs'] server_certificate: (Updatable) Resource representing the location of the TLS certificate.
        """
        pulumi.set(__self__, "mode", mode)
        if client_validation is not None:
            pulumi.set(__self__, "client_validation", client_validation)
        if server_certificate is not None:
            pulumi.set(__self__, "server_certificate", server_certificate)

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Input[str]:
        """
        (Updatable) DISABLED: Connection can only be plaintext. PERMISSIVE: Connection can be either plaintext or TLS/mTLS. If the clientValidation.trustedCaBundle property is configured for the listener, mTLS is performed and the client's certificates are validated by the gateway. TLS: Connection can only be TLS.  MUTUAL_TLS: Connection can only be MTLS.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="clientValidation")
    def client_validation(self) -> Optional[pulumi.Input['IngressGatewayHostListenerTlsClientValidationArgs']]:
        """
        (Updatable) Resource representing the TLS configuration used for validating client certificates.
        """
        return pulumi.get(self, "client_validation")

    @client_validation.setter
    def client_validation(self, value: Optional[pulumi.Input['IngressGatewayHostListenerTlsClientValidationArgs']]):
        pulumi.set(self, "client_validation", value)

    @property
    @pulumi.getter(name="serverCertificate")
    def server_certificate(self) -> Optional[pulumi.Input['IngressGatewayHostListenerTlsServerCertificateArgs']]:
        """
        (Updatable) Resource representing the location of the TLS certificate.
        """
        return pulumi.get(self, "server_certificate")

    @server_certificate.setter
    def server_certificate(self, value: Optional[pulumi.Input['IngressGatewayHostListenerTlsServerCertificateArgs']]):
        pulumi.set(self, "server_certificate", value)


if not MYPY:
    class IngressGatewayHostListenerTlsClientValidationArgsDict(TypedDict):
        subject_alternate_names: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        (Updatable) A list of alternate names to verify the subject identity in the certificate presented by the client.
        """
        trusted_ca_bundle: NotRequired[pulumi.Input['IngressGatewayHostListenerTlsClientValidationTrustedCaBundleArgsDict']]
        """
        (Updatable) Resource representing the CA bundle.
        """
elif False:
    IngressGatewayHostListenerTlsClientValidationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IngressGatewayHostListenerTlsClientValidationArgs:
    def __init__(__self__, *,
                 subject_alternate_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 trusted_ca_bundle: Optional[pulumi.Input['IngressGatewayHostListenerTlsClientValidationTrustedCaBundleArgs']] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subject_alternate_names: (Updatable) A list of alternate names to verify the subject identity in the certificate presented by the client.
        :param pulumi.Input['IngressGatewayHostListenerTlsClientValidationTrustedCaBundleArgs'] trusted_ca_bundle: (Updatable) Resource representing the CA bundle.
        """
        if subject_alternate_names is not None:
            pulumi.set(__self__, "subject_alternate_names", subject_alternate_names)
        if trusted_ca_bundle is not None:
            pulumi.set(__self__, "trusted_ca_bundle", trusted_ca_bundle)

    @property
    @pulumi.getter(name="subjectAlternateNames")
    def subject_alternate_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A list of alternate names to verify the subject identity in the certificate presented by the client.
        """
        return pulumi.get(self, "subject_alternate_names")

    @subject_alternate_names.setter
    def subject_alternate_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subject_alternate_names", value)

    @property
    @pulumi.getter(name="trustedCaBundle")
    def trusted_ca_bundle(self) -> Optional[pulumi.Input['IngressGatewayHostListenerTlsClientValidationTrustedCaBundleArgs']]:
        """
        (Updatable) Resource representing the CA bundle.
        """
        return pulumi.get(self, "trusted_ca_bundle")

    @trusted_ca_bundle.setter
    def trusted_ca_bundle(self, value: Optional[pulumi.Input['IngressGatewayHostListenerTlsClientValidationTrustedCaBundleArgs']]):
        pulumi.set(self, "trusted_ca_bundle", value)


if not MYPY:
    class IngressGatewayHostListenerTlsClientValidationTrustedCaBundleArgsDict(TypedDict):
        type: pulumi.Input[str]
        """
        (Updatable) Type of certificate.
        """
        ca_bundle_id: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The OCID of the CA Bundle resource.
        """
        secret_name: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Name of the secret. For Kubernetes this will be the name of an opaque Kubernetes secret with key ca.crt. For other platforms the secret must be mounted at: /etc/oci/secrets/${secretName}/ca.crt
        """
elif False:
    IngressGatewayHostListenerTlsClientValidationTrustedCaBundleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IngressGatewayHostListenerTlsClientValidationTrustedCaBundleArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 ca_bundle_id: Optional[pulumi.Input[str]] = None,
                 secret_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: (Updatable) Type of certificate.
        :param pulumi.Input[str] ca_bundle_id: (Updatable) The OCID of the CA Bundle resource.
        :param pulumi.Input[str] secret_name: (Updatable) Name of the secret. For Kubernetes this will be the name of an opaque Kubernetes secret with key ca.crt. For other platforms the secret must be mounted at: /etc/oci/secrets/${secretName}/ca.crt
        """
        pulumi.set(__self__, "type", type)
        if ca_bundle_id is not None:
            pulumi.set(__self__, "ca_bundle_id", ca_bundle_id)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        (Updatable) Type of certificate.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="caBundleId")
    def ca_bundle_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the CA Bundle resource.
        """
        return pulumi.get(self, "ca_bundle_id")

    @ca_bundle_id.setter
    def ca_bundle_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_bundle_id", value)

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Name of the secret. For Kubernetes this will be the name of an opaque Kubernetes secret with key ca.crt. For other platforms the secret must be mounted at: /etc/oci/secrets/${secretName}/ca.crt
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_name", value)


if not MYPY:
    class IngressGatewayHostListenerTlsServerCertificateArgsDict(TypedDict):
        type: pulumi.Input[str]
        """
        (Updatable) Type of certificate.
        """
        certificate_id: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The OCID of the leaf certificate resource.
        """
        secret_name: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Name of the secret. For Kubernetes this is the name of the Kubernetes secret of type tls. For other platforms the secrets must be mounted at: /etc/oci/secrets/${secretName}/tls.{key,crt}
        """
elif False:
    IngressGatewayHostListenerTlsServerCertificateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IngressGatewayHostListenerTlsServerCertificateArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 certificate_id: Optional[pulumi.Input[str]] = None,
                 secret_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: (Updatable) Type of certificate.
        :param pulumi.Input[str] certificate_id: (Updatable) The OCID of the leaf certificate resource.
        :param pulumi.Input[str] secret_name: (Updatable) Name of the secret. For Kubernetes this is the name of the Kubernetes secret of type tls. For other platforms the secrets must be mounted at: /etc/oci/secrets/${secretName}/tls.{key,crt}
        """
        pulumi.set(__self__, "type", type)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        (Updatable) Type of certificate.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the leaf certificate resource.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_id", value)

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Name of the secret. For Kubernetes this is the name of the Kubernetes secret of type tls. For other platforms the secrets must be mounted at: /etc/oci/secrets/${secretName}/tls.{key,crt}
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_name", value)


if not MYPY:
    class IngressGatewayMtlsArgsDict(TypedDict):
        certificate_id: NotRequired[pulumi.Input[str]]
        """
        The OCID of the certificate resource that will be used for mTLS authentication with other virtual services in the mesh.
        """
        maximum_validity: NotRequired[pulumi.Input[int]]
        """
        (Updatable) The number of days the mTLS certificate is valid.  This value should be less than the Maximum Validity Duration  for Certificates (Days) setting on the Certificate Authority associated with this Mesh.  The certificate will be automatically renewed after 2/3 of the validity period, so a certificate with a maximum validity of 45 days will be renewed every 30 days.
        """
elif False:
    IngressGatewayMtlsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IngressGatewayMtlsArgs:
    def __init__(__self__, *,
                 certificate_id: Optional[pulumi.Input[str]] = None,
                 maximum_validity: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] certificate_id: The OCID of the certificate resource that will be used for mTLS authentication with other virtual services in the mesh.
        :param pulumi.Input[int] maximum_validity: (Updatable) The number of days the mTLS certificate is valid.  This value should be less than the Maximum Validity Duration  for Certificates (Days) setting on the Certificate Authority associated with this Mesh.  The certificate will be automatically renewed after 2/3 of the validity period, so a certificate with a maximum validity of 45 days will be renewed every 30 days.
        """
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if maximum_validity is not None:
            pulumi.set(__self__, "maximum_validity", maximum_validity)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the certificate resource that will be used for mTLS authentication with other virtual services in the mesh.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_id", value)

    @property
    @pulumi.getter(name="maximumValidity")
    def maximum_validity(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of days the mTLS certificate is valid.  This value should be less than the Maximum Validity Duration  for Certificates (Days) setting on the Certificate Authority associated with this Mesh.  The certificate will be automatically renewed after 2/3 of the validity period, so a certificate with a maximum validity of 45 days will be renewed every 30 days.
        """
        return pulumi.get(self, "maximum_validity")

    @maximum_validity.setter
    def maximum_validity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maximum_validity", value)


if not MYPY:
    class IngressGatewayRouteTableRouteRuleArgsDict(TypedDict):
        destinations: pulumi.Input[Sequence[pulumi.Input['IngressGatewayRouteTableRouteRuleDestinationArgsDict']]]
        """
        (Updatable) The destination of the request.
        """
        type: pulumi.Input[str]
        """
        (Updatable) Type of protocol.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ingress_gateway_host: NotRequired[pulumi.Input['IngressGatewayRouteTableRouteRuleIngressGatewayHostArgsDict']]
        """
        (Updatable) The ingress gateway host to which the route rule attaches. If not specified, the route rule gets attached to all hosts on the ingress gateway.
        """
        is_grpc: NotRequired[pulumi.Input[bool]]
        """
        (Updatable) If true, the rule will check that the content-type header has a application/grpc or one of the various application/grpc+ values.
        """
        is_host_rewrite_enabled: NotRequired[pulumi.Input[bool]]
        """
        (Updatable) If true, the hostname will be rewritten to the target virtual deployment's DNS hostname.
        """
        is_path_rewrite_enabled: NotRequired[pulumi.Input[bool]]
        """
        (Updatable) If true, the matched path prefix will be rewritten to '/' before being directed to the target virtual deployment.
        """
        path: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Route to match
        """
        path_type: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Match type for the route
        """
        request_timeout_in_ms: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The maximum duration in milliseconds for the upstream service to respond to a request.  If provided, the timeout value overrides the default timeout of 15 seconds for the HTTP based route rules, and disabled (no timeout) when 'isGrpc' is true.  The value 0 (zero) indicates that the timeout is disabled.  For streaming responses from the upstream service, consider either keeping the timeout disabled or set a sufficiently high value.
        """
elif False:
    IngressGatewayRouteTableRouteRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IngressGatewayRouteTableRouteRuleArgs:
    def __init__(__self__, *,
                 destinations: pulumi.Input[Sequence[pulumi.Input['IngressGatewayRouteTableRouteRuleDestinationArgs']]],
                 type: pulumi.Input[str],
                 ingress_gateway_host: Optional[pulumi.Input['IngressGatewayRouteTableRouteRuleIngressGatewayHostArgs']] = None,
                 is_grpc: Optional[pulumi.Input[bool]] = None,
                 is_host_rewrite_enabled: Optional[pulumi.Input[bool]] = None,
                 is_path_rewrite_enabled: Optional[pulumi.Input[bool]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 path_type: Optional[pulumi.Input[str]] = None,
                 request_timeout_in_ms: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['IngressGatewayRouteTableRouteRuleDestinationArgs']]] destinations: (Updatable) The destination of the request.
        :param pulumi.Input[str] type: (Updatable) Type of protocol.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input['IngressGatewayRouteTableRouteRuleIngressGatewayHostArgs'] ingress_gateway_host: (Updatable) The ingress gateway host to which the route rule attaches. If not specified, the route rule gets attached to all hosts on the ingress gateway.
        :param pulumi.Input[bool] is_grpc: (Updatable) If true, the rule will check that the content-type header has a application/grpc or one of the various application/grpc+ values.
        :param pulumi.Input[bool] is_host_rewrite_enabled: (Updatable) If true, the hostname will be rewritten to the target virtual deployment's DNS hostname.
        :param pulumi.Input[bool] is_path_rewrite_enabled: (Updatable) If true, the matched path prefix will be rewritten to '/' before being directed to the target virtual deployment.
        :param pulumi.Input[str] path: (Updatable) Route to match
        :param pulumi.Input[str] path_type: (Updatable) Match type for the route
        :param pulumi.Input[str] request_timeout_in_ms: (Updatable) The maximum duration in milliseconds for the upstream service to respond to a request.  If provided, the timeout value overrides the default timeout of 15 seconds for the HTTP based route rules, and disabled (no timeout) when 'isGrpc' is true.  The value 0 (zero) indicates that the timeout is disabled.  For streaming responses from the upstream service, consider either keeping the timeout disabled or set a sufficiently high value.
        """
        pulumi.set(__self__, "destinations", destinations)
        pulumi.set(__self__, "type", type)
        if ingress_gateway_host is not None:
            pulumi.set(__self__, "ingress_gateway_host", ingress_gateway_host)
        if is_grpc is not None:
            pulumi.set(__self__, "is_grpc", is_grpc)
        if is_host_rewrite_enabled is not None:
            pulumi.set(__self__, "is_host_rewrite_enabled", is_host_rewrite_enabled)
        if is_path_rewrite_enabled is not None:
            pulumi.set(__self__, "is_path_rewrite_enabled", is_path_rewrite_enabled)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if path_type is not None:
            pulumi.set(__self__, "path_type", path_type)
        if request_timeout_in_ms is not None:
            pulumi.set(__self__, "request_timeout_in_ms", request_timeout_in_ms)

    @property
    @pulumi.getter
    def destinations(self) -> pulumi.Input[Sequence[pulumi.Input['IngressGatewayRouteTableRouteRuleDestinationArgs']]]:
        """
        (Updatable) The destination of the request.
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: pulumi.Input[Sequence[pulumi.Input['IngressGatewayRouteTableRouteRuleDestinationArgs']]]):
        pulumi.set(self, "destinations", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        (Updatable) Type of protocol.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="ingressGatewayHost")
    def ingress_gateway_host(self) -> Optional[pulumi.Input['IngressGatewayRouteTableRouteRuleIngressGatewayHostArgs']]:
        """
        (Updatable) The ingress gateway host to which the route rule attaches. If not specified, the route rule gets attached to all hosts on the ingress gateway.
        """
        return pulumi.get(self, "ingress_gateway_host")

    @ingress_gateway_host.setter
    def ingress_gateway_host(self, value: Optional[pulumi.Input['IngressGatewayRouteTableRouteRuleIngressGatewayHostArgs']]):
        pulumi.set(self, "ingress_gateway_host", value)

    @property
    @pulumi.getter(name="isGrpc")
    def is_grpc(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, the rule will check that the content-type header has a application/grpc or one of the various application/grpc+ values.
        """
        return pulumi.get(self, "is_grpc")

    @is_grpc.setter
    def is_grpc(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_grpc", value)

    @property
    @pulumi.getter(name="isHostRewriteEnabled")
    def is_host_rewrite_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, the hostname will be rewritten to the target virtual deployment's DNS hostname.
        """
        return pulumi.get(self, "is_host_rewrite_enabled")

    @is_host_rewrite_enabled.setter
    def is_host_rewrite_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_host_rewrite_enabled", value)

    @property
    @pulumi.getter(name="isPathRewriteEnabled")
    def is_path_rewrite_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, the matched path prefix will be rewritten to '/' before being directed to the target virtual deployment.
        """
        return pulumi.get(self, "is_path_rewrite_enabled")

    @is_path_rewrite_enabled.setter
    def is_path_rewrite_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_path_rewrite_enabled", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Route to match
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="pathType")
    def path_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Match type for the route
        """
        return pulumi.get(self, "path_type")

    @path_type.setter
    def path_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path_type", value)

    @property
    @pulumi.getter(name="requestTimeoutInMs")
    def request_timeout_in_ms(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The maximum duration in milliseconds for the upstream service to respond to a request.  If provided, the timeout value overrides the default timeout of 15 seconds for the HTTP based route rules, and disabled (no timeout) when 'isGrpc' is true.  The value 0 (zero) indicates that the timeout is disabled.  For streaming responses from the upstream service, consider either keeping the timeout disabled or set a sufficiently high value.
        """
        return pulumi.get(self, "request_timeout_in_ms")

    @request_timeout_in_ms.setter
    def request_timeout_in_ms(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_timeout_in_ms", value)


if not MYPY:
    class IngressGatewayRouteTableRouteRuleDestinationArgsDict(TypedDict):
        virtual_service_id: pulumi.Input[str]
        """
        (Updatable) The OCID of the virtual service where the request will be routed.
        """
        port: NotRequired[pulumi.Input[int]]
        """
        (Updatable) The port on the virtual service to target. Mandatory if the virtual deployments are listening on multiple ports.
        """
        weight: NotRequired[pulumi.Input[int]]
        """
        (Updatable) Weight of traffic target.
        """
elif False:
    IngressGatewayRouteTableRouteRuleDestinationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IngressGatewayRouteTableRouteRuleDestinationArgs:
    def __init__(__self__, *,
                 virtual_service_id: pulumi.Input[str],
                 port: Optional[pulumi.Input[int]] = None,
                 weight: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] virtual_service_id: (Updatable) The OCID of the virtual service where the request will be routed.
        :param pulumi.Input[int] port: (Updatable) The port on the virtual service to target. Mandatory if the virtual deployments are listening on multiple ports.
        :param pulumi.Input[int] weight: (Updatable) Weight of traffic target.
        """
        pulumi.set(__self__, "virtual_service_id", virtual_service_id)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="virtualServiceId")
    def virtual_service_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the virtual service where the request will be routed.
        """
        return pulumi.get(self, "virtual_service_id")

    @virtual_service_id.setter
    def virtual_service_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "virtual_service_id", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The port on the virtual service to target. Mandatory if the virtual deployments are listening on multiple ports.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Weight of traffic target.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "weight", value)


if not MYPY:
    class IngressGatewayRouteTableRouteRuleIngressGatewayHostArgsDict(TypedDict):
        name: pulumi.Input[str]
        """
        (Updatable) Name of the ingress gateway host that this route should apply to.
        """
        port: NotRequired[pulumi.Input[int]]
        """
        (Updatable) The port of the ingress gateway host listener. Leave empty to match all ports for the host.
        """
elif False:
    IngressGatewayRouteTableRouteRuleIngressGatewayHostArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IngressGatewayRouteTableRouteRuleIngressGatewayHostArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] name: (Updatable) Name of the ingress gateway host that this route should apply to.
        :param pulumi.Input[int] port: (Updatable) The port of the ingress gateway host listener. Leave empty to match all ports for the host.
        """
        pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        (Updatable) Name of the ingress gateway host that this route should apply to.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The port of the ingress gateway host listener. Leave empty to match all ports for the host.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


if not MYPY:
    class MeshCertificateAuthorityArgsDict(TypedDict):
        id: pulumi.Input[str]
        """
        The OCID of the certificate authority resource.
        """
elif False:
    MeshCertificateAuthorityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MeshCertificateAuthorityArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] id: The OCID of the certificate authority resource.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        The OCID of the certificate authority resource.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)


if not MYPY:
    class MeshMtlsArgsDict(TypedDict):
        minimum: pulumi.Input[str]
        """
        (Updatable) DISABLED: No minimum virtual services within this mesh can use any mTLS authentication mode. PERMISSIVE: Virtual services within this mesh can use either PERMISSIVE or STRICT modes. STRICT: All virtual services within this mesh must use STRICT mode. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
elif False:
    MeshMtlsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MeshMtlsArgs:
    def __init__(__self__, *,
                 minimum: pulumi.Input[str]):
        """
        :param pulumi.Input[str] minimum: (Updatable) DISABLED: No minimum virtual services within this mesh can use any mTLS authentication mode. PERMISSIVE: Virtual services within this mesh can use either PERMISSIVE or STRICT modes. STRICT: All virtual services within this mesh must use STRICT mode. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "minimum", minimum)

    @property
    @pulumi.getter
    def minimum(self) -> pulumi.Input[str]:
        """
        (Updatable) DISABLED: No minimum virtual services within this mesh can use any mTLS authentication mode. PERMISSIVE: Virtual services within this mesh can use either PERMISSIVE or STRICT modes. STRICT: All virtual services within this mesh must use STRICT mode. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "minimum")

    @minimum.setter
    def minimum(self, value: pulumi.Input[str]):
        pulumi.set(self, "minimum", value)


if not MYPY:
    class VirtualDeploymentAccessLoggingArgsDict(TypedDict):
        is_enabled: NotRequired[pulumi.Input[bool]]
        """
        (Updatable) Determines if the logging configuration is enabled.
        """
elif False:
    VirtualDeploymentAccessLoggingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VirtualDeploymentAccessLoggingArgs:
    def __init__(__self__, *,
                 is_enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] is_enabled: (Updatable) Determines if the logging configuration is enabled.
        """
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Determines if the logging configuration is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enabled", value)


if not MYPY:
    class VirtualDeploymentListenerArgsDict(TypedDict):
        port: pulumi.Input[int]
        """
        (Updatable) Port in which virtual deployment is running.
        """
        protocol: pulumi.Input[str]
        """
        (Updatable) Type of protocol used in virtual deployment.
        """
        idle_timeout_in_ms: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The maximum duration in milliseconds for which the request's stream may be idle. The value 0 (zero) indicates that the timeout is disabled.
        """
        request_timeout_in_ms: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The maximum duration in milliseconds for the deployed service to respond to an incoming request through the listener.  If provided, the timeout value overrides the default timeout of 15 seconds for the HTTP/HTTP2 listeners, and disabled (no timeout) for the GRPC listeners. The value 0 (zero) indicates that the timeout is disabled.  The timeout cannot be configured for the TCP and TLS_PASSTHROUGH listeners.  For streaming responses from the deployed service, consider either keeping the timeout disabled or set a sufficiently high value.
        """
elif False:
    VirtualDeploymentListenerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VirtualDeploymentListenerArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[int],
                 protocol: pulumi.Input[str],
                 idle_timeout_in_ms: Optional[pulumi.Input[str]] = None,
                 request_timeout_in_ms: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] port: (Updatable) Port in which virtual deployment is running.
        :param pulumi.Input[str] protocol: (Updatable) Type of protocol used in virtual deployment.
        :param pulumi.Input[str] idle_timeout_in_ms: (Updatable) The maximum duration in milliseconds for which the request's stream may be idle. The value 0 (zero) indicates that the timeout is disabled.
        :param pulumi.Input[str] request_timeout_in_ms: (Updatable) The maximum duration in milliseconds for the deployed service to respond to an incoming request through the listener.  If provided, the timeout value overrides the default timeout of 15 seconds for the HTTP/HTTP2 listeners, and disabled (no timeout) for the GRPC listeners. The value 0 (zero) indicates that the timeout is disabled.  The timeout cannot be configured for the TCP and TLS_PASSTHROUGH listeners.  For streaming responses from the deployed service, consider either keeping the timeout disabled or set a sufficiently high value.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        if idle_timeout_in_ms is not None:
            pulumi.set(__self__, "idle_timeout_in_ms", idle_timeout_in_ms)
        if request_timeout_in_ms is not None:
            pulumi.set(__self__, "request_timeout_in_ms", request_timeout_in_ms)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        (Updatable) Port in which virtual deployment is running.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        (Updatable) Type of protocol used in virtual deployment.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="idleTimeoutInMs")
    def idle_timeout_in_ms(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The maximum duration in milliseconds for which the request's stream may be idle. The value 0 (zero) indicates that the timeout is disabled.
        """
        return pulumi.get(self, "idle_timeout_in_ms")

    @idle_timeout_in_ms.setter
    def idle_timeout_in_ms(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idle_timeout_in_ms", value)

    @property
    @pulumi.getter(name="requestTimeoutInMs")
    def request_timeout_in_ms(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The maximum duration in milliseconds for the deployed service to respond to an incoming request through the listener.  If provided, the timeout value overrides the default timeout of 15 seconds for the HTTP/HTTP2 listeners, and disabled (no timeout) for the GRPC listeners. The value 0 (zero) indicates that the timeout is disabled.  The timeout cannot be configured for the TCP and TLS_PASSTHROUGH listeners.  For streaming responses from the deployed service, consider either keeping the timeout disabled or set a sufficiently high value.
        """
        return pulumi.get(self, "request_timeout_in_ms")

    @request_timeout_in_ms.setter
    def request_timeout_in_ms(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_timeout_in_ms", value)


if not MYPY:
    class VirtualDeploymentServiceDiscoveryArgsDict(TypedDict):
        type: pulumi.Input[str]
        """
        (Updatable) Type of service discovery.
        """
        hostname: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The hostname of the virtual deployments.
        """
elif False:
    VirtualDeploymentServiceDiscoveryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VirtualDeploymentServiceDiscoveryArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 hostname: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: (Updatable) Type of service discovery.
        :param pulumi.Input[str] hostname: (Updatable) The hostname of the virtual deployments.
        """
        pulumi.set(__self__, "type", type)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        (Updatable) Type of service discovery.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The hostname of the virtual deployments.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)


if not MYPY:
    class VirtualServiceDefaultRoutingPolicyArgsDict(TypedDict):
        type: pulumi.Input[str]
        """
        (Updatable) Type of the virtual service routing policy.
        """
elif False:
    VirtualServiceDefaultRoutingPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VirtualServiceDefaultRoutingPolicyArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] type: (Updatable) Type of the virtual service routing policy.
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        (Updatable) Type of the virtual service routing policy.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class VirtualServiceMtlsArgsDict(TypedDict):
        mode: pulumi.Input[str]
        """
        (Updatable) DISABLED: Connection is not tunneled. PERMISSIVE: Connection can be either plaintext or an mTLS tunnel. STRICT: Connection is an mTLS tunnel.  Clients without a valid certificate will be rejected.
        """
        certificate_id: NotRequired[pulumi.Input[str]]
        """
        The OCID of the certificate resource that will be used for mTLS authentication with other virtual services in the mesh.
        """
        maximum_validity: NotRequired[pulumi.Input[int]]
        """
        (Updatable) The number of days the mTLS certificate is valid.  This value should be less than the Maximum Validity Duration  for Certificates (Days) setting on the Certificate Authority associated with this Mesh.  The certificate will be automatically renewed after 2/3 of the validity period, so a certificate with a maximum validity of 45 days will be renewed every 30 days.
        """
elif False:
    VirtualServiceMtlsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VirtualServiceMtlsArgs:
    def __init__(__self__, *,
                 mode: pulumi.Input[str],
                 certificate_id: Optional[pulumi.Input[str]] = None,
                 maximum_validity: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] mode: (Updatable) DISABLED: Connection is not tunneled. PERMISSIVE: Connection can be either plaintext or an mTLS tunnel. STRICT: Connection is an mTLS tunnel.  Clients without a valid certificate will be rejected.
        :param pulumi.Input[str] certificate_id: The OCID of the certificate resource that will be used for mTLS authentication with other virtual services in the mesh.
        :param pulumi.Input[int] maximum_validity: (Updatable) The number of days the mTLS certificate is valid.  This value should be less than the Maximum Validity Duration  for Certificates (Days) setting on the Certificate Authority associated with this Mesh.  The certificate will be automatically renewed after 2/3 of the validity period, so a certificate with a maximum validity of 45 days will be renewed every 30 days.
        """
        pulumi.set(__self__, "mode", mode)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if maximum_validity is not None:
            pulumi.set(__self__, "maximum_validity", maximum_validity)

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Input[str]:
        """
        (Updatable) DISABLED: Connection is not tunneled. PERMISSIVE: Connection can be either plaintext or an mTLS tunnel. STRICT: Connection is an mTLS tunnel.  Clients without a valid certificate will be rejected.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the certificate resource that will be used for mTLS authentication with other virtual services in the mesh.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_id", value)

    @property
    @pulumi.getter(name="maximumValidity")
    def maximum_validity(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of days the mTLS certificate is valid.  This value should be less than the Maximum Validity Duration  for Certificates (Days) setting on the Certificate Authority associated with this Mesh.  The certificate will be automatically renewed after 2/3 of the validity period, so a certificate with a maximum validity of 45 days will be renewed every 30 days.
        """
        return pulumi.get(self, "maximum_validity")

    @maximum_validity.setter
    def maximum_validity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maximum_validity", value)


if not MYPY:
    class VirtualServiceRouteTableRouteRuleArgsDict(TypedDict):
        destinations: pulumi.Input[Sequence[pulumi.Input['VirtualServiceRouteTableRouteRuleDestinationArgsDict']]]
        """
        (Updatable) The destination of the request.
        """
        type: pulumi.Input[str]
        """
        (Updatable) Type of protocol.
        """
        is_grpc: NotRequired[pulumi.Input[bool]]
        """
        (Updatable) If true, the rule will check that the content-type header has a application/grpc or one of the various application/grpc+ values.
        """
        path: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Route to match
        """
        path_type: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Match type for the route
        """
        request_timeout_in_ms: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The maximum duration in milliseconds for the target service to respond to a request.  If provided, the timeout value overrides the default timeout of 15 seconds for the HTTP based route rules, and disabled (no timeout) when 'isGrpc' is true.  The value 0 (zero) indicates that the timeout is disabled.  For streaming responses from the target service, consider either keeping the timeout disabled or set a sufficiently high value.
        """
elif False:
    VirtualServiceRouteTableRouteRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VirtualServiceRouteTableRouteRuleArgs:
    def __init__(__self__, *,
                 destinations: pulumi.Input[Sequence[pulumi.Input['VirtualServiceRouteTableRouteRuleDestinationArgs']]],
                 type: pulumi.Input[str],
                 is_grpc: Optional[pulumi.Input[bool]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 path_type: Optional[pulumi.Input[str]] = None,
                 request_timeout_in_ms: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['VirtualServiceRouteTableRouteRuleDestinationArgs']]] destinations: (Updatable) The destination of the request.
        :param pulumi.Input[str] type: (Updatable) Type of protocol.
        :param pulumi.Input[bool] is_grpc: (Updatable) If true, the rule will check that the content-type header has a application/grpc or one of the various application/grpc+ values.
        :param pulumi.Input[str] path: (Updatable) Route to match
        :param pulumi.Input[str] path_type: (Updatable) Match type for the route
        :param pulumi.Input[str] request_timeout_in_ms: (Updatable) The maximum duration in milliseconds for the target service to respond to a request.  If provided, the timeout value overrides the default timeout of 15 seconds for the HTTP based route rules, and disabled (no timeout) when 'isGrpc' is true.  The value 0 (zero) indicates that the timeout is disabled.  For streaming responses from the target service, consider either keeping the timeout disabled or set a sufficiently high value.
        """
        pulumi.set(__self__, "destinations", destinations)
        pulumi.set(__self__, "type", type)
        if is_grpc is not None:
            pulumi.set(__self__, "is_grpc", is_grpc)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if path_type is not None:
            pulumi.set(__self__, "path_type", path_type)
        if request_timeout_in_ms is not None:
            pulumi.set(__self__, "request_timeout_in_ms", request_timeout_in_ms)

    @property
    @pulumi.getter
    def destinations(self) -> pulumi.Input[Sequence[pulumi.Input['VirtualServiceRouteTableRouteRuleDestinationArgs']]]:
        """
        (Updatable) The destination of the request.
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: pulumi.Input[Sequence[pulumi.Input['VirtualServiceRouteTableRouteRuleDestinationArgs']]]):
        pulumi.set(self, "destinations", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        (Updatable) Type of protocol.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="isGrpc")
    def is_grpc(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, the rule will check that the content-type header has a application/grpc or one of the various application/grpc+ values.
        """
        return pulumi.get(self, "is_grpc")

    @is_grpc.setter
    def is_grpc(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_grpc", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Route to match
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="pathType")
    def path_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Match type for the route
        """
        return pulumi.get(self, "path_type")

    @path_type.setter
    def path_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path_type", value)

    @property
    @pulumi.getter(name="requestTimeoutInMs")
    def request_timeout_in_ms(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The maximum duration in milliseconds for the target service to respond to a request.  If provided, the timeout value overrides the default timeout of 15 seconds for the HTTP based route rules, and disabled (no timeout) when 'isGrpc' is true.  The value 0 (zero) indicates that the timeout is disabled.  For streaming responses from the target service, consider either keeping the timeout disabled or set a sufficiently high value.
        """
        return pulumi.get(self, "request_timeout_in_ms")

    @request_timeout_in_ms.setter
    def request_timeout_in_ms(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_timeout_in_ms", value)


if not MYPY:
    class VirtualServiceRouteTableRouteRuleDestinationArgsDict(TypedDict):
        virtual_deployment_id: pulumi.Input[str]
        """
        (Updatable) The OCID of the virtual deployment where the request will be routed.
        """
        weight: pulumi.Input[int]
        """
        (Updatable) Weight of traffic target.
        """
        port: NotRequired[pulumi.Input[int]]
        """
        (Updatable) Port on virtual deployment to target. If port is missing, the rule will target all ports on the virtual deployment.
        """
elif False:
    VirtualServiceRouteTableRouteRuleDestinationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VirtualServiceRouteTableRouteRuleDestinationArgs:
    def __init__(__self__, *,
                 virtual_deployment_id: pulumi.Input[str],
                 weight: pulumi.Input[int],
                 port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] virtual_deployment_id: (Updatable) The OCID of the virtual deployment where the request will be routed.
        :param pulumi.Input[int] weight: (Updatable) Weight of traffic target.
        :param pulumi.Input[int] port: (Updatable) Port on virtual deployment to target. If port is missing, the rule will target all ports on the virtual deployment.
        """
        pulumi.set(__self__, "virtual_deployment_id", virtual_deployment_id)
        pulumi.set(__self__, "weight", weight)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="virtualDeploymentId")
    def virtual_deployment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the virtual deployment where the request will be routed.
        """
        return pulumi.get(self, "virtual_deployment_id")

    @virtual_deployment_id.setter
    def virtual_deployment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "virtual_deployment_id", value)

    @property
    @pulumi.getter
    def weight(self) -> pulumi.Input[int]:
        """
        (Updatable) Weight of traffic target.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: pulumi.Input[int]):
        pulumi.set(self, "weight", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Port on virtual deployment to target. If port is missing, the rule will target all ports on the virtual deployment.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


if not MYPY:
    class GetAccessPoliciesFilterArgsDict(TypedDict):
        name: str
        """
        A filter to return only resources that match the entire name given.
        """
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetAccessPoliciesFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetAccessPoliciesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: A filter to return only resources that match the entire name given.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that match the entire name given.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetIngressGatewayRouteTablesFilterArgsDict(TypedDict):
        name: str
        """
        A filter to return only resources that match the entire name given.
        """
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetIngressGatewayRouteTablesFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetIngressGatewayRouteTablesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: A filter to return only resources that match the entire name given.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that match the entire name given.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetIngressGatewaysFilterArgsDict(TypedDict):
        name: str
        """
        A filter to return only resources that match the entire name given.
        """
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetIngressGatewaysFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetIngressGatewaysFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: A filter to return only resources that match the entire name given.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that match the entire name given.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetMeshesFilterArgsDict(TypedDict):
        name: str
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetMeshesFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetMeshesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetVirtualDeploymentsFilterArgsDict(TypedDict):
        name: str
        """
        A filter to return only resources that match the entire name given.
        """
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetVirtualDeploymentsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetVirtualDeploymentsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: A filter to return only resources that match the entire name given.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that match the entire name given.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetVirtualServiceRouteTablesFilterArgsDict(TypedDict):
        name: str
        """
        A filter to return only resources that match the entire name given.
        """
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetVirtualServiceRouteTablesFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetVirtualServiceRouteTablesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: A filter to return only resources that match the entire name given.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that match the entire name given.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetVirtualServicesFilterArgsDict(TypedDict):
        name: str
        """
        A filter to return only resources that match the entire name given.
        """
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetVirtualServicesFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetVirtualServicesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: A filter to return only resources that match the entire name given.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that match the entire name given.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


