/*
 * Decompiled with CFR 0.152.
 */
package io.ray.api.options;

import io.ray.api.concurrencygroup.ConcurrencyGroup;
import io.ray.api.options.ActorLifetime;
import io.ray.api.options.BaseTaskOptions;
import io.ray.api.placementgroup.PlacementGroup;
import io.ray.api.runtimeenv.RuntimeEnv;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActorCreationOptions
extends BaseTaskOptions {
    public static final int NO_RESTART = 0;
    public static final int INFINITE_RESTART = -1;
    public final String name;
    public ActorLifetime lifetime;
    public final int maxRestarts;
    public final int maxTaskRetries;
    public final List<String> jvmOptions;
    public final int maxConcurrency;
    public final PlacementGroup group;
    public final int bundleIndex;
    public final List<ConcurrencyGroup> concurrencyGroups;
    public final String serializedRuntimeEnv;
    public final String namespace;
    public final int maxPendingCalls;
    public final boolean isAsync;
    public final boolean executeOutOfOrder;

    private ActorCreationOptions(String name, ActorLifetime lifetime, Map<String, Double> resources, int maxRestarts, int maxTaskRetries, List<String> jvmOptions, int maxConcurrency, PlacementGroup group, int bundleIndex, List<ConcurrencyGroup> concurrencyGroups, String serializedRuntimeEnv, String namespace, int maxPendingCalls, boolean isAsync) {
        super(resources);
        this.name = name;
        this.lifetime = lifetime;
        this.maxRestarts = maxRestarts;
        this.maxTaskRetries = maxTaskRetries;
        this.jvmOptions = jvmOptions;
        this.maxConcurrency = maxConcurrency;
        this.group = group;
        this.bundleIndex = bundleIndex;
        this.concurrencyGroups = concurrencyGroups;
        this.serializedRuntimeEnv = serializedRuntimeEnv;
        this.namespace = namespace;
        this.maxPendingCalls = maxPendingCalls;
        this.isAsync = isAsync;
        this.executeOutOfOrder = isAsync;
    }

    public static class Builder {
        private String name;
        private ActorLifetime lifetime = null;
        private Map<String, Double> resources = new HashMap<String, Double>();
        private int maxRestarts = 0;
        private int maxTaskRetries = 0;
        private List<String> jvmOptions = new ArrayList<String>();
        private int maxConcurrency = 1;
        private PlacementGroup group;
        private int bundleIndex;
        private List<ConcurrencyGroup> concurrencyGroups = new ArrayList<ConcurrencyGroup>();
        private RuntimeEnv runtimeEnv = null;
        private String namespace = null;
        private int maxPendingCalls = -1;
        private boolean isAsync = false;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setLifetime(ActorLifetime lifetime) {
            this.lifetime = lifetime;
            return this;
        }

        public Builder setResource(String resourceName, Double resourceQuantity) {
            this.resources.put(resourceName, resourceQuantity);
            return this;
        }

        public Builder setResources(Map<String, Double> resources) {
            this.resources.putAll(resources);
            return this;
        }

        public Builder setMaxRestarts(int maxRestarts) {
            this.maxRestarts = maxRestarts;
            return this;
        }

        public Builder setMaxTaskRetries(int maxTaskRetries) {
            this.maxTaskRetries = maxTaskRetries;
            return this;
        }

        public Builder setJvmOptions(List<String> jvmOptions) {
            this.jvmOptions = jvmOptions;
            return this;
        }

        public Builder setMaxConcurrency(int maxConcurrency) {
            if (maxConcurrency <= 0) {
                throw new IllegalArgumentException("maxConcurrency must be greater than 0.");
            }
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public Builder setMaxPendingCalls(int maxPendingCalls) {
            if (maxPendingCalls < -1 || maxPendingCalls == 0) {
                throw new IllegalArgumentException("maxPendingCalls must be greater than 0, or -1 to disable.");
            }
            this.maxPendingCalls = maxPendingCalls;
            return this;
        }

        public Builder setAsync(boolean isAsync) {
            this.isAsync = isAsync;
            return this;
        }

        public Builder setPlacementGroup(PlacementGroup group, int bundleIndex) {
            this.group = group;
            this.bundleIndex = bundleIndex;
            return this;
        }

        public ActorCreationOptions build() {
            return new ActorCreationOptions(this.name, this.lifetime, this.resources, this.maxRestarts, this.maxTaskRetries, this.jvmOptions, this.maxConcurrency, this.group, this.bundleIndex, this.concurrencyGroups, this.runtimeEnv != null ? this.runtimeEnv.serializeToRuntimeEnvInfo() : "", this.namespace, this.maxPendingCalls, this.isAsync);
        }

        public Builder setConcurrencyGroups(List<ConcurrencyGroup> concurrencyGroups) {
            this.concurrencyGroups = concurrencyGroups;
            return this;
        }

        public Builder setRuntimeEnv(RuntimeEnv runtimeEnv) {
            this.runtimeEnv = runtimeEnv;
            return this;
        }

        public Builder setNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }
    }
}

