"""
    DSOTM API

    Allow clients to send transactions data to FactSet  # noqa: E501

    The version of the OpenAPI document: 1
    Contact: analytics.api.support@factset.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from fds.sdk.DirectStreamingofTransactionMessages.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from fds.sdk.DirectStreamingofTransactionMessages.exceptions import ApiAttributeError



class ExecutionParameters(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'net': (float,),  # noqa: E501
            'gross': (float,),  # noqa: E501
            'settlementvalue': (float,),  # noqa: E501
            'settlementdate': (str,),  # noqa: E501
            'portfolio': (str,),  # noqa: E501
            'transactionid': (str,),  # noqa: E501
            'symbol': (str,),  # noqa: E501
            'tradetype': (str,),  # noqa: E501
            'status': (str,),  # noqa: E501
            'tradedate': (str,),  # noqa: E501
            'amount': (float,),  # noqa: E501
            'currencyiso': (str,),  # noqa: E501
            'settlementcurrencyiso': (str,),  # noqa: E501
            'description': (str,),  # noqa: E501
            'transactionleaves': (float,),  # noqa: E501
            'foreignexchangerate': (float,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'net': 'net',  # noqa: E501
        'gross': 'gross',  # noqa: E501
        'settlementvalue': 'settlementvalue',  # noqa: E501
        'settlementdate': 'settlementdate',  # noqa: E501
        'portfolio': 'portfolio',  # noqa: E501
        'transactionid': 'transactionid',  # noqa: E501
        'symbol': 'symbol',  # noqa: E501
        'tradetype': 'tradetype',  # noqa: E501
        'status': 'status',  # noqa: E501
        'tradedate': 'tradedate',  # noqa: E501
        'amount': 'amount',  # noqa: E501
        'currencyiso': 'currencyiso',  # noqa: E501
        'settlementcurrencyiso': 'settlementcurrencyiso',  # noqa: E501
        'description': 'description',  # noqa: E501
        'transactionleaves': 'transactionleaves',  # noqa: E501
        'foreignexchangerate': 'foreignexchangerate',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, net, gross, settlementvalue, settlementdate, portfolio, transactionid, symbol, tradetype, status, tradedate, amount, currencyiso, *args, **kwargs):  # noqa: E501
        """ExecutionParameters - a model defined in OpenAPI

        Args:
            net (float): Cash value of the transaction, net of brokerage costs.
            gross (float): Cash value of the transaction, including brokerage costs
            settlementvalue (float): Cash value of the transaction, a value that has been multiplied by an applicable FX rates to convert the a transacti
            settlementdate (str): Settlement date in YYYYMMDD format
            portfolio (str): Path of the portfolio (Ex: Client:/folder1/testing.ofdb)
            transactionid (str): Unique id for the transaction
            symbol (str): Symbol corresponding to the traded instrument.
            tradetype (str): Trade type could be any of the following values BL, BC, SL, SS.  which stands for Buy Long, Buy to cover, Sell Long and Sell Short respectively.
            status (str): Status could be any of the following value: ACCT or CNCL.  which stands for Accounted and Cancelled respectively.
            tradedate (str): Transaction date which is in the format YYYYMMDD
            amount (float): Quantity of the instrument traded.
            currencyiso (str): The currency code of cash valued fields, Net Amount and Gross Amount.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            settlementcurrencyiso (str): Currency code for Settlement Value. [optional]  # noqa: E501
            description (str): Description. [optional]  # noqa: E501
            transactionleaves (float): Shares that have been ordered and not executed. [optional]  # noqa: E501
            foreignexchangerate (float): FX rate that can be picked up by PA, multiplied with the cash valued fields, Net, Gross, to allow PA to show transactions in reporting currency.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.net = net
        self.gross = gross
        self.settlementvalue = settlementvalue
        self.settlementdate = settlementdate
        self.portfolio = portfolio
        self.transactionid = transactionid
        self.symbol = symbol
        self.tradetype = tradetype
        self.status = status
        self.tradedate = tradedate
        self.amount = amount
        self.currencyiso = currencyiso
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, net, gross, settlementvalue, settlementdate, portfolio, transactionid, symbol, tradetype, status, tradedate, amount, currencyiso, *args, **kwargs):  # noqa: E501
        """ExecutionParameters - a model defined in OpenAPI

        Args:
            net (float): Cash value of the transaction, net of brokerage costs.
            gross (float): Cash value of the transaction, including brokerage costs
            settlementvalue (float): Cash value of the transaction, a value that has been multiplied by an applicable FX rates to convert the a transacti
            settlementdate (str): Settlement date in YYYYMMDD format
            portfolio (str): Path of the portfolio (Ex: Client:/folder1/testing.ofdb)
            transactionid (str): Unique id for the transaction
            symbol (str): Symbol corresponding to the traded instrument.
            tradetype (str): Trade type could be any of the following values BL, BC, SL, SS.  which stands for Buy Long, Buy to cover, Sell Long and Sell Short respectively.
            status (str): Status could be any of the following value: ACCT or CNCL.  which stands for Accounted and Cancelled respectively.
            tradedate (str): Transaction date which is in the format YYYYMMDD
            amount (float): Quantity of the instrument traded.
            currencyiso (str): The currency code of cash valued fields, Net Amount and Gross Amount.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            settlementcurrencyiso (str): Currency code for Settlement Value. [optional]  # noqa: E501
            description (str): Description. [optional]  # noqa: E501
            transactionleaves (float): Shares that have been ordered and not executed. [optional]  # noqa: E501
            foreignexchangerate (float): FX rate that can be picked up by PA, multiplied with the cash valued fields, Net, Gross, to allow PA to show transactions in reporting currency.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.net = net
        self.gross = gross
        self.settlementvalue = settlementvalue
        self.settlementdate = settlementdate
        self.portfolio = portfolio
        self.transactionid = transactionid
        self.symbol = symbol
        self.tradetype = tradetype
        self.status = status
        self.tradedate = tradedate
        self.amount = amount
        self.currencyiso = currencyiso
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
