# dbt-oracle

[![PyPI version](https://badge.fury.io/py/dbt-oracle.svg)](https://pypi.python.org/pypi/dbt-oracle)
[![dbt-tests-adapter](https://github.com/oracle/dbt-oracle/actions/workflows/oracle-xe-adapter-tests.yml/badge.svg)](https://github.com/oracle/dbt-oracle/actions/workflows/oracle-xe-adapter-tests.yml)
[![dbt-oracle docs](https://img.shields.io/badge/docs-read-blue)](https://docs.getdbt.com/reference/warehouse-setups/oracle-setup)
[![dbt-oracle license](https://img.shields.io/badge/license-Apache%202.0-blue)][4]

`dbt-oracle` implements [dbt (data build tool)](https://docs.getdbt.com/docs/introduction) functionalities for Oracle Autonomous Database. 

> Prior to version 1.0.0, dbt-oracle was created and maintained by [Indicium](https://indicium.tech/) on [their GitHub repo](https://github.com/techindicium/dbt-oracle). Contributors in this repo are credited for laying the groundwork and maintaining the adapter till version 0.4.3.
From version 1.0.0, dbt-oracle is maintained and distributed by Oracle.


## Installation

```bash
pip install dbt-oracle
```


## Documentation

Please refer to the [Oracle setup on dbt docs website][1] for documentation.

## Help

Questions can be asked either in [db-oracle community Slack channel][6] or in [GitHub Discussions][7]

Bugs reports or feature requests can be raised in [GitHub Issues][8]

## Sample project

To get started, a sample dbt project can be found in the directory [/dbt_adbs_test_project][5].

## Contributing

This project welcomes contributions from the community. Before submitting a pull request, please [review our contribution guide](./CONTRIBUTING.md).

## Security

Please consult the [security guide](./SECURITY.md) for our responsible security vulnerability disclosure process.

## License
dbt-oracle is licensed under Apache 2.0 License which you can find [here][4].

[1]: https://docs.getdbt.com/reference/warehouse-profiles/oracle-profile
[2]: https://github.com/oracle/dbt-oracle/blob/main/CONTRIBUTING.md
[3]: https://github.com/oracle/dbt-oracle/blob/main/SECURITY.md
[4]: https://github.com/oracle/dbt-oracle/blob/main/LICENSE.txt
[5]: https://github.com/oracle/dbt-oracle/tree/main/dbt_adbs_test_project
[6]: https://getdbt.slack.com/archives/C01PWH4TXLY
[7]: https://github.com/oracle/dbt-oracle/discussions
[8]: https://github.com/oracle/dbt-oracle/issues

