# Generated by Django 4.2 on 2023-09-30 23:09

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="TimeSerie",
            fields=[
                (
                    "timestamp",
                    models.DateTimeField(
                        primary_key=True, serialize=False, verbose_name="Timestamp"
                    ),
                ),
                ("value", models.FloatField(verbose_name="Value")),
            ],
            options={
                "db_table": "timescaledbapp_timeserie",
                "managed": False,
            },
        ),
        migrations.CreateModel(
            name="Source",
            fields=[
                (
                    "label",
                    models.CharField(
                        max_length=64,
                        primary_key=True,
                        serialize=False,
                        unique=True,
                        verbose_name="Source ID",
                    ),
                ),
                ("name", models.CharField(max_length=256, verbose_name="Name")),
                (
                    "location",
                    models.CharField(
                        blank=True, max_length=256, null=True, verbose_name="Location"
                    ),
                ),
                (
                    "device",
                    models.CharField(
                        blank=True, max_length=256, null=True, verbose_name="Device"
                    ),
                ),
                (
                    "protocol",
                    models.CharField(
                        blank=True, max_length=256, null=True, verbose_name="Protocol"
                    ),
                ),
                (
                    "version",
                    models.CharField(
                        blank=True, max_length=16, null=True, verbose_name="Version"
                    ),
                ),
                (
                    "description",
                    models.TextField(
                        blank=True,
                        max_length=32768,
                        null=True,
                        verbose_name="Description",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(auto_now_add=True, verbose_name="Created"),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Measure",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("label", models.CharField(max_length=16, verbose_name="Label")),
                ("name", models.CharField(max_length=256, verbose_name="Name")),
                (
                    "description",
                    models.TextField(
                        blank=True,
                        max_length=32768,
                        null=True,
                        verbose_name="Description",
                    ),
                ),
                (
                    "source",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="measures",
                        to="timescaledbapp.source",
                    ),
                ),
            ],
            options={
                "unique_together": {("source", "label")},
            },
        ),
        migrations.CreateModel(
            name="Chunk",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("label", models.CharField(blank=True, max_length=32, null=True)),
                (
                    "measure",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="chunks",
                        to="timescaledbapp.measure",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Channel",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("label", models.CharField(max_length=16, verbose_name="Label")),
                ("name", models.CharField(max_length=256, verbose_name="Name")),
                ("unit", models.CharField(max_length=256, verbose_name="Unit")),
                ("sampling_rate", models.FloatField(verbose_name="Sampling rate")),
                (
                    "description",
                    models.TextField(
                        blank=True,
                        max_length=32768,
                        null=True,
                        verbose_name="Description",
                    ),
                ),
                ("count", models.IntegerField(default=0, verbose_name="Count")),
                (
                    "scale_factor",
                    models.FloatField(default=1, verbose_name="Scale factor"),
                ),
                (
                    "measure",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="channels",
                        to="timescaledbapp.measure",
                    ),
                ),
            ],
            options={
                "unique_together": {("measure", "label")},
            },
        ),
    ]
