# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetSystemBfdFeatureResult',
    'AwaitableGetSystemBfdFeatureResult',
    'get_system_bfd_feature',
    'get_system_bfd_feature_output',
]

@pulumi.output_type
class GetSystemBfdFeatureResult:
    """
    A collection of values returned by getSystemBfdFeature.
    """
    def __init__(__self__, colors=None, default_dscp=None, default_dscp_variable=None, description=None, feature_profile_id=None, id=None, multiplier=None, multiplier_variable=None, name=None, poll_interval=None, poll_interval_variable=None, version=None):
        if colors and not isinstance(colors, list):
            raise TypeError("Expected argument 'colors' to be a list")
        pulumi.set(__self__, "colors", colors)
        if default_dscp and not isinstance(default_dscp, int):
            raise TypeError("Expected argument 'default_dscp' to be a int")
        pulumi.set(__self__, "default_dscp", default_dscp)
        if default_dscp_variable and not isinstance(default_dscp_variable, str):
            raise TypeError("Expected argument 'default_dscp_variable' to be a str")
        pulumi.set(__self__, "default_dscp_variable", default_dscp_variable)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if feature_profile_id and not isinstance(feature_profile_id, str):
            raise TypeError("Expected argument 'feature_profile_id' to be a str")
        pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if multiplier and not isinstance(multiplier, int):
            raise TypeError("Expected argument 'multiplier' to be a int")
        pulumi.set(__self__, "multiplier", multiplier)
        if multiplier_variable and not isinstance(multiplier_variable, str):
            raise TypeError("Expected argument 'multiplier_variable' to be a str")
        pulumi.set(__self__, "multiplier_variable", multiplier_variable)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if poll_interval and not isinstance(poll_interval, int):
            raise TypeError("Expected argument 'poll_interval' to be a int")
        pulumi.set(__self__, "poll_interval", poll_interval)
        if poll_interval_variable and not isinstance(poll_interval_variable, str):
            raise TypeError("Expected argument 'poll_interval_variable' to be a str")
        pulumi.set(__self__, "poll_interval_variable", poll_interval_variable)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def colors(self) -> Sequence['outputs.GetSystemBfdFeatureColorResult']:
        """
        Set color that identifies the WAN transport tunnel
        """
        return pulumi.get(self, "colors")

    @property
    @pulumi.getter(name="defaultDscp")
    def default_dscp(self) -> int:
        return pulumi.get(self, "default_dscp")

    @property
    @pulumi.getter(name="defaultDscpVariable")
    def default_dscp_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "default_dscp_variable")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> str:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the Feature
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def multiplier(self) -> int:
        return pulumi.get(self, "multiplier")

    @property
    @pulumi.getter(name="multiplierVariable")
    def multiplier_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "multiplier_variable")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pollInterval")
    def poll_interval(self) -> int:
        return pulumi.get(self, "poll_interval")

    @property
    @pulumi.getter(name="pollIntervalVariable")
    def poll_interval_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "poll_interval_variable")

    @property
    @pulumi.getter
    def version(self) -> int:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")


class AwaitableGetSystemBfdFeatureResult(GetSystemBfdFeatureResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSystemBfdFeatureResult(
            colors=self.colors,
            default_dscp=self.default_dscp,
            default_dscp_variable=self.default_dscp_variable,
            description=self.description,
            feature_profile_id=self.feature_profile_id,
            id=self.id,
            multiplier=self.multiplier,
            multiplier_variable=self.multiplier_variable,
            name=self.name,
            poll_interval=self.poll_interval,
            poll_interval_variable=self.poll_interval_variable,
            version=self.version)


def get_system_bfd_feature(feature_profile_id: Optional[str] = None,
                           id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSystemBfdFeatureResult:
    """
    This data source can read the System BFD Feature.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_system_bfd_feature(id="f6b2c44c-693c-4763-b010-895aa3d236bd",
        feature_profile_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac")
    ```


    :param str feature_profile_id: Feature Profile ID
    :param str id: The id of the Feature
    """
    __args__ = dict()
    __args__['featureProfileId'] = feature_profile_id
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sdwan:index/getSystemBfdFeature:getSystemBfdFeature', __args__, opts=opts, typ=GetSystemBfdFeatureResult).value

    return AwaitableGetSystemBfdFeatureResult(
        colors=pulumi.get(__ret__, 'colors'),
        default_dscp=pulumi.get(__ret__, 'default_dscp'),
        default_dscp_variable=pulumi.get(__ret__, 'default_dscp_variable'),
        description=pulumi.get(__ret__, 'description'),
        feature_profile_id=pulumi.get(__ret__, 'feature_profile_id'),
        id=pulumi.get(__ret__, 'id'),
        multiplier=pulumi.get(__ret__, 'multiplier'),
        multiplier_variable=pulumi.get(__ret__, 'multiplier_variable'),
        name=pulumi.get(__ret__, 'name'),
        poll_interval=pulumi.get(__ret__, 'poll_interval'),
        poll_interval_variable=pulumi.get(__ret__, 'poll_interval_variable'),
        version=pulumi.get(__ret__, 'version'))
def get_system_bfd_feature_output(feature_profile_id: Optional[pulumi.Input[str]] = None,
                                  id: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSystemBfdFeatureResult]:
    """
    This data source can read the System BFD Feature.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_system_bfd_feature(id="f6b2c44c-693c-4763-b010-895aa3d236bd",
        feature_profile_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac")
    ```


    :param str feature_profile_id: Feature Profile ID
    :param str id: The id of the Feature
    """
    __args__ = dict()
    __args__['featureProfileId'] = feature_profile_id
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sdwan:index/getSystemBfdFeature:getSystemBfdFeature', __args__, opts=opts, typ=GetSystemBfdFeatureResult)
    return __ret__.apply(lambda __response__: GetSystemBfdFeatureResult(
        colors=pulumi.get(__response__, 'colors'),
        default_dscp=pulumi.get(__response__, 'default_dscp'),
        default_dscp_variable=pulumi.get(__response__, 'default_dscp_variable'),
        description=pulumi.get(__response__, 'description'),
        feature_profile_id=pulumi.get(__response__, 'feature_profile_id'),
        id=pulumi.get(__response__, 'id'),
        multiplier=pulumi.get(__response__, 'multiplier'),
        multiplier_variable=pulumi.get(__response__, 'multiplier_variable'),
        name=pulumi.get(__response__, 'name'),
        poll_interval=pulumi.get(__response__, 'poll_interval'),
        poll_interval_variable=pulumi.get(__response__, 'poll_interval_variable'),
        version=pulumi.get(__response__, 'version')))
