# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CameraCustomAnalyticsArtifactsArgs', 'CameraCustomAnalyticsArtifacts']

@pulumi.input_type
class CameraCustomAnalyticsArtifactsArgs:
    def __init__(__self__, *,
                 organization_id: pulumi.Input[_builtins.str],
                 artifact_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CameraCustomAnalyticsArtifacts resource.
        :param pulumi.Input[_builtins.str] organization_id: Organization ID
        :param pulumi.Input[_builtins.str] artifact_id: Custom analytics artifact ID
        :param pulumi.Input[_builtins.str] name: Custom analytics artifact name
        """
        pulumi.set(__self__, "organization_id", organization_id)
        if artifact_id is not None:
            pulumi.set(__self__, "artifact_id", artifact_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[_builtins.str]:
        """
        Organization ID
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom analytics artifact ID
        """
        return pulumi.get(self, "artifact_id")

    @artifact_id.setter
    def artifact_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "artifact_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom analytics artifact name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _CameraCustomAnalyticsArtifactsState:
    def __init__(__self__, *,
                 artifact_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input['CameraCustomAnalyticsArtifactsStatusArgs']] = None):
        """
        Input properties used for looking up and filtering CameraCustomAnalyticsArtifacts resources.
        :param pulumi.Input[_builtins.str] artifact_id: Custom analytics artifact ID
        :param pulumi.Input[_builtins.str] name: Custom analytics artifact name
        :param pulumi.Input[_builtins.str] organization_id: Organization ID
        :param pulumi.Input['CameraCustomAnalyticsArtifactsStatusArgs'] status: Custom analytics artifact status
        """
        if artifact_id is not None:
            pulumi.set(__self__, "artifact_id", artifact_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom analytics artifact ID
        """
        return pulumi.get(self, "artifact_id")

    @artifact_id.setter
    def artifact_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "artifact_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom analytics artifact name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Organization ID
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['CameraCustomAnalyticsArtifactsStatusArgs']]:
        """
        Custom analytics artifact status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['CameraCustomAnalyticsArtifactsStatusArgs']]):
        pulumi.set(self, "status", value)


@pulumi.type_token("meraki:organizations/cameraCustomAnalyticsArtifacts:CameraCustomAnalyticsArtifacts")
class CameraCustomAnalyticsArtifacts(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artifact_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.organizations.CameraCustomAnalyticsArtifacts("example",
            name="example",
            organization_id="string")
        pulumi.export("merakiOrganizationsCameraCustomAnalyticsArtifactsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:organizations/cameraCustomAnalyticsArtifacts:CameraCustomAnalyticsArtifacts example "artifact_id,organization_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] artifact_id: Custom analytics artifact ID
        :param pulumi.Input[_builtins.str] name: Custom analytics artifact name
        :param pulumi.Input[_builtins.str] organization_id: Organization ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CameraCustomAnalyticsArtifactsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.organizations.CameraCustomAnalyticsArtifacts("example",
            name="example",
            organization_id="string")
        pulumi.export("merakiOrganizationsCameraCustomAnalyticsArtifactsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:organizations/cameraCustomAnalyticsArtifacts:CameraCustomAnalyticsArtifacts example "artifact_id,organization_id"
        ```

        :param str resource_name: The name of the resource.
        :param CameraCustomAnalyticsArtifactsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CameraCustomAnalyticsArtifactsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artifact_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CameraCustomAnalyticsArtifactsArgs.__new__(CameraCustomAnalyticsArtifactsArgs)

            __props__.__dict__["artifact_id"] = artifact_id
            __props__.__dict__["name"] = name
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
            __props__.__dict__["status"] = None
        super(CameraCustomAnalyticsArtifacts, __self__).__init__(
            'meraki:organizations/cameraCustomAnalyticsArtifacts:CameraCustomAnalyticsArtifacts',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            artifact_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            organization_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[Union['CameraCustomAnalyticsArtifactsStatusArgs', 'CameraCustomAnalyticsArtifactsStatusArgsDict']]] = None) -> 'CameraCustomAnalyticsArtifacts':
        """
        Get an existing CameraCustomAnalyticsArtifacts resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] artifact_id: Custom analytics artifact ID
        :param pulumi.Input[_builtins.str] name: Custom analytics artifact name
        :param pulumi.Input[_builtins.str] organization_id: Organization ID
        :param pulumi.Input[Union['CameraCustomAnalyticsArtifactsStatusArgs', 'CameraCustomAnalyticsArtifactsStatusArgsDict']] status: Custom analytics artifact status
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CameraCustomAnalyticsArtifactsState.__new__(_CameraCustomAnalyticsArtifactsState)

        __props__.__dict__["artifact_id"] = artifact_id
        __props__.__dict__["name"] = name
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["status"] = status
        return CameraCustomAnalyticsArtifacts(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> pulumi.Output[_builtins.str]:
        """
        Custom analytics artifact ID
        """
        return pulumi.get(self, "artifact_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Custom analytics artifact name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[_builtins.str]:
        """
        Organization ID
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output['outputs.CameraCustomAnalyticsArtifactsStatus']:
        """
        Custom analytics artifact status
        """
        return pulumi.get(self, "status")

