"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Inspector = void 0;
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [inspector](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoninspector.html).
 *
 * @experimental
 */
class Inspector extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [inspector](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoninspector.html).
     *
     * @experimental
     */
    constructor(props) {
        super(props);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'inspector';
        /**
         * @experimental
         */
        this.accessLevelList = {
            "Write": [
                "AddAttributesToFindings",
                "CreateAssessmentTarget",
                "CreateAssessmentTemplate",
                "CreateResourceGroup",
                "DeleteAssessmentRun",
                "DeleteAssessmentTarget",
                "DeleteAssessmentTemplate",
                "RegisterCrossAccountAccessRole",
                "RemoveAttributesFromFindings",
                "StartAssessmentRun",
                "StopAssessmentRun",
                "SubscribeToEvent",
                "UnsubscribeFromEvent",
                "UpdateAssessmentTarget"
            ],
            "Read": [
                "DescribeAssessmentRuns",
                "DescribeAssessmentTargets",
                "DescribeAssessmentTemplates",
                "DescribeCrossAccountAccessRole",
                "DescribeFindings",
                "DescribeResourceGroups",
                "DescribeRulesPackages",
                "GetTelemetryMetadata",
                "PreviewAgents"
            ],
            "List": [
                "ListAssessmentRunAgents",
                "ListAssessmentRuns",
                "ListAssessmentTargets",
                "ListAssessmentTemplates",
                "ListEventSubscriptions",
                "ListFindings",
                "ListRulesPackages",
                "ListTagsForResource"
            ],
            "Tagging": [
                "SetTagsForResource"
            ]
        };
    }
    /**
     * (experimental) Assigns attributes (key and value pairs) to the findings that are specified by the ARNs of the findings.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_AddAttributesToFindings.html
     *
     * @experimental
     */
    toAddAttributesToFindings() {
        return this.to('AddAttributesToFindings');
    }
    /**
     * (experimental) Creates a new assessment target using the ARN of the resource group that is generated by CreateResourceGroup.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_CreateAssessmentTarget.html
     *
     * @experimental
     */
    toCreateAssessmentTarget() {
        return this.to('CreateAssessmentTarget');
    }
    /**
     * (experimental) Creates an assessment template for the assessment target that is specified by the ARN of the assessment target.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_CreateAssessmentTemplate.html
     *
     * @experimental
     */
    toCreateAssessmentTemplate() {
        return this.to('CreateAssessmentTemplate');
    }
    /**
     * (experimental) Creates a resource group using the specified set of tags (key and value pairs) that are used to select the EC2 instances to be included in an Amazon Inspector assessment target.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_CreateResourceGroup.html
     *
     * @experimental
     */
    toCreateResourceGroup() {
        return this.to('CreateResourceGroup');
    }
    /**
     * (experimental) Deletes the assessment run that is specified by the ARN of the assessment run.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DeleteAssessmentRun.html
     *
     * @experimental
     */
    toDeleteAssessmentRun() {
        return this.to('DeleteAssessmentRun');
    }
    /**
     * (experimental) Deletes the assessment target that is specified by the ARN of the assessment target.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DeleteAssessmentTarget.html
     *
     * @experimental
     */
    toDeleteAssessmentTarget() {
        return this.to('DeleteAssessmentTarget');
    }
    /**
     * (experimental) Deletes the assessment template that is specified by the ARN of the assessment template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DeleteAssessmentTemplate.html
     *
     * @experimental
     */
    toDeleteAssessmentTemplate() {
        return this.to('DeleteAssessmentTemplate');
    }
    /**
     * (experimental) Describes the assessment runs that are specified by the ARNs of the assessment runs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeAssessmentRuns.html
     *
     * @experimental
     */
    toDescribeAssessmentRuns() {
        return this.to('DescribeAssessmentRuns');
    }
    /**
     * (experimental) Describes the assessment targets that are specified by the ARNs of the assessment targets.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeAssessmentTargets.html
     *
     * @experimental
     */
    toDescribeAssessmentTargets() {
        return this.to('DescribeAssessmentTargets');
    }
    /**
     * (experimental) Describes the assessment templates that are specified by the ARNs of the assessment templates.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeAssessmentTemplates.html
     *
     * @experimental
     */
    toDescribeAssessmentTemplates() {
        return this.to('DescribeAssessmentTemplates');
    }
    /**
     * (experimental) Describes the IAM role that enables Amazon Inspector to access your AWS account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeCrossAccountAccessRole.html
     *
     * @experimental
     */
    toDescribeCrossAccountAccessRole() {
        return this.to('DescribeCrossAccountAccessRole');
    }
    /**
     * (experimental) Describes the findings that are specified by the ARNs of the findings.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeFindings.html
     *
     * @experimental
     */
    toDescribeFindings() {
        return this.to('DescribeFindings');
    }
    /**
     * (experimental) Describes the resource groups that are specified by the ARNs of the resource groups.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeResourceGroups.html
     *
     * @experimental
     */
    toDescribeResourceGroups() {
        return this.to('DescribeResourceGroups');
    }
    /**
     * (experimental) Describes the rules packages that are specified by the ARNs of the rules packages.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeRulesPackages.html
     *
     * @experimental
     */
    toDescribeRulesPackages() {
        return this.to('DescribeRulesPackages');
    }
    /**
     * (experimental) Information about the data that is collected for the specified assessment run.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_GetTelemetryMetadata.html
     *
     * @experimental
     */
    toGetTelemetryMetadata() {
        return this.to('GetTelemetryMetadata');
    }
    /**
     * (experimental) Lists the agents of the assessment runs that are specified by the ARNs of the assessment runs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentRunAgents.html
     *
     * @experimental
     */
    toListAssessmentRunAgents() {
        return this.to('ListAssessmentRunAgents');
    }
    /**
     * (experimental) Lists the assessment runs that correspond to the assessment templates that are specified by the ARNs of the assessment templates.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentRuns.html
     *
     * @experimental
     */
    toListAssessmentRuns() {
        return this.to('ListAssessmentRuns');
    }
    /**
     * (experimental) Lists the ARNs of the assessment targets within this AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentTargets.html
     *
     * @experimental
     */
    toListAssessmentTargets() {
        return this.to('ListAssessmentTargets');
    }
    /**
     * (experimental) Lists the assessment templates that correspond to the assessment targets that are specified by the ARNs of the assessment targets.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentTemplates.html
     *
     * @experimental
     */
    toListAssessmentTemplates() {
        return this.to('ListAssessmentTemplates');
    }
    /**
     * (experimental) Lists all the event subscriptions for the assessment template that is specified by the ARN of the assessment template.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListEventSubscriptions.html
     *
     * @experimental
     */
    toListEventSubscriptions() {
        return this.to('ListEventSubscriptions');
    }
    /**
     * (experimental) Lists findings that are generated by the assessment runs that are specified by the ARNs of the assessment runs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListFindings.html
     *
     * @experimental
     */
    toListFindings() {
        return this.to('ListFindings');
    }
    /**
     * (experimental) Lists all available Amazon Inspector rules packages.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListRulesPackages.html
     *
     * @experimental
     */
    toListRulesPackages() {
        return this.to('ListRulesPackages');
    }
    /**
     * (experimental) Lists all tags associated with an assessment template.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * (experimental) Previews the agents installed on the EC2 instances that are part of the specified assessment target.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_PreviewAgents.html
     *
     * @experimental
     */
    toPreviewAgents() {
        return this.to('PreviewAgents');
    }
    /**
     * (experimental) Registers the IAM role that Amazon Inspector uses to list your EC2 instances at the start of the assessment run or when you call the PreviewAgents action.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_RegisterCrossAccountAccessRole.html
     *
     * @experimental
     */
    toRegisterCrossAccountAccessRole() {
        return this.to('RegisterCrossAccountAccessRole');
    }
    /**
     * (experimental) Removes entire attributes (key and value pairs) from the findings that are specified by the ARNs of the findings where an attribute with the specified key exists.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_RemoveAttributesFromFindings.html
     *
     * @experimental
     */
    toRemoveAttributesFromFindings() {
        return this.to('RemoveAttributesFromFindings');
    }
    /**
     * (experimental) Sets tags (key and value pairs) to the assessment template that is specified by the ARN of the assessment template.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_SetTagsForResource.html
     *
     * @experimental
     */
    toSetTagsForResource() {
        return this.to('SetTagsForResource');
    }
    /**
     * (experimental) Starts the assessment run specified by the ARN of the assessment template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_StartAssessmentRun.html
     *
     * @experimental
     */
    toStartAssessmentRun() {
        return this.to('StartAssessmentRun');
    }
    /**
     * (experimental) Stops the assessment run that is specified by the ARN of the assessment run.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_StopAssessmentRun.html
     *
     * @experimental
     */
    toStopAssessmentRun() {
        return this.to('StopAssessmentRun');
    }
    /**
     * (experimental) Enables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_SubscribeToEvent.html
     *
     * @experimental
     */
    toSubscribeToEvent() {
        return this.to('SubscribeToEvent');
    }
    /**
     * (experimental) Disables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_UnsubscribeFromEvent.html
     *
     * @experimental
     */
    toUnsubscribeFromEvent() {
        return this.to('UnsubscribeFromEvent');
    }
    /**
     * (experimental) Updates the assessment target that is specified by the ARN of the assessment target.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_UpdateAssessmentTarget.html
     *
     * @experimental
     */
    toUpdateAssessmentTarget() {
        return this.to('UpdateAssessmentTarget');
    }
}
exports.Inspector = Inspector;
//# sourceMappingURL=data:application/json;base64,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