# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/database/redshiftConnection.json
#   timestamp: 2022-05-12T14:41:42+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field, SecretStr

from .. import connectionBasicType


class RedshiftType(Enum):
    Redshift = 'Redshift'


class RedshiftScheme(Enum):
    redshift_psycopg2 = 'redshift+psycopg2'


class RedshiftConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[RedshiftType] = Field(
        RedshiftType.Redshift, description='Service Type', title='Service Type'
    )
    scheme: Optional[RedshiftScheme] = Field(
        RedshiftScheme.redshift_psycopg2,
        description='SQLAlchemy driver scheme options.',
        title='Connection Scheme',
    )
    username: str = Field(
        ...,
        description='username to connect  to the Redshift. This user should have privileges to read all the metadata in Redshift.',
        title='Username',
    )
    password: Optional[SecretStr] = Field(
        None, description='password to connect  to the Redshift.', title='Password'
    )
    hostPort: str = Field(
        ..., description='Host and port of the Redshift.', title='Host and Port'
    )
    database: Optional[str] = Field(
        None,
        description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank, OpenMetadata Ingestion attempts to scan all the databases.',
        title='Database',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = Field(
        None, title='Connection Options'
    )
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = Field(
        None, title='Connection Arguments'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
    supportsUsageExtraction: Optional[
        connectionBasicType.SupportsUsageExtraction
    ] = None
    supportsProfiler: Optional[connectionBasicType.SupportsProfiler] = Field(
        None, title='Supports Profiler'
    )
