# generated by datamodel-codegen:
#   filename:  schema/tests/tableTest.json
#   timestamp: 2022-05-12T14:41:42+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import BaseModel, Extra, Field

from ..type import basic, entityReference
from . import basic as basic_1
from .table import (
    tableColumnCountToEqual,
    tableRowCountToBeBetween,
    tableRowCountToEqual,
)


class TableTestType(Enum):
    tableRowCountToEqual = 'tableRowCountToEqual'
    tableRowCountToBeBetween = 'tableRowCountToBeBetween'
    tableColumnCountToEqual = 'tableColumnCountToEqual'


class TableTestCase(BaseModel):
    class Config:
        extra = Extra.forbid

    config: Optional[
        Union[
            tableRowCountToEqual.TableRowCountToEqual,
            tableRowCountToBeBetween.TableRowCountToBeBetween,
            tableColumnCountToEqual.TableColumnCountToEqual,
        ]
    ] = None
    tableTestType: Optional[TableTestType] = None


class TableTest(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[basic.Uuid] = Field(
        None, description='Unique identifier of this table instance.'
    )
    name: basic.EntityName = Field(
        ..., description='Name that identifies this test case.'
    )
    description: Optional[str] = Field(None, description='Description of the testcase.')
    testCase: TableTestCase
    executionFrequency: Optional[basic_1.TestCaseExecutionFrequency] = None
    results: Optional[List[basic_1.TestCaseResult]] = Field(
        None, description='List of results of the test case.'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this Pipeline.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
