# -*- coding: utf-8 -*-
# Generated by https://github.com/verloop/twirpy/protoc-gen-twirpy.  DO NOT EDIT!
# source: camera_service.proto

from google.protobuf import symbol_database as _symbol_database

from twirp.base import Endpoint
from twirp.server import TwirpServer
from twirp.client import TwirpClient
try:
	from twirp.async_client import AsyncTwirpClient
	_async_available = True
except ModuleNotFoundError:
	_async_available = False

_sym_db = _symbol_database.Default()

class CameraServiceServer(TwirpServer):

	def __init__(self, *args, service, server_path_prefix="/twirp"):
		super().__init__(service=service)
		self._prefix = F"{server_path_prefix}/cameraService.CameraService"
		self._endpoints = {
			"IsCameraAlive": Endpoint(
				service_name="CameraService",
				name="IsCameraAlive",
				function=getattr(service, "IsCameraAlive"),
				input=_sym_db.GetSymbol("google.protobuf.Empty"),
				output=_sym_db.GetSymbol("cameraService.IsCameraAliveResponse"),
			),
			"GetInstalledModules": Endpoint(
				service_name="CameraService",
				name="GetInstalledModules",
				function=getattr(service, "GetInstalledModules"),
				input=_sym_db.GetSymbol("google.protobuf.Empty"),
				output=_sym_db.GetSymbol("cameraService.InstalledModules"),
			),
			"InstallModules": Endpoint(
				service_name="CameraService",
				name="InstallModules",
				function=getattr(service, "InstallModules"),
				input=_sym_db.GetSymbol("cameraService.InstallModulesRequest"),
				output=_sym_db.GetSymbol("google.protobuf.Empty"),
			),
			"UninstallModules": Endpoint(
				service_name="CameraService",
				name="UninstallModules",
				function=getattr(service, "UninstallModules"),
				input=_sym_db.GetSymbol("cameraService.UninstallModulesRequest"),
				output=_sym_db.GetSymbol("google.protobuf.Empty"),
			),
			"GetLastFrame": Endpoint(
				service_name="CameraService",
				name="GetLastFrame",
				function=getattr(service, "GetLastFrame"),
				input=_sym_db.GetSymbol("cameraService.GetLastFrameRequest"),
				output=_sym_db.GetSymbol("cameraService.Frame"),
			),
		}

class CameraServiceClient(TwirpClient):

	def IsCameraAlive(self, *args, ctx, request, server_path_prefix="/twirp", **kwargs):
		return self._make_request(
			url=F"{server_path_prefix}/cameraService.CameraService/IsCameraAlive",
			ctx=ctx,
			request=request,
			response_obj=_sym_db.GetSymbol("cameraService.IsCameraAliveResponse"),
			**kwargs,
		)

	def GetInstalledModules(self, *args, ctx, request, server_path_prefix="/twirp", **kwargs):
		return self._make_request(
			url=F"{server_path_prefix}/cameraService.CameraService/GetInstalledModules",
			ctx=ctx,
			request=request,
			response_obj=_sym_db.GetSymbol("cameraService.InstalledModules"),
			**kwargs,
		)

	def InstallModules(self, *args, ctx, request, server_path_prefix="/twirp", **kwargs):
		return self._make_request(
			url=F"{server_path_prefix}/cameraService.CameraService/InstallModules",
			ctx=ctx,
			request=request,
			response_obj=_sym_db.GetSymbol("google.protobuf.Empty"),
			**kwargs,
		)

	def UninstallModules(self, *args, ctx, request, server_path_prefix="/twirp", **kwargs):
		return self._make_request(
			url=F"{server_path_prefix}/cameraService.CameraService/UninstallModules",
			ctx=ctx,
			request=request,
			response_obj=_sym_db.GetSymbol("google.protobuf.Empty"),
			**kwargs,
		)

	def GetLastFrame(self, *args, ctx, request, server_path_prefix="/twirp", **kwargs):
		return self._make_request(
			url=F"{server_path_prefix}/cameraService.CameraService/GetLastFrame",
			ctx=ctx,
			request=request,
			response_obj=_sym_db.GetSymbol("cameraService.Frame"),
			**kwargs,
		)


if _async_available:
	class AsyncCameraServiceClient(AsyncTwirpClient):

		async def IsCameraAlive(self, *, ctx, request, server_path_prefix="/twirp", session=None, **kwargs):
			return await self._make_request(
				url=F"{server_path_prefix}/cameraService.CameraService/IsCameraAlive",
				ctx=ctx,
				request=request,
				response_obj=_sym_db.GetSymbol("cameraService.IsCameraAliveResponse"),
				session=session,
				**kwargs,
			)

		async def GetInstalledModules(self, *, ctx, request, server_path_prefix="/twirp", session=None, **kwargs):
			return await self._make_request(
				url=F"{server_path_prefix}/cameraService.CameraService/GetInstalledModules",
				ctx=ctx,
				request=request,
				response_obj=_sym_db.GetSymbol("cameraService.InstalledModules"),
				session=session,
				**kwargs,
			)

		async def InstallModules(self, *, ctx, request, server_path_prefix="/twirp", session=None, **kwargs):
			return await self._make_request(
				url=F"{server_path_prefix}/cameraService.CameraService/InstallModules",
				ctx=ctx,
				request=request,
				response_obj=_sym_db.GetSymbol("google.protobuf.Empty"),
				session=session,
				**kwargs,
			)

		async def UninstallModules(self, *, ctx, request, server_path_prefix="/twirp", session=None, **kwargs):
			return await self._make_request(
				url=F"{server_path_prefix}/cameraService.CameraService/UninstallModules",
				ctx=ctx,
				request=request,
				response_obj=_sym_db.GetSymbol("google.protobuf.Empty"),
				session=session,
				**kwargs,
			)

		async def GetLastFrame(self, *, ctx, request, server_path_prefix="/twirp", session=None, **kwargs):
			return await self._make_request(
				url=F"{server_path_prefix}/cameraService.CameraService/GetLastFrame",
				ctx=ctx,
				request=request,
				response_obj=_sym_db.GetSymbol("cameraService.Frame"),
				session=session,
				**kwargs,
			)
