{% set ns = namespace(first_target=True) %}
{% for target in targets %}
{%  if target.analysis_results.orphaned_stacks
        or target.analysis_results.failed_stacks
        or target.change_sets|first
%}
{%    if not ns.first_target %}
<br>

{%    endif %}
{%    set ns.first_target = False %}
### :dart: `{{ target.name }}` | `{{ target.account }}` | {{ ':{}: '|format_if(REGION_TO_EMOJI[target.region]) }}`{{ target.region }}` [[login]({{ target.login }})]

**Stacks:** {{ target.analysis_results.stack_summary }}
{%    if target.analysis_results.orphaned_stacks %}
**Orphaned Stacks:** `{{ '`, `'.join(target.analysis_results.orphaned_stacks) }}`
{%    endif %}
{%    if target.analysis_results.failed_stacks %}
**Failed Stacks:** `{{ '`, `'.join(target.analysis_results.failed_stacks) }}`
{%    endif %}
{%  for change_set in target.change_sets %}
{%    if loop.first %}

{%    endif %}
<details>
<summary>{% if change_set.is_failed %}{{ ':woman_shrugging:' if change_set.is_noop else ':x:' }}{% endif %}{{ ':sparkles:' if change_set.type == change_set.type.CREATE }}<code>{{ change_set.detail.StackName }}</code> [<a href="{{ change_set.url }}">change set</a>]</summary>

{%    if change_set.detail.Status != 'CREATE_COMPLETE' %}
#### Change Set Status: `{{ change_set.detail.Status }}`

{{ change_set.detail.StatusReason }}

{%    endif %}
{%    if change_set.detail.Parameters|length > 1 %}
#### Parameters

|Name|Value|
|:-|:-|
{%      for p in change_set.detail.Parameters if not p.ParameterKey == METADATA_PARAMETER %}
|`{{ p.ParameterKey }}`|{{ p.ParameterValue|md_code }}|
{%      endfor %}

{%    endif %}
{%    if change_set.detail.Capabilities %}
#### Capabilities: `{{ '` | `'.join(change_set.detail.Capabilities) }}`

{%    endif %}
#### Resource Changes

{%    if change_set.detail.Changes %}
|Resource|Resource Type|Action|Replace?|Modification Scope|Change Source|
|:-|:-|:-|:-|:-|:-|
{%      for change in change_set.detail.Changes %}
|`{{ change.ResourceChange.LogicalResourceId }}`|`{{ change.ResourceChange.ResourceType }}`|`{{ change.ResourceChange.Action }}`|{{ '`{}`'|format_if(change.ResourceChange.Replacement) }}|{{ '<br>'.join(change.ResourceChange.Scope) }}|
{%-       for change_detail in change.ResourceChange.Details %}
{{ '<br>' if not loop.first }}{{ '`{}`'|format_if(change_detail.ChangeSource) }}{{ ' (`{}`)'|format_if(change_detail.CausingEntity) }}{{ ' **`[{}]`**'|format_if(change_detail.Evaluation) }}
{%-       endfor %}|
{%      endfor %}

{%    else %}
No resource changes.

{%    endif %}
{%    if change_set.detail.Tags %}
#### Tags

|Key|Value|
|:-|:-|
{%      for t in change_set.detail.Tags %}
|`{{ t.Key }}`|{{ t.Value|md_code }}|
{%      endfor %}

{%    endif %}
</details>
{%  endfor %}

{%  endif %}
{% endfor %}
{% if ns.first_target %}
No changes to managed stacks detected.

{% endif %}
---
_CloudFormation change set summary generated by [`cfn-review-bot`](https://github.com/biochimia/cfn-review-bot)_
