# coding: utf-8

"""
    VRt.Agro [AG]

    The version of the OpenAPI document: 6.12.2101

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, conlist, constr
from vrt_lss_agro.models.attribute import Attribute
from vrt_lss_agro.models.contract_type import ContractType
from vrt_lss_agro.models.pricelist import Pricelist

class Contract(BaseModel):
    """
    Contract - defines a list of purchase and sale prices for a specific group of sellers and buyers. 
    """
    key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Key, unique identifier.")
    type: ContractType = Field(...)
    target_keys: conlist(constr(strict=True, max_length=1024, min_length=1), max_items=100, min_items=1, unique_items=True) = Field(..., description="List of production object keys. ")
    pricelist: conlist(Pricelist, max_items=50, min_items=0) = Field(..., description="List of prices for the purchase and sale of agricultural crops. ")
    attributes: Optional[conlist(Attribute, max_items=1000, min_items=0, unique_items=True)] = Field(None, description="Attributes. Used to add service information.")
    __properties = ["key", "type", "target_keys", "pricelist", "attributes"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Contract:
        """Create an instance of Contract from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in pricelist (list)
        _items = []
        if self.pricelist:
            for _item in self.pricelist:
                if _item:
                    _items.append(_item.to_dict())
            _dict['pricelist'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attributes (list)
        _items = []
        if self.attributes:
            for _item in self.attributes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attributes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Contract:
        """Create an instance of Contract from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Contract.parse_obj(obj)

        _obj = Contract.parse_obj({
            "key": obj.get("key"),
            "type": obj.get("type"),
            "target_keys": obj.get("target_keys"),
            "pricelist": [Pricelist.from_dict(_item) for _item in obj.get("pricelist")] if obj.get("pricelist") is not None else None,
            "attributes": [Attribute.from_dict(_item) for _item in obj.get("attributes")] if obj.get("attributes") is not None else None
        })
        return _obj

