# coding: utf-8

"""
    VRt.Agro [AG]

    The version of the OpenAPI document: 6.12.2101

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, conint, conlist, constr
from vrt_lss_agro.models.attribute import Attribute

class Crop(BaseModel):
    """
    A crop. 
    """
    key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Key, unique identifier.")
    base_humidity: conint(strict=True, le=999, ge=1) = Field(..., description="Humidity crop, in ppm (‰).")
    compatible_storage_types: Optional[conlist(constr(strict=True, max_length=256, min_length=1), max_items=10, min_items=0, unique_items=True)] = Field(None, description="List of compatible short-term storage types. ")
    compatible_silo_types: Optional[conlist(constr(strict=True, max_length=256, min_length=1), max_items=10, min_items=0, unique_items=True)] = Field(None, description="List of compatible long-term storage types. ")
    attributes: Optional[conlist(Attribute, max_items=1000, min_items=0, unique_items=True)] = Field(None, description="Attributes. Used to add service information.")
    __properties = ["key", "base_humidity", "compatible_storage_types", "compatible_silo_types", "attributes"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Crop:
        """Create an instance of Crop from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in attributes (list)
        _items = []
        if self.attributes:
            for _item in self.attributes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attributes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Crop:
        """Create an instance of Crop from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Crop.parse_obj(obj)

        _obj = Crop.parse_obj({
            "key": obj.get("key"),
            "base_humidity": obj.get("base_humidity"),
            "compatible_storage_types": obj.get("compatible_storage_types"),
            "compatible_silo_types": obj.get("compatible_silo_types"),
            "attributes": [Attribute.from_dict(_item) for _item in obj.get("attributes")] if obj.get("attributes") is not None else None
        })
        return _obj

