# coding: utf-8

"""
    VRt.Agro [AG]

    The version of the OpenAPI document: 6.12.2101

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, conlist, constr
from vrt_lss_agro.models.attribute import Attribute
from vrt_lss_agro.models.capacity_forecast_element import CapacityForecastElement
from vrt_lss_agro.models.cost_forecast_element import CostForecastElement

class Gate(BaseModel):
    """
    Grain process. 
    """
    key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Key, unique identifier.")
    input_capacity_forecast: conlist(CapacityForecastElement, max_items=3653, min_items=0) = Field(..., description="Capacity forecast.")
    input_cost_forecast: Optional[conlist(CostForecastElement, max_items=3653, min_items=0)] = Field(None, description="Cost forecast.")
    output_capacity_forecast: conlist(CapacityForecastElement, max_items=3653, min_items=0) = Field(..., description="Capacity forecast.")
    output_cost_forecast: Optional[conlist(CostForecastElement, max_items=3653, min_items=0)] = Field(None, description="Cost forecast.")
    attributes: Optional[conlist(Attribute, max_items=1000, min_items=0, unique_items=True)] = Field(None, description="Attributes. Used to add service information.")
    __properties = ["key", "input_capacity_forecast", "input_cost_forecast", "output_capacity_forecast", "output_cost_forecast", "attributes"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Gate:
        """Create an instance of Gate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in input_capacity_forecast (list)
        _items = []
        if self.input_capacity_forecast:
            for _item in self.input_capacity_forecast:
                if _item:
                    _items.append(_item.to_dict())
            _dict['input_capacity_forecast'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in input_cost_forecast (list)
        _items = []
        if self.input_cost_forecast:
            for _item in self.input_cost_forecast:
                if _item:
                    _items.append(_item.to_dict())
            _dict['input_cost_forecast'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in output_capacity_forecast (list)
        _items = []
        if self.output_capacity_forecast:
            for _item in self.output_capacity_forecast:
                if _item:
                    _items.append(_item.to_dict())
            _dict['output_capacity_forecast'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in output_cost_forecast (list)
        _items = []
        if self.output_cost_forecast:
            for _item in self.output_cost_forecast:
                if _item:
                    _items.append(_item.to_dict())
            _dict['output_cost_forecast'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attributes (list)
        _items = []
        if self.attributes:
            for _item in self.attributes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attributes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Gate:
        """Create an instance of Gate from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Gate.parse_obj(obj)

        _obj = Gate.parse_obj({
            "key": obj.get("key"),
            "input_capacity_forecast": [CapacityForecastElement.from_dict(_item) for _item in obj.get("input_capacity_forecast")] if obj.get("input_capacity_forecast") is not None else None,
            "input_cost_forecast": [CostForecastElement.from_dict(_item) for _item in obj.get("input_cost_forecast")] if obj.get("input_cost_forecast") is not None else None,
            "output_capacity_forecast": [CapacityForecastElement.from_dict(_item) for _item in obj.get("output_capacity_forecast")] if obj.get("output_capacity_forecast") is not None else None,
            "output_cost_forecast": [CostForecastElement.from_dict(_item) for _item in obj.get("output_cost_forecast")] if obj.get("output_cost_forecast") is not None else None,
            "attributes": [Attribute.from_dict(_item) for _item in obj.get("attributes")] if obj.get("attributes") is not None else None
        })
        return _obj

