from typing import (
    Any,
    Callable,
    ClassVar,
    Dict,
    Generic,
    Iterable,
    Iterator,
    List,
    Literal,
    Optional,
    Sequence,
    Tuple,
    TypeVar,
    Union,
)

from typing_extensions import TypeAlias, Unpack

EllipsisType = type(...)
import datetime
import os
from typing import overload

import dimod.sampleset
import numpy

from ._backward import *  # noqa: F403

_Dim0: TypeAlias = Literal[0]
_Dim1: TypeAlias = Literal[1]
_Dim2: TypeAlias = Literal[2]
_Dim3: TypeAlias = Literal[3]
_Dim4: TypeAlias = Literal[4]
_NDim = TypeVar("_NDim", _Dim0, _Dim1, _Dim2, _Dim3, _Dim4)
_AmplifyClient = TypeVar(
    "_AmplifyClient",
    FixstarsClient,
    DWaveSamplerClient,
    LeapHybridSamplerClient,
    LeapHybridCQMSamplerClient,
    FujitsuDA4Client,
    ToshibaSQBM2Client,
    GurobiClient,
    NECVA2Client,
    DASClient,
    Literal[None],
)
AmplifyClient: TypeAlias = Union[
    FixstarsClient,
    DWaveSamplerClient,
    LeapHybridSamplerClient,
    LeapHybridCQMSamplerClient,
    FujitsuDA4Client,
    ToshibaSQBM2Client,
    GurobiClient,
    NECVA2Client,
    DASClient,
]

class _ClientResultDescriptor:
    @overload
    def __get__(self, instance: Result[FixstarsClient], owner: Any) -> FixstarsClient.Result: ...
    @overload
    def __get__(self, instance: Result[DWaveSamplerClient], owner: Any) -> dimod.sampleset.SampleSet: ...
    @overload
    def __get__(self, instance: Result[LeapHybridSamplerClient], owner: Any) -> dimod.sampleset.SampleSet: ...
    @overload
    def __get__(self, instance: Result[LeapHybridCQMSamplerClient], owner: Any) -> dimod.sampleset.SampleSet: ...
    @overload
    def __get__(self, instance: Result[FujitsuDA4Client], owner: Any) -> FujitsuDA4Client.Result: ...
    @overload
    def __get__(self, instance: Result[ToshibaSQBM2Client], owner: Any) -> ToshibaSQBM2Client.Result: ...
    @overload
    def __get__(self, instance: Result[GurobiClient], owner: Any) -> GurobiClient.Result: ...
    @overload
    def __get__(self, instance: Result[NECVA2Client], owner: Any) -> NECVA2Client.Result: ...
    @overload
    def __get__(self, instance: Result[DASClient], owner: Any) -> DASClient.Result: ...
    @overload
    def __get__(self, instance: Result[Literal[None]], owner: Any) -> None: ...
    @overload
    def __get__(
        self, instance: Any, owner: Any
    ) -> Union[
        FixstarsClient.Result,
        dimod.sampleset.SampleSet,
        FujitsuDA4Client.Result,
        ToshibaSQBM2Client.Result,
        GurobiClient.Result,
        NECVA2Client.Result,
        DASClient.Result,
        None,
    ]: ...

class _EmbeddingDescriptor:
    @overload
    def __get__(
        self,
        instance: Union[
            Result[DWaveSamplerClient], Result[LeapHybridSamplerClient], Result[LeapHybridCQMSamplerClient]
        ],
        owner: Any,
    ) -> Result.GraphConversion: ...
    @overload
    def __get__(self, instance: Any, owner: Any) -> None: ...

newaxis: None

class AcceptableDegrees:
    def __init__(
        self,
        objective: dict[Union[VariableType, str], Union[Degree, str]] = ...,
        equality_constraints: dict[Union[VariableType, str], Union[Degree, str]] = ...,
        inequality_constraints: dict[Union[VariableType, str], Union[Degree, str]] = ...,
    ) -> None:
        """__init__

        Args:
            objective (dict[Union[amplify.VariableType, str], Union[amplify.Degree, str]]): Defaults to ``{VariableType.Binary: Degree.Zero, VariableType.Ising: Degree.Zero, VariableType.Integer: Degree.Zero, VariableType.Real: Degree.Zero}``.
            equality_constraints (dict[Union[amplify.VariableType, str], Union[amplify.Degree, str]]): Defaults to ``{VariableType.Binary: Degree.Zero, VariableType.Ising: Degree.Zero, VariableType.Integer: Degree.Zero, VariableType.Real: Degree.Zero}``.
            inequality_constraints (dict[Union[amplify.VariableType, str], Union[amplify.Degree, str]]): Defaults to ``{VariableType.Binary: Degree.Zero, VariableType.Ising: Degree.Zero, VariableType.Integer: Degree.Zero, VariableType.Real: Degree.Zero}``.
        """
    @property
    def equality_constraints(self) -> dict[VariableType, Degree]:
        """equality_constraints property

        Returns:
            dict[amplify.VariableType, amplify.Degree]:
        """
    @property
    def inequality_constraints(self) -> dict[VariableType, Degree]:
        """inequality_constraints property

        Returns:
            dict[amplify.VariableType, amplify.Degree]:
        """
    @property
    def objective(self) -> dict[VariableType, Degree]:
        """objective property

        Returns:
            dict[amplify.VariableType, amplify.Degree]:
        """

class Constraint:
    __array_priority__: ClassVar[int] = ...
    label: str
    """label property

    Returns:
        str:
    """
    weight: float
    """weight property

    Returns:
        float:
    """
    @overload
    def __init__(
        self, left: Poly, bounds: Tuple[Optional[float], Optional[float]], penalty: Poly, label: str = ...
    ) -> None: ...
    @overload
    def __init__(self, left: Poly, eq: float, penalty: Poly, label: str = ...) -> None: ...
    @overload
    def __init__(self, left: Poly, le: float, penalty: Poly, label: str = ...) -> None: ...
    @overload
    def __init__(self, left: Poly, ge: float, penalty: Poly, label: str = ...) -> None:
        """__init__

        :Overloading:

        .. admonition:: 1. __init__(self, left: amplify.Poly, bounds: Tuple[Optional[float], Optional[float]], penalty: amplify.Poly, label: str = '') -> None

            Args:
                * left (amplify.Poly):
                * bounds (Tuple[Optional[float], Optional[float]]):
                * penalty (amplify.Poly):
                * label (str): Defaults to ``''``.

        .. admonition:: 2. __init__(self, left: amplify.Poly, eq: float, penalty: amplify.Poly, label: str = '') -> None

            Args:
                * left (amplify.Poly):
                * eq (float):
                * penalty (amplify.Poly):
                * label (str): Defaults to ``''``.

        .. admonition:: 3. __init__(self, left: amplify.Poly, le: float, penalty: amplify.Poly, label: str = '') -> None

            Args:
                * left (amplify.Poly):
                * le (float):
                * penalty (amplify.Poly):
                * label (str): Defaults to ``''``.

        .. admonition:: 4. __init__(self, left: amplify.Poly, ge: float, penalty: amplify.Poly, label: str = '') -> None

            Args:
                * left (amplify.Poly):
                * ge (float):
                * penalty (amplify.Poly):
                * label (str): Defaults to ``''``.
        """
    def _repr_latex_(self) -> str:
        """_repr_latex_

        Returns:
            str:
        """
    @overload
    def is_satisfied(self, values: Values) -> bool: ...
    @overload
    def is_satisfied(self, mapping: dict[Poly, float]) -> bool:
        """is_satisfied

        :Overloading:

        .. admonition:: 1. is_satisfied(self, values: amplify.Values) -> bool

            Args:
                * values (amplify.Values):

            Returns:
                bool:

        .. admonition:: 2. is_satisfied(self, mapping: dict[amplify.Poly, Union[float, int]]) -> bool

            Args:
                * mapping (dict[amplify.Poly, Union[float, int]]):

            Returns:
                bool:
        """
    def __add__(self, arg: Constraint) -> ConstraintList:
        """__add__

        Args:
            arg (amplify.Constraint):

        Returns:
            amplify.ConstraintList:
        """
    def __eq__(self, arg: Constraint) -> bool:
        """__eq__

        Args:
            arg (amplify.Constraint):

        Returns:
            bool:
        """
    def __imul__(self, arg: float) -> Constraint:
        """__imul__

        Args:
            arg (float):

        Returns:
            amplify.Constraint:
        """
    def __itruediv__(self, arg: float) -> Constraint:
        """__itruediv__

        Args:
            arg (float):

        Returns:
            amplify.Constraint:
        """
    def __mul__(self, arg: float) -> Constraint:
        """__mul__

        Args:
            arg (float):

        Returns:
            amplify.Constraint:
        """
    def __ne__(self, arg: Constraint) -> bool:
        """__ne__

        Args:
            arg (amplify.Constraint):

        Returns:
            bool:
        """
    def __radd__(self, arg: int) -> Constraint:
        """__radd__

        Args:
            arg (int):

        Returns:
            amplify.Constraint:
        """
    def __rmul__(self, arg: float) -> Constraint:
        """__rmul__

        Args:
            arg (float):

        Returns:
            amplify.Constraint:
        """
    def __truediv__(self, arg: float) -> Constraint:
        """__truediv__

        Args:
            arg (float):

        Returns:
            amplify.Constraint:
        """
    @property
    def conditional(self) -> Tuple[Poly, str, Union[float, Tuple[float, float]]]:
        """conditional property

        Returns:
            Tuple[amplify.Poly, str, Union[float, Tuple[float, float]]]:
        """
    @property
    def penalty(self) -> Poly:
        """penalty property

        Returns:
            amplify.Poly:
        """

class ConstraintList:
    class Iterator:
        def __init__(self, *args, **kwargs) -> None: ...
        def __iter__(self) -> ConstraintList.Iterator:
            """__iter__

            Returns:
                amplify.ConstraintList.Iterator:
            """
        def __next__(self) -> Constraint:
            """__next__

            Returns:
                amplify.Constraint:
            """

    __array_priority__: ClassVar[int] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, object: Sequence[Constraint]) -> None:
        """__init__

        Args:
            object (Sequence[amplify.Constraint]):
        """
    def _repr_latex_(self) -> str:
        """_repr_latex_

        Returns:
            str:
        """
    def append(self, value: Constraint) -> None:
        """append

        Args:
            value (amplify.Constraint):
        """
    def clear(self) -> None:
        """clear"""
    def copy(self) -> ConstraintList:
        """copy

        Returns:
            amplify.ConstraintList:
        """
    def count(self, value: Constraint) -> int:
        """count

        Args:
            value (amplify.Constraint):

        Returns:
            int:
        """
    def extend(self, sequence: Sequence[Constraint]) -> None:
        """extend

        Args:
            sequence (Sequence[amplify.Constraint]):
        """
    @overload
    def index(self, value: Constraint) -> int: ...
    @overload
    def index(self, value: Constraint, start: int) -> int: ...
    @overload
    def index(self, value: Constraint, start: int, end: int) -> int:
        """index

        :Overloading:

        .. admonition:: 1. index(self, value: amplify.Constraint) -> int

            Args:
                * value (amplify.Constraint):

            Returns:
                int:

        .. admonition:: 2. index(self, value: amplify.Constraint, start: int) -> int

            Args:
                * value (amplify.Constraint):
                * start (int):

            Returns:
                int:

        .. admonition:: 3. index(self, value: amplify.Constraint, start: int, end: int) -> int

            Args:
                * value (amplify.Constraint):
                * start (int):
                * end (int):

            Returns:
                int:
        """
    def insert(self, index: int, value: Constraint) -> None:
        """insert

        Args:
            index (int):
            value (amplify.Constraint):
        """
    def pop(self, index: Optional[int] = ...) -> Constraint:
        """pop

        Args:
            index (int | None): Defaults to ``None``.

        Returns:
            amplify.Constraint:
        """
    def remove(self, value: Constraint) -> None:
        """remove

        Args:
            value (amplify.Constraint):
        """
    def reverse(self) -> None:
        """reverse"""
    @overload
    def __add__(self, arg: ConstraintList) -> ConstraintList: ...
    @overload
    def __add__(self, arg: Constraint) -> ConstraintList:
        """__add__

        :Overloading:

        .. admonition:: 1. __add__(self, arg: amplify.ConstraintList, /) -> amplify.ConstraintList

            Args:
                * arg (amplify.ConstraintList):

            Returns:
                amplify.ConstraintList:

        .. admonition:: 2. __add__(self, arg: amplify.Constraint, /) -> amplify.ConstraintList

            Args:
                * arg (amplify.Constraint):

            Returns:
                amplify.ConstraintList:
        """
    def __copy__(self) -> ConstraintList:
        """__copy__

        Returns:
            amplify.ConstraintList:
        """
    def __deepcopy__(self, memo: Optional[Any] = ...) -> ConstraintList:
        """__deepcopy__

        Args:
            memo (Any | None): Defaults to ``None``.

        Returns:
            amplify.ConstraintList:
        """
    def __eq__(self, arg: ConstraintList) -> bool:
        """__eq__

        Args:
            arg (amplify.ConstraintList):

        Returns:
            bool:
        """
    def __getitem__(self, key: int) -> Constraint:
        """__getitem__

        Args:
            key (int):

        Returns:
            amplify.Constraint:
        """
    @overload
    def __iadd__(self, arg: ConstraintList) -> ConstraintList: ...
    @overload
    def __iadd__(self, arg: Constraint) -> ConstraintList:
        """__iadd__

        :Overloading:

        .. admonition:: 1. __iadd__(self, arg: amplify.ConstraintList, /) -> amplify.ConstraintList

            Args:
                * arg (amplify.ConstraintList):

            Returns:
                amplify.ConstraintList:

        .. admonition:: 2. __iadd__(self, arg: amplify.Constraint, /) -> amplify.ConstraintList

            Args:
                * arg (amplify.Constraint):

            Returns:
                amplify.ConstraintList:
        """
    def __imul__(self, arg: float) -> ConstraintList:
        """__imul__

        Args:
            arg (float):

        Returns:
            amplify.ConstraintList:
        """
    def __iter__(self) -> ConstraintList.Iterator:
        """__iter__

        Returns:
            amplify.ConstraintList.Iterator:
        """
    def __itruediv__(self, arg: float) -> ConstraintList:
        """__itruediv__

        Args:
            arg (float):

        Returns:
            amplify.ConstraintList:
        """
    def __len__(self) -> int:
        """__len__

        Returns:
            int:
        """
    def __mul__(self, arg: float) -> ConstraintList:
        """__mul__

        Args:
            arg (float):

        Returns:
            amplify.ConstraintList:
        """
    def __ne__(self, arg: ConstraintList) -> bool:
        """__ne__

        Args:
            arg (amplify.ConstraintList):

        Returns:
            bool:
        """
    @overload
    def __radd__(self, arg: Constraint) -> ConstraintList: ...
    @overload
    def __radd__(self, arg: int) -> ConstraintList:
        """__radd__

        :Overloading:

        .. admonition:: 1. __radd__(self, arg: amplify.Constraint, /) -> amplify.ConstraintList

            Args:
                * arg (amplify.Constraint):

            Returns:
                amplify.ConstraintList:

        .. admonition:: 2. __radd__(self, arg: int, /) -> amplify.ConstraintList

            Args:
                * arg (int):

            Returns:
                amplify.ConstraintList:
        """
    def __rmul__(self, arg: float) -> ConstraintList:
        """__rmul__

        Args:
            arg (float):

        Returns:
            amplify.ConstraintList:
        """
    def __setitem__(self, key: int, value: Constraint) -> None:
        """__setitem__

        Args:
            key (int):
            value (amplify.Constraint):
        """
    def __truediv__(self, arg: float) -> ConstraintList:
        """__truediv__

        Args:
            arg (float):

        Returns:
            amplify.ConstraintList:
        """

class DASClient:
    class Algorithm:
        ALL: ClassVar[DASClient.Algorithm] = ...
        PT: ClassVar[DASClient.Algorithm] = ...
        QMC: ClassVar[DASClient.Algorithm] = ...
        SA: ClassVar[DASClient.Algorithm] = ...
        __name__: Any
        def __init__(self, *args, **kwargs) -> None: ...
        def __eq__(self, other) -> bool: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        def __ne__(self, other) -> bool: ...

    class Parameters:
        class Schedule:
            @property
            def algorithm(self) -> Optional[DASClient.Algorithm]:
                """algorithm property

                Returns:
                    amplify.DASClient.Algorithm | None:
                """
            @algorithm.setter
            def algorithm(
                self, value: Union[Optional[DASClient.Algorithm], Literal["SA", "QMC", "PT", "ALL"]]
            ) -> None: ...
            anneal_time: Optional[int]
            """anneal_time property

            Returns:
                int | None:
            """
            gamma: Optional[List[float]]
            """gamma property

            Returns:
                List[float] | None:
            """
            temper: Optional[List[float]]
            """temper property

            Returns:
                List[float] | None:
            """
            def __init__(self, *args, **kwargs) -> None: ...
            def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
                """_repr_pretty_

                Args:
                    arg0 (Any):
                    arg1 (bool):
                """

        @property
        def algorithm(self) -> Optional[DASClient.Algorithm]:
            """algorithm property

            Returns:
                amplify.DASClient.Algorithm | None:
            """
        @algorithm.setter
        def algorithm(self, value: Union[Optional[DASClient.Algorithm], Literal["SA", "QMC", "PT", "ALL"]]) -> None: ...
        anneal_time: Optional[int]
        """anneal_time property

        Returns:
            int | None:
        """
        auto: Optional[bool]
        """auto property

        Returns:
            bool | None:
        """
        decrease_factor: Optional[float]
        """decrease_factor property

        Returns:
            float | None:
        """
        @property
        def proc(self) -> Optional[DASClient.Proc]:
            """proc property

            Returns:
                amplify.DASClient.Proc | None:
            """
        @proc.setter
        def proc(self, value: Union[Optional[DASClient.Proc], Literal["CPU", "GPU"]]) -> None: ...
        pt_factor: Optional[float]
        """pt_factor property

        Returns:
            float | None:
        """
        pt_temper: Optional[float]
        """pt_temper property

        Returns:
            float | None:
        """
        qmc_gamma: Optional[float]
        """qmc_gamma property

        Returns:
            float | None:
        """
        qmc_temper: Optional[float]
        """qmc_temper property

        Returns:
            float | None:
        """
        repetition: Optional[int]
        """repetition property

        Returns:
            int | None:
        """
        sa_temper: Optional[float]
        """sa_temper property

        Returns:
            float | None:
        """
        @property
        def schedule_type(self) -> Optional[DASClient.ScheduleType]:
            """schedule_type property

            Returns:
                amplify.DASClient.ScheduleType | None:
            """
        @schedule_type.setter
        def schedule_type(
            self, value: Union[Optional[DASClient.ScheduleType], Literal["Linear", "Power", "Expo"]]
        ) -> None: ...
        trotter: Optional[int]
        """trotter property

        Returns:
            int | None:
        """
        def __init__(self, *args, **kwargs) -> None: ...
        def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
            """_repr_pretty_

            Args:
                arg0 (Any):
                arg1 (bool):
            """
        @property
        def schedule(self) -> DASClient.Parameters.Schedule:
            """schedule property

            Returns:
                amplify.DASClient.Parameters.Schedule:
            """

    class Proc:
        CPU: ClassVar[DASClient.Proc] = ...
        GPU: ClassVar[DASClient.Proc] = ...
        __name__: Any
        def __init__(self, *args, **kwargs) -> None: ...
        def __eq__(self, other) -> bool: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        def __ne__(self, other) -> bool: ...

    class Result:
        def __init__(self, *args, **kwargs) -> None: ...
        def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
            """_repr_pretty_

            Args:
                arg0 (Any):
                arg1 (bool):
            """
        @property
        def energy(self) -> float:
            """energy property

            Returns:
                float:
            """
        @property
        def execution_time(self) -> datetime.timedelta:
            """execution_time property

            Returns:
                datetime.timedelta:
            """
        @property
        def spins(self) -> List[int]:
            """spins property

            Returns:
                List[int]:
            """

    class ScheduleType:
        Expo: ClassVar[DASClient.ScheduleType] = ...
        Linear: ClassVar[DASClient.ScheduleType] = ...
        Power: ClassVar[DASClient.ScheduleType] = ...
        __name__: Any
        def __init__(self, *args, **kwargs) -> None: ...
        def __eq__(self, other) -> bool: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        def __ne__(self, other) -> bool: ...

    @property
    def write_request_data(self) -> Optional[os.PathLike]:
        """write_request_data property

        Returns:
            os.PathLike | None:
        """
    @write_request_data.setter
    def write_request_data(self, value: Union[Optional[os.PathLike], str]) -> None: ...
    @property
    def write_response_data(self) -> Optional[os.PathLike]:
        """write_response_data property

        Returns:
            os.PathLike | None:
        """
    @write_response_data.setter
    def write_response_data(self, value: Union[Optional[os.PathLike], str]) -> None: ...
    def __init__(self) -> None:
        """__init__"""
    def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
        """_repr_pretty_

        Args:
            arg0 (Any):
            arg1 (bool):
        """
    @overload
    def solve(self, objective: Union[Poly, Matrix], dry_run: Literal[False] = ...) -> DASClient.Result: ...
    @overload
    def solve(self, objective: Union[Poly, Matrix], dry_run: Literal[True]) -> None:
        """solve

        :Overloading:

        .. admonition:: 1. solve(self, objective: Union[amplify.Poly, amplify.Matrix], dry_run: Literal[False] = False) -> amplify.DASClient.Result

            Args:
                * objective (amplify.Poly | amplify.Matrix):
                * dry_run (Literal[False]): Defaults to ``False``.

            Returns:
                amplify.DASClient.Result:

        .. admonition:: 2. solve(self, objective: Union[amplify.Poly, amplify.Matrix], dry_run: Literal[True]) -> None

            Args:
                * objective (amplify.Poly | amplify.Matrix):
                * dry_run (Literal[True]):
        """
    @property
    def acceptable_degrees(self) -> AcceptableDegrees:
        """acceptable_degrees property

        Returns:
            amplify.AcceptableDegrees:
        """
    @property
    def library_path(self) -> Optional[str]:
        """library_path property

        Returns:
            str | None:
        """
    @property
    def parameters(self) -> DASClient.Parameters:
        """parameters property

        Returns:
            amplify.DASClient.Parameters:
        """
    @property
    def version(self) -> str:
        """version property

        Returns:
            str:
        """

class DWaveClientParameters:
    def __init__(self) -> None:
        """__init__"""
    def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
        """_repr_pretty_

        Args:
            arg0 (Any):
            arg1 (bool):
        """
    def __getattr__(self, arg: Any) -> object:
        """__getattr__

        Args:
            arg (Any):

        Returns:
            object:
        """
    def __setattr__(self, arg0: Any, arg1: Any) -> None:
        """__setattr__

        Args:
            arg0 (Any):
            arg1 (Any):
        """

class DWaveSamplerClient:
    proxy: Optional[str]
    """proxy property

    Returns:
        str | None:
    """
    solver: str
    """solver property

    Returns:
        str:
    """
    token: str
    """token property

    Returns:
        str:
    """
    url: str
    """url property

    Returns:
        str:
    """
    @property
    def write_request_data(self) -> Optional[os.PathLike]:
        """write_request_data property

        Returns:
            os.PathLike | None:
        """
    @write_request_data.setter
    def write_request_data(self, value: Union[Optional[os.PathLike], str]) -> None: ...
    @property
    def write_response_data(self) -> Optional[os.PathLike]:
        """write_response_data property

        Returns:
            os.PathLike | None:
        """
    @write_response_data.setter
    def write_response_data(self, value: Union[Optional[os.PathLike], str]) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, token: str = ..., solver: str = ..., url: str = ..., proxy: Optional[str] = ...) -> None:
        """__init__

        Args:
            token (str): Defaults to ``''``.
            solver (str): Defaults to ``''``.
            url (str): Defaults to ``''``.
            proxy (str | None): Defaults to ``None``.
        """
    def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
        """_repr_pretty_

        Args:
            arg0 (Any):
            arg1 (bool):
        """
    @overload
    def solve(self, objective: Poly, dry_run: Literal[False] = ...) -> dimod.sampleset.SampleSet: ...
    @overload
    def solve(self, objective: Poly, dry_run: Literal[True]) -> None:
        """solve

        :Overloading:

        .. admonition:: 1. solve(self, objective: amplify.Poly, dry_run: Literal[False] = False) -> dimod.sampleset.SampleSet

            Args:
                * objective (amplify.Poly):
                * dry_run (Literal[False]): Defaults to ``False``.

            Returns:
                dimod.sampleset.SampleSet:

        .. admonition:: 2. solve(self, objective: amplify.Poly, dry_run: Literal[True]) -> None

            Args:
                * objective (amplify.Poly):
                * dry_run (Literal[True]):
        """
    @property
    def acceptable_degrees(self) -> AcceptableDegrees:
        """acceptable_degrees property

        Returns:
            amplify.AcceptableDegrees:
        """
    @property
    def graph(self) -> Graph:
        """graph property

        Returns:
            amplify.Graph:
        """
    @property
    def parameters(self) -> DWaveClientParameters:
        """parameters property

        Returns:
            amplify.DWaveClientParameters:
        """
    @property
    def properties(self) -> dict[str, Any]:
        """properties property

        Returns:
            dict[str, Any]:
        """
    @property
    def solver_names(self) -> list[str]:
        """solver_names property

        Returns:
            list[str]:
        """
    @property
    def version(self) -> str:
        """version property

        Returns:
            str:
        """

class Degree:
    Cubic: ClassVar[Degree] = ...
    HighOrder: ClassVar[Degree] = ...
    Linear: ClassVar[Degree] = ...
    Quadratic: ClassVar[Degree] = ...
    Quartic: ClassVar[Degree] = ...
    Zero: ClassVar[Degree] = ...
    __name__: Any
    def __init__(self, *args, **kwargs) -> None: ...
    def __eq__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...

class EmbeddingMethod:
    Clique: ClassVar[EmbeddingMethod] = ...
    Default: ClassVar[EmbeddingMethod] = ...
    Minor: ClassVar[EmbeddingMethod] = ...
    Parallel: ClassVar[EmbeddingMethod] = ...
    __name__: Any
    def __init__(self, *args, **kwargs) -> None: ...
    def __eq__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...

class FixstarsClient:
    class Parameters:
        class Outputs:
            duplicate: Optional[bool]
            """duplicate property

            Returns:
                bool | None:
            """
            energies: Optional[bool]
            """energies property

            Returns:
                bool | None:
            """
            feasibilities: Optional[bool]
            """feasibilities property

            Returns:
                bool | None:
            """
            num_outputs: Optional[int]
            """num_outputs property

            Returns:
                int | None:
            """
            sort: Optional[bool]
            """sort property

            Returns:
                bool | None:
            """
            spins: Optional[bool]
            """spins property

            Returns:
                bool | None:
            """
            def __init__(self, *args, **kwargs) -> None: ...
            def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
                """_repr_pretty_

                Args:
                    arg0 (Any):
                    arg1 (bool):
                """

        num_gpus: Optional[int]
        """num_gpus property

        Returns:
            int | None:
        """
        penalty_calibration: Optional[bool]
        """penalty_calibration property

        Returns:
            bool | None:
        """
        @property
        def timeout(self) -> Optional[datetime.timedelta]:
            """timeout property

            Returns:
                datetime.timedelta | None:
            """
        @timeout.setter
        def timeout(self, value: Union[Optional[datetime.timedelta], int]) -> None: ...
        def __init__(self, *args, **kwargs) -> None: ...
        def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
            """_repr_pretty_

            Args:
                arg0 (Any):
                arg1 (bool):
            """
        @property
        def outputs(self) -> FixstarsClient.Parameters.Outputs:
            """outputs property

            Returns:
                amplify.FixstarsClient.Parameters.Outputs:
            """

    class Result:
        class ExecutionParameters:
            def __init__(self, *args, **kwargs) -> None: ...
            def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
                """_repr_pretty_

                Args:
                    arg0 (Any):
                    arg1 (bool):
                """
            @property
            def num_gpus(self) -> int:
                """num_gpus property

                Returns:
                    int:
                """
            @property
            def num_iterations(self) -> int:
                """num_iterations property

                Returns:
                    int:
                """
            @property
            def penalty_calibration(self) -> bool:
                """penalty_calibration property

                Returns:
                    bool:
                """
            @property
            def penalty_multipliers(self) -> numpy.ndarray[Any, numpy.dtype[numpy.float64]]:
                """penalty_multipliers property

                Returns:
                    numpy.ndarray:
                """
            @property
            def timeout(self) -> datetime.timedelta:
                """timeout property

                Returns:
                    datetime.timedelta:
                """
            @property
            def version(self) -> str:
                """version property

                Returns:
                    str:
                """

        class ExecutionTime:
            def __init__(self, *args, **kwargs) -> None: ...
            def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
                """_repr_pretty_

                Args:
                    arg0 (Any):
                    arg1 (bool):
                """
            @property
            def annealing_time(self) -> datetime.timedelta:
                """annealing_time property

                Returns:
                    datetime.timedelta:
                """
            @property
            def cpu_time(self) -> datetime.timedelta:
                """cpu_time property

                Returns:
                    datetime.timedelta:
                """
            @property
            def queue_time(self) -> datetime.timedelta:
                """queue_time property

                Returns:
                    datetime.timedelta:
                """
            @property
            def time_stamps(self) -> List[datetime.timedelta]:
                """time_stamps property

                Returns:
                    List[datetime.timedelta]:
                """

        def __init__(self, *args, **kwargs) -> None: ...
        def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
            """_repr_pretty_

            Args:
                arg0 (Any):
                arg1 (bool):
            """
        @property
        def energies(self) -> numpy.ndarray[Any, numpy.dtype[numpy.float64]]:
            """energies property

            Returns:
                numpy.ndarray:
            """
        @property
        def execution_parameters(self) -> FixstarsClient.Result.ExecutionParameters:
            """execution_parameters property

            Returns:
                amplify.FixstarsClient.Result.ExecutionParameters:
            """
        @property
        def execution_time(self) -> FixstarsClient.Result.ExecutionTime:
            """execution_time property

            Returns:
                amplify.FixstarsClient.Result.ExecutionTime:
            """
        @property
        def feasibilities(self) -> numpy.ndarray[Any, numpy.dtype[numpy.bool_]]:
            """feasibilities property

            Returns:
                numpy.ndarray:
            """
        @property
        def message(self) -> str:
            """message property

            Returns:
                str:
            """
        @property
        def spins(self) -> list[numpy.ndarray[Any, numpy.dtype[numpy.int8]]]:
            """spins property

            Returns:
                list[numpy.ndarray[Any, numpy.dtype[numpy.int8]]]:
            """

    compression: bool
    """compression property

    Returns:
        bool:
    """
    proxy: Optional[str]
    """proxy property

    Returns:
        str | None:
    """
    token: str
    """token property

    Returns:
        str:
    """
    url: str
    """url property

    Returns:
        str:
    """
    @property
    def write_request_data(self) -> Optional[os.PathLike]:
        """write_request_data property

        Returns:
            os.PathLike | None:
        """
    @write_request_data.setter
    def write_request_data(self, value: Union[Optional[os.PathLike], str]) -> None: ...
    @property
    def write_response_data(self) -> Optional[os.PathLike]:
        """write_response_data property

        Returns:
            os.PathLike | None:
        """
    @write_response_data.setter
    def write_response_data(self, value: Union[Optional[os.PathLike], str]) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, token: str = ..., url: str = ..., proxy: Optional[str] = ...) -> None:
        """__init__

        Args:
            token (str): Defaults to ``''``.
            url (str): Defaults to ``''``.
            proxy (str | None): Defaults to ``None``.
        """
    def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
        """_repr_pretty_

        Args:
            arg0 (Any):
            arg1 (bool):
        """
    @overload
    def solve(self, objective: Union[Poly, Matrix], dry_run: Literal[False] = ...) -> FixstarsClient.Result: ...
    @overload
    def solve(
        self, constraint: Union[Constraint, ConstraintList], dry_run: Literal[False] = ...
    ) -> FixstarsClient.Result: ...
    @overload
    def solve(
        self,
        objective: Union[Poly, Matrix],
        constraint: Union[Constraint, ConstraintList],
        dry_run: Literal[False] = ...,
    ) -> FixstarsClient.Result: ...
    @overload
    def solve(self, objective: Union[Poly, Matrix], dry_run: Literal[True]) -> None: ...
    @overload
    def solve(self, constraint: Union[Constraint, ConstraintList], dry_run: Literal[True]) -> None: ...
    @overload
    def solve(
        self, objective: Union[Poly, Matrix], constraint: Union[Constraint, ConstraintList], dry_run: Literal[True]
    ) -> None:
        """solve

        :Overloading:

        .. admonition:: 1. solve(self, objective: Union[amplify.Poly, amplify.Matrix], dry_run: Literal[False] = False) -> amplify.FixstarsClient.Result

            Args:
                * objective (amplify.Poly | amplify.Matrix):
                * dry_run (Literal[False]): Defaults to ``False``.

            Returns:
                amplify.FixstarsClient.Result:

        .. admonition:: 2. solve(self, constraint: Union[amplify.Constraint, amplify.ConstraintList], dry_run: Literal[False] = False) -> amplify.FixstarsClient.Result

            Args:
                * constraint (amplify.Constraint | amplify.ConstraintList):
                * dry_run (Literal[False]): Defaults to ``False``.

            Returns:
                amplify.FixstarsClient.Result:

        .. admonition:: 3. solve(self, objective: Union[amplify.Poly, amplify.Matrix], constraint: Union[amplify.Constraint, amplify.ConstraintList], dry_run: Literal[False] = False) -> amplify.FixstarsClient.Result

            Args:
                * objective (amplify.Poly | amplify.Matrix):
                * constraint (amplify.Constraint | amplify.ConstraintList):
                * dry_run (Literal[False]): Defaults to ``False``.

            Returns:
                amplify.FixstarsClient.Result:

        .. admonition:: 4. solve(self, objective: Union[amplify.Poly, amplify.Matrix], dry_run: Literal[True]) -> None

            Args:
                * objective (amplify.Poly | amplify.Matrix):
                * dry_run (Literal[True]):

        .. admonition:: 5. solve(self, constraint: Union[amplify.Constraint, amplify.ConstraintList], dry_run: Literal[True]) -> None

            Args:
                * constraint (amplify.Constraint | amplify.ConstraintList):
                * dry_run (Literal[True]):

        .. admonition:: 6. solve(self, objective: Union[amplify.Poly, amplify.Matrix], constraint: Union[amplify.Constraint, amplify.ConstraintList], dry_run: Literal[True]) -> None

            Args:
                * objective (amplify.Poly | amplify.Matrix):
                * constraint (amplify.Constraint | amplify.ConstraintList):
                * dry_run (Literal[True]):
        """
    @property
    def acceptable_degrees(self) -> AcceptableDegrees:
        """acceptable_degrees property

        Returns:
            amplify.AcceptableDegrees:
        """
    @property
    def parameters(self) -> FixstarsClient.Parameters:
        """parameters property

        Returns:
            amplify.FixstarsClient.Parameters:
        """
    @property
    def version(self) -> str:
        """version property

        Returns:
            str:
        """

class FujitsuDA3cClient(FujitsuDA4Client):  # noqa: F821
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(
        self, token: str = ..., type_id: Optional[str] = ..., url: str = ..., proxy: Optional[str] = ...
    ) -> None:
        """__init__

        Args:
            token (str): Defaults to ``''``.
            type_id (str | None): Defaults to ``None``.
            url (str): Defaults to ``''``.
            proxy (str | None): Defaults to ``None``.
        """

class FujitsuDA4Client:
    class CommonError:
        def __init__(self, *args, **kwargs) -> None: ...
        def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
            """_repr_pretty_

            Args:
                arg0 (Any):
                arg1 (bool):
            """
        @property
        def code(self) -> int:
            """code property

            Returns:
                int:
            """
        @property
        def message(self) -> str:
            """message property

            Returns:
                str:
            """
        @property
        def title(self) -> str:
            """title property

            Returns:
                str:
            """

    class JobStatus:
        Canceled: ClassVar[FujitsuDA4Client.JobStatus] = ...
        Deleted: ClassVar[FujitsuDA4Client.JobStatus] = ...
        Done: ClassVar[FujitsuDA4Client.JobStatus] = ...
        Error: ClassVar[FujitsuDA4Client.JobStatus] = ...
        Running: ClassVar[FujitsuDA4Client.JobStatus] = ...
        Waiting: ClassVar[FujitsuDA4Client.JobStatus] = ...
        __name__: Any
        def __init__(self, *args, **kwargs) -> None: ...
        def __eq__(self, other) -> bool: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        def __ne__(self, other) -> bool: ...

    class JobStatusInfo:
        def __init__(self, *args, **kwargs) -> None: ...
        def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
            """_repr_pretty_

            Args:
                arg0 (Any):
                arg1 (bool):
            """
        @property
        def job_id(self) -> str:
            """job_id property

            Returns:
                str:
            """
        @property
        def job_status(self) -> FujitsuDA4Client.JobStatus:
            """job_status property

            Returns:
                amplify.FujitsuDA4Client.JobStatus:
            """
        @property
        def start_time(self) -> datetime.datetime:
            """start_time property

            Returns:
                datetime.datetime:
            """

    class Parameters:
        gs_cutoff: Optional[int]
        """gs_cutoff property

        Returns:
            int | None:
        """
        gs_level: Optional[int]
        """gs_level property

        Returns:
            int | None:
        """
        internal_penalty: Optional[int]
        """internal_penalty property

        Returns:
            int | None:
        """
        max_penalty_coef: Optional[int]
        """max_penalty_coef property

        Returns:
            int | None:
        """
        num_group: Optional[int]
        """num_group property

        Returns:
            int | None:
        """
        num_output_solution: Optional[int]
        """num_output_solution property

        Returns:
            int | None:
        """
        num_run: Optional[int]
        """num_run property

        Returns:
            int | None:
        """
        one_hot_cutoff: Optional[int]
        """one_hot_cutoff property

        Returns:
            int | None:
        """
        one_hot_level: Optional[int]
        """one_hot_level property

        Returns:
            int | None:
        """
        penalty_auto_mode: Optional[int]
        """penalty_auto_mode property

        Returns:
            int | None:
        """
        penalty_coef: Optional[int]
        """penalty_coef property

        Returns:
            int | None:
        """
        penalty_inc_rate: Optional[int]
        """penalty_inc_rate property

        Returns:
            int | None:
        """
        target_energy: Optional[float]
        """target_energy property

        Returns:
            float | None:
        """
        @property
        def time_limit_sec(self) -> Optional[datetime.timedelta]:
            """time_limit_sec property

            Returns:
                datetime.timedelta | None:
            """
        @time_limit_sec.setter
        def time_limit_sec(self, value: Union[Optional[datetime.timedelta], int]) -> None: ...
        def __init__(self, *args, **kwargs) -> None: ...
        def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
            """_repr_pretty_

            Args:
                arg0 (Any):
                arg1 (bool):
            """

    class Progress:
        def __init__(self, *args, **kwargs) -> None: ...
        def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
            """_repr_pretty_

            Args:
                arg0 (Any):
                arg1 (bool):
            """
        @property
        def energy(self) -> float:
            """energy property

            Returns:
                float:
            """
        @property
        def penalty_energy(self) -> float:
            """penalty_energy property

            Returns:
                float:
            """
        @property
        def time(self) -> datetime.timedelta:
            """time property

            Returns:
                datetime.timedelta:
            """

    class QuboResponse:
        def __init__(self, *args, **kwargs) -> None: ...
        def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
            """_repr_pretty_

            Args:
                arg0 (Any):
                arg1 (bool):
            """
        @property
        def message(self) -> str:
            """message property

            Returns:
                str:
            """
        @property
        def qubo_solution(self) -> FujitsuDA4Client.QuboSolutionList:
            """qubo_solution property

            Returns:
                amplify.FujitsuDA4Client.QuboSolutionList:
            """
        @property
        def status(self) -> FujitsuDA4Client.JobStatus:
            """status property

            Returns:
                amplify.FujitsuDA4Client.JobStatus:
            """

    class QuboSolution:
        def __init__(self, *args, **kwargs) -> None: ...
        def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
            """_repr_pretty_

            Args:
                arg0 (Any):
                arg1 (bool):
            """
        @property
        def configuration(self) -> Dict[str, bool]:
            """configuration property

            Returns:
                Dict[str, bool]:
            """
        @property
        def energy(self) -> float:
            """energy property

            Returns:
                float:
            """
        @property
        def frequency(self) -> int:
            """frequency property

            Returns:
                int:
            """
        @property
        def penalty_energy(self) -> float:
            """penalty_energy property

            Returns:
                float:
            """

    class QuboSolutionList:
        def __init__(self, *args, **kwargs) -> None: ...
        def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
            """_repr_pretty_

            Args:
                arg0 (Any):
                arg1 (bool):
            """
        @property
        def progress(self) -> List[FujitsuDA4Client.Progress]:
            """progress property

            Returns:
                List[amplify.FujitsuDA4Client.Progress]:
            """
        @property
        def result_status(self) -> bool:
            """result_status property

            Returns:
                bool:
            """
        @property
        def solutions(self) -> List[FujitsuDA4Client.QuboSolution]:
            """solutions property

            Returns:
                List[amplify.FujitsuDA4Client.QuboSolution]:
            """
        @property
        def timing(self) -> FujitsuDA4Client.SolverTiming:
            """timing property

            Returns:
                amplify.FujitsuDA4Client.SolverTiming:
            """

    class Result:
        def __init__(self, *args, **kwargs) -> None: ...
        def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
            """_repr_pretty_

            Args:
                arg0 (Any):
                arg1 (bool):
            """
        @property
        def message(self) -> str:
            """message property

            Returns:
                str:
            """
        @property
        def qubo_solution(self) -> FujitsuDA4Client.QuboSolutionList:
            """qubo_solution property

            Returns:
                amplify.FujitsuDA4Client.QuboSolutionList:
            """
        @property
        def status(self) -> FujitsuDA4Client.JobStatus:
            """status property

            Returns:
                amplify.FujitsuDA4Client.JobStatus:
            """

    class SolverTiming:
        def __init__(self, *args, **kwargs) -> None: ...
        def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
            """_repr_pretty_

            Args:
                arg0 (Any):
                arg1 (bool):
            """
        @property
        def solve_time(self) -> datetime.timedelta:
            """solve_time property

            Returns:
                datetime.timedelta:
            """
        @property
        def total_elapsed_time(self) -> datetime.timedelta:
            """total_elapsed_time property

            Returns:
                datetime.timedelta:
            """

    proxy: Optional[str]
    """proxy property

    Returns:
        str | None:
    """
    set_inequalities: bool
    """set_inequalities property

    Returns:
        bool:
    """
    set_one_way_one_hot_groups: bool
    """set_one_way_one_hot_groups property

    Returns:
        bool:
    """
    set_penalty_binary_polynomial: bool
    """set_penalty_binary_polynomial property

    Returns:
        bool:
    """
    set_two_way_one_hot_groups: bool
    """set_two_way_one_hot_groups property

    Returns:
        bool:
    """
    token: str
    """token property

    Returns:
        str:
    """
    type_id: Optional[str]
    """type_id property

    Returns:
        str | None:
    """
    url: str
    """url property

    Returns:
        str:
    """
    @property
    def write_request_data(self) -> Optional[os.PathLike]:
        """write_request_data property

        Returns:
            os.PathLike | None:
        """
    @write_request_data.setter
    def write_request_data(self, value: Union[Optional[os.PathLike], str]) -> None: ...
    @property
    def write_response_data(self) -> Optional[os.PathLike]:
        """write_response_data property

        Returns:
            os.PathLike | None:
        """
    @write_response_data.setter
    def write_response_data(self, value: Union[Optional[os.PathLike], str]) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(
        self, token: str = ..., type_id: Optional[str] = ..., url: str = ..., proxy: Optional[str] = ...
    ) -> None:
        """__init__

        Args:
            token (str): Defaults to ``''``.
            type_id (str | None): Defaults to ``None``.
            url (str): Defaults to ``''``.
            proxy (str | None): Defaults to ``None``.
        """
    def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
        """_repr_pretty_

        Args:
            arg0 (Any):
            arg1 (bool):
        """
    @overload
    def async_solve(self, objective: Poly) -> str: ...
    @overload
    def async_solve(self, constraint: Union[Constraint, ConstraintList]) -> str: ...
    @overload
    def async_solve(self, objective: Poly, constraint: Union[Constraint, ConstraintList]) -> str:
        """async_solve

        :Overloading:

        .. admonition:: 1. async_solve(self, objective: amplify.Poly) -> str

            Args:
                * objective (amplify.Poly):

            Returns:
                str:

        .. admonition:: 2. async_solve(self, constraint: Union[amplify.Constraint, amplify.ConstraintList]) -> str

            Args:
                * constraint (amplify.Constraint | amplify.ConstraintList):

            Returns:
                str:

        .. admonition:: 3. async_solve(self, objective: amplify.Poly, constraint: Union[amplify.Constraint, amplify.ConstraintList]) -> str

            Args:
                * objective (amplify.Poly):
                * constraint (amplify.Constraint | amplify.ConstraintList):

            Returns:
                str:
        """
    def cancel_job(self, job_id: str) -> FujitsuDA4Client.JobStatus:
        """cancel_job

        Args:
            job_id (str):

        Returns:
            amplify.FujitsuDA4Client.JobStatus:
        """
    def delete_job_result(self, job_id: str) -> FujitsuDA4Client.Result:
        """delete_job_result

        Args:
            job_id (str):

        Returns:
            amplify.FujitsuDA4Client.Result:
        """
    def get_job_result(self, job_id: str) -> FujitsuDA4Client.Result:
        """get_job_result

        Args:
            job_id (str):

        Returns:
            amplify.FujitsuDA4Client.Result:
        """
    def get_jobs(self) -> List[FujitsuDA4Client.JobStatusInfo]:
        """get_jobs

        Returns:
            List[amplify.FujitsuDA4Client.JobStatusInfo]:
        """
    def health_check(self) -> Optional[FujitsuDA4Client.CommonError]:
        """health_check

        Returns:
            amplify.FujitsuDA4Client.CommonError | None:
        """
    @overload
    def solve(
        self,
        objective: Union[Poly, Matrix],
        dry_run: Literal[False] = ...,
        retry_after_delete: bool = ...,
        delete_after_solve: bool = ...,
    ) -> FujitsuDA4Client.Result: ...
    @overload
    def solve(
        self,
        constraint: Union[Constraint, ConstraintList],
        dry_run: Literal[False] = ...,
        retry_after_delete: bool = ...,
        delete_after_solve: bool = ...,
    ) -> FujitsuDA4Client.Result: ...
    @overload
    def solve(
        self,
        objective: Union[Poly, Matrix],
        constraint: Union[Constraint, ConstraintList],
        dry_run: Literal[False] = ...,
        retry_after_delete: bool = ...,
        delete_after_solve: bool = ...,
    ) -> FujitsuDA4Client.Result: ...
    @overload
    def solve(
        self,
        objective: Union[Poly, Matrix],
        dry_run: Literal[True],
        retry_after_delete: bool = ...,
        delete_after_solve: bool = ...,
    ) -> None: ...
    @overload
    def solve(
        self,
        constraint: Union[Constraint, ConstraintList],
        dry_run: Literal[True],
        retry_after_delete: bool = ...,
        delete_after_solve: bool = ...,
    ) -> None: ...
    @overload
    def solve(
        self,
        objective: Union[Poly, Matrix],
        constraint: Union[Constraint, ConstraintList],
        dry_run: Literal[True],
        retry_after_delete: bool = ...,
        delete_after_solve: bool = ...,
    ) -> None:
        """solve

        :Overloading:

        .. admonition:: 1. solve(self, objective: Union[amplify.Poly, amplify.Matrix], dry_run: Literal[False] = False, retry_after_delete: bool = True, delete_after_solve: bool = True) -> amplify.FujitsuDA4Client.Result

            Args:
                * objective (amplify.Poly | amplify.Matrix):
                * dry_run (Literal[False]): Defaults to ``False``.
                * retry_after_delete (bool): Defaults to ``True``.
                * delete_after_solve (bool): Defaults to ``True``.

            Returns:
                amplify.FujitsuDA4Client.Result:

        .. admonition:: 2. solve(self, constraint: Union[amplify.Constraint, amplify.ConstraintList], dry_run: Literal[False] = False, retry_after_delete: bool = True, delete_after_solve: bool = True) -> amplify.FujitsuDA4Client.Result

            Args:
                * constraint (amplify.Constraint | amplify.ConstraintList):
                * dry_run (Literal[False]): Defaults to ``False``.
                * retry_after_delete (bool): Defaults to ``True``.
                * delete_after_solve (bool): Defaults to ``True``.

            Returns:
                amplify.FujitsuDA4Client.Result:

        .. admonition:: 3. solve(self, objective: Union[amplify.Poly, amplify.Matrix], constraint: Union[amplify.Constraint, amplify.ConstraintList], dry_run: Literal[False] = False, retry_after_delete: bool = True, delete_after_solve: bool = True) -> amplify.FujitsuDA4Client.Result

            Args:
                * objective (amplify.Poly | amplify.Matrix):
                * constraint (amplify.Constraint | amplify.ConstraintList):
                * dry_run (Literal[False]): Defaults to ``False``.
                * retry_after_delete (bool): Defaults to ``True``.
                * delete_after_solve (bool): Defaults to ``True``.

            Returns:
                amplify.FujitsuDA4Client.Result:

        .. admonition:: 4. solve(self, objective: Union[amplify.Poly, amplify.Matrix], dry_run: Literal[True], retry_after_delete: bool = True, delete_after_solve: bool = True) -> None

            Args:
                * objective (amplify.Poly | amplify.Matrix):
                * dry_run (Literal[True]):
                * retry_after_delete (bool): Defaults to ``True``.
                * delete_after_solve (bool): Defaults to ``True``.

        .. admonition:: 5. solve(self, constraint: Union[amplify.Constraint, amplify.ConstraintList], dry_run: Literal[True], retry_after_delete: bool = True, delete_after_solve: bool = True) -> None

            Args:
                * constraint (amplify.Constraint | amplify.ConstraintList):
                * dry_run (Literal[True]):
                * retry_after_delete (bool): Defaults to ``True``.
                * delete_after_solve (bool): Defaults to ``True``.

        .. admonition:: 6. solve(self, objective: Union[amplify.Poly, amplify.Matrix], constraint: Union[amplify.Constraint, amplify.ConstraintList], dry_run: Literal[True], retry_after_delete: bool = True, delete_after_solve: bool = True) -> None

            Args:
                * objective (amplify.Poly | amplify.Matrix):
                * constraint (amplify.Constraint | amplify.ConstraintList):
                * dry_run (Literal[True]):
                * retry_after_delete (bool): Defaults to ``True``.
                * delete_after_solve (bool): Defaults to ``True``.
        """
    @property
    def acceptable_degrees(self) -> AcceptableDegrees:
        """acceptable_degrees property

        Returns:
            amplify.AcceptableDegrees:
        """
    @property
    def parameters(self) -> FujitsuDA4Client.Parameters:
        """parameters property

        Returns:
            amplify.FujitsuDA4Client.Parameters:
        """
    @property
    def version(self) -> str:
        """version property

        Returns:
            str:
        """

class Graph:
    def __init__(self, *args, **kwargs) -> None: ...
    def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
        """_repr_pretty_

        Args:
            arg0 (Any):
            arg1 (bool):
        """
    @property
    def adjacency(self) -> List[List[int]]:
        """adjacency property

        Returns:
            List[List[int]]:
        """
    @property
    def edges(self) -> List[Tuple[int, int]]:
        """edges property

        Returns:
            List[Tuple[int, int]]:
        """
    @property
    def nodes(self) -> List[int]:
        """nodes property

        Returns:
            List[int]:
        """
    @property
    def shape(self) -> List[int]:
        """shape property

        Returns:
            List[int]:
        """
    @property
    def type(self) -> str:
        """type property

        Returns:
            str:
        """

class GurobiClient:
    class Parameters:
        agg_fill: Optional[int]
        """agg_fill property

        Returns:
            int | None:
        """
        aggregate: Optional[int]
        """aggregate property

        Returns:
            int | None:
        """
        bar_conv_tol: Optional[float]
        """bar_conv_tol property

        Returns:
            float | None:
        """
        bar_correctors: Optional[int]
        """bar_correctors property

        Returns:
            int | None:
        """
        bar_homogeneous: Optional[int]
        """bar_homogeneous property

        Returns:
            int | None:
        """
        bar_iter_limit: Optional[int]
        """bar_iter_limit property

        Returns:
            int | None:
        """
        bar_order: Optional[int]
        """bar_order property

        Returns:
            int | None:
        """
        bar_qcp_conv_tol: Optional[float]
        """bar_qcp_conv_tol property

        Returns:
            float | None:
        """
        best_bd_stop: Optional[float]
        """best_bd_stop property

        Returns:
            float | None:
        """
        best_obj_stop: Optional[float]
        """best_obj_stop property

        Returns:
            float | None:
        """
        bqp_cuts: Optional[int]
        """bqp_cuts property

        Returns:
            int | None:
        """
        branch_dir: Optional[int]
        """branch_dir property

        Returns:
            int | None:
        """
        clique_cuts: Optional[int]
        """clique_cuts property

        Returns:
            int | None:
        """
        cloud_access_id: Optional[str]
        """cloud_access_id property

        Returns:
            str | None:
        """
        cloud_host: Optional[str]
        """cloud_host property

        Returns:
            str | None:
        """
        cloud_pool: Optional[str]
        """cloud_pool property

        Returns:
            str | None:
        """
        cloud_secret_key: Optional[str]
        """cloud_secret_key property

        Returns:
            str | None:
        """
        compute_server: Optional[str]
        """compute_server property

        Returns:
            str | None:
        """
        concurrent_jobs: Optional[int]
        """concurrent_jobs property

        Returns:
            int | None:
        """
        concurrent_method: Optional[int]
        """concurrent_method property

        Returns:
            int | None:
        """
        concurrent_mip: Optional[int]
        """concurrent_mip property

        Returns:
            int | None:
        """
        cover_cuts: Optional[int]
        """cover_cuts property

        Returns:
            int | None:
        """
        crossover: Optional[int]
        """crossover property

        Returns:
            int | None:
        """
        crossover_basis: Optional[int]
        """crossover_basis property

        Returns:
            int | None:
        """
        cs_app_name: Optional[str]
        """cs_app_name property

        Returns:
            str | None:
        """
        cs_auth_token: Optional[str]
        """cs_auth_token property

        Returns:
            str | None:
        """
        cs_batch_mode: Optional[int]
        """cs_batch_mode property

        Returns:
            int | None:
        """
        cs_client_log: Optional[int]
        """cs_client_log property

        Returns:
            int | None:
        """
        cs_group: Optional[str]
        """cs_group property

        Returns:
            str | None:
        """
        cs_idle_timeout: Optional[int]
        """cs_idle_timeout property

        Returns:
            int | None:
        """
        cs_manager: Optional[str]
        """cs_manager property

        Returns:
            str | None:
        """
        cs_priority: Optional[int]
        """cs_priority property

        Returns:
            int | None:
        """
        cs_queue_timeout: Optional[float]
        """cs_queue_timeout property

        Returns:
            float | None:
        """
        cs_router: Optional[str]
        """cs_router property

        Returns:
            str | None:
        """
        csapi_access_id: Optional[str]
        """csapi_access_id property

        Returns:
            str | None:
        """
        csapi_secret: Optional[str]
        """csapi_secret property

        Returns:
            str | None:
        """
        cstls_insecure: Optional[int]
        """cstls_insecure property

        Returns:
            int | None:
        """
        cut_agg_passes: Optional[int]
        """cut_agg_passes property

        Returns:
            int | None:
        """
        cut_passes: Optional[int]
        """cut_passes property

        Returns:
            int | None:
        """
        cutoff: Optional[float]
        """cutoff property

        Returns:
            float | None:
        """
        cuts: Optional[int]
        """cuts property

        Returns:
            int | None:
        """
        degen_moves: Optional[int]
        """degen_moves property

        Returns:
            int | None:
        """
        disconnected: Optional[int]
        """disconnected property

        Returns:
            int | None:
        """
        display_interval: Optional[int]
        """display_interval property

        Returns:
            int | None:
        """
        distributed_mip_jobs: Optional[int]
        """distributed_mip_jobs property

        Returns:
            int | None:
        """
        dual_reductions: Optional[int]
        """dual_reductions property

        Returns:
            int | None:
        """
        feas_relax_big_m: Optional[float]
        """feas_relax_big_m property

        Returns:
            float | None:
        """
        feasibility_tol: Optional[float]
        """feasibility_tol property

        Returns:
            float | None:
        """
        flow_cover_cuts: Optional[int]
        """flow_cover_cuts property

        Returns:
            int | None:
        """
        flow_path_cuts: Optional[int]
        """flow_path_cuts property

        Returns:
            int | None:
        """
        func_max_val: Optional[float]
        """func_max_val property

        Returns:
            float | None:
        """
        func_nonlinear: Optional[int]
        """func_nonlinear property

        Returns:
            int | None:
        """
        func_piece_error: Optional[float]
        """func_piece_error property

        Returns:
            float | None:
        """
        func_piece_length: Optional[float]
        """func_piece_length property

        Returns:
            float | None:
        """
        func_piece_ratio: Optional[float]
        """func_piece_ratio property

        Returns:
            float | None:
        """
        func_pieces: Optional[int]
        """func_pieces property

        Returns:
            int | None:
        """
        gomory_passes: Optional[int]
        """gomory_passes property

        Returns:
            int | None:
        """
        gub_cover_cuts: Optional[int]
        """gub_cover_cuts property

        Returns:
            int | None:
        """
        heuristics: Optional[float]
        """heuristics property

        Returns:
            float | None:
        """
        ignore_names: Optional[int]
        """ignore_names property

        Returns:
            int | None:
        """
        iis_method: Optional[int]
        """iis_method property

        Returns:
            int | None:
        """
        implied_cuts: Optional[int]
        """implied_cuts property

        Returns:
            int | None:
        """
        improve_start_gap: Optional[float]
        """improve_start_gap property

        Returns:
            float | None:
        """
        improve_start_nodes: Optional[float]
        """improve_start_nodes property

        Returns:
            float | None:
        """
        improve_start_time: Optional[float]
        """improve_start_time property

        Returns:
            float | None:
        """
        inf_proof_cuts: Optional[int]
        """inf_proof_cuts property

        Returns:
            int | None:
        """
        inf_unbd_info: Optional[int]
        """inf_unbd_info property

        Returns:
            int | None:
        """
        int_feas_tol: Optional[float]
        """int_feas_tol property

        Returns:
            float | None:
        """
        integrality_focus: Optional[int]
        """integrality_focus property

        Returns:
            int | None:
        """
        iteration_limit: Optional[float]
        """iteration_limit property

        Returns:
            float | None:
        """
        job_id: Optional[str]
        """job_id property

        Returns:
            str | None:
        """
        json_sol_detail: Optional[int]
        """json_sol_detail property

        Returns:
            int | None:
        """
        lazy_constraints: Optional[int]
        """lazy_constraints property

        Returns:
            int | None:
        """
        license_id: Optional[int]
        """license_id property

        Returns:
            int | None:
        """
        lift_project_cuts: Optional[int]
        """lift_project_cuts property

        Returns:
            int | None:
        """
        @property
        def log_file(self) -> Optional[os.PathLike]:
            """log_file property

            Returns:
                os.PathLike | None:
            """
        @log_file.setter
        def log_file(self, value: Union[Optional[os.PathLike], str]) -> None: ...
        log_to_console: Optional[bool]
        """log_to_console property

        Returns:
            bool | None:
        """
        lp_warm_start: Optional[int]
        """lp_warm_start property

        Returns:
            int | None:
        """
        markowitz_tol: Optional[float]
        """markowitz_tol property

        Returns:
            float | None:
        """
        mem_limit: Optional[float]
        """mem_limit property

        Returns:
            float | None:
        """
        method: Optional[int]
        """method property

        Returns:
            int | None:
        """
        min_rel_nodes: Optional[int]
        """min_rel_nodes property

        Returns:
            int | None:
        """
        mip_focus: Optional[int]
        """mip_focus property

        Returns:
            int | None:
        """
        mip_gap: Optional[float]
        """mip_gap property

        Returns:
            float | None:
        """
        mip_gap_abs: Optional[float]
        """mip_gap_abs property

        Returns:
            float | None:
        """
        mip_sep_cuts: Optional[int]
        """mip_sep_cuts property

        Returns:
            int | None:
        """
        miqcp_method: Optional[int]
        """miqcp_method property

        Returns:
            int | None:
        """
        mir_cuts: Optional[int]
        """mir_cuts property

        Returns:
            int | None:
        """
        mixing_cuts: Optional[int]
        """mixing_cuts property

        Returns:
            int | None:
        """
        mod_k_cuts: Optional[int]
        """mod_k_cuts property

        Returns:
            int | None:
        """
        multi_obj_method: Optional[int]
        """multi_obj_method property

        Returns:
            int | None:
        """
        multi_obj_pre: Optional[int]
        """multi_obj_pre property

        Returns:
            int | None:
        """
        network_alg: Optional[int]
        """network_alg property

        Returns:
            int | None:
        """
        network_cuts: Optional[int]
        """network_cuts property

        Returns:
            int | None:
        """
        nlp_heur: Optional[int]
        """nlp_heur property

        Returns:
            int | None:
        """
        no_rel_heur_time: Optional[float]
        """no_rel_heur_time property

        Returns:
            float | None:
        """
        no_rel_heur_work: Optional[float]
        """no_rel_heur_work property

        Returns:
            float | None:
        """
        no_rel_heuristic: Optional[int]
        """no_rel_heuristic property

        Returns:
            int | None:
        """
        node_limit: Optional[float]
        """node_limit property

        Returns:
            float | None:
        """
        node_method: Optional[int]
        """node_method property

        Returns:
            int | None:
        """
        @property
        def nodefile_dir(self) -> Optional[os.PathLike]:
            """nodefile_dir property

            Returns:
                os.PathLike | None:
            """
        @nodefile_dir.setter
        def nodefile_dir(self, value: Union[Optional[os.PathLike], str]) -> None: ...
        nodefile_start: Optional[float]
        """nodefile_start property

        Returns:
            float | None:
        """
        non_convex: Optional[int]
        """non_convex property

        Returns:
            int | None:
        """
        norm_adjust: Optional[int]
        """norm_adjust property

        Returns:
            int | None:
        """
        numeric_focus: Optional[int]
        """numeric_focus property

        Returns:
            int | None:
        """
        obbt: Optional[int]
        """obbt property

        Returns:
            int | None:
        """
        obj_number: Optional[int]
        """obj_number property

        Returns:
            int | None:
        """
        obj_scale: Optional[float]
        """obj_scale property

        Returns:
            float | None:
        """
        optimality_tol: Optional[float]
        """optimality_tol property

        Returns:
            float | None:
        """
        output_flag: Optional[int]
        """output_flag property

        Returns:
            int | None:
        """
        partition_place: Optional[int]
        """partition_place property

        Returns:
            int | None:
        """
        perturb_value: Optional[float]
        """perturb_value property

        Returns:
            float | None:
        """
        pool_gap: Optional[float]
        """pool_gap property

        Returns:
            float | None:
        """
        pool_gap_abs: Optional[float]
        """pool_gap_abs property

        Returns:
            float | None:
        """
        pool_search_mode: Optional[int]
        """pool_search_mode property

        Returns:
            int | None:
        """
        pool_solutions: Optional[int]
        """pool_solutions property

        Returns:
            int | None:
        """
        pre_crush: Optional[int]
        """pre_crush property

        Returns:
            int | None:
        """
        pre_dep_row: Optional[int]
        """pre_dep_row property

        Returns:
            int | None:
        """
        pre_dual: Optional[int]
        """pre_dual property

        Returns:
            int | None:
        """
        pre_miqcp_form: Optional[int]
        """pre_miqcp_form property

        Returns:
            int | None:
        """
        pre_passes: Optional[int]
        """pre_passes property

        Returns:
            int | None:
        """
        pre_q_linearize: Optional[int]
        """pre_q_linearize property

        Returns:
            int | None:
        """
        pre_sparsify: Optional[int]
        """pre_sparsify property

        Returns:
            int | None:
        """
        presolve: Optional[int]
        """presolve property

        Returns:
            int | None:
        """
        proj_implied_cuts: Optional[int]
        """proj_implied_cuts property

        Returns:
            int | None:
        """
        psd_cuts: Optional[int]
        """psd_cuts property

        Returns:
            int | None:
        """
        psd_tol: Optional[float]
        """psd_tol property

        Returns:
            float | None:
        """
        pump_passes: Optional[int]
        """pump_passes property

        Returns:
            int | None:
        """
        qcp_dual: Optional[int]
        """qcp_dual property

        Returns:
            int | None:
        """
        quad: Optional[int]
        """quad property

        Returns:
            int | None:
        """
        record: Optional[int]
        """record property

        Returns:
            int | None:
        """
        relax_lift_cuts: Optional[int]
        """relax_lift_cuts property

        Returns:
            int | None:
        """
        @property
        def result_file(self) -> Optional[os.PathLike]:
            """result_file property

            Returns:
                os.PathLike | None:
            """
        @result_file.setter
        def result_file(self, value: Union[Optional[os.PathLike], str]) -> None: ...
        rins: Optional[int]
        """rins property

        Returns:
            int | None:
        """
        rlt_cuts: Optional[int]
        """rlt_cuts property

        Returns:
            int | None:
        """
        scale_flag: Optional[int]
        """scale_flag property

        Returns:
            int | None:
        """
        scenario_number: Optional[int]
        """scenario_number property

        Returns:
            int | None:
        """
        seed: Optional[int]
        """seed property

        Returns:
            int | None:
        """
        server_password: Optional[str]
        """server_password property

        Returns:
            str | None:
        """
        server_timeout: Optional[int]
        """server_timeout property

        Returns:
            int | None:
        """
        sift_method: Optional[int]
        """sift_method property

        Returns:
            int | None:
        """
        sifting: Optional[int]
        """sifting property

        Returns:
            int | None:
        """
        simplex_pricing: Optional[int]
        """simplex_pricing property

        Returns:
            int | None:
        """
        soft_mem_limit: Optional[float]
        """soft_mem_limit property

        Returns:
            float | None:
        """
        sol_files: Optional[str]
        """sol_files property

        Returns:
            str | None:
        """
        solution_limit: Optional[int]
        """solution_limit property

        Returns:
            int | None:
        """
        solution_number: Optional[int]
        """solution_number property

        Returns:
            int | None:
        """
        solution_target: Optional[int]
        """solution_target property

        Returns:
            int | None:
        """
        start_node_limit: Optional[int]
        """start_node_limit property

        Returns:
            int | None:
        """
        start_number: Optional[int]
        """start_number property

        Returns:
            int | None:
        """
        strong_cg_cuts: Optional[int]
        """strong_cg_cuts property

        Returns:
            int | None:
        """
        sub_mip_cuts: Optional[int]
        """sub_mip_cuts property

        Returns:
            int | None:
        """
        sub_mip_nodes: Optional[int]
        """sub_mip_nodes property

        Returns:
            int | None:
        """
        symmetry: Optional[int]
        """symmetry property

        Returns:
            int | None:
        """
        threads: Optional[int]
        """threads property

        Returns:
            int | None:
        """
        time_limit: Optional[datetime.timedelta]
        """time_limit property

        Returns:
            datetime.timedelta | None:
        """
        token_server: Optional[str]
        """token_server property

        Returns:
            str | None:
        """
        ts_port: Optional[int]
        """ts_port property

        Returns:
            int | None:
        """
        tune_cleanup: Optional[float]
        """tune_cleanup property

        Returns:
            float | None:
        """
        tune_criterion: Optional[int]
        """tune_criterion property

        Returns:
            int | None:
        """
        tune_dynamic_jobs: Optional[int]
        """tune_dynamic_jobs property

        Returns:
            int | None:
        """
        tune_jobs: Optional[int]
        """tune_jobs property

        Returns:
            int | None:
        """
        tune_metric: Optional[int]
        """tune_metric property

        Returns:
            int | None:
        """
        tune_output: Optional[int]
        """tune_output property

        Returns:
            int | None:
        """
        tune_results: Optional[int]
        """tune_results property

        Returns:
            int | None:
        """
        tune_target_mip_gap: Optional[float]
        """tune_target_mip_gap property

        Returns:
            float | None:
        """
        tune_target_time: Optional[float]
        """tune_target_time property

        Returns:
            float | None:
        """
        tune_time_limit: Optional[datetime.timedelta]
        """tune_time_limit property

        Returns:
            datetime.timedelta | None:
        """
        tune_trials: Optional[int]
        """tune_trials property

        Returns:
            int | None:
        """
        update_mode: Optional[int]
        """update_mode property

        Returns:
            int | None:
        """
        username: Optional[str]
        """username property

        Returns:
            str | None:
        """
        var_branch: Optional[int]
        """var_branch property

        Returns:
            int | None:
        """
        wls_access_id: Optional[str]
        """wls_access_id property

        Returns:
            str | None:
        """
        wls_secret: Optional[str]
        """wls_secret property

        Returns:
            str | None:
        """
        wls_token: Optional[str]
        """wls_token property

        Returns:
            str | None:
        """
        wls_token_duration: Optional[int]
        """wls_token_duration property

        Returns:
            int | None:
        """
        wls_token_refresh: Optional[float]
        """wls_token_refresh property

        Returns:
            float | None:
        """
        work_limit: Optional[float]
        """work_limit property

        Returns:
            float | None:
        """
        worker_password: Optional[str]
        """worker_password property

        Returns:
            str | None:
        """
        worker_pool: Optional[str]
        """worker_pool property

        Returns:
            str | None:
        """
        zero_half_cuts: Optional[int]
        """zero_half_cuts property

        Returns:
            int | None:
        """
        zero_obj_nodes: Optional[int]
        """zero_obj_nodes property

        Returns:
            int | None:
        """
        def __init__(self, *args, **kwargs) -> None: ...
        def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
            """_repr_pretty_

            Args:
                arg0 (Any):
                arg1 (bool):
            """

    class Result:
        class OptimizationStatusCode:
            Cutoff: ClassVar[GurobiClient.Result.OptimizationStatusCode] = ...
            InfOrUnbd: ClassVar[GurobiClient.Result.OptimizationStatusCode] = ...
            Infeasible: ClassVar[GurobiClient.Result.OptimizationStatusCode] = ...
            Inprogress: ClassVar[GurobiClient.Result.OptimizationStatusCode] = ...
            Interrupted: ClassVar[GurobiClient.Result.OptimizationStatusCode] = ...
            IterationLimit: ClassVar[GurobiClient.Result.OptimizationStatusCode] = ...
            Loaded: ClassVar[GurobiClient.Result.OptimizationStatusCode] = ...
            MemLimit: ClassVar[GurobiClient.Result.OptimizationStatusCode] = ...
            NodeLimit: ClassVar[GurobiClient.Result.OptimizationStatusCode] = ...
            Numeric: ClassVar[GurobiClient.Result.OptimizationStatusCode] = ...
            Optimal: ClassVar[GurobiClient.Result.OptimizationStatusCode] = ...
            SolutionLimit: ClassVar[GurobiClient.Result.OptimizationStatusCode] = ...
            Suboptimal: ClassVar[GurobiClient.Result.OptimizationStatusCode] = ...
            TimeLimit: ClassVar[GurobiClient.Result.OptimizationStatusCode] = ...
            Unbounded: ClassVar[GurobiClient.Result.OptimizationStatusCode] = ...
            Unknown: ClassVar[GurobiClient.Result.OptimizationStatusCode] = ...
            UserObjLimit: ClassVar[GurobiClient.Result.OptimizationStatusCode] = ...
            WorkLimit: ClassVar[GurobiClient.Result.OptimizationStatusCode] = ...
            __name__: Any
            def __init__(self, *args, **kwargs) -> None: ...
            def __eq__(self, other) -> bool: ...
            def __ge__(self, other) -> bool: ...
            def __gt__(self, other) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> Any: ...
            def __int__(self) -> int: ...
            def __le__(self, other) -> bool: ...
            def __lt__(self, other) -> bool: ...
            def __ne__(self, other) -> bool: ...

        def __init__(self, *args, **kwargs) -> None: ...
        def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
            """_repr_pretty_

            Args:
                arg0 (Any):
                arg1 (bool):
            """
        @property
        def bar_iter_count(self) -> Optional[int]:
            """bar_iter_count property

            Returns:
                int | None:
            """
        @property
        def bound_vio(self) -> Optional[float]:
            """bound_vio property

            Returns:
                float | None:
            """
        @property
        def constr_vio(self) -> Optional[float]:
            """constr_vio property

            Returns:
                float | None:
            """
        @property
        def farkas_proof(self) -> Optional[float]:
            """farkas_proof property

            Returns:
                float | None:
            """
        @property
        def int_vio(self) -> Optional[float]:
            """int_vio property

            Returns:
                float | None:
            """
        @property
        def iter_count(self) -> Optional[float]:
            """iter_count property

            Returns:
                float | None:
            """
        @property
        def mip_gap(self) -> Optional[float]:
            """mip_gap property

            Returns:
                float | None:
            """
        @property
        def node_count(self) -> Optional[float]:
            """node_count property

            Returns:
                float | None:
            """
        @property
        def obj_bound(self) -> Optional[float]:
            """obj_bound property

            Returns:
                float | None:
            """
        @property
        def obj_bound_c(self) -> Optional[float]:
            """obj_bound_c property

            Returns:
                float | None:
            """
        @property
        def obj_val(self) -> Optional[float]:
            """obj_val property

            Returns:
                float | None:
            """
        @property
        def pool_obj_bound(self) -> Optional[float]:
            """pool_obj_bound property

            Returns:
                float | None:
            """
        @property
        def pool_obj_val(self) -> Optional[numpy.ndarray[Any, numpy.dtype[numpy.float64]]]:
            """pool_obj_val property

            Returns:
                numpy.ndarray | None:
            """
        @property
        def runtime(self) -> datetime.timedelta:
            """runtime property

            Returns:
                datetime.timedelta:
            """
        @property
        def sol_count(self) -> Optional[int]:
            """sol_count property

            Returns:
                int | None:
            """
        @property
        def status(self) -> GurobiClient.Result.OptimizationStatusCode:
            """status property

            Returns:
                amplify.GurobiClient.Result.OptimizationStatusCode:
            """
        @property
        def time_stamps(self) -> List[Tuple[float, datetime.timedelta]]:
            """time_stamps property

            Returns:
                List[Tuple[float, datetime.timedelta]]:
            """
        @property
        def var_names(self) -> Optional[List[str]]:
            """var_names property

            Returns:
                List[str] | None:
            """
        @property
        def x(self) -> Optional[numpy.ndarray[Any, numpy.dtype[numpy.float64]]]:
            """x property

            Returns:
                numpy.ndarray | None:
            """
        @property
        def xn(self) -> Optional[list[numpy.ndarray[Any, numpy.dtype[numpy.float64]]]]:
            """xn property

            Returns:
                list[numpy.ndarray[Any, numpy.dtype[numpy.float64]]] | None:
            """

    library_path: Optional[str]
    """library_path property

    Returns:
        str | None:
    """
    write_request_data: Optional[str]
    """write_request_data property

    Returns:
        str | None:
    """
    write_response_data: Optional[str]
    """write_response_data property

    Returns:
        str | None:
    """
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, library_path: str) -> None:
        """__init__

        Args:
            library_path (str):
        """
    def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
        """_repr_pretty_

        Args:
            arg0 (Any):
            arg1 (bool):
        """
    @overload
    def solve(self, objective: Union[Poly, Matrix], dry_run: Literal[False] = ...) -> GurobiClient.Result: ...
    @overload
    def solve(
        self, constraint: Union[Constraint, ConstraintList], dry_run: Literal[False] = ...
    ) -> GurobiClient.Result: ...
    @overload
    def solve(
        self,
        objective: Union[Poly, Matrix],
        constraint: Union[Constraint, ConstraintList],
        dry_run: Literal[False] = ...,
    ) -> GurobiClient.Result: ...
    @overload
    def solve(self, objective: Union[Poly, Matrix], dry_run: Literal[True]) -> None: ...
    @overload
    def solve(self, constraint: Union[Constraint, ConstraintList], dry_run: Literal[True]) -> None: ...
    @overload
    def solve(
        self, objective: Union[Poly, Matrix], constraint: Union[Constraint, ConstraintList], dry_run: Literal[True]
    ) -> None:
        """solve

        :Overloading:

        .. admonition:: 1. solve(self, objective: Union[amplify.Poly, amplify.Matrix], dry_run: Literal[False] = False) -> amplify.GurobiClient.Result

            Args:
                * objective (amplify.Poly | amplify.Matrix):
                * dry_run (Literal[False]): Defaults to ``False``.

            Returns:
                amplify.GurobiClient.Result:

        .. admonition:: 2. solve(self, constraint: Union[amplify.Constraint, amplify.ConstraintList], dry_run: Literal[False] = False) -> amplify.GurobiClient.Result

            Args:
                * constraint (amplify.Constraint | amplify.ConstraintList):
                * dry_run (Literal[False]): Defaults to ``False``.

            Returns:
                amplify.GurobiClient.Result:

        .. admonition:: 3. solve(self, objective: Union[amplify.Poly, amplify.Matrix], constraint: Union[amplify.Constraint, amplify.ConstraintList], dry_run: Literal[False] = False) -> amplify.GurobiClient.Result

            Args:
                * objective (amplify.Poly | amplify.Matrix):
                * constraint (amplify.Constraint | amplify.ConstraintList):
                * dry_run (Literal[False]): Defaults to ``False``.

            Returns:
                amplify.GurobiClient.Result:

        .. admonition:: 4. solve(self, objective: Union[amplify.Poly, amplify.Matrix], dry_run: Literal[True]) -> None

            Args:
                * objective (amplify.Poly | amplify.Matrix):
                * dry_run (Literal[True]):

        .. admonition:: 5. solve(self, constraint: Union[amplify.Constraint, amplify.ConstraintList], dry_run: Literal[True]) -> None

            Args:
                * constraint (amplify.Constraint | amplify.ConstraintList):
                * dry_run (Literal[True]):

        .. admonition:: 6. solve(self, objective: Union[amplify.Poly, amplify.Matrix], constraint: Union[amplify.Constraint, amplify.ConstraintList], dry_run: Literal[True]) -> None

            Args:
                * objective (amplify.Poly | amplify.Matrix):
                * constraint (amplify.Constraint | amplify.ConstraintList):
                * dry_run (Literal[True]):
        """
    @overload
    def tune(self, objective: Union[Poly, Matrix]) -> None: ...
    @overload
    def tune(self, constraint: Union[Constraint, ConstraintList]) -> None: ...
    @overload
    def tune(self, objective: Union[Poly, Matrix], constraint: Union[Constraint, ConstraintList]) -> None:
        """tune

        :Overloading:

        .. admonition:: 1. tune(self, objective: Union[amplify.Poly, amplify.Matrix]) -> None

            Args:
                * objective (amplify.Poly | amplify.Matrix):

        .. admonition:: 2. tune(self, constraint: Union[amplify.Constraint, amplify.ConstraintList]) -> None

            Args:
                * constraint (amplify.Constraint | amplify.ConstraintList):

        .. admonition:: 3. tune(self, objective: Union[amplify.Poly, amplify.Matrix], constraint: Union[amplify.Constraint, amplify.ConstraintList]) -> None

            Args:
                * objective (amplify.Poly | amplify.Matrix):
                * constraint (amplify.Constraint | amplify.ConstraintList):
        """
    @property
    def acceptable_degrees(self) -> AcceptableDegrees:
        """acceptable_degrees property

        Returns:
            amplify.AcceptableDegrees:
        """
    @property
    def parameters(self) -> GurobiClient.Parameters:
        """parameters property

        Returns:
            amplify.GurobiClient.Parameters:
        """
    @property
    def version(self) -> str:
        """version property

        Returns:
            str:
        """

class IntegerEncodingMethod:
    Binary: ClassVar[IntegerEncodingMethod] = ...
    Default: ClassVar[IntegerEncodingMethod] = ...
    Linear: ClassVar[IntegerEncodingMethod] = ...
    Unary: ClassVar[IntegerEncodingMethod] = ...
    __name__: Any
    def __init__(self, *args, **kwargs) -> None: ...
    def __eq__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...

class LeapHybridCQMSamplerClient:
    proxy: Optional[str]
    """proxy property

    Returns:
        str | None:
    """
    solver: str
    """solver property

    Returns:
        str:
    """
    token: str
    """token property

    Returns:
        str:
    """
    url: str
    """url property

    Returns:
        str:
    """
    @property
    def write_request_data(self) -> Optional[os.PathLike]:
        """write_request_data property

        Returns:
            os.PathLike | None:
        """
    @write_request_data.setter
    def write_request_data(self, value: Union[Optional[os.PathLike], str]) -> None: ...
    @property
    def write_response_data(self) -> Optional[os.PathLike]:
        """write_response_data property

        Returns:
            os.PathLike | None:
        """
    @write_response_data.setter
    def write_response_data(self, value: Union[Optional[os.PathLike], str]) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, token: str = ..., solver: str = ..., url: str = ..., proxy: Optional[str] = ...) -> None:
        """__init__

        Args:
            token (str): Defaults to ``''``.
            solver (str): Defaults to ``''``.
            url (str): Defaults to ``''``.
            proxy (str | None): Defaults to ``None``.
        """
    def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
        """_repr_pretty_

        Args:
            arg0 (Any):
            arg1 (bool):
        """
    @overload
    def solve(self, objective: Union[Poly, Matrix], dry_run: Literal[False] = ...) -> dimod.sampleset.SampleSet: ...
    @overload
    def solve(
        self, constraint: Union[Constraint, ConstraintList], dry_run: Literal[False] = ...
    ) -> dimod.sampleset.SampleSet: ...
    @overload
    def solve(
        self,
        objective: Union[Poly, Matrix],
        constraint: Union[Constraint, ConstraintList],
        dry_run: Literal[False] = ...,
    ) -> dimod.sampleset.SampleSet: ...
    @overload
    def solve(self, objective: Union[Poly, Matrix], dry_run: Literal[True]) -> None: ...
    @overload
    def solve(self, constraint: Union[Constraint, ConstraintList], dry_run: Literal[True]) -> None: ...
    @overload
    def solve(
        self, objective: Union[Poly, Matrix], constraint: Union[Constraint, ConstraintList], dry_run: Literal[True]
    ) -> None:
        """solve

        :Overloading:

        .. admonition:: 1. solve(self, objective: Union[amplify.Poly, amplify.Matrix], dry_run: Literal[False] = False) -> dimod.sampleset.SampleSet

            Args:
                * objective (amplify.Poly | amplify.Matrix):
                * dry_run (Literal[False]): Defaults to ``False``.

            Returns:
                dimod.sampleset.SampleSet:

        .. admonition:: 2. solve(self, constraint: Union[amplify.Constraint, amplify.ConstraintList], dry_run: Literal[False] = False) -> dimod.sampleset.SampleSet

            Args:
                * constraint (amplify.Constraint | amplify.ConstraintList):
                * dry_run (Literal[False]): Defaults to ``False``.

            Returns:
                dimod.sampleset.SampleSet:

        .. admonition:: 3. solve(self, objective: Union[amplify.Poly, amplify.Matrix], constraint: Union[amplify.Constraint, amplify.ConstraintList], dry_run: Literal[False] = False) -> dimod.sampleset.SampleSet

            Args:
                * objective (amplify.Poly | amplify.Matrix):
                * constraint (amplify.Constraint | amplify.ConstraintList):
                * dry_run (Literal[False]): Defaults to ``False``.

            Returns:
                dimod.sampleset.SampleSet:

        .. admonition:: 4. solve(self, objective: Union[amplify.Poly, amplify.Matrix], dry_run: Literal[True]) -> None

            Args:
                * objective (amplify.Poly | amplify.Matrix):
                * dry_run (Literal[True]):

        .. admonition:: 5. solve(self, constraint: Union[amplify.Constraint, amplify.ConstraintList], dry_run: Literal[True]) -> None

            Args:
                * constraint (amplify.Constraint | amplify.ConstraintList):
                * dry_run (Literal[True]):

        .. admonition:: 6. solve(self, objective: Union[amplify.Poly, amplify.Matrix], constraint: Union[amplify.Constraint, amplify.ConstraintList], dry_run: Literal[True]) -> None

            Args:
                * objective (amplify.Poly | amplify.Matrix):
                * constraint (amplify.Constraint | amplify.ConstraintList):
                * dry_run (Literal[True]):
        """
    @property
    def acceptable_degrees(self) -> AcceptableDegrees:
        """acceptable_degrees property

        Returns:
            amplify.AcceptableDegrees:
        """
    @property
    def parameters(self) -> DWaveClientParameters:
        """parameters property

        Returns:
            amplify.DWaveClientParameters:
        """
    @property
    def properties(self) -> dict[str, Any]:
        """properties property

        Returns:
            dict[str, Any]:
        """
    @property
    def solver_names(self) -> list[str]:
        """solver_names property

        Returns:
            list[str]:
        """
    @property
    def version(self) -> str:
        """version property

        Returns:
            str:
        """

class LeapHybridSamplerClient:
    proxy: Optional[str]
    """proxy property

    Returns:
        str | None:
    """
    solver: str
    """solver property

    Returns:
        str:
    """
    token: str
    """token property

    Returns:
        str:
    """
    url: str
    """url property

    Returns:
        str:
    """
    @property
    def write_request_data(self) -> Optional[os.PathLike]:
        """write_request_data property

        Returns:
            os.PathLike | None:
        """
    @write_request_data.setter
    def write_request_data(self, value: Union[Optional[os.PathLike], str]) -> None: ...
    @property
    def write_response_data(self) -> Optional[os.PathLike]:
        """write_response_data property

        Returns:
            os.PathLike | None:
        """
    @write_response_data.setter
    def write_response_data(self, value: Union[Optional[os.PathLike], str]) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, token: str = ..., solver: str = ..., url: str = ..., proxy: Optional[str] = ...) -> None:
        """__init__

        Args:
            token (str): Defaults to ``''``.
            solver (str): Defaults to ``''``.
            url (str): Defaults to ``''``.
            proxy (str | None): Defaults to ``None``.
        """
    def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
        """_repr_pretty_

        Args:
            arg0 (Any):
            arg1 (bool):
        """
    @overload
    def solve(self, objective: Union[Poly, Matrix], dry_run: Literal[False] = ...) -> dimod.sampleset.SampleSet: ...
    @overload
    def solve(self, objective: Union[Poly, Matrix], dry_run: Literal[True]) -> None:
        """solve

        :Overloading:

        .. admonition:: 1. solve(self, objective: Union[amplify.Poly, amplify.Matrix], dry_run: Literal[False] = False) -> dimod.sampleset.SampleSet

            Args:
                * objective (amplify.Poly | amplify.Matrix):
                * dry_run (Literal[False]): Defaults to ``False``.

            Returns:
                dimod.sampleset.SampleSet:

        .. admonition:: 2. solve(self, objective: Union[amplify.Poly, amplify.Matrix], dry_run: Literal[True]) -> None

            Args:
                * objective (amplify.Poly | amplify.Matrix):
                * dry_run (Literal[True]):
        """
    @property
    def acceptable_degrees(self) -> AcceptableDegrees:
        """acceptable_degrees property

        Returns:
            amplify.AcceptableDegrees:
        """
    @property
    def parameters(self) -> DWaveClientParameters:
        """parameters property

        Returns:
            amplify.DWaveClientParameters:
        """
    @property
    def properties(self) -> dict[str, Any]:
        """properties property

        Returns:
            dict[str, Any]:
        """
    @property
    def solver_names(self) -> list[str]:
        """solver_names property

        Returns:
            list[str]:
        """
    @property
    def version(self) -> str:
        """version property

        Returns:
            str:
        """

class Matrix:
    __array_priority__: ClassVar[int] = ...
    constant: float
    """constant property

    Returns:
        float:
    """
    linear: numpy.ndarray[Any, numpy.dtype[numpy.float64]]
    """linear property

    Returns:
        numpy.ndarray:
    """
    quadratic: numpy.ndarray[Any, numpy.dtype[numpy.float64]]
    """quadratic property

    Returns:
        numpy.ndarray:
    """
    def __init__(self, *args, **kwargs) -> None: ...
    def _repr_latex_(self) -> str:
        """_repr_latex_

        Returns:
            str:
        """
    @overload
    def evaluate(self, values: Values) -> float: ...
    @overload
    def evaluate(self, values: Values, default: float) -> float:
        """evaluate

        :Overloading:

        .. admonition:: 1. evaluate(self, values: amplify.Values) -> float

            Args:
                * values (amplify.Values):

            Returns:
                float:

        .. admonition:: 2. evaluate(self, values: amplify.Values, default: float) -> float

            Args:
                * values (amplify.Values):
                * default (float):

            Returns:
                float:
        """
    def to_poly(self) -> Poly:
        """to_poly

        Returns:
            amplify.Poly:
        """
    def __add__(self, arg: Union[Constraint, ConstraintList]) -> Model:
        """__add__

        Args:
            arg (amplify.Constraint | amplify.ConstraintList):

        Returns:
            amplify.Model:
        """
    def __eq__(self, arg: Matrix) -> bool:
        """__eq__

        Args:
            arg (amplify.Matrix):

        Returns:
            bool:
        """
    def __ne__(self, arg: Matrix) -> bool:
        """__ne__

        Args:
            arg (amplify.Matrix):

        Returns:
            bool:
        """
    def __radd__(self, arg: Union[Constraint, ConstraintList]) -> Model:
        """__radd__

        Args:
            arg (amplify.Constraint | amplify.ConstraintList):

        Returns:
            amplify.Model:
        """
    @property
    def variable_array(self) -> PolyArray:
        """variable_array property

        Returns:
            amplify.PolyArray:
        """

class Model:
    constraints: ConstraintList
    """constraints property

    Returns:
        amplify.ConstraintList:
    """
    objective: Union[Poly, Matrix]
    """objective property

    Returns:
        amplify.Poly | amplify.Matrix:
    """
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, objective: Union[Poly, Matrix]) -> None: ...
    @overload
    def __init__(self, constraint: Union[Constraint, ConstraintList]) -> None: ...
    @overload
    def __init__(self, objective: Union[Poly, Matrix], constraint: Union[Constraint, ConstraintList]) -> None:
        """__init__

        :Overloading:

        .. admonition:: 1. __init__(self) -> None

        .. admonition:: 2. __init__(self, objective: Union[amplify.Poly, amplify.Matrix]) -> None

            Args:
                * objective (amplify.Poly | amplify.Matrix):

        .. admonition:: 3. __init__(self, constraint: Union[amplify.Constraint, amplify.ConstraintList]) -> None

            Args:
                * constraint (amplify.Constraint | amplify.ConstraintList):

        .. admonition:: 4. __init__(self, objective: Union[amplify.Poly, amplify.Matrix], constraint: Union[amplify.Constraint, amplify.ConstraintList]) -> None

            Args:
                * objective (amplify.Poly | amplify.Matrix):
                * constraint (amplify.Constraint | amplify.ConstraintList):
        """
    def _repr_latex_(self) -> str:
        """_repr_latex_

        Returns:
            str:
        """
    def copy(self) -> Model:
        """copy

        Returns:
            amplify.Model:
        """
    def get_variables(self, with_penalty: bool = ...) -> List[Variable]:
        """get_variables

        Args:
            with_penalty (bool): Defaults to ``False``.

        Returns:
            List[amplify.Variable]:
        """
    def to_intermediate_model(
        self,
        acceptable_degrees: AcceptableDegrees,
        integer_encoding_method: Union[Literal["Unary", "Linear", "Binary", "Default"], IntegerEncodingMethod] = ...,
        quadratization_method: Union[Literal["IshikawaKZFD", "Substitute"], QuadratizationMethod] = ...,
        substitution_multiplier: float = ...,
    ) -> Tuple[Model, Result.ModelConversion.IntermediateMapping]:
        """to_intermediate_model

        Args:
            acceptable_degrees (amplify.AcceptableDegrees):
            integer_encoding_method (str | amplify.IntegerEncodingMethod): Defaults to ``Default``.
            quadratization_method (str | amplify.QuadratizationMethod): Defaults to ``IshikawaKZFD``.
            substitution_multiplier (float): Defaults to ``1.0``.

        Returns:
            Tuple[amplify.Model, amplify.Result.ModelConversion.IntermediateMapping]:
        """
    def to_unconstrained_poly(self) -> Poly:
        """to_unconstrained_poly

        Returns:
            amplify.Poly:
        """
    def __add__(self, arg: Union[Poly, Constraint, ConstraintList]) -> Model:
        """__add__

        Args:
            arg (amplify.Poly | amplify.Constraint | amplify.ConstraintList):

        Returns:
            amplify.Model:
        """
    def __eq__(self, arg: Model) -> bool:
        """__eq__

        Args:
            arg (amplify.Model):

        Returns:
            bool:
        """
    def __iadd__(self, arg: Union[Poly, Constraint, ConstraintList]) -> Model:
        """__iadd__

        Args:
            arg (amplify.Poly | amplify.Constraint | amplify.ConstraintList):

        Returns:
            amplify.Model:
        """
    def __isub__(self, arg: Poly) -> Model:
        """__isub__

        Args:
            arg (amplify.Poly):

        Returns:
            amplify.Model:
        """
    def __ne__(self, arg: Model) -> bool:
        """__ne__

        Args:
            arg (amplify.Model):

        Returns:
            bool:
        """
    def __radd__(self, arg: Union[Poly, Constraint, ConstraintList]) -> Model:
        """__radd__

        Args:
            arg (amplify.Poly | amplify.Constraint | amplify.ConstraintList):

        Returns:
            amplify.Model:
        """
    def __sub__(self, arg: Poly) -> Model:
        """__sub__

        Args:
            arg (amplify.Poly):

        Returns:
            amplify.Model:
        """
    @property
    def variables(self) -> List[Variable]:
        """alias of `~amplify.Model.get_variables`

        Returns:
            List[amplify.Variable]:
        """

class NECVA2Client:
    class Parameters:
        beta_list: Optional[List[float]]
        """beta_list property

        Returns:
            List[float] | None:
        """
        beta_range: Optional[Tuple[float, float]]
        """beta_range property

        Returns:
            Tuple[float, float, int] | None:
        """
        dense: Optional[bool]
        """dense property

        Returns:
            bool | None:
        """
        num_reads: Optional[int]
        """num_reads property

        Returns:
            int | None:
        """
        num_results: Optional[int]
        """num_results property

        Returns:
            int | None:
        """
        num_sweeps: Optional[int]
        """num_sweeps property

        Returns:
            int | None:
        """
        @property
        def timeout(self) -> Optional[datetime.timedelta]:
            """timeout property

            Returns:
                datetime.timedelta | None:
            """
        @timeout.setter
        def timeout(self, value: Union[Optional[datetime.timedelta], int]) -> None: ...
        ve_num: Optional[int]
        """ve_num property

        Returns:
            int | None:
        """
        @property
        def vector_mode(self) -> Optional[NECVA2Client.VectorMode]:
            """vector_mode property

            Returns:
                amplify.NECVA2Client.VectorMode | None:
            """
        @vector_mode.setter
        def vector_mode(
            self, value: Union[Optional[NECVA2Client.VectorMode], Literal["speed", "accuracy"]]
        ) -> None: ...
        def __init__(self, *args, **kwargs) -> None: ...
        def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
            """_repr_pretty_

            Args:
                arg0 (Any):
                arg1 (bool):
            """

    class Result:
        class Result:
            def __init__(self, *args, **kwargs) -> None: ...
            def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
                """_repr_pretty_

                Args:
                    arg0 (Any):
                    arg1 (bool):
                """
            @property
            def constraint(self) -> bool:
                """constraint property

                Returns:
                    bool:
                """
            @property
            def energy(self) -> float:
                """energy property

                Returns:
                    float:
                """
            @property
            def memory_usage(self) -> float:
                """memory_usage property

                Returns:
                    float:
                """
            @property
            def spin(self) -> Dict[str, int]:
                """spin property

                Returns:
                    Dict[str, int]:
                """
            @property
            def time(self) -> datetime.timedelta:
                """time property

                Returns:
                    datetime.timedelta:
                """

        class Timing:
            def __init__(self, *args, **kwargs) -> None: ...
            def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
                """_repr_pretty_

                Args:
                    arg0 (Any):
                    arg1 (bool):
                """
            @property
            def execution_time(self) -> datetime.timedelta:
                """execution_time property

                Returns:
                    datetime.timedelta:
                """
            @property
            def queue_time(self) -> datetime.timedelta:
                """queue_time property

                Returns:
                    datetime.timedelta:
                """
            @property
            def solve_qubo_time(self) -> datetime.timedelta:
                """solve_qubo_time property

                Returns:
                    datetime.timedelta:
                """

        def __init__(self, *args, **kwargs) -> None: ...
        def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
            """_repr_pretty_

            Args:
                arg0 (Any):
                arg1 (bool):
            """
        @property
        def result(self) -> List[NECVA2Client.Result.Result]:
            """result property

            Returns:
                List[amplify.NECVA2Client.Result.Result]:
            """
        @property
        def timing(self) -> NECVA2Client.Result.Timing:
            """timing property

            Returns:
                amplify.NECVA2Client.Result.Timing:
            """

    class VectorMode:
        Accuracy: ClassVar[NECVA2Client.VectorMode] = ...
        Speed: ClassVar[NECVA2Client.VectorMode] = ...
        __name__: Any
        def __init__(self, *args, **kwargs) -> None: ...
        def __eq__(self, other) -> bool: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        def __ne__(self, other) -> bool: ...

    proxy: Optional[str]
    """proxy property

    Returns:
        str | None:
    """
    set_andzero: bool
    """set_andzero property

    Returns:
        bool:
    """
    set_fixed: bool
    """set_fixed property

    Returns:
        bool:
    """
    set_maxone: bool
    """set_maxone property

    Returns:
        bool:
    """
    set_minmaxone: bool
    """set_minmaxone property

    Returns:
        bool:
    """
    set_onehot: bool
    """set_onehot property

    Returns:
        bool:
    """
    set_orone: bool
    """set_orone property

    Returns:
        bool:
    """
    set_supplement: bool
    """set_supplement property

    Returns:
        bool:
    """
    token: str
    """token property

    Returns:
        str:
    """
    url: str
    """url property

    Returns:
        str:
    """
    @property
    def write_request_data(self) -> Optional[os.PathLike]:
        """write_request_data property

        Returns:
            os.PathLike | None:
        """
    @write_request_data.setter
    def write_request_data(self, value: Union[Optional[os.PathLike], str]) -> None: ...
    @property
    def write_response_data(self) -> Optional[os.PathLike]:
        """write_response_data property

        Returns:
            os.PathLike | None:
        """
    @write_response_data.setter
    def write_response_data(self, value: Union[Optional[os.PathLike], str]) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, token: str = ..., url: str = ..., proxy: Optional[str] = ...) -> None:
        """__init__

        Args:
            token (str): Defaults to ``''``.
            url (str): Defaults to ``''``.
            proxy (str | None): Defaults to ``None``.
        """
    def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
        """_repr_pretty_

        Args:
            arg0 (Any):
            arg1 (bool):
        """
    @overload
    def solve(self, objective: Union[Poly, Matrix], dry_run: Literal[False] = ...) -> NECVA2Client.Result: ...
    @overload
    def solve(
        self, constraint: Union[Constraint, ConstraintList], dry_run: Literal[False] = ...
    ) -> NECVA2Client.Result: ...
    @overload
    def solve(
        self,
        objective: Union[Poly, Matrix],
        constraint: Union[Constraint, ConstraintList],
        dry_run: Literal[False] = ...,
    ) -> NECVA2Client.Result: ...
    @overload
    def solve(self, objective: Union[Poly, Matrix], dry_run: Literal[True]) -> None: ...
    @overload
    def solve(self, constraint: Union[Constraint, ConstraintList], dry_run: Literal[True]) -> None: ...
    @overload
    def solve(
        self, objective: Union[Poly, Matrix], constraint: Union[Constraint, ConstraintList], dry_run: Literal[True]
    ) -> None:
        """solve

        :Overloading:

        .. admonition:: 1. solve(self, objective: Union[amplify.Poly, amplify.Matrix], dry_run: Literal[False] = False) -> amplify.NECVA2Client.Result

            Args:
                * objective (amplify.Poly | amplify.Matrix):
                * dry_run (Literal[False]): Defaults to ``False``.

            Returns:
                amplify.NECVA2Client.Result:

        .. admonition:: 2. solve(self, constraint: Union[amplify.Constraint, amplify.ConstraintList], dry_run: Literal[False] = False) -> amplify.NECVA2Client.Result

            Args:
                * constraint (amplify.Constraint | amplify.ConstraintList):
                * dry_run (Literal[False]): Defaults to ``False``.

            Returns:
                amplify.NECVA2Client.Result:

        .. admonition:: 3. solve(self, objective: Union[amplify.Poly, amplify.Matrix], constraint: Union[amplify.Constraint, amplify.ConstraintList], dry_run: Literal[False] = False) -> amplify.NECVA2Client.Result

            Args:
                * objective (amplify.Poly | amplify.Matrix):
                * constraint (amplify.Constraint | amplify.ConstraintList):
                * dry_run (Literal[False]): Defaults to ``False``.

            Returns:
                amplify.NECVA2Client.Result:

        .. admonition:: 4. solve(self, objective: Union[amplify.Poly, amplify.Matrix], dry_run: Literal[True]) -> None

            Args:
                * objective (amplify.Poly | amplify.Matrix):
                * dry_run (Literal[True]):

        .. admonition:: 5. solve(self, constraint: Union[amplify.Constraint, amplify.ConstraintList], dry_run: Literal[True]) -> None

            Args:
                * constraint (amplify.Constraint | amplify.ConstraintList):
                * dry_run (Literal[True]):

        .. admonition:: 6. solve(self, objective: Union[amplify.Poly, amplify.Matrix], constraint: Union[amplify.Constraint, amplify.ConstraintList], dry_run: Literal[True]) -> None

            Args:
                * objective (amplify.Poly | amplify.Matrix):
                * constraint (amplify.Constraint | amplify.ConstraintList):
                * dry_run (Literal[True]):
        """
    @property
    def acceptable_degrees(self) -> AcceptableDegrees:
        """acceptable_degrees property

        Returns:
            amplify.AcceptableDegrees:
        """
    @property
    def parameters(self) -> NECVA2Client.Parameters:
        """parameters property

        Returns:
            amplify.NECVA2Client.Parameters:
        """
    @property
    def version(self) -> str:
        """version property

        Returns:
            str:
        """

class PenaltyFormulation:
    Default: ClassVar[PenaltyFormulation] = ...
    IntegerVariable: ClassVar[PenaltyFormulation] = ...
    LinearRelaxation: ClassVar[PenaltyFormulation] = ...
    QuadraticRelaxation: ClassVar[PenaltyFormulation] = ...
    RealVariable: ClassVar[PenaltyFormulation] = ...
    Relaxation: ClassVar[PenaltyFormulation] = ...
    __name__: Any
    def __init__(self, *args, **kwargs) -> None: ...
    def __eq__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...

class Poly:
    class Iterator:
        def __init__(self, *args, **kwargs) -> None: ...
        def __iter__(self) -> Poly.Iterator:
            """__iter__

            Returns:
                amplify.Poly.Iterator:
            """
        def __next__(self) -> Any:
            """__next__

            Returns:
                tuple[tuple[amplify.Poly, ...], float]:
            """

    __array_priority__: ClassVar[int] = ...
    lower_bound: Optional[float]
    """lower_bound property

    Returns:
        float | None:
    """
    name: str
    """name property

    Returns:
        str:
    """
    upper_bound: Optional[float]
    """upper_bound property

    Returns:
        float | None:
    """
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg: float) -> None:
        """__init__

        Args:
            arg (float):
        """
    def _repr_latex_(self) -> str:
        """_repr_latex_

        Returns:
            str:
        """
    def as_dict(self) -> dict[tuple[int, ...], float]:
        """as_dict

        Returns:
            dict[tuple[int, ...], float]:
        """
    def as_variable(self) -> Variable:
        """as_variable

        Returns:
            amplify.Variable:
        """
    def asdict(self) -> dict[tuple[int, ...], float]:
        """alias of :meth:`~amplify.Poly.as_dict`

        Returns:
            dict[tuple[int, ...], float]:
        """
    @overload
    def decode(self, values: Values) -> float: ...
    @overload
    def decode(self, values: Values, default: float) -> float: ...
    @overload
    def decode(self, values: Values, default: None) -> Poly:
        """decode

        :Overloading:

        .. admonition:: 1. decode(self, values: amplify.Values) -> float

            Args:
                * values (amplify.Values):

            Returns:
                float:

        .. admonition:: 2. decode(self, values: amplify.Values, default: float) -> float

            Args:
                * values (amplify.Values):
                * default (float):

            Returns:
                float:

        .. admonition:: 3. decode(self, values: amplify.Values, default: None) -> amplify.Poly

            Args:
                * values (amplify.Values):
                * default (None):

            Returns:
                amplify.Poly:
        """
    def degree(self) -> int:
        """degree

        Returns:
            int:
        """
    @overload
    def evaluate(self, values: Values) -> float: ...
    @overload
    def evaluate(self, values: Values, default: float) -> float: ...
    @overload
    def evaluate(self, values: Values, default: None) -> Poly:
        """evaluate

        :Overloading:

        .. admonition:: 1. evaluate(self, values: amplify.Values) -> float

            Args:
                * values (amplify.Values):

            Returns:
                float:

        .. admonition:: 2. evaluate(self, values: amplify.Values, default: float) -> float

            Args:
                * values (amplify.Values):
                * default (float):

            Returns:
                float:

        .. admonition:: 3. evaluate(self, values: amplify.Values, default: None) -> amplify.Poly

            Args:
                * values (amplify.Values):
                * default (None):

            Returns:
                amplify.Poly:
        """
    def is_linear(self) -> bool:
        """is_linear

        Returns:
            bool:
        """
    def is_number(self) -> bool:
        """is_number

        Returns:
            bool:
        """
    def is_quadratic(self) -> bool:
        """is_quadratic

        Returns:
            bool:
        """
    def is_variable(self) -> bool:
        """is_variable

        Returns:
            bool:
        """
    def substitute(self, mapping: dict[Poly, Union[Poly, float]]) -> Poly:
        """substitute

        Args:
            mapping (dict[amplify.Poly, Union[amplify.Poly, float, int]]):

        Returns:
            amplify.Poly:
        """
    @overload
    def __add__(self, arg: Union[Poly, float]) -> Poly: ...
    @overload
    def __add__(self, arg: numpy.ndarray) -> PolyArray: ...
    @overload
    def __add__(self, arg: Union[Constraint, ConstraintList]) -> Model:
        """__add__

        :Overloading:

        .. admonition:: 1. __add__(self, arg: Union[amplify.Poly, float], /) -> amplify.Poly

            Args:
                * arg (amplify.Poly | float):

            Returns:
                amplify.Poly:

        .. admonition:: 2. __add__(self, arg: numpy.ndarray, /) -> amplify.PolyArray

            Args:
                * arg (numpy.ndarray):

            Returns:
                amplify.PolyArray:

        .. admonition:: 3. __add__(self, arg: Union[amplify.Constraint, amplify.ConstraintList], /) -> amplify.Model

            Args:
                * arg (amplify.Constraint | amplify.ConstraintList):

            Returns:
                amplify.Model:
        """
    @overload
    def __and__(self, arg: Union[Poly, bool]) -> Poly: ...
    @overload
    def __and__(self, arg: numpy.ndarray[Any, numpy.dtype[numpy.bool_]]) -> PolyArray:
        """__and__

        :Overloading:

        .. admonition:: 1. __and__(self, arg: Union[amplify.Poly, bool], /) -> amplify.Poly

            Args:
                * arg (amplify.Poly | bool):

            Returns:
                amplify.Poly:

        .. admonition:: 2. __and__(self, arg: numpy.ndarray[Any, numpy.dtype[numpy.bool_]], /) -> amplify.PolyArray

            Args:
                * arg (numpy.ndarray):

            Returns:
                amplify.PolyArray:
        """
    def __bool__(self) -> bool:
        """__bool__

        Returns:
            bool:
        """
    def __eq__(self, arg: Union[Poly, float]) -> bool:
        """__eq__

        Args:
            arg (amplify.Poly | float):

        Returns:
            bool:
        """
    def __float__(self) -> float:
        """__float__

        Returns:
            float:
        """
    def __iadd__(self, arg: Union[Poly, float]) -> Poly:
        """__iadd__

        Args:
            arg (amplify.Poly | float):

        Returns:
            amplify.Poly:
        """
    def __iand__(self, arg: Union[Poly, bool]) -> Poly:
        """__iand__

        Args:
            arg (amplify.Poly | bool):

        Returns:
            amplify.Poly:
        """
    def __imul__(self, arg: Union[Poly, float]) -> Poly:
        """__imul__

        Args:
            arg (amplify.Poly | float):

        Returns:
            amplify.Poly:
        """
    def __index__(self) -> int:
        """__index__

        Returns:
            int:
        """
    def __int__(self) -> int:
        """__int__

        Returns:
            int:
        """
    def __invert__(self) -> Poly:
        """__invert__

        Returns:
            amplify.Poly:
        """
    def __ior__(self, arg: Union[Poly, bool]) -> Poly:
        """__ior__

        Args:
            arg (amplify.Poly | bool):

        Returns:
            amplify.Poly:
        """
    def __ipow__(self, arg: int) -> Poly:
        """__ipow__

        Args:
            arg (int):

        Returns:
            amplify.Poly:
        """
    def __isub__(self, arg: Union[Poly, float]) -> Poly:
        """__isub__

        Args:
            arg (amplify.Poly | float):

        Returns:
            amplify.Poly:
        """
    def __iter__(self) -> Poly.Iterator:
        """__iter__

        Returns:
            amplify.Poly.Iterator:
        """
    def __itruediv__(self, arg: float) -> Poly:
        """__itruediv__

        Args:
            arg (float):

        Returns:
            amplify.Poly:
        """
    def __ixor__(self, arg: Union[Poly, bool]) -> Poly:
        """__ixor__

        Args:
            arg (amplify.Poly | bool):

        Returns:
            amplify.Poly:
        """
    def __len__(self) -> int:
        """__len__

        Returns:
            int:
        """
    @overload
    def __mul__(self, arg: Union[Poly, float]) -> Poly: ...
    @overload
    def __mul__(self, arg: numpy.ndarray) -> PolyArray:
        """__mul__

        :Overloading:

        .. admonition:: 1. __mul__(self, arg: Union[amplify.Poly, float], /) -> amplify.Poly

            Args:
                * arg (amplify.Poly | float):

            Returns:
                amplify.Poly:

        .. admonition:: 2. __mul__(self, arg: numpy.ndarray, /) -> amplify.PolyArray

            Args:
                * arg (numpy.ndarray):

            Returns:
                amplify.PolyArray:
        """
    def __ne__(self, arg: Union[Poly, float]) -> bool:
        """__ne__

        Args:
            arg (amplify.Poly | float):

        Returns:
            bool:
        """
    def __neg__(self) -> Poly:
        """__neg__

        Returns:
            amplify.Poly:
        """
    @overload
    def __or__(self, arg: Union[Poly, bool]) -> Poly: ...
    @overload
    def __or__(self, arg: numpy.ndarray[Any, numpy.dtype[numpy.bool_]]) -> PolyArray:
        """__or__

        :Overloading:

        .. admonition:: 1. __or__(self, arg: Union[amplify.Poly, bool], /) -> amplify.Poly

            Args:
                * arg (amplify.Poly | bool):

            Returns:
                amplify.Poly:

        .. admonition:: 2. __or__(self, arg: numpy.ndarray[Any, numpy.dtype[numpy.bool_]], /) -> amplify.PolyArray

            Args:
                * arg (numpy.ndarray):

            Returns:
                amplify.PolyArray:
        """
    def __pos__(self) -> Poly:
        """__pos__

        Returns:
            amplify.Poly:
        """
    def __pow__(self, arg: int) -> Poly:
        """__pow__

        Args:
            arg (int):

        Returns:
            amplify.Poly:
        """
    @overload
    def __radd__(self, arg: float) -> Poly: ...
    @overload
    def __radd__(self, arg: numpy.ndarray) -> PolyArray: ...
    @overload
    def __radd__(self, arg: Union[Constraint, ConstraintList]) -> Model:
        """__radd__

        :Overloading:

        .. admonition:: 1. __radd__(self, arg: float, /) -> amplify.Poly

            Args:
                * arg (float):

            Returns:
                amplify.Poly:

        .. admonition:: 2. __radd__(self, arg: numpy.ndarray, /) -> amplify.PolyArray

            Args:
                * arg (numpy.ndarray):

            Returns:
                amplify.PolyArray:

        .. admonition:: 3. __radd__(self, arg: Union[amplify.Constraint, amplify.ConstraintList], /) -> amplify.Model

            Args:
                * arg (amplify.Constraint | amplify.ConstraintList):

            Returns:
                amplify.Model:
        """
    @overload
    def __rand__(self, arg: bool) -> Poly: ...
    @overload
    def __rand__(self, arg: numpy.ndarray[Any, numpy.dtype[numpy.bool_]]) -> PolyArray:
        """__rand__

        :Overloading:

        .. admonition:: 1. __rand__(self, arg: bool, /) -> amplify.Poly

            Args:
                * arg (bool):

            Returns:
                amplify.Poly:

        .. admonition:: 2. __rand__(self, arg: numpy.ndarray[Any, numpy.dtype[numpy.bool_]], /) -> amplify.PolyArray

            Args:
                * arg (numpy.ndarray):

            Returns:
                amplify.PolyArray:
        """
    @overload
    def __rmul__(self, arg: float) -> Poly: ...
    @overload
    def __rmul__(self, arg: numpy.ndarray) -> PolyArray:
        """__rmul__

        :Overloading:

        .. admonition:: 1. __rmul__(self, arg: float, /) -> amplify.Poly

            Args:
                * arg (float):

            Returns:
                amplify.Poly:

        .. admonition:: 2. __rmul__(self, arg: numpy.ndarray, /) -> amplify.PolyArray

            Args:
                * arg (numpy.ndarray):

            Returns:
                amplify.PolyArray:
        """
    @overload
    def __ror__(self, arg: bool) -> Poly: ...
    @overload
    def __ror__(self, arg: numpy.ndarray[Any, numpy.dtype[numpy.bool_]]) -> PolyArray:
        """__ror__

        :Overloading:

        .. admonition:: 1. __ror__(self, arg: bool, /) -> amplify.Poly

            Args:
                * arg (bool):

            Returns:
                amplify.Poly:

        .. admonition:: 2. __ror__(self, arg: numpy.ndarray[Any, numpy.dtype[numpy.bool_]], /) -> amplify.PolyArray

            Args:
                * arg (numpy.ndarray):

            Returns:
                amplify.PolyArray:
        """
    @overload
    def __rsub__(self, arg: float) -> Poly: ...
    @overload
    def __rsub__(self, arg: numpy.ndarray) -> PolyArray:
        """__rsub__

        :Overloading:

        .. admonition:: 1. __rsub__(self, arg: float, /) -> amplify.Poly

            Args:
                * arg (float):

            Returns:
                amplify.Poly:

        .. admonition:: 2. __rsub__(self, arg: numpy.ndarray, /) -> amplify.PolyArray

            Args:
                * arg (numpy.ndarray):

            Returns:
                amplify.PolyArray:
        """
    @overload
    def __rxor__(self, arg: bool) -> Poly: ...
    @overload
    def __rxor__(self, arg: numpy.ndarray[Any, numpy.dtype[numpy.bool_]]) -> PolyArray:
        """__rxor__

        :Overloading:

        .. admonition:: 1. __rxor__(self, arg: bool, /) -> amplify.Poly

            Args:
                * arg (bool):

            Returns:
                amplify.Poly:

        .. admonition:: 2. __rxor__(self, arg: numpy.ndarray[Any, numpy.dtype[numpy.bool_]], /) -> amplify.PolyArray

            Args:
                * arg (numpy.ndarray):

            Returns:
                amplify.PolyArray:
        """
    @overload
    def __sub__(self, arg: Union[Poly, float]) -> Poly: ...
    @overload
    def __sub__(self, arg: numpy.ndarray) -> PolyArray:
        """__sub__

        :Overloading:

        .. admonition:: 1. __sub__(self, arg: Union[amplify.Poly, float], /) -> amplify.Poly

            Args:
                * arg (amplify.Poly | float):

            Returns:
                amplify.Poly:

        .. admonition:: 2. __sub__(self, arg: numpy.ndarray, /) -> amplify.PolyArray

            Args:
                * arg (numpy.ndarray):

            Returns:
                amplify.PolyArray:
        """
    @overload
    def __truediv__(self, arg: float) -> Poly: ...
    @overload
    def __truediv__(self, arg: numpy.ndarray) -> PolyArray:
        """__truediv__

        :Overloading:

        .. admonition:: 1. __truediv__(self, arg: float, /) -> amplify.Poly

            Args:
                * arg (float):

            Returns:
                amplify.Poly:

        .. admonition:: 2. __truediv__(self, arg: numpy.ndarray, /) -> amplify.PolyArray

            Args:
                * arg (numpy.ndarray):

            Returns:
                amplify.PolyArray:
        """
    @overload
    def __xor__(self, arg: Union[Poly, bool]) -> Poly: ...
    @overload
    def __xor__(self, arg: numpy.ndarray[Any, numpy.dtype[numpy.bool_]]) -> PolyArray:
        """__xor__

        :Overloading:

        .. admonition:: 1. __xor__(self, arg: Union[amplify.Poly, bool], /) -> amplify.Poly

            Args:
                * arg (amplify.Poly | bool):

            Returns:
                amplify.Poly:

        .. admonition:: 2. __xor__(self, arg: numpy.ndarray[Any, numpy.dtype[numpy.bool_]], /) -> amplify.PolyArray

            Args:
                * arg (numpy.ndarray):

            Returns:
                amplify.PolyArray:
        """
    @property
    def id(self) -> int:
        """id property

        Returns:
            int:
        """
    @property
    def type(self) -> VariableType:
        """type property

        Returns:
            amplify.VariableType:
        """
    @property
    def variables(self) -> List[Variable]:
        """variables property

        Returns:
            List[amplify.Variable]:
        """

class PolyArray(Generic[_NDim]):
    class Iterator:
        def __init__(self, *args, **kwargs) -> None: ...
        def __iter__(self) -> PolyArray.Iterator:
            """__iter__

            Returns:
                amplify.PolyArray.Iterator:
            """
        def __next__(self) -> Union[PolyArray, Poly]:
            """__next__

            Returns:
                amplify.PolyArray | amplify.Poly:
            """

    __array_priority__: ClassVar[int] = ...
    shape: tuple[int, ...]
    """shape property

    Returns:
        tuple[int, ...]:
    """
    def __init__(self, object: Union[numpy.ndarray, list, Poly]) -> None:
        """__init__

        Args:
            object (numpy.ndarray | list | amplify.Poly):
        """
    def _repr_latex_(self) -> str:
        """_repr_latex_

        Returns:
            str:
        """
    def copy(self) -> PolyArray:
        """copy

        Returns:
            amplify.PolyArray:
        """
    @overload
    def decode(self, values: Values) -> numpy.ndarray[Any, numpy.dtype[numpy.float64]]: ...
    @overload
    def decode(self, values: Values, default: float) -> numpy.ndarray[Any, numpy.dtype[numpy.float64]]: ...
    @overload
    def decode(self, values: Values, default: None) -> PolyArray:
        """decode

        :Overloading:

        .. admonition:: 1. decode(self, values: amplify.Values) -> numpy.ndarray[Any, numpy.dtype[numpy.float64]]

            Args:
                * values (amplify.Values):

            Returns:
                numpy.ndarray:

        .. admonition:: 2. decode(self, values: amplify.Values, default: float) -> numpy.ndarray[Any, numpy.dtype[numpy.float64]]

            Args:
                * values (amplify.Values):
                * default (float):

            Returns:
                numpy.ndarray:

        .. admonition:: 3. decode(self, values: amplify.Values, default: None) -> amplify.PolyArray

            Args:
                * values (amplify.Values):
                * default (None):

            Returns:
                amplify.PolyArray:
        """
    def diagonal(self, offset: int = ..., axis1: int = ..., axis2: int = ...) -> PolyArray:
        """diagonal

        Args:
            offset (int): Defaults to ``0``.
            axis1 (int): Defaults to ``0``.
            axis2 (int): Defaults to ``1``.

        Returns:
            amplify.PolyArray:
        """
    @overload
    def evaluate(self, values: Values) -> numpy.ndarray[Any, numpy.dtype[numpy.float64]]: ...
    @overload
    def evaluate(self, values: Values, default: float) -> numpy.ndarray[Any, numpy.dtype[numpy.float64]]: ...
    @overload
    def evaluate(self, values: Values, default: None) -> PolyArray:
        """evaluate

        :Overloading:

        .. admonition:: 1. evaluate(self, values: amplify.Values) -> numpy.ndarray[Any, numpy.dtype[numpy.float64]]

            Args:
                * values (amplify.Values):

            Returns:
                numpy.ndarray:

        .. admonition:: 2. evaluate(self, values: amplify.Values, default: float) -> numpy.ndarray[Any, numpy.dtype[numpy.float64]]

            Args:
                * values (amplify.Values):
                * default (float):

            Returns:
                numpy.ndarray:

        .. admonition:: 3. evaluate(self, values: amplify.Values, default: None) -> amplify.PolyArray

            Args:
                * values (amplify.Values):
                * default (None):

            Returns:
                amplify.PolyArray:
        """
    def fill(self, value: Union[Poly, float]) -> None:
        """fill

        Args:
            value (amplify.Poly | float | int):
        """
    def flatten(self) -> PolyArray:
        """flatten

        Returns:
            amplify.PolyArray:
        """
    def nonzero(self) -> tuple[numpy.ndarray[Any, numpy.dtype[numpy.uint64]], ...]:
        """nonzero

        Returns:
            tuple[numpy.ndarray[Any, numpy.dtype[numpy.uint64]], ...]:
        """
    def ravel(self) -> PolyArray:
        """ravel

        Returns:
            amplify.PolyArray:
        """
    def repeat(self, repeats: Union[int, list[int]], axis: Optional[int] = ...) -> PolyArray:
        """repeat

        Args:
            repeats (int | list[int]):
            axis (int | None): Defaults to ``None``.

        Returns:
            amplify.PolyArray:
        """
    @overload
    def reshape(self, shape: Union[int, tuple[int, ...]]) -> PolyArray: ...
    @overload
    def reshape(self, *shape: int) -> PolyArray:
        """reshape

        :Overloading:

        .. admonition:: 1. reshape(self, shape: Union[int, tuple[int, ...]]) -> amplify.PolyArray

            Args:
                * shape (int | tuple[int, ...]):

            Returns:
                amplify.PolyArray:

        .. admonition:: 2. reshape(self, \\*shape: int) -> amplify.PolyArray

            Args:
                * \\*shape (int):

            Returns:
                amplify.PolyArray:
        """
    def roll(self, shift: int, axis: Optional[int] = ...) -> PolyArray:
        """roll

        Args:
            shift (int):
            axis (int | None): Defaults to ``None``.

        Returns:
            amplify.PolyArray:
        """
    def substitute(self, mapping: dict[Poly, Union[Poly, float]]) -> PolyArray:
        """substitute

        Args:
            mapping (dict[amplify.Poly, Union[amplify.Poly, float, int]]):

        Returns:
            amplify.PolyArray:
        """
    @overload
    def sum(self, axis: Literal[None] = ...) -> Poly: ...
    @overload
    def sum(self: PolyArray[_Dim0]) -> Poly: ...
    @overload
    def sum(self: PolyArray[_Dim1], axis: Optional[Union[int, tuple[int]]]) -> Poly: ...
    @overload
    def sum(self: PolyArray[_Dim2], axis: Optional[tuple[int, int]]) -> Poly: ...
    @overload
    def sum(self: PolyArray[_Dim2], axis: Union[int, tuple[int]]) -> PolyArray[_Dim1]: ...
    @overload
    def sum(self: PolyArray[_Dim3], axis: Optional[tuple[int, int, int]]) -> Poly: ...
    @overload
    def sum(self: PolyArray[_Dim3], axis: tuple[int, int]) -> PolyArray[_Dim1]: ...
    @overload
    def sum(self: PolyArray[_Dim3], axis: Union[int, tuple[int]]) -> PolyArray[_Dim2]: ...
    @overload
    def sum(self: PolyArray[_Dim4], axis: Optional[tuple[int, int, int, int]]) -> Poly: ...
    @overload
    def sum(self: PolyArray[_Dim4], axis: tuple[int, int, int]) -> PolyArray[_Dim1]: ...
    @overload
    def sum(self: PolyArray[_Dim4], axis: tuple[int, int]) -> PolyArray[_Dim2]: ...
    @overload
    def sum(self: PolyArray[_Dim4], axis: Union[int, tuple[int]]) -> PolyArray[_Dim3]: ...
    @overload
    def sum(self: PolyArray[_NDim], axis: tuple[()]) -> PolyArray[_NDim]: ...
    @overload
    def sum(self, axis: Optional[Union[int, tuple[int, ...]]]) -> Union[Poly, PolyArray]:
        """sum

        :Overloading:

        .. admonition:: 1. sum(self, axis: Literal[None] = None) -> amplify.Poly

            Args:
                * axis (Literal[None] | None): Defaults to ``None``.

            Returns:
                amplify.Poly:

        .. admonition:: 2. sum(self, axis: Optional[Union[int, tuple[int, ...]]]) -> Union[amplify.Poly, amplify.PolyArray]

            Args:
                * axis (int | tuple[int, ...] | None):

            Returns:
                amplify.Poly | amplify.PolyArray:
        """
    def swapaxes(self, axis1: int, axis2: int) -> PolyArray:
        """swapaxes

        Args:
            axis1 (int):
            axis2 (int):

        Returns:
            amplify.PolyArray:
        """
    def take(self, indices: Union[int, list[int]], axis: Optional[int] = ...) -> Union[PolyArray, Poly]:
        """take

        Args:
            indices (int | list[int]):
            axis (int | None): Defaults to ``None``.

        Returns:
            amplify.PolyArray | amplify.Poly:
        """
    def to_list(self) -> Union[Poly, list[Poly]]:
        """to_list

        Returns:
            amplify.Poly | list[amplify.Poly]:
        """
    def to_numpy(self) -> numpy.ndarray[Any, numpy.dtype[numpy.float64]]:
        """to_numpy

        Returns:
            numpy.ndarray:
        """
    def tolist(self) -> Union[Poly, list[Poly]]:
        """alias of :meth:`~amplify.PolyArray.to_list`

        Returns:
            amplify.Poly | list[amplify.Poly]:
        """
    def tonumpy(self) -> numpy.ndarray[Any, numpy.dtype[numpy.float64]]:
        """alias of :meth:`~amplify.PolyArray.to_numpy`

        Returns:
            numpy.ndarray:
        """
    @overload
    def transpose(self, axes: Optional[tuple[int, ...]] = ...) -> PolyArray: ...
    @overload
    def transpose(self, *axes: int) -> PolyArray:
        """transpose

        :Overloading:

        .. admonition:: 1. transpose(self, axes: Optional[tuple[int, ...]] = None) -> amplify.PolyArray

            Args:
                * axes (tuple[int, ...] | None): Defaults to ``None``.

            Returns:
                amplify.PolyArray:

        .. admonition:: 2. transpose(self, \\*axes: int) -> amplify.PolyArray

            Args:
                * \\*axes (int):

            Returns:
                amplify.PolyArray:
        """
    def view(self) -> PolyArray:
        """view

        Returns:
            amplify.PolyArray:
        """
    def __add__(self, arg: Union[PolyArray, Poly, float, list, numpy.ndarray]) -> PolyArray:
        """__add__

        Args:
            arg (amplify.PolyArray | amplify.Poly | float | int | list | numpy.ndarray):

        Returns:
            amplify.PolyArray:
        """
    def __and__(
        self, arg: Union[PolyArray, Poly, bool, list, numpy.ndarray[Any, numpy.dtype[numpy.bool_]]]
    ) -> PolyArray:
        """__and__

        Args:
            arg (amplify.PolyArray | amplify.Poly | bool | list | numpy.ndarray):

        Returns:
            amplify.PolyArray:
        """
    def __bool__(self) -> bool:
        """__bool__

        Returns:
            bool:
        """
    def __copy__(self) -> PolyArray:
        """__copy__

        Returns:
            amplify.PolyArray:
        """
    def __deepcopy__(self, arg: dict) -> PolyArray:
        """__deepcopy__

        Args:
            arg (dict):

        Returns:
            amplify.PolyArray:
        """
    def __eq__(
        self, arg: Union[PolyArray, Poly, float, list, numpy.ndarray]
    ) -> numpy.ndarray[Any, numpy.dtype[numpy.bool_]]:
        """__eq__

        Args:
            arg (amplify.PolyArray | amplify.Poly | float | int | list | numpy.ndarray):

        Returns:
            numpy.ndarray:
        """
    def __float__(self) -> float:
        """__float__

        Returns:
            float:
        """
    @overload
    def __getitem__(self: PolyArray[_Dim1], arg: Union[int, tuple[int]]) -> Poly: ...
    @overload
    def __getitem__(self: PolyArray[_Dim1], arg: Union[slice, tuple[slice]]) -> PolyArray[_Dim1]: ...
    @overload
    def __getitem__(self: PolyArray[_Dim2], arg: tuple[int, int]) -> Poly: ...
    @overload
    def __getitem__(
        self: PolyArray[_Dim2], arg: Union[int, tuple[int], tuple[slice, int], tuple[int, slice]]
    ) -> PolyArray[_Dim1]: ...
    @overload
    def __getitem__(
        self: PolyArray[_Dim2], arg: Union[slice, tuple[slice], tuple[slice, slice]]
    ) -> PolyArray[_Dim2]: ...
    @overload
    def __getitem__(self: PolyArray[_Dim3], arg: tuple[int, int, int]) -> Poly: ...
    @overload
    def __getitem__(
        self: PolyArray[_Dim3],
        arg: Union[tuple[int, int], tuple[int, int, slice], tuple[int, slice, int], tuple[slice, int, int]],
    ) -> PolyArray[_Dim1]: ...
    @overload
    def __getitem__(
        self: PolyArray[_Dim3],
        arg: Union[
            int,
            tuple[int],
            tuple[slice, int],
            tuple[int, slice],
            tuple[slice, slice, int],
            tuple[slice, int, slice],
            tuple[int, slice, slice],
        ],
    ) -> PolyArray[_Dim2]: ...
    @overload
    def __getitem__(
        self: PolyArray[_Dim3], arg: Union[slice, tuple[slice], tuple[slice, slice], tuple[slice, slice, slice]]
    ) -> PolyArray[_Dim3]: ...
    @overload
    def __getitem__(self: PolyArray[_Dim4], arg: tuple[int, int, int, int]) -> Poly: ...
    @overload
    def __getitem__(
        self: PolyArray[_Dim4],
        arg: Union[
            tuple[int, int, int],
            tuple[int, int, int, slice],
            tuple[int, int, slice, int],
            tuple[int, slice, int, int],
            tuple[slice, int, int, int],
        ],
    ) -> PolyArray[_Dim1]: ...
    @overload
    def __getitem__(
        self: PolyArray[_Dim4],
        arg: Union[
            tuple[int, int],
            tuple[int, int, slice],
            tuple[int, slice, int],
            tuple[slice, int, int],
            tuple[int, int, slice, slice],
            tuple[int, slice, int, slice],
            tuple[slice, int, int, slice],
            tuple[slice, int, slice, int],
            tuple[slice, slice, int, int],
        ],
    ) -> PolyArray[_Dim2]: ...
    @overload
    def __getitem__(
        self: PolyArray[_Dim4],
        arg: Union[
            int,
            tuple[int],
            tuple[int, slice],
            tuple[slice, int],
            tuple[int, slice, slice],
            tuple[slice, slice, int],
            tuple[slice, int, slice],
            tuple[int, slice, slice, slice],
            tuple[slice, int, slice, slice],
            tuple[slice, slice, int, slice],
            tuple[slice, slice, slice, int],
        ],
    ) -> PolyArray[_Dim3]: ...
    @overload
    def __getitem__(
        self: PolyArray[_Dim4],
        arg: Union[
            slice, tuple[slice], tuple[slice, slice], tuple[slice, slice, slice], tuple[slice, slice, slice, slice]
        ],
    ) -> PolyArray[_Dim4]: ...
    @overload
    def __getitem__(self, arg: Optional[Union[tuple, slice, EllipsisType, int]]) -> Union[PolyArray, Poly]:
        """__getitem__

        Args:
            arg (tuple | slice | EllipsisType | int | None):

        Returns:
            amplify.PolyArray | amplify.Poly:
        """
    def __iadd__(self, arg: Union[PolyArray, Poly, float, list, numpy.ndarray]) -> PolyArray:
        """__iadd__

        Args:
            arg (amplify.PolyArray | amplify.Poly | float | int | list | numpy.ndarray):

        Returns:
            amplify.PolyArray:
        """
    def __iand__(
        self, arg: Union[PolyArray, Poly, bool, list, numpy.ndarray[Any, numpy.dtype[numpy.bool_]]]
    ) -> PolyArray:
        """__iand__

        Args:
            arg (amplify.PolyArray | amplify.Poly | bool | list | numpy.ndarray):

        Returns:
            amplify.PolyArray:
        """
    def __imul__(self, arg: Union[PolyArray, Poly, float, list, numpy.ndarray]) -> PolyArray:
        """__imul__

        Args:
            arg (amplify.PolyArray | amplify.Poly | float | int | list | numpy.ndarray):

        Returns:
            amplify.PolyArray:
        """
    def __index__(self) -> int:
        """__index__

        Returns:
            int:
        """
    def __int__(self) -> int:
        """__int__

        Returns:
            int:
        """
    def __invert__(self) -> PolyArray:
        """__invert__

        Returns:
            amplify.PolyArray:
        """
    def __ior__(
        self, arg: Union[PolyArray, Poly, bool, list, numpy.ndarray[Any, numpy.dtype[numpy.bool_]]]
    ) -> PolyArray:
        """__ior__

        Args:
            arg (amplify.PolyArray | amplify.Poly | bool | list | numpy.ndarray):

        Returns:
            amplify.PolyArray:
        """
    def __ipow__(self, arg: int) -> PolyArray:
        """__ipow__

        Args:
            arg (int):

        Returns:
            amplify.PolyArray:
        """
    def __isub__(self, arg: Union[PolyArray, Poly, float, list, numpy.ndarray]) -> PolyArray:
        """__isub__

        Args:
            arg (amplify.PolyArray | amplify.Poly | float | int | list | numpy.ndarray):

        Returns:
            amplify.PolyArray:
        """
    def __iter__(self) -> PolyArray.Iterator:
        """__iter__

        Returns:
            amplify.PolyArray.Iterator:
        """
    def __itruediv__(self, arg: Union[float, list, numpy.ndarray]) -> PolyArray:
        """__itruediv__

        Args:
            arg (float | int | list | numpy.ndarray):

        Returns:
            amplify.PolyArray:
        """
    def __ixor__(
        self, arg: Union[PolyArray, Poly, bool, list, numpy.ndarray[Any, numpy.dtype[numpy.bool_]]]
    ) -> PolyArray:
        """__ixor__

        Args:
            arg (amplify.PolyArray | amplify.Poly | bool | list | numpy.ndarray):

        Returns:
            amplify.PolyArray:
        """
    def __len__(self) -> int:
        """__len__

        Returns:
            int:
        """
    def __matmul__(self, arg: Union[PolyArray, numpy.ndarray]) -> Union[Poly, PolyArray]:
        """__matmul__

        Args:
            arg (amplify.PolyArray | numpy.ndarray):

        Returns:
            amplify.Poly | amplify.PolyArray:
        """
    def __mul__(self, arg: Union[PolyArray, Poly, float, list, numpy.ndarray]) -> PolyArray:
        """__mul__

        Args:
            arg (amplify.PolyArray | amplify.Poly | float | int | list | numpy.ndarray):

        Returns:
            amplify.PolyArray:
        """
    def __ne__(
        self, arg: Union[PolyArray, Poly, float, list, numpy.ndarray]
    ) -> numpy.ndarray[Any, numpy.dtype[numpy.bool_]]:
        """__ne__

        Args:
            arg (amplify.PolyArray | amplify.Poly | float | int | list | numpy.ndarray):

        Returns:
            numpy.ndarray:
        """
    def __neg__(self) -> PolyArray:
        """__neg__

        Returns:
            amplify.PolyArray:
        """
    def __or__(
        self, arg: Union[PolyArray, Poly, bool, list, numpy.ndarray[Any, numpy.dtype[numpy.bool_]]]
    ) -> PolyArray:
        """__or__

        Args:
            arg (amplify.PolyArray | amplify.Poly | bool | list | numpy.ndarray):

        Returns:
            amplify.PolyArray:
        """
    def __pos__(self) -> PolyArray:
        """__pos__

        Returns:
            amplify.PolyArray:
        """
    def __pow__(self, arg: int) -> PolyArray:
        """__pow__

        Args:
            arg (int):

        Returns:
            amplify.PolyArray:
        """
    def __radd__(self, arg: Union[Poly, float, list, numpy.ndarray]) -> PolyArray:
        """__radd__

        Args:
            arg (amplify.Poly | float | int | list | numpy.ndarray):

        Returns:
            amplify.PolyArray:
        """
    def __rand__(self, arg: Union[Poly, bool, list, numpy.ndarray[Any, numpy.dtype[numpy.bool_]]]) -> PolyArray:
        """__rand__

        Args:
            arg (amplify.Poly | bool | list | numpy.ndarray):

        Returns:
            amplify.PolyArray:
        """
    def __rmatmul__(self, arg: Union[PolyArray, numpy.ndarray]) -> Union[Poly, PolyArray]:
        """__rmatmul__

        Args:
            arg (amplify.PolyArray | numpy.ndarray):

        Returns:
            amplify.Poly | amplify.PolyArray:
        """
    def __rmul__(self, arg: Union[Poly, float, list, numpy.ndarray]) -> PolyArray:
        """__rmul__

        Args:
            arg (amplify.Poly | float | int | list | numpy.ndarray):

        Returns:
            amplify.PolyArray:
        """
    def __ror__(self, arg: Union[Poly, bool, list, numpy.ndarray[Any, numpy.dtype[numpy.bool_]]]) -> PolyArray:
        """__ror__

        Args:
            arg (amplify.Poly | bool | list | numpy.ndarray):

        Returns:
            amplify.PolyArray:
        """
    def __rsub__(self, arg: Union[Poly, float, list, numpy.ndarray]) -> PolyArray:
        """__rsub__

        Args:
            arg (amplify.Poly | float | int | list | numpy.ndarray):

        Returns:
            amplify.PolyArray:
        """
    def __rxor__(self, arg: Union[Poly, bool, list, numpy.ndarray[Any, numpy.dtype[numpy.bool_]]]) -> PolyArray:
        """__rxor__

        Args:
            arg (amplify.Poly | bool | list | numpy.ndarray):

        Returns:
            amplify.PolyArray:
        """
    def __setitem__(
        self,
        arg: Optional[Union[tuple, slice, EllipsisType, int]],
        value: Union[Poly, float, list, numpy.ndarray, PolyArray],
    ) -> None:
        """__setitem__

        Args:
            arg (tuple | slice | EllipsisType | int | None):
            value (amplify.Poly | float | int | list | numpy.ndarray | amplify.PolyArray):
        """
    def __sub__(self, arg: Union[PolyArray, Poly, float, list, numpy.ndarray]) -> PolyArray:
        """__sub__

        Args:
            arg (amplify.PolyArray | amplify.Poly | float | int | list | numpy.ndarray):

        Returns:
            amplify.PolyArray:
        """
    def __truediv__(self, arg: Union[float, list, numpy.ndarray]) -> PolyArray:
        """__truediv__

        Args:
            arg (float | int | list | numpy.ndarray):

        Returns:
            amplify.PolyArray:
        """
    def __xor__(
        self, arg: Union[PolyArray, Poly, bool, list, numpy.ndarray[Any, numpy.dtype[numpy.bool_]]]
    ) -> PolyArray:
        """__xor__

        Args:
            arg (amplify.PolyArray | amplify.Poly | bool | list | numpy.ndarray):

        Returns:
            amplify.PolyArray:
        """
    @property
    def T(self) -> PolyArray:
        """T property

        Returns:
            amplify.PolyArray:
        """
    @property
    def flat(self) -> PolyArray:
        """flat property

        Returns:
            amplify.PolyArray:
        """
    @property
    def ndim(self) -> int:
        """ndim property

        Returns:
            int:
        """
    @property
    def size(self) -> int:
        """size property

        Returns:
            int:
        """

class QuadratizationMethod:
    ISHIKAWA_KZFD: ClassVar[QuadratizationMethod] = ...
    IshikawaKZFD: ClassVar[QuadratizationMethod] = ...
    SUBSTITUTION: ClassVar[QuadratizationMethod] = ...
    Substitute: ClassVar[QuadratizationMethod] = ...
    __name__: Any
    def __init__(self, *args, **kwargs) -> None: ...
    def __eq__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...

class Result(Generic[_AmplifyClient]):
    class GraphConversion:
        class ChainBreakFractions:
            class Iterator:
                def __init__(self, *args, **kwargs) -> None: ...
                def __iter__(self) -> Result.GraphConversion.ChainBreakFractions.Iterator:
                    """__iter__

                    Returns:
                        amplify.Result.GraphConversion.ChainBreakFractions.Iterator:
                    """
                def __next__(self) -> float:
                    """__next__

                    Returns:
                        float:
                    """

            def __init__(self, *args, **kwargs) -> None: ...
            def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
                """_repr_pretty_

                Args:
                    arg0 (Any):
                    arg1 (bool):
                """
            def __bool__(self) -> bool:
                """__bool__

                Returns:
                    bool:
                """
            def __getitem__(self, key: int) -> float:
                """__getitem__

                Args:
                    key (int):

                Returns:
                    float:
                """
            def __iter__(self) -> Result.GraphConversion.ChainBreakFractions.Iterator:
                """__iter__

                Returns:
                    amplify.Result.GraphConversion.ChainBreakFractions.Iterator:
                """
            def __len__(self) -> int:
                """__len__

                Returns:
                    int:
                """

        def __init__(self, *args, **kwargs) -> None: ...
        def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
            """_repr_pretty_

            Args:
                arg0 (Any):
                arg1 (bool):
            """
        @property
        def chain_break_fractions(self) -> Result.GraphConversion.ChainBreakFractions:
            """chain_break_fractions property

            Returns:
                amplify.Result.GraphConversion.ChainBreakFractions:
            """
        @property
        def chains(self) -> list[numpy.ndarray[Any, numpy.dtype[numpy.uint32]]]:
            """chains property

            Returns:
                list[numpy.ndarray[Any, numpy.dtype[numpy.uint32]]]:
            """
        @property
        def dst_graph(self) -> Graph:
            """dst_graph property

            Returns:
                amplify.Graph:
            """
        @property
        def num_variables(self) -> int:
            """num_variables property

            Returns:
                int:
            """
        @property
        def poly(self) -> Poly:
            """poly property

            Returns:
                amplify.Poly:
            """
        @property
        def src_graph(self) -> List[Tuple[int, int]]:
            """src_graph property

            Returns:
                List[Tuple[int, int]]:
            """
        @property
        def values_list(self) -> Result.ValuesList:
            """values_list property

            Returns:
                amplify.Result.ValuesList:
            """

    class ModelConversion:
        class IntermediateMapping:
            class ItemsView:
                def __init__(self, *args, **kwargs) -> None: ...
                def __bool__(self) -> bool:
                    """__bool__

                    Returns:
                        bool:
                    """
                def __iter__(self) -> Result.ModelConversion.IntermediateMapping.ItemsView:
                    """__iter__

                    Returns:
                        amplify.Result.ModelConversion.IntermediateMapping.ItemsView:
                    """
                def __len__(self) -> int:
                    """__len__

                    Returns:
                        int:
                    """
                def __next__(self) -> Tuple[Poly, Poly]:
                    """__next__

                    Returns:
                        Tuple[amplify.Poly, amplify.Poly]:
                    """

            class KeysView:
                def __init__(self, *args, **kwargs) -> None: ...
                def __bool__(self) -> bool:
                    """__bool__

                    Returns:
                        bool:
                    """
                @overload
                def __contains__(self, arg: Poly) -> bool: ...
                @overload
                def __contains__(self, arg: Any) -> bool:
                    """__contains__

                    :Overloading:

                    .. admonition:: 1. __contains__(self, arg: amplify.Poly, /) -> bool

                        Args:
                            * arg (amplify.Poly):

                        Returns:
                            bool:

                    .. admonition:: 2. __contains__(self, arg: Any, /) -> bool

                        Args:
                            * arg (Any):

                        Returns:
                            bool:
                    """
                def __iter__(self) -> Result.ModelConversion.IntermediateMapping.KeysView:
                    """__iter__

                    Returns:
                        amplify.Result.ModelConversion.IntermediateMapping.KeysView:
                    """
                def __len__(self) -> int:
                    """__len__

                    Returns:
                        int:
                    """
                def __next__(self) -> Poly:
                    """__next__

                    Returns:
                        amplify.Poly:
                    """

            class ValuesView:
                def __init__(self, *args, **kwargs) -> None: ...
                def __bool__(self) -> bool:
                    """__bool__

                    Returns:
                        bool:
                    """
                def __iter__(self) -> Result.ModelConversion.IntermediateMapping.ValuesView:
                    """__iter__

                    Returns:
                        amplify.Result.ModelConversion.IntermediateMapping.ValuesView:
                    """
                def __len__(self) -> int:
                    """__len__

                    Returns:
                        int:
                    """
                def __next__(self) -> Poly:
                    """__next__

                    Returns:
                        amplify.Poly:
                    """

            def __init__(self, *args, **kwargs) -> None: ...
            def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
                """_repr_pretty_

                Args:
                    arg0 (Any):
                    arg1 (bool):
                """
            def items(self) -> Result.ModelConversion.IntermediateMapping.ItemsView:
                """items

                Returns:
                    amplify.Result.ModelConversion.IntermediateMapping.ItemsView:
                """
            def keys(self) -> Result.ModelConversion.IntermediateMapping.KeysView:
                """keys

                Returns:
                    amplify.Result.ModelConversion.IntermediateMapping.KeysView:
                """
            def values(self) -> Result.ModelConversion.IntermediateMapping.ValuesView:
                """values

                Returns:
                    amplify.Result.ModelConversion.IntermediateMapping.ValuesView:
                """
            def __bool__(self) -> bool:
                """__bool__

                Returns:
                    bool:
                """
            @overload
            def __contains__(self, arg: Poly) -> bool: ...
            @overload
            def __contains__(self, arg: Any) -> bool:
                """__contains__

                :Overloading:

                .. admonition:: 1. __contains__(self, arg: amplify.Poly, /) -> bool

                    Args:
                        * arg (amplify.Poly):

                    Returns:
                        bool:

                .. admonition:: 2. __contains__(self, arg: Any, /) -> bool

                    Args:
                        * arg (Any):

                    Returns:
                        bool:
                """
            def __getitem__(self, arg: Poly) -> Poly:
                """__getitem__

                Args:
                    arg (amplify.Poly):

                Returns:
                    amplify.Poly:
                """
            def __iter__(self) -> Result.ModelConversion.IntermediateMapping.KeysView:
                """__iter__

                Returns:
                    amplify.Result.ModelConversion.IntermediateMapping.KeysView:
                """
            def __len__(self) -> int:
                """__len__

                Returns:
                    int:
                """

        def __init__(self, *args, **kwargs) -> None: ...
        def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
            """_repr_pretty_

            Args:
                arg0 (Any):
                arg1 (bool):
            """
        @property
        def mapping(self) -> Result.ModelConversion.IntermediateMapping:
            """mapping property

            Returns:
                amplify.Result.ModelConversion.IntermediateMapping:
            """
        @property
        def model(self) -> Model:
            """model property

            Returns:
                amplify.Model:
            """
        @property
        def num_variables(self) -> int:
            """num_variables property

            Returns:
                int:
            """
        @property
        def values_list(self) -> Result.ValuesList:
            """values_list property

            Returns:
                amplify.Result.ValuesList:
            """

    class Solution:
        def __init__(self, *args, **kwargs) -> None: ...
        def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
            """_repr_pretty_

            Args:
                arg0 (Any):
                arg1 (bool):
            """
        @property
        def feasible(self) -> bool:
            """feasible property

            Returns:
                bool:
            """
        @property
        def objective(self) -> float:
            """objective property

            Returns:
                float:
            """
        @property
        def time(self) -> datetime.timedelta:
            """time property

            Returns:
                datetime.timedelta:
            """
        @property
        def values(self) -> Values:
            """values property

            Returns:
                amplify.Values:
            """

    class SolutionList:
        class Iterator:
            def __init__(self, *args, **kwargs) -> None: ...
            def __iter__(self) -> Result.SolutionList.Iterator:
                """__iter__

                Returns:
                    amplify.Result.SolutionList.Iterator:
                """
            def __next__(self) -> Result.Solution:
                """__next__

                Returns:
                    amplify.Result.Solution:
                """

        def __init__(self, *args, **kwargs) -> None: ...
        def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
            """_repr_pretty_

            Args:
                arg0 (Any):
                arg1 (bool):
            """
        def __bool__(self) -> bool:
            """__bool__

            Returns:
                bool:
            """
        def __getitem__(self, key: int) -> Result.Solution:
            """__getitem__

            Args:
                key (int):

            Returns:
                amplify.Result.Solution:
            """
        def __iter__(self) -> Result.SolutionList.Iterator:
            """__iter__

            Returns:
                amplify.Result.SolutionList.Iterator:
            """
        def __len__(self) -> int:
            """__len__

            Returns:
                int:
            """

    class SplitView:
        def __init__(self, *args, **kwargs) -> None: ...
        def __bool__(self) -> bool:
            """__bool__

            Returns:
                bool:
            """
        def __getitem__(self, key: int) -> Result:
            """__getitem__

            Args:
                key (int):

            Returns:
                amplify.Result:
            """
        def __iter__(self) -> Result.SplitView:
            """__iter__

            Returns:
                amplify.Result.SplitView:
            """
        def __len__(self) -> int:
            """__len__

            Returns:
                int:
            """
        def __next__(self) -> Result:
            """__next__

            Returns:
                amplify.Result:
            """

    class ValuesList:
        class Iterator:
            def __init__(self, *args, **kwargs) -> None: ...
            def __iter__(self) -> Result.ValuesList.Iterator:
                """__iter__

                Returns:
                    amplify.Result.ValuesList.Iterator:
                """
            def __next__(self) -> Values:
                """__next__

                Returns:
                    amplify.Values:
                """

        def __init__(self, *args, **kwargs) -> None: ...
        def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
            """_repr_pretty_

            Args:
                arg0 (Any):
                arg1 (bool):
            """
        def __bool__(self) -> bool:
            """__bool__

            Returns:
                bool:
            """
        def __getitem__(self, key: int) -> Values:
            """__getitem__

            Args:
                key (int):

            Returns:
                amplify.Values:
            """
        def __iter__(self) -> Result.ValuesList.Iterator:
            """__iter__

            Returns:
                amplify.Result.ValuesList.Iterator:
            """
        def __len__(self) -> int:
            """__len__

            Returns:
                int:
            """

    filter_solution: bool
    """filter_solution property

    Returns:
        bool:
    """
    def __init__(self, *args, **kwargs) -> None: ...
    def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
        """_repr_pretty_

        Args:
            arg0 (Any):
            arg1 (bool):
        """
    def sort(self) -> None:
        """sort"""
    def __getitem__(self, key: int) -> Result.Solution:
        """__getitem__

        Args:
            key (int):

        Returns:
            amplify.Result.Solution:
        """
    def __iter__(self) -> Result.SolutionList.Iterator:
        """__iter__

        Returns:
            amplify.Result.SolutionList.Iterator:
        """
    def __len__(self) -> int:
        """__len__

        Returns:
            int:
        """
    @property
    def best(self) -> Result.Solution:
        """best property

        Returns:
            amplify.Result.Solution:
        """
    client_result: _ClientResultDescriptor
    """client_result property

    Returns:
        amplify.FixstarsClient.Result | dimod.sampleset.SampleSet | amplify.FujitsuDA4Client.Result | amplify.ToshibaSQBM2Client.Result | amplify.GurobiClient.Result | amplify.NECVA2Client.Result | amplify.DASClient.Result | None:
    """

    embedding: _EmbeddingDescriptor
    """embedding property

    Returns:
        amplify.Result.GraphConversion | None:
    """

    @property
    def execution_time(self) -> datetime.timedelta:
        """execution_time property

        Returns:
            datetime.timedelta:
        """
    @property
    def intermediate(self) -> Result.ModelConversion:
        """intermediate property

        Returns:
            amplify.Result.ModelConversion:
        """
    @property
    def num_solves(self) -> int:
        """num_solves property

        Returns:
            int:
        """
    @property
    def response_time(self) -> datetime.timedelta:
        """response_time property

        Returns:
            datetime.timedelta:
        """
    @property
    def solutions(self) -> Result.SolutionList:
        """solutions property

        Returns:
            amplify.Result.SolutionList:
        """
    @property
    def split(self) -> Result.SplitView:
        """split property

        Returns:
            amplify.Result.SplitView:
        """
    @property
    def total_time(self) -> datetime.timedelta:
        """total_time property

        Returns:
            datetime.timedelta:
        """

class ToshibaSQBM2Client:
    class Parameters:
        C: Optional[float]
        """C property

        Returns:
            float | None:
        """
        HMCsteps: Optional[int]
        """HMCsteps property

        Returns:
            int | None:
        """
        HMCweight: Optional[int]
        """HMCweight property

        Returns:
            int | None:
        """
        PD3Orate: Optional[int]
        """PD3Orate property

        Returns:
            int | None:
        """
        algo: Optional[int]
        """algo property

        Returns:
            int | None:
        """
        algos: Optional[str]
        """algos property

        Returns:
            str | None:
        """
        blocks: Optional[int]
        """blocks property

        Returns:
            int | None:
        """
        detail_level: Optional[int]
        """detail_level property

        Returns:
            int | None:
        """
        detail_log: Optional[int]
        """detail_log property

        Returns:
            int | None:
        """
        dt: Optional[float]
        """dt property

        Returns:
            float | None:
        """
        loops: Optional[int]
        """loops property

        Returns:
            int | None:
        """
        maxout: Optional[int]
        """maxout property

        Returns:
            int | None:
        """
        @property
        def maxwait(self) -> Optional[datetime.timedelta]:
            """maxwait property

            Returns:
                datetime.timedelta | None:
            """
        @maxwait.setter
        def maxwait(self, value: Union[Optional[datetime.timedelta], int]) -> None: ...
        multishot: Optional[int]
        """multishot property

        Returns:
            int | None:
        """
        phi: Optional[float]
        """phi property

        Returns:
            float | None:
        """
        steps: Optional[int]
        """steps property

        Returns:
            int | None:
        """
        target: Optional[float]
        """target property

        Returns:
            float | None:
        """
        @property
        def timeout(self) -> Optional[datetime.timedelta]:
            """timeout property

            Returns:
                datetime.timedelta | None:
            """
        @timeout.setter
        def timeout(self, value: Union[Optional[datetime.timedelta], int]) -> None: ...
        def __init__(self, *args, **kwargs) -> None: ...
        def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
            """_repr_pretty_

            Args:
                arg0 (Any):
                arg1 (bool):
            """

    class Result(Solution):
        def __init__(self, *args, **kwargs) -> None: ...
        def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
            """_repr_pretty_

            Args:
                arg0 (Any):
                arg1 (bool):
            """
        @property
        def id(self) -> str:
            """id property

            Returns:
                str:
            """
        @property
        def message(self) -> str:
            """message property

            Returns:
                str:
            """
        @property
        def others(self) -> List[ToshibaSQBM2Client.Solution]:
            """others property

            Returns:
                List[amplify.ToshibaSQBM2Client.Solution]:
            """
        @property
        def runs(self) -> int:
            """runs property

            Returns:
                int:
            """
        @property
        def time(self) -> datetime.timedelta:
            """time property

            Returns:
                datetime.timedelta:
            """
        @property
        def wait(self) -> datetime.timedelta:
            """wait property

            Returns:
                datetime.timedelta:
            """

    class Solution:
        def __init__(self, *args, **kwargs) -> None: ...
        def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
            """_repr_pretty_

            Args:
                arg0 (Any):
                arg1 (bool):
            """
        @property
        def count(self) -> int:
            """count property

            Returns:
                int:
            """
        @property
        def param(self) -> ToshibaSQBM2Client.Parameters:
            """param property

            Returns:
                amplify.ToshibaSQBM2Client.Parameters:
            """
        @property
        def result(self) -> numpy.ndarray[Any, numpy.dtype[numpy.float64]]:
            """result property

            Returns:
                numpy.ndarray:
            """
        @property
        def value(self) -> float:
            """value property

            Returns:
                float:
            """

    class Solver:
        Pubo: ClassVar[ToshibaSQBM2Client.Solver] = ...
        Qplib: ClassVar[ToshibaSQBM2Client.Solver] = ...
        Qubo: ClassVar[ToshibaSQBM2Client.Solver] = ...
        __name__: Any
        def __init__(self, *args, **kwargs) -> None: ...
        def __eq__(self, other) -> bool: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        def __ne__(self, other) -> bool: ...

    compression: bool
    """compression property

    Returns:
        bool:
    """
    proxy: Optional[str]
    """proxy property

    Returns:
        str | None:
    """
    @property
    def solver(self) -> ToshibaSQBM2Client.Solver:
        """solver property

        Returns:
            amplify.ToshibaSQBM2Client.Solver:
        """
    @solver.setter
    def solver(self, value: Union[ToshibaSQBM2Client.Solver, Literal["Qubo", "Qplib", "Pubo"]]) -> None: ...
    token: str
    """token property

    Returns:
        str:
    """
    url: str
    """url property

    Returns:
        str:
    """
    @property
    def write_request_data(self) -> Optional[os.PathLike]:
        """write_request_data property

        Returns:
            os.PathLike | None:
        """
    @write_request_data.setter
    def write_request_data(self, value: Union[Optional[os.PathLike], str]) -> None: ...
    @property
    def write_response_data(self) -> Optional[os.PathLike]:
        """write_response_data property

        Returns:
            os.PathLike | None:
        """
    @write_response_data.setter
    def write_response_data(self, value: Union[Optional[os.PathLike], str]) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, token: str = ..., url: str = ..., proxy: Optional[str] = ...) -> None:
        """__init__

        Args:
            token (str): Defaults to ``''``.
            url (str): Defaults to ``''``.
            proxy (str | None): Defaults to ``None``.
        """
    def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
        """_repr_pretty_

        Args:
            arg0 (Any):
            arg1 (bool):
        """
    def health_check(self) -> bool:
        """health_check

        Returns:
            bool:
        """
    @overload
    def solve(self, objective: Union[Poly, Matrix], dry_run: Literal[False] = ...) -> ToshibaSQBM2Client.Result: ...
    @overload
    def solve(
        self, constraint: Union[Constraint, ConstraintList], dry_run: Literal[False] = ...
    ) -> ToshibaSQBM2Client.Result: ...
    @overload
    def solve(
        self,
        objective: Union[Poly, Matrix],
        constraint: Union[Constraint, ConstraintList],
        dry_run: Literal[False] = ...,
    ) -> ToshibaSQBM2Client.Result: ...
    @overload
    def solve(self, objective: Union[Poly, Matrix], dry_run: Literal[True]) -> None: ...
    @overload
    def solve(self, constraint: Union[Constraint, ConstraintList], dry_run: Literal[True]) -> None: ...
    @overload
    def solve(
        self, objective: Union[Poly, Matrix], constraint: Union[Constraint, ConstraintList], dry_run: Literal[True]
    ) -> None:
        """solve

        :Overloading:

        .. admonition:: 1. solve(self, objective: Union[amplify.Poly, amplify.Matrix], dry_run: Literal[False] = False) -> amplify.ToshibaSQBM2Client.Result

            Args:
                * objective (amplify.Poly | amplify.Matrix):
                * dry_run (Literal[False]): Defaults to ``False``.

            Returns:
                amplify.ToshibaSQBM2Client.Result:

        .. admonition:: 2. solve(self, constraint: Union[amplify.Constraint, amplify.ConstraintList], dry_run: Literal[False] = False) -> amplify.ToshibaSQBM2Client.Result

            Args:
                * constraint (amplify.Constraint | amplify.ConstraintList):
                * dry_run (Literal[False]): Defaults to ``False``.

            Returns:
                amplify.ToshibaSQBM2Client.Result:

        .. admonition:: 3. solve(self, objective: Union[amplify.Poly, amplify.Matrix], constraint: Union[amplify.Constraint, amplify.ConstraintList], dry_run: Literal[False] = False) -> amplify.ToshibaSQBM2Client.Result

            Args:
                * objective (amplify.Poly | amplify.Matrix):
                * constraint (amplify.Constraint | amplify.ConstraintList):
                * dry_run (Literal[False]): Defaults to ``False``.

            Returns:
                amplify.ToshibaSQBM2Client.Result:

        .. admonition:: 4. solve(self, objective: Union[amplify.Poly, amplify.Matrix], dry_run: Literal[True]) -> None

            Args:
                * objective (amplify.Poly | amplify.Matrix):
                * dry_run (Literal[True]):

        .. admonition:: 5. solve(self, constraint: Union[amplify.Constraint, amplify.ConstraintList], dry_run: Literal[True]) -> None

            Args:
                * constraint (amplify.Constraint | amplify.ConstraintList):
                * dry_run (Literal[True]):

        .. admonition:: 6. solve(self, objective: Union[amplify.Poly, amplify.Matrix], constraint: Union[amplify.Constraint, amplify.ConstraintList], dry_run: Literal[True]) -> None

            Args:
                * objective (amplify.Poly | amplify.Matrix):
                * constraint (amplify.Constraint | amplify.ConstraintList):
                * dry_run (Literal[True]):
        """
    @property
    def acceptable_degrees(self) -> AcceptableDegrees:
        """acceptable_degrees property

        Returns:
            amplify.AcceptableDegrees:
        """
    @property
    def parameters(self) -> ToshibaSQBM2Client.Parameters:
        """parameters property

        Returns:
            amplify.ToshibaSQBM2Client.Parameters:
        """
    @property
    def version(self) -> str:
        """version property

        Returns:
            str:
        """

class Values:
    class ItemsView:
        def __init__(self, *args, **kwargs) -> None: ...
        def __bool__(self) -> bool:
            """__bool__

            Returns:
                bool:
            """
        def __iter__(self) -> Values.ItemsView:
            """__iter__

            Returns:
                amplify.Values.ItemsView:
            """
        def __len__(self) -> int:
            """__len__

            Returns:
                int:
            """
        def __next__(self) -> Tuple[Poly, float]:
            """__next__

            Returns:
                Tuple[amplify.Poly, float]:
            """

    class KeysView:
        def __init__(self, *args, **kwargs) -> None: ...
        def __bool__(self) -> bool:
            """__bool__

            Returns:
                bool:
            """
        @overload
        def __contains__(self, arg: Poly) -> bool: ...
        @overload
        def __contains__(self, arg: Any) -> bool:
            """__contains__

            :Overloading:

            .. admonition:: 1. __contains__(self, arg: amplify.Poly, /) -> bool

                Args:
                    * arg (amplify.Poly):

                Returns:
                    bool:

            .. admonition:: 2. __contains__(self, arg: Any, /) -> bool

                Args:
                    * arg (Any):

                Returns:
                    bool:
            """
        def __iter__(self) -> Values.KeysView:
            """__iter__

            Returns:
                amplify.Values.KeysView:
            """
        def __len__(self) -> int:
            """__len__

            Returns:
                int:
            """
        def __next__(self) -> Poly:
            """__next__

            Returns:
                amplify.Poly:
            """

    class ValuesView:
        def __init__(self, *args, **kwargs) -> None: ...
        def __bool__(self) -> bool:
            """__bool__

            Returns:
                bool:
            """
        def __iter__(self) -> Values.ValuesView:
            """__iter__

            Returns:
                amplify.Values.ValuesView:
            """
        def __len__(self) -> int:
            """__len__

            Returns:
                int:
            """
        def __next__(self) -> float:
            """__next__

            Returns:
                float:
            """

    def __init__(self, *args, **kwargs) -> None: ...
    def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
        """_repr_pretty_

        Args:
            arg0 (Any):
            arg1 (bool):
        """
    def items(self) -> Values.ItemsView:
        """items

        Returns:
            amplify.Values.ItemsView:
        """
    def keys(self) -> Values.KeysView:
        """keys

        Returns:
            amplify.Values.KeysView:
        """
    def values(self) -> Values.ValuesView:
        """values

        Returns:
            amplify.Values.ValuesView:
        """
    def __bool__(self) -> bool:
        """__bool__

        Returns:
            bool:
        """
    @overload
    def __contains__(self, arg: Poly) -> bool: ...
    @overload
    def __contains__(self, arg: Any) -> bool:
        """__contains__

        :Overloading:

        .. admonition:: 1. __contains__(self, arg: amplify.Poly, /) -> bool

            Args:
                * arg (amplify.Poly):

            Returns:
                bool:

        .. admonition:: 2. __contains__(self, arg: Any, /) -> bool

            Args:
                * arg (Any):

            Returns:
                bool:
        """
    def __getitem__(self, arg: Poly) -> float:
        """__getitem__

        Args:
            arg (amplify.Poly):

        Returns:
            float:
        """
    def __iter__(self) -> Values.KeysView:
        """__iter__

        Returns:
            amplify.Values.KeysView:
        """
    def __len__(self) -> int:
        """__len__

        Returns:
            int:
        """

class Variable:
    lower_bound: Optional[float]
    """lower_bound property

    Returns:
        float | None:
    """
    name: str
    """name property

    Returns:
        str:
    """
    upper_bound: Optional[float]
    """upper_bound property

    Returns:
        float | None:
    """
    def __init__(self, *args, **kwargs) -> None: ...
    def _repr_pretty_(self, arg0: Any, arg1: bool) -> None:
        """_repr_pretty_

        Args:
            arg0 (Any):
            arg1 (bool):
        """
    def __eq__(self, arg: Variable) -> bool:
        """__eq__

        Args:
            arg (amplify.Variable):

        Returns:
            bool:
        """
    def __ne__(self, arg: Variable) -> bool:
        """__ne__

        Args:
            arg (amplify.Variable):

        Returns:
            bool:
        """
    @property
    def id(self) -> int:
        """id property

        Returns:
            int:
        """
    @property
    def type(self) -> VariableType:
        """type property

        Returns:
            amplify.VariableType:
        """

class VariableGenerator:
    def __init__(self) -> None:
        """__init__"""
    @overload
    def array(
        self,
        type: Union[Literal["Binary", "Integer", "Ising", "Real"], VariableType],
        shape: int,
        bounds: tuple[Optional[float], ...] = ...,
        name: str = ...,
    ) -> PolyArray[_Dim1]: ...
    @overload
    def array(
        self,
        type: Union[Literal["Binary", "Integer", "Ising", "Real"], VariableType],
        shape: tuple[int],
        bounds: tuple[Optional[float], ...] = ...,
        name: str = ...,
    ) -> PolyArray[_Dim1]: ...
    @overload
    def array(
        self,
        type: Union[Literal["Binary", "Integer", "Ising", "Real"], VariableType],
        shape: tuple[int, int],
        bounds: tuple[Optional[float], ...] = ...,
        name: str = ...,
    ) -> PolyArray[_Dim2]: ...
    @overload
    def array(
        self,
        type: Union[Literal["Binary", "Integer", "Ising", "Real"], VariableType],
        shape: tuple[int, int, int],
        bounds: tuple[Optional[float], ...] = ...,
        name: str = ...,
    ) -> PolyArray[_Dim3]: ...
    @overload
    def array(
        self,
        type: Union[Literal["Binary", "Integer", "Ising", "Real"], VariableType],
        shape: tuple[int, int, int, int],
        bounds: tuple[Optional[float], ...] = ...,
        name: str = ...,
    ) -> PolyArray[_Dim4]: ...
    @overload
    def array(
        self,
        type: Union[Literal["Binary", "Integer", "Ising", "Real"], VariableType],
        shape: Union[tuple[int, ...], int],
        bounds: tuple[Optional[float], ...] = ...,
        name: str = ...,
    ) -> PolyArray: ...
    @overload
    def array(
        self, type: Union[Literal["Binary", "Integer", "Ising", "Real"], VariableType], *shape: Unpack[tuple[int]]
    ) -> PolyArray[_Dim1]: ...
    @overload
    def array(
        self, type: Union[Literal["Binary", "Integer", "Ising", "Real"], VariableType], *shape: Unpack[tuple[int, int]]
    ) -> PolyArray[_Dim2]: ...
    @overload
    def array(
        self,
        type: Union[Literal["Binary", "Integer", "Ising", "Real"], VariableType],
        *shape: Unpack[tuple[int, int, int]],
    ) -> PolyArray[_Dim3]: ...
    @overload
    def array(
        self,
        type: Union[Literal["Binary", "Integer", "Ising", "Real"], VariableType],
        *shape: Unpack[tuple[int, int, int, int]],
    ) -> PolyArray[_Dim4]: ...
    @overload
    def array(self, type: Union[Literal["Binary", "Integer", "Ising", "Real"], VariableType], *shape: int) -> PolyArray:
        """array

        :Overloading:

        .. admonition:: 1. array(self, type: Union[str, amplify.VariableType], shape: Union[tuple[int, ...], int], bounds: tuple[Optional[float], ...] = (None, None), name: str = '') -> amplify.PolyArray

            Args:
                * type (str | amplify.VariableType):
                * shape (tuple[int, ...] | int):
                * bounds (tuple[Optional[float], ...]): Defaults to ``(None, None)``.
                * name (str): Defaults to ``''``.

            Returns:
                amplify.PolyArray:

        .. admonition:: 2. array(self, type: Union[str, amplify.VariableType], \\*shape: int) -> amplify.PolyArray

            Args:
                * type (str | amplify.VariableType):
                * \\*shape (int):

            Returns:
                amplify.PolyArray:
        """
    @overload
    def matrix(
        self,
        type: Union[Literal["Binary", "Integer", "Ising", "Real"], VariableType],
        shape: Union[int, tuple[int, ...]],
        bounds: tuple[Optional[float], ...] = ...,
        name: str = ...,
    ) -> Matrix: ...
    @overload
    def matrix(self, type: Union[Literal["Binary", "Integer", "Ising", "Real"], VariableType], *shape: int) -> Matrix:
        """matrix

        :Overloading:

        .. admonition:: 1. matrix(self, type: Union[str, amplify.VariableType], shape: Union[int, tuple[int, ...]], bounds: tuple[Optional[float], ...] = (None, None), name: str = '') -> amplify.Matrix

            Args:
                * type (str | amplify.VariableType):
                * shape (int | tuple[int, ...]):
                * bounds (tuple[Optional[float], ...]): Defaults to ``(None, None)``.
                * name (str): Defaults to ``''``.

            Returns:
                amplify.Matrix:

        .. admonition:: 2. matrix(self, type: Union[str, amplify.VariableType], \\*shape: int) -> amplify.Matrix

            Args:
                * type (str | amplify.VariableType):
                * \\*shape (int):

            Returns:
                amplify.Matrix:
        """
    def scalar(
        self,
        type: Union[Literal["Binary", "Integer", "Ising", "Real"], VariableType],
        bounds: tuple = ...,
        name: str = ...,
    ) -> Poly:
        """scalar

        Args:
            type (str | amplify.VariableType):
            bounds (tuple): Defaults to ``(None, None)``.
            name (str): Defaults to ``''``.

        Returns:
            amplify.Poly:
        """
    @property
    def variables(self) -> List[Variable]:
        """variables property

        Returns:
            List[amplify.Variable]:
        """

class VariableType:
    Binary: ClassVar[VariableType] = ...
    Integer: ClassVar[VariableType] = ...
    Ising: ClassVar[VariableType] = ...
    Real: ClassVar[VariableType] = ...
    __name__: Any
    def __init__(self, *args, **kwargs) -> None: ...
    def __eq__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...

@overload
def clamp(
    poly: Poly,
    bounds: Tuple[Optional[float], Optional[float]],
    label: str = ...,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = ...,
) -> Constraint: ...
@overload
def clamp(
    array: PolyArray,
    bounds: Tuple[Optional[float], Optional[float]],
    label: str = ...,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = ...,
    axis: Literal[None] = ...,
) -> Constraint: ...
@overload
def clamp(
    array: PolyArray,
    bounds: Tuple[Optional[float], Optional[float]],
    label: str = ...,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = ...,
    axis: Optional[Union[int, tuple[int, ...]]] = ...,
) -> Union[Constraint, ConstraintList]:
    """clamp

    :Overloading:

    .. admonition:: 1. clamp(poly: amplify.Poly, bounds: Tuple[Optional[float], Optional[float]], label: str = '', penalty_formulation: Union[str, amplify.PenaltyFormulation] = Default) -> amplify.Constraint

        Args:
            * poly (amplify.Poly):
            * bounds (Tuple[Optional[float], Optional[float]]):
            * label (str): Defaults to ``''``.
            * penalty_formulation (str | amplify.PenaltyFormulation): Defaults to ``Default``.

        Returns:
            amplify.Constraint:

    .. admonition:: 2. clamp(array: amplify.PolyArray, bounds: Tuple[Optional[float], Optional[float]], label: str = '', penalty_formulation: Union[str, amplify.PenaltyFormulation] = Default, axis: Literal[None] = None) -> amplify.Constraint

        Args:
            * array (amplify.PolyArray):
            * bounds (Tuple[Optional[float], Optional[float]]):
            * label (str): Defaults to ``''``.
            * penalty_formulation (str | amplify.PenaltyFormulation): Defaults to ``Default``.
            * axis (Literal[None] | None): Defaults to ``None``.

        Returns:
            amplify.Constraint:

    .. admonition:: 3. clamp(array: amplify.PolyArray, bounds: Tuple[Optional[float], Optional[float]], label: str = '', penalty_formulation: Union[str, amplify.PenaltyFormulation] = Default, axis: Optional[Union[int, tuple[int, ...]]] = None) -> Union[amplify.Constraint, amplify.ConstraintList]

        Args:
            * array (amplify.PolyArray):
            * bounds (Tuple[Optional[float], Optional[float]]):
            * label (str): Defaults to ``''``.
            * penalty_formulation (str | amplify.PenaltyFormulation): Defaults to ``Default``.
            * axis (int | tuple[int, ...] | None): Defaults to ``None``.

        Returns:
            amplify.Constraint | amplify.ConstraintList:
    """

@overload
def domain_wall(array: PolyArray[_Dim1], label: str = ..., ascending: bool = ...) -> Constraint: ...
@overload
def domain_wall(array: PolyArray, label: str = ..., ascending: bool = ...) -> ConstraintList:
    """domain_wall

    Args:
        array (amplify.PolyArray):
        label (str): Defaults to ``''``.
        ascending (bool): Defaults to ``True``.

    Returns:
        amplify.Constraint | amplify.ConstraintList:
    """

@overload
def dot(arg0: PolyArray, arg1: Union[PolyArray, numpy.ndarray]) -> Union[Poly, PolyArray]: ...
@overload
def dot(arg0: numpy.ndarray, arg1: PolyArray) -> Union[Poly, PolyArray]:
    """dot

    :Overloading:

    .. admonition:: 1. dot(arg0: amplify.PolyArray, arg1: Union[amplify.PolyArray, numpy.ndarray], /) -> Union[amplify.Poly, amplify.PolyArray]

        Args:
            * arg0 (amplify.PolyArray):
            * arg1 (amplify.PolyArray | numpy.ndarray):

        Returns:
            amplify.Poly | amplify.PolyArray:

    .. admonition:: 2. dot(arg0: numpy.ndarray, arg1: amplify.PolyArray, /) -> Union[amplify.Poly, amplify.PolyArray]

        Args:
            * arg0 (numpy.ndarray):
            * arg1 (amplify.PolyArray):

        Returns:
            amplify.Poly | amplify.PolyArray:
    """

def einsum(subscripts: str, *operands: Union[PolyArray, numpy.ndarray]) -> Union[Poly, PolyArray]:
    """einsum

    Args:
        subscripts (str):
        *operands (amplify.PolyArray | numpy.ndarray):

    Returns:
        amplify.Poly | amplify.PolyArray:
    """

def embed(
    poly: Poly,
    client_graph: Graph,
    embedding_method: Union[Literal["Default", "Clique", "Minor", "Parallel"], EmbeddingMethod] = ...,
    embedding_timeout: datetime.timedelta = ...,
    chain_strength: float = ...,
) -> Tuple[Poly, list[numpy.ndarray[Any, numpy.dtype[numpy.uint32]]], List[Tuple[int, int]]]:
    """embed

    Args:
        poly (amplify.Poly):
        client_graph (amplify.Graph):
        embedding_method (str | amplify.EmbeddingMethod): Defaults to ``Default``.
        embedding_timeout (datetime.timedelta): Defaults to ``0:00:10``.
        chain_strength (float): Defaults to ``1.0``.

    Returns:
        Tuple[amplify.Poly, list[numpy.ndarray[Any, numpy.dtype[numpy.uint32]]], List[Tuple[int, int]]]:
    """

@overload
def equal_to(poly: Poly, right: float, label: str = ...) -> Constraint: ...
@overload
def equal_to(array: PolyArray, right: float, label: str = ..., axis: Literal[None] = ...) -> Constraint: ...
@overload
def equal_to(array: PolyArray[_Dim0], right: float, label: str = ...) -> Constraint: ...
@overload
def equal_to(
    array: PolyArray[_Dim1], right: float, label: str = ..., axis: Optional[Union[int, tuple[int]]] = ...
) -> Constraint: ...
@overload
def equal_to(
    array: PolyArray[_Dim2], right: float, label: str = ..., axis: Optional[tuple[int, int]] = ...
) -> Constraint: ...
@overload
def equal_to(
    array: PolyArray[_Dim2], right: float, label: str = ..., axis: Union[int, tuple[int]] = ...
) -> ConstraintList: ...
@overload
def equal_to(
    array: PolyArray[_Dim3], right: float, label: str = ..., axis: Optional[tuple[int, int, int]] = ...
) -> Constraint: ...
@overload
def equal_to(
    array: PolyArray[_Dim3], right: float, label: str = ..., axis: Union[int, tuple[int, ...]] = ...
) -> ConstraintList: ...
@overload
def equal_to(
    array: PolyArray[_Dim4], right: float, label: str = ..., axis: Optional[tuple[int, int, int, int]] = ...
) -> Constraint: ...
@overload
def equal_to(
    array: PolyArray[_Dim4], right: float, label: str = ..., axis: Union[int, tuple[int, ...]] = ...
) -> ConstraintList: ...
@overload
def equal_to(array: PolyArray, right: float, label: str = ..., axis: tuple[()] = ...) -> ConstraintList: ...
@overload
def equal_to(
    array: PolyArray, right: float, label: str = ..., axis: Optional[Union[int, tuple[int, ...]]] = ...
) -> Union[Constraint, ConstraintList]:
    """equal_to

    :Overloading:

    .. admonition:: 1. equal_to(poly: amplify.Poly, right: float, label: str = '') -> amplify.Constraint

        Args:
            * poly (amplify.Poly):
            * right (float):
            * label (str): Defaults to ``''``.

        Returns:
            amplify.Constraint:

    .. admonition:: 2. equal_to(array: amplify.PolyArray, right: float, label: str = '', axis: Literal[None] = None) -> amplify.Constraint

        Args:
            * array (amplify.PolyArray):
            * right (float):
            * label (str): Defaults to ``''``.
            * axis (Literal[None] | None): Defaults to ``None``.

        Returns:
            amplify.Constraint:

    .. admonition:: 3. equal_to(array: amplify.PolyArray, right: float, label: str = '', axis: Optional[Union[int, tuple[int, ...]]] = None) -> Union[amplify.Constraint, amplify.ConstraintList]

        Args:
            * array (amplify.PolyArray):
            * right (float):
            * label (str): Defaults to ``''``.
            * axis (int | tuple[int, ...] | None): Defaults to ``None``.

        Returns:
            amplify.Constraint | amplify.ConstraintList:
    """

@overload
def greater_equal(
    poly: Poly,
    right: float,
    label: str = ...,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = ...,
) -> Constraint: ...
@overload
def greater_equal(
    array: PolyArray,
    right: float,
    label: str = ...,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = ...,
    axis: Literal[None] = ...,
) -> Constraint: ...
@overload
def greater_equal(
    array: PolyArray[_Dim0],
    right: float,
    label: str = ...,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = ...,
) -> Constraint: ...
@overload
def greater_equal(
    array: PolyArray[_Dim1],
    right: float,
    label: str = ...,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = ...,
    axis: Optional[Union[int, tuple[int]]] = ...,
) -> Constraint: ...
@overload
def greater_equal(
    array: PolyArray[_Dim2],
    right: float,
    label: str = ...,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = ...,
    axis: Optional[tuple[int, int]] = ...,
) -> Constraint: ...
@overload
def greater_equal(
    array: PolyArray[_Dim2],
    right: float,
    label: str = ...,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = ...,
    axis: Union[int, tuple[int]] = ...,
) -> ConstraintList: ...
@overload
def greater_equal(
    array: PolyArray[_Dim3],
    right: float,
    label: str = ...,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = ...,
    axis: Optional[tuple[int, int, int]] = ...,
) -> Constraint: ...
@overload
def greater_equal(
    array: PolyArray[_Dim3],
    right: float,
    label: str = ...,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = ...,
    axis: Union[int, tuple[int, ...]] = ...,
) -> ConstraintList: ...
@overload
def greater_equal(
    array: PolyArray[_Dim4],
    right: float,
    label: str = ...,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = ...,
    axis: Optional[tuple[int, int, int, int]] = ...,
) -> Constraint: ...
@overload
def greater_equal(
    array: PolyArray[_Dim4],
    right: float,
    label: str = ...,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = ...,
    axis: Union[int, tuple[int, ...]] = ...,
) -> ConstraintList: ...
@overload
def greater_equal(
    array: PolyArray,
    right: float,
    label: str = ...,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = ...,
    axis: tuple[()] = ...,
) -> ConstraintList: ...
@overload
def greater_equal(
    array: PolyArray,
    right: float,
    label: str = ...,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = ...,
    axis: Optional[Union[int, tuple[int, ...]]] = ...,
) -> Union[Constraint, ConstraintList]:
    """greater_equal

    :Overloading:

    .. admonition:: 1. greater_equal(poly: amplify.Poly, right: float, label: str = '', penalty_formulation: Union[str, amplify.PenaltyFormulation] = Default) -> amplify.Constraint

        Args:
            * poly (amplify.Poly):
            * right (float):
            * label (str): Defaults to ``''``.
            * penalty_formulation (str | amplify.PenaltyFormulation): Defaults to ``Default``.

        Returns:
            amplify.Constraint:

    .. admonition:: 2. greater_equal(array: amplify.PolyArray, right: float, label: str = '', penalty_formulation: Union[str, amplify.PenaltyFormulation] = Default, axis: Literal[None] = None) -> amplify.Constraint

        Args:
            * array (amplify.PolyArray):
            * right (float):
            * label (str): Defaults to ``''``.
            * penalty_formulation (str | amplify.PenaltyFormulation): Defaults to ``Default``.
            * axis (Literal[None] | None): Defaults to ``None``.

        Returns:
            amplify.Constraint:

    .. admonition:: 3. greater_equal(array: amplify.PolyArray, right: float, label: str = '', penalty_formulation: Union[str, amplify.PenaltyFormulation] = Default, axis: Optional[Union[int, tuple[int, ...]]] = None) -> Union[amplify.Constraint, amplify.ConstraintList]

        Args:
            * array (amplify.PolyArray):
            * right (float):
            * label (str): Defaults to ``''``.
            * penalty_formulation (str | amplify.PenaltyFormulation): Defaults to ``Default``.
            * axis (int | tuple[int, ...] | None): Defaults to ``None``.

        Returns:
            amplify.Constraint | amplify.ConstraintList:
    """

@overload
def less_equal(
    poly: Poly,
    right: float,
    label: str = ...,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = ...,
) -> Constraint: ...
@overload
def less_equal(
    array: PolyArray,
    right: float,
    label: str = ...,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = ...,
    axis: Literal[None] = ...,
) -> Constraint: ...
@overload
def less_equal(
    array: PolyArray[_Dim0],
    right: float,
    label: str = ...,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = ...,
) -> Constraint: ...
@overload
def less_equal(
    array: PolyArray[_Dim1],
    right: float,
    label: str = ...,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = ...,
    axis: Optional[Union[int, tuple[int]]] = ...,
) -> Constraint: ...
@overload
def less_equal(
    array: PolyArray[_Dim2],
    right: float,
    label: str = ...,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = ...,
    axis: Optional[tuple[int, int]] = ...,
) -> Constraint: ...
@overload
def less_equal(
    array: PolyArray[_Dim2],
    right: float,
    label: str = ...,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = ...,
    axis: Union[int, tuple[int]] = ...,
) -> ConstraintList: ...
@overload
def less_equal(
    array: PolyArray[_Dim3],
    right: float,
    label: str = ...,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = ...,
    axis: Optional[tuple[int, int, int]] = ...,
) -> Constraint: ...
@overload
def less_equal(
    array: PolyArray[_Dim3],
    right: float,
    label: str = ...,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = ...,
    axis: Union[int, tuple[int, ...]] = ...,
) -> ConstraintList: ...
@overload
def less_equal(
    array: PolyArray[_Dim4],
    right: float,
    label: str = ...,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = ...,
    axis: Optional[tuple[int, int, int, int]] = ...,
) -> Constraint: ...
@overload
def less_equal(
    array: PolyArray[_Dim4],
    right: float,
    label: str = ...,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = ...,
    axis: Union[int, tuple[int, ...]] = ...,
) -> ConstraintList: ...
@overload
def less_equal(
    array: PolyArray,
    right: float,
    label: str = ...,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = ...,
    axis: tuple[()] = ...,
) -> ConstraintList: ...
@overload
def less_equal(
    array: PolyArray,
    right: float,
    label: str = ...,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = ...,
    axis: Optional[Union[int, tuple[int, ...]]] = ...,
) -> Union[Constraint, ConstraintList]:
    """less_equal

    :Overloading:

    .. admonition:: 1. less_equal(poly: amplify.Poly, right: float, label: str = '', penalty_formulation: Union[str, amplify.PenaltyFormulation] = Default) -> amplify.Constraint

        Args:
            * poly (amplify.Poly):
            * right (float):
            * label (str): Defaults to ``''``.
            * penalty_formulation (str | amplify.PenaltyFormulation): Defaults to ``Default``.

        Returns:
            amplify.Constraint:

    .. admonition:: 2. less_equal(array: amplify.PolyArray, right: float, label: str = '', penalty_formulation: Union[str, amplify.PenaltyFormulation] = Default, axis: Literal[None] = None) -> amplify.Constraint

        Args:
            * array (amplify.PolyArray):
            * right (float):
            * label (str): Defaults to ``''``.
            * penalty_formulation (str | amplify.PenaltyFormulation): Defaults to ``Default``.
            * axis (Literal[None] | None): Defaults to ``None``.

        Returns:
            amplify.Constraint:

    .. admonition:: 3. less_equal(array: amplify.PolyArray, right: float, label: str = '', penalty_formulation: Union[str, amplify.PenaltyFormulation] = Default, axis: Optional[Union[int, tuple[int, ...]]] = None) -> Union[amplify.Constraint, amplify.ConstraintList]

        Args:
            * array (amplify.PolyArray):
            * right (float):
            * label (str): Defaults to ``''``.
            * penalty_formulation (str | amplify.PenaltyFormulation): Defaults to ``Default``.
            * axis (int | tuple[int, ...] | None): Defaults to ``None``.

        Returns:
            amplify.Constraint | amplify.ConstraintList:
    """

@overload
def matmul(arg0: PolyArray, arg1: Union[PolyArray, numpy.ndarray]) -> Union[Poly, PolyArray]: ...
@overload
def matmul(arg0: numpy.ndarray, arg1: PolyArray) -> Union[Poly, PolyArray]:
    """matmul

    :Overloading:

    .. admonition:: 1. matmul(arg0: amplify.PolyArray, arg1: Union[amplify.PolyArray, numpy.ndarray], /) -> Union[amplify.Poly, amplify.PolyArray]

        Args:
            * arg0 (amplify.PolyArray):
            * arg1 (amplify.PolyArray | numpy.ndarray):

        Returns:
            amplify.Poly | amplify.PolyArray:

    .. admonition:: 2. matmul(arg0: numpy.ndarray, arg1: amplify.PolyArray, /) -> Union[amplify.Poly, amplify.PolyArray]

        Args:
            * arg0 (numpy.ndarray):
            * arg1 (amplify.PolyArray):

        Returns:
            amplify.Poly | amplify.PolyArray:
    """

@overload
def one_hot(poly: Poly, label: str = ...) -> Constraint: ...
@overload
def one_hot(array: PolyArray, label: str = ..., axis: Literal[None] = ...) -> Constraint: ...
@overload
def one_hot(array: PolyArray[_Dim0], label: str = ...) -> Constraint: ...
@overload
def one_hot(array: PolyArray[_Dim1], label: str = ..., axis: Optional[Union[int, tuple[int]]] = ...) -> Constraint: ...
@overload
def one_hot(array: PolyArray[_Dim2], label: str = ..., axis: Optional[tuple[int, int]] = ...) -> Constraint: ...
@overload
def one_hot(array: PolyArray[_Dim2], label: str = ..., axis: Union[int, tuple[int]] = ...) -> ConstraintList: ...
@overload
def one_hot(array: PolyArray[_Dim3], label: str = ..., axis: Optional[tuple[int, int, int]] = ...) -> Constraint: ...
@overload
def one_hot(array: PolyArray[_Dim3], label: str = ..., axis: Union[int, tuple[int, ...]] = ...) -> ConstraintList: ...
@overload
def one_hot(
    array: PolyArray[_Dim4], label: str = ..., axis: Optional[tuple[int, int, int, int]] = ...
) -> Constraint: ...
@overload
def one_hot(array: PolyArray[_Dim4], label: str = ..., axis: Union[int, tuple[int, ...]] = ...) -> ConstraintList: ...
@overload
def one_hot(array: PolyArray, label: str = ..., axis: tuple[()] = ...) -> ConstraintList: ...
@overload
def one_hot(
    array: PolyArray, label: str = ..., axis: Optional[Union[int, tuple[int, ...]]] = ...
) -> Union[Constraint, ConstraintList]:
    """one_hot

    :Overloading:

    .. admonition:: 1. one_hot(poly: amplify.Poly, label: str = '') -> amplify.Constraint

        Args:
            * poly (amplify.Poly):
            * label (str): Defaults to ``''``.

        Returns:
            amplify.Constraint:

    .. admonition:: 2. one_hot(array: amplify.PolyArray, label: str = '', axis: Literal[None] = None) -> amplify.Constraint

        Args:
            * array (amplify.PolyArray):
            * label (str): Defaults to ``''``.
            * axis (Literal[None] | None): Defaults to ``None``.

        Returns:
            amplify.Constraint:

    .. admonition:: 3. one_hot(array: amplify.PolyArray, label: str = '', axis: Optional[Union[int, tuple[int, ...]]] = None) -> Union[amplify.Constraint, amplify.ConstraintList]

        Args:
            * array (amplify.PolyArray):
            * label (str): Defaults to ``''``.
            * axis (int | tuple[int, ...] | None): Defaults to ``None``.

        Returns:
            amplify.Constraint | amplify.ConstraintList:
    """

@overload
def parallel_solve(
    model: Union[Model, List[Model]],
    client: Union[
        Union[
            FixstarsClient,
            DWaveSamplerClient,
            LeapHybridSamplerClient,
            LeapHybridCQMSamplerClient,
            FujitsuDA4Client,
            ToshibaSQBM2Client,
            GurobiClient,
            NECVA2Client,
            DASClient,
        ],
        List[
            Union[
                FixstarsClient,
                DWaveSamplerClient,
                LeapHybridSamplerClient,
                LeapHybridCQMSamplerClient,
                FujitsuDA4Client,
                ToshibaSQBM2Client,
                GurobiClient,
                NECVA2Client,
                DASClient,
            ]
        ],
    ],
    integer_encoding_method: Union[
        Literal["Unary", "Linear", "Binary", "Default"],
        IntegerEncodingMethod,
        List[Union[Literal["Unary", "Linear", "Binary", "Default"], IntegerEncodingMethod]],
    ] = ...,
    quadratization_method: Union[
        Literal["IshikawaKZFD", "Substitute"],
        QuadratizationMethod,
        List[Union[Literal["IshikawaKZFD", "Substitute"], QuadratizationMethod]],
    ] = ...,
    substitution_multiplier: Union[float, List[float]] = ...,
    embedding_method: Union[
        Literal["Default", "Clique", "Minor", "Parallel"],
        EmbeddingMethod,
        List[Union[Literal["Default", "Clique", "Minor", "Parallel"], EmbeddingMethod]],
    ] = ...,
    embedding_timeout: Union[float, datetime.timedelta, List[Union[float, datetime.timedelta]]] = ...,
    chain_strength: Union[float, List[float]] = ...,
    dry_run: Union[bool, List[bool]] = ...,
    num_solves: Union[int, List[int]] = ...,
    filter_solution: Union[bool, List[bool]] = ...,
    sort_solution: Union[bool, List[bool]] = ...,
    concurrency: int = ...,
) -> list[Optional[Result]]: ...
@overload
def parallel_solve(
    model: Union[
        Union[Poly, Matrix, Constraint, ConstraintList], List[Union[Poly, Matrix, Constraint, ConstraintList]]
    ],
    client: Union[
        Union[
            FixstarsClient,
            DWaveSamplerClient,
            LeapHybridSamplerClient,
            LeapHybridCQMSamplerClient,
            FujitsuDA4Client,
            ToshibaSQBM2Client,
            GurobiClient,
            NECVA2Client,
            DASClient,
        ],
        List[
            Union[
                FixstarsClient,
                DWaveSamplerClient,
                LeapHybridSamplerClient,
                LeapHybridCQMSamplerClient,
                FujitsuDA4Client,
                ToshibaSQBM2Client,
                GurobiClient,
                NECVA2Client,
                DASClient,
            ]
        ],
    ],
    integer_encoding_method: Union[
        Literal["Unary", "Linear", "Binary", "Default"],
        IntegerEncodingMethod,
        List[Union[Literal["Unary", "Linear", "Binary", "Default"], IntegerEncodingMethod]],
    ] = ...,
    quadratization_method: Union[
        Literal["IshikawaKZFD", "Substitute"],
        QuadratizationMethod,
        List[Union[Literal["IshikawaKZFD", "Substitute"], QuadratizationMethod]],
    ] = ...,
    substitution_multiplier: Union[float, List[float]] = ...,
    embedding_method: Union[
        Literal["Default", "Clique", "Minor", "Parallel"],
        EmbeddingMethod,
        List[Union[Literal["Default", "Clique", "Minor", "Parallel"], EmbeddingMethod]],
    ] = ...,
    embedding_timeout: Union[float, datetime.timedelta, List[Union[float, datetime.timedelta]]] = ...,
    chain_strength: Union[float, List[float]] = ...,
    dry_run: Union[bool, List[bool]] = ...,
    num_solves: Union[int, List[int]] = ...,
    filter_solution: Union[bool, List[bool]] = ...,
    sort_solution: Union[bool, List[bool]] = ...,
    concurrency: int = ...,
) -> list[Optional[Result]]:
    """parallel_solve

    :Overloading:

    .. admonition:: 1. parallel_solve(model: Union[amplify.Model, List[amplify.Model]], client: Union[Union[amplify.FixstarsClient, amplify.DWaveSamplerClient, amplify.LeapHybridSamplerClient, amplify.LeapHybridCQMSamplerClient, amplify.FujitsuDA4Client, amplify.ToshibaSQBM2Client, amplify.GurobiClient, amplify.NECVA2Client, amplify.DASClient], List[Union[amplify.FixstarsClient, amplify.DWaveSamplerClient, amplify.LeapHybridSamplerClient, amplify.LeapHybridCQMSamplerClient, amplify.FujitsuDA4Client, amplify.ToshibaSQBM2Client, amplify.GurobiClient, amplify.NECVA2Client, amplify.DASClient]]], integer_encoding_method: Union[str, amplify.IntegerEncodingMethod, List[Union[str, amplify.IntegerEncodingMethod]]] = Default, quadratization_method: Union[str, amplify.QuadratizationMethod, List[Union[str, amplify.QuadratizationMethod]]] = IshikawaKZFD, substitution_multiplier: Union[float, List[float]] = 1.0, embedding_method: Union[str, amplify.EmbeddingMethod, List[Union[str, amplify.EmbeddingMethod]]] = Default, embedding_timeout: Union[float, datetime.timedelta, List[Union[float, datetime.timedelta]]] = 10.0, chain_strength: Union[float, List[float]] = 1.0, dry_run: Union[bool, List[bool]] = False, num_solves: Union[int, List[int]] = 1, filter_solution: Union[bool, List[bool]] = True, sort_solution: Union[bool, List[bool]] = True, concurrency: int = 0) -> list[Optional[amplify.Result]]

        Args:
            * model (amplify.Model | List[amplify.Model]):
            * client (amplify.FixstarsClient | amplify.DWaveSamplerClient | amplify.LeapHybridSamplerClient | amplify.LeapHybridCQMSamplerClient | amplify.FujitsuDA4Client | amplify.ToshibaSQBM2Client | amplify.GurobiClient | amplify.NECVA2Client | amplify.DASClient | List[Union[amplify.FixstarsClient, amplify.DWaveSamplerClient, amplify.LeapHybridSamplerClient, amplify.LeapHybridCQMSamplerClient, amplify.FujitsuDA4Client, amplify.ToshibaSQBM2Client, amplify.GurobiClient, amplify.NECVA2Client, amplify.DASClient]]):
            * integer_encoding_method (str | amplify.IntegerEncodingMethod | List[Union[str, amplify.IntegerEncodingMethod]]): Defaults to ``Default``.
            * quadratization_method (str | amplify.QuadratizationMethod | List[Union[str, amplify.QuadratizationMethod]]): Defaults to ``IshikawaKZFD``.
            * substitution_multiplier (float | List[float]): Defaults to ``1.0``.
            * embedding_method (str | amplify.EmbeddingMethod | List[Union[str, amplify.EmbeddingMethod]]): Defaults to ``Default``.
            * embedding_timeout (float | datetime.timedelta | List[Union[float, datetime.timedelta]]): Defaults to ``10.0``.
            * chain_strength (float | List[float]): Defaults to ``1.0``.
            * dry_run (bool | List[bool]): Defaults to ``False``.
            * num_solves (int | List[int]): Defaults to ``1``.
            * filter_solution (bool | List[bool]): Defaults to ``True``.
            * sort_solution (bool | List[bool]): Defaults to ``True``.
            * concurrency (int): Defaults to ``0``.

        Returns:
            list[Optional[amplify.Result]]:

    .. admonition:: 2. parallel_solve(model: Union[Union[amplify.Poly, amplify.Matrix, amplify.Constraint, amplify.ConstraintList], List[Union[amplify.Poly, amplify.Matrix, amplify.Constraint, amplify.ConstraintList]]], client: Union[Union[amplify.FixstarsClient, amplify.DWaveSamplerClient, amplify.LeapHybridSamplerClient, amplify.LeapHybridCQMSamplerClient, amplify.FujitsuDA4Client, amplify.ToshibaSQBM2Client, amplify.GurobiClient, amplify.NECVA2Client, amplify.DASClient], List[Union[amplify.FixstarsClient, amplify.DWaveSamplerClient, amplify.LeapHybridSamplerClient, amplify.LeapHybridCQMSamplerClient, amplify.FujitsuDA4Client, amplify.ToshibaSQBM2Client, amplify.GurobiClient, amplify.NECVA2Client, amplify.DASClient]]], integer_encoding_method: Union[str, amplify.IntegerEncodingMethod, List[Union[str, amplify.IntegerEncodingMethod]]] = Default, quadratization_method: Union[str, amplify.QuadratizationMethod, List[Union[str, amplify.QuadratizationMethod]]] = IshikawaKZFD, substitution_multiplier: Union[float, List[float]] = 1.0, embedding_method: Union[str, amplify.EmbeddingMethod, List[Union[str, amplify.EmbeddingMethod]]] = Default, embedding_timeout: Union[float, datetime.timedelta, List[Union[float, datetime.timedelta]]] = 10.0, chain_strength: Union[float, List[float]] = 1.0, dry_run: Union[bool, List[bool]] = False, num_solves: Union[int, List[int]] = 1, filter_solution: Union[bool, List[bool]] = True, sort_solution: Union[bool, List[bool]] = True, concurrency: int = 0) -> list[Optional[amplify.Result]]

        Args:
            * model (amplify.Poly | amplify.Matrix | amplify.Constraint | amplify.ConstraintList | List[Union[amplify.Poly, amplify.Matrix, amplify.Constraint, amplify.ConstraintList]]):
            * client (amplify.FixstarsClient | amplify.DWaveSamplerClient | amplify.LeapHybridSamplerClient | amplify.LeapHybridCQMSamplerClient | amplify.FujitsuDA4Client | amplify.ToshibaSQBM2Client | amplify.GurobiClient | amplify.NECVA2Client | amplify.DASClient | List[Union[amplify.FixstarsClient, amplify.DWaveSamplerClient, amplify.LeapHybridSamplerClient, amplify.LeapHybridCQMSamplerClient, amplify.FujitsuDA4Client, amplify.ToshibaSQBM2Client, amplify.GurobiClient, amplify.NECVA2Client, amplify.DASClient]]):
            * integer_encoding_method (str | amplify.IntegerEncodingMethod | List[Union[str, amplify.IntegerEncodingMethod]]): Defaults to ``Default``.
            * quadratization_method (str | amplify.QuadratizationMethod | List[Union[str, amplify.QuadratizationMethod]]): Defaults to ``IshikawaKZFD``.
            * substitution_multiplier (float | List[float]): Defaults to ``1.0``.
            * embedding_method (str | amplify.EmbeddingMethod | List[Union[str, amplify.EmbeddingMethod]]): Defaults to ``Default``.
            * embedding_timeout (float | datetime.timedelta | List[Union[float, datetime.timedelta]]): Defaults to ``10.0``.
            * chain_strength (float | List[float]): Defaults to ``1.0``.
            * dry_run (bool | List[bool]): Defaults to ``False``.
            * num_solves (int | List[int]): Defaults to ``1``.
            * filter_solution (bool | List[bool]): Defaults to ``True``.
            * sort_solution (bool | List[bool]): Defaults to ``True``.
            * concurrency (int): Defaults to ``0``.

        Returns:
            list[Optional[amplify.Result]]:
    """

def set_num_threads(arg: int) -> None:
    """set_num_threads

    Args:
        arg (int):
    """

@overload
def solve(
    model: Model,
    client: _AmplifyClient,
    integer_encoding_method: Union[Literal["Unary", "Linear", "Binary", "Default"], IntegerEncodingMethod] = ...,
    quadratization_method: Union[Literal["IshikawaKZFD", "Substitute"], QuadratizationMethod] = ...,
    substitution_multiplier: float = ...,
    embedding_method: Union[Literal["Default", "Clique", "Minor", "Parallel"], EmbeddingMethod] = ...,
    embedding_timeout: Union[float, datetime.timedelta] = ...,
    chain_strength: float = ...,
    dry_run: Literal[False] = ...,
    num_solves: int = ...,
    filter_solution: bool = ...,
    sort_solution: bool = ...,
) -> Result[_AmplifyClient]: ...
@overload
def solve(
    model: Model,
    client: _AmplifyClient,
    integer_encoding_method: Union[Literal["Unary", "Linear", "Binary", "Default"], IntegerEncodingMethod] = ...,
    quadratization_method: Union[Literal["IshikawaKZFD", "Substitute"], QuadratizationMethod] = ...,
    substitution_multiplier: float = ...,
    embedding_method: Union[Literal["Default", "Clique", "Minor", "Parallel"], EmbeddingMethod] = ...,
    embedding_timeout: Union[float, datetime.timedelta] = ...,
    chain_strength: float = ...,
    dry_run: Literal[True] = ...,
    num_solves: int = ...,
    filter_solution: bool = ...,
    sort_solution: bool = ...,
) -> Result[Literal[None]]: ...
@overload
def solve(
    model: Model,
    client: _AmplifyClient,
    integer_encoding_method: Union[Literal["Unary", "Linear", "Binary", "Default"], IntegerEncodingMethod] = ...,
    quadratization_method: Union[Literal["IshikawaKZFD", "Substitute"], QuadratizationMethod] = ...,
    substitution_multiplier: float = ...,
    embedding_method: Union[Literal["Default", "Clique", "Minor", "Parallel"], EmbeddingMethod] = ...,
    embedding_timeout: Union[float, datetime.timedelta] = ...,
    chain_strength: float = ...,
    dry_run: bool = ...,
    num_solves: int = ...,
    filter_solution: bool = ...,
    sort_solution: bool = ...,
) -> Union[Result[_AmplifyClient], Result[Literal[None]]]: ...
@overload
def solve(
    model: Union[Poly, Matrix, Constraint, ConstraintList],
    client: _AmplifyClient,
    integer_encoding_method: Union[Literal["Unary", "Linear", "Binary", "Default"], IntegerEncodingMethod] = ...,
    quadratization_method: Union[Literal["IshikawaKZFD", "Substitute"], QuadratizationMethod] = ...,
    substitution_multiplier: float = ...,
    embedding_method: Union[Literal["Default", "Clique", "Minor", "Parallel"], EmbeddingMethod] = ...,
    embedding_timeout: Union[float, datetime.timedelta] = ...,
    chain_strength: float = ...,
    dry_run: Literal[False] = ...,
    num_solves: int = ...,
    filter_solution: bool = ...,
    sort_solution: bool = ...,
) -> Result[_AmplifyClient]: ...
@overload
def solve(
    model: Union[Poly, Matrix, Constraint, ConstraintList],
    client: _AmplifyClient,
    integer_encoding_method: Union[Literal["Unary", "Linear", "Binary", "Default"], IntegerEncodingMethod] = ...,
    quadratization_method: Union[Literal["IshikawaKZFD", "Substitute"], QuadratizationMethod] = ...,
    substitution_multiplier: float = ...,
    embedding_method: Union[Literal["Default", "Clique", "Minor", "Parallel"], EmbeddingMethod] = ...,
    embedding_timeout: Union[float, datetime.timedelta] = ...,
    chain_strength: float = ...,
    dry_run: Literal[True] = ...,
    num_solves: int = ...,
    filter_solution: bool = ...,
    sort_solution: bool = ...,
) -> Result[Literal[None]]: ...
@overload
def solve(
    model: Union[Poly, Matrix, Constraint, ConstraintList],
    client: _AmplifyClient,
    integer_encoding_method: Union[Literal["Unary", "Linear", "Binary", "Default"], IntegerEncodingMethod] = ...,
    quadratization_method: Union[Literal["IshikawaKZFD", "Substitute"], QuadratizationMethod] = ...,
    substitution_multiplier: float = ...,
    embedding_method: Union[Literal["Default", "Clique", "Minor", "Parallel"], EmbeddingMethod] = ...,
    embedding_timeout: Union[float, datetime.timedelta] = ...,
    chain_strength: float = ...,
    dry_run: bool = ...,
    num_solves: int = ...,
    filter_solution: bool = ...,
    sort_solution: bool = ...,
) -> Union[Result[_AmplifyClient], Result[Literal[None]]]:
    """solve

    :Overloading:

    .. admonition:: 1. solve(model: amplify.Model, client: Union[amplify.FixstarsClient, amplify.DWaveSamplerClient, amplify.LeapHybridSamplerClient, amplify.LeapHybridCQMSamplerClient, amplify.FujitsuDA4Client, amplify.ToshibaSQBM2Client, amplify.GurobiClient, amplify.NECVA2Client, amplify.DASClient], integer_encoding_method: Union[str, amplify.IntegerEncodingMethod] = Default, quadratization_method: Union[str, amplify.QuadratizationMethod] = IshikawaKZFD, substitution_multiplier: float = 1.0, embedding_method: Union[str, amplify.EmbeddingMethod] = Default, embedding_timeout: Union[float, datetime.timedelta] = 10.0, chain_strength: float = 1.0, dry_run: bool = False, num_solves: int = 1, filter_solution: bool = True, sort_solution: bool = True) -> amplify.Result

        Args:
            * model (amplify.Model):
            * client (amplify.FixstarsClient | amplify.DWaveSamplerClient | amplify.LeapHybridSamplerClient | amplify.LeapHybridCQMSamplerClient | amplify.FujitsuDA4Client | amplify.ToshibaSQBM2Client | amplify.GurobiClient | amplify.NECVA2Client | amplify.DASClient):
            * integer_encoding_method (str | amplify.IntegerEncodingMethod): Defaults to ``Default``.
            * quadratization_method (str | amplify.QuadratizationMethod): Defaults to ``IshikawaKZFD``.
            * substitution_multiplier (float): Defaults to ``1.0``.
            * embedding_method (str | amplify.EmbeddingMethod): Defaults to ``Default``.
            * embedding_timeout (float | datetime.timedelta): Defaults to ``10.0``.
            * chain_strength (float): Defaults to ``1.0``.
            * dry_run (bool): Defaults to ``False``.
            * num_solves (int): Defaults to ``1``.
            * filter_solution (bool): Defaults to ``True``.
            * sort_solution (bool): Defaults to ``True``.

        Returns:
            amplify.Result:

    .. admonition:: 2. solve(model: Union[amplify.Poly, amplify.Matrix, amplify.Constraint, amplify.ConstraintList], client: Union[amplify.FixstarsClient, amplify.DWaveSamplerClient, amplify.LeapHybridSamplerClient, amplify.LeapHybridCQMSamplerClient, amplify.FujitsuDA4Client, amplify.ToshibaSQBM2Client, amplify.GurobiClient, amplify.NECVA2Client, amplify.DASClient], integer_encoding_method: Union[str, amplify.IntegerEncodingMethod] = Default, quadratization_method: Union[str, amplify.QuadratizationMethod] = IshikawaKZFD, substitution_multiplier: float = 1.0, embedding_method: Union[str, amplify.EmbeddingMethod] = Default, embedding_timeout: Union[float, datetime.timedelta] = 10.0, chain_strength: float = 1.0, dry_run: bool = False, num_solves: int = 1, filter_solution: bool = True, sort_solution: bool = True) -> amplify.Result

        Args:
            * model (amplify.Poly | amplify.Matrix | amplify.Constraint | amplify.ConstraintList):
            * client (amplify.FixstarsClient | amplify.DWaveSamplerClient | amplify.LeapHybridSamplerClient | amplify.LeapHybridCQMSamplerClient | amplify.FujitsuDA4Client | amplify.ToshibaSQBM2Client | amplify.GurobiClient | amplify.NECVA2Client | amplify.DASClient):
            * integer_encoding_method (str | amplify.IntegerEncodingMethod): Defaults to ``Default``.
            * quadratization_method (str | amplify.QuadratizationMethod): Defaults to ``IshikawaKZFD``.
            * substitution_multiplier (float): Defaults to ``1.0``.
            * embedding_method (str | amplify.EmbeddingMethod): Defaults to ``Default``.
            * embedding_timeout (float | datetime.timedelta): Defaults to ``10.0``.
            * chain_strength (float): Defaults to ``1.0``.
            * dry_run (bool): Defaults to ``False``.
            * num_solves (int): Defaults to ``1``.
            * filter_solution (bool): Defaults to ``True``.
            * sort_solution (bool): Defaults to ``True``.

        Returns:
            amplify.Result:
    """

@overload
def sum(arg: Union[list[Union[Poly, float]], Iterator[Union[Poly, float]]]) -> Poly: ...
@overload
def sum(
    arg: Union[list[Union[Constraint, ConstraintList]], Iterator[Union[Constraint, ConstraintList]]],
) -> ConstraintList: ...
@overload
def sum(array: PolyArray) -> Poly: ...
@overload
def sum(array: PolyArray, axis: Literal[None]) -> Poly: ...
@overload
def sum(array: PolyArray[_Dim0]) -> Poly: ...
@overload
def sum(array: PolyArray[_Dim1], axis: Optional[Union[int, tuple[int]]]) -> Poly: ...
@overload
def sum(array: PolyArray[_Dim2], axis: Optional[tuple[int, int]]) -> Poly: ...
@overload
def sum(array: PolyArray[_Dim2], axis: Union[int, tuple[int]]) -> PolyArray[_Dim1]: ...
@overload
def sum(array: PolyArray[_Dim3], axis: Optional[tuple[int, int, int]]) -> Poly: ...
@overload
def sum(array: PolyArray[_Dim3], axis: tuple[int, int]) -> PolyArray[_Dim1]: ...
@overload
def sum(array: PolyArray[_Dim3], axis: Union[int, tuple[int]]) -> PolyArray[_Dim2]: ...
@overload
def sum(array: PolyArray[_Dim4], axis: Optional[tuple[int, int, int, int]]) -> Poly: ...
@overload
def sum(array: PolyArray[_Dim4], axis: tuple[int, int, int]) -> PolyArray[_Dim1]: ...
@overload
def sum(array: PolyArray[_Dim4], axis: tuple[int, int]) -> PolyArray[_Dim2]: ...
@overload
def sum(array: PolyArray[_Dim4], axis: Union[int, tuple[int]]) -> PolyArray[_Dim3]: ...
@overload
def sum(array: PolyArray[_NDim], axis: tuple[()]) -> PolyArray[_NDim]: ...
@overload
def sum(array: PolyArray, axis: Optional[Union[int, tuple[int, ...]]]) -> Union[Poly, PolyArray]: ...
@overload
def sum(stop: int, func: Callable[[int], Poly]) -> Poly: ...
@overload
def sum(start: int, stop: int, func: Callable[[int], Poly]) -> Poly: ...
@overload
def sum(start: int, stop: int, step: int, func: Callable[[int], Poly]) -> Poly: ...
@overload
def sum(sequence: Sequence[Any], func: Callable[[Any], Poly]) -> Poly: ...
@overload
def sum(iterable: Iterable[Any], func: Callable[[Any], Poly]) -> Poly: ...
@overload
def sum(iterator: Iterator[Any], func: Callable[[Any], Poly]) -> Poly: ...
@overload
def sum(*args, **kwargs) -> Any:
    """sum

    :Overloading:

    .. admonition:: 1. sum(arg: list, /) -> Any

        Args:
            * arg (list):

        Returns:
            Any:

    .. admonition:: 2. sum(arg: Iterator, /) -> Any

        Args:
            * arg (Iterator):

        Returns:
            Any:

    .. admonition:: 3. sum(array: amplify.PolyArray) -> amplify.Poly

        Args:
            * array (amplify.PolyArray):

        Returns:
            amplify.Poly:

    .. admonition:: 4. sum(array: amplify.PolyArray, axis: Literal[None]) -> amplify.Poly

        Args:
            * array (amplify.PolyArray):
            * axis (Literal[None] | None):

        Returns:
            amplify.Poly:

    .. admonition:: 5. sum(array: amplify.PolyArray, axis: Optional[Union[int, tuple[int, ...]]]) -> Union[amplify.Poly, amplify.PolyArray]

        Args:
            * array (amplify.PolyArray):
            * axis (int | tuple[int, ...] | None):

        Returns:
            amplify.Poly | amplify.PolyArray:

    .. admonition:: 6. sum(stop: int, func: Callable[[int], amplify.Poly]) -> amplify.Poly

        Args:
            * stop (int):
            * func (Callable[[int], amplify.Poly]):

        Returns:
            amplify.Poly:

    .. admonition:: 7. sum(start: int, stop: int, func: Callable[[int], amplify.Poly]) -> amplify.Poly

        Args:
            * start (int):
            * stop (int):
            * func (Callable[[int], amplify.Poly]):

        Returns:
            amplify.Poly:

    .. admonition:: 8. sum(start: int, stop: int, step: int, func: Callable[[int], amplify.Poly]) -> amplify.Poly

        Args:
            * start (int):
            * stop (int):
            * step (int):
            * func (Callable[[int], amplify.Poly]):

        Returns:
            amplify.Poly:

    .. admonition:: 9. sum(sequence: Sequence[Any], func: Callable[[Any], amplify.Poly]) -> amplify.Poly

        Args:
            * sequence (Sequence[Any]):
            * func (Callable[[Any], amplify.Poly]):

        Returns:
            amplify.Poly:

    .. admonition:: 10. sum(iterable: Iterable[Any], func: Callable[[Any], amplify.Poly]) -> amplify.Poly

        Args:
            * iterable (Iterable[Any]):
            * func (Callable[[Any], amplify.Poly]):

        Returns:
            amplify.Poly:

    .. admonition:: 11. sum(iterator: Iterator[Any], func: Callable[[Any], amplify.Poly]) -> amplify.Poly

        Args:
            * iterator (Iterator[Any]):
            * func (Callable[[Any], amplify.Poly]):

        Returns:
            amplify.Poly:

    .. admonition:: 12. sum(\\*args, \\*\\*kwargs) -> Any

        Args:
            * \\*args:
            * \\*\\*kwargs:

        Returns:
            Any:
    """

def to_edges(poly: Poly) -> List[Tuple[int, int]]:
    """to_edges

    Args:
        poly (amplify.Poly):

    Returns:
        List[Tuple[int, int]]:
    """

__version__: str
