"""
This type stub file was generated by pyright.
"""

import typing as t
import flask
import werkzeug.routing
from connexion import jsonifier
from connexion.frameworks.abstract import Framework
from connexion.lifecycle import WSGIRequest
from connexion.uri_parsing import AbstractURIParser

"""
This module defines functionality specific to the Flask framework.
"""
class Flask(Framework):
    @staticmethod
    def is_framework_response(response: t.Any) -> bool:
        ...
    
    @classmethod
    def connexion_to_framework_response(cls, response): # -> flask.wrappers.Response | werkzeug.sansio.response.Response:
        ...
    
    @classmethod
    def build_response(cls, data: t.Any, *, content_type: str = ..., headers: dict = ..., status_code: int = ...): # -> flask.wrappers.Response | werkzeug.sansio.response.Response:
        ...
    
    @staticmethod
    def get_request(*, uri_parser: AbstractURIParser, **kwargs) -> WSGIRequest:
        ...
    


PATH_PARAMETER = ...
PATH_PARAMETER_CONVERTERS = ...
def flaskify_endpoint(identifier, randomize=...): # -> str:
    """
    Converts the provided identifier in a valid flask endpoint name

    :type identifier: str
    :param randomize: If specified, add this many random characters (upper case
        and digits) to the endpoint name, separated by a pipe character.
    :type randomize: int | None
    :rtype: str

    """
    ...

def convert_path_parameter(match, types): # -> str:
    ...

def flaskify_path(swagger_path, types=...): # -> str:
    """
    Convert swagger path templates to flask path templates

    :type swagger_path: str
    :type types: dict
    :rtype: str

    >>> flaskify_path('/foo-bar/{my-param}')
    '/foo-bar/<my_param>'

    >>> flaskify_path('/foo/{someint}', {'someint': 'int'})
    '/foo/<int:someint>'
    """
    ...

class FlaskJSONProvider(flask.json.provider.DefaultJSONProvider):
    """Custom JSONProvider which adds connexion defaults on top of Flask's"""
    @jsonifier.wrap_default
    def default(self, o): # -> Any:
        ...
    


class NumberConverter(werkzeug.routing.BaseConverter):
    """Flask converter for OpenAPI number type"""
    regex = ...
    def to_python(self, value): # -> float:
        ...
    


class IntegerConverter(werkzeug.routing.BaseConverter):
    """Flask converter for OpenAPI integer type"""
    regex = ...
    def to_python(self, value): # -> int:
        ...
    


