# coding: utf-8

"""
    GroupDocs.Rewriter API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 24.4.0
    Contact: anton.perhunov@aspose.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from groupdocs_rewriter_cloud.models.http_status_code import HttpStatusCode

class ParaphraseTextResponse(BaseModel):
    """
    ParaphraseTextResponse
    """
    status: Optional[HttpStatusCode] = None
    message: Optional[StrictStr] = Field(None, description="Information about process")
    paraphrase_reult: Optional[StrictStr] = Field(None, alias="paraphraseReult")
    paraphrase_results: Optional[conlist(StrictStr)] = Field(None, alias="paraphraseResults")
    source_list: Optional[conlist(StrictStr)] = Field(None, alias="sourceList", description="Return tokenized source text")
    target_list: Optional[conlist(StrictStr)] = Field(None, alias="targetList", description="Return tokenized target text")
    __properties = ["status", "message", "paraphraseReult", "paraphraseResults", "sourceList", "targetList"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ParaphraseTextResponse:
        """Create an instance of ParaphraseTextResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if paraphrase_reult (nullable) is None
        # and __fields_set__ contains the field
        if self.paraphrase_reult is None and "paraphrase_reult" in self.__fields_set__:
            _dict['paraphraseReult'] = None

        # set to None if paraphrase_results (nullable) is None
        # and __fields_set__ contains the field
        if self.paraphrase_results is None and "paraphrase_results" in self.__fields_set__:
            _dict['paraphraseResults'] = None

        # set to None if source_list (nullable) is None
        # and __fields_set__ contains the field
        if self.source_list is None and "source_list" in self.__fields_set__:
            _dict['sourceList'] = None

        # set to None if target_list (nullable) is None
        # and __fields_set__ contains the field
        if self.target_list is None and "target_list" in self.__fields_set__:
            _dict['targetList'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ParaphraseTextResponse:
        """Create an instance of ParaphraseTextResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ParaphraseTextResponse.parse_obj(obj)

        _obj = ParaphraseTextResponse.parse_obj({
            "status": obj.get("status"),
            "message": obj.get("message"),
            "paraphrase_reult": obj.get("paraphraseReult"),
            "paraphrase_results": obj.get("paraphraseResults"),
            "source_list": obj.get("sourceList"),
            "target_list": obj.get("targetList")
        })
        return _obj

