# coding: utf-8

"""
    GroupDocs.Rewriter API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 24.4.0
    Contact: anton.perhunov@aspose.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist

class CloudTextRequest(BaseModel):
    """
    CloudTextRequest
    """
    language: Optional[StrictInt] = Field(None, description="Language of original text")
    text: Optional[StrictStr] = Field(None, description="Text to rewrite")
    action: Optional[StrictStr] = Field(None, description="Rewrite or summarize")
    texts: Optional[conlist(StrictStr)] = Field(None, description="Text array to rewrite")
    suggestions: Optional[StrictInt] = Field(None, description="Number of suggested variants, 3 maximum")
    diversity: Optional[StrictInt] = Field(None, description="Diversity of text")
    tokenize: Optional[StrictBool] = Field(None, description="Should source and target texts be returned in tokenized form")
    origin: Optional[StrictStr] = Field(None, description="for analysis only")
    request_id: Optional[StrictStr] = Field(None, alias="requestId")
    __properties = ["language", "text", "action", "texts", "suggestions", "diversity", "tokenize", "origin", "requestId"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CloudTextRequest:
        """Create an instance of CloudTextRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CloudTextRequest:
        """Create an instance of CloudTextRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CloudTextRequest.parse_obj(obj)

        _obj = CloudTextRequest.parse_obj({
            "language": obj.get("language"),
            "text": obj.get("text"),
            "action": obj.get("action"),
            "texts": obj.get("texts"),
            "suggestions": obj.get("suggestions"),
            "diversity": obj.get("diversity"),
            "tokenize": obj.get("tokenize"),
            "origin": obj.get("origin"),
            "request_id": obj.get("requestId")
        })
        return _obj

