# coding: utf-8

"""
    GroupDocs.Rewriter API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 24.4.0
    Contact: anton.perhunov@aspose.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr, constr
from groupdocs_rewriter_cloud.models.file_saving_mode import FileSavingMode
from groupdocs_rewriter_cloud.models.simplify_supported_fromats import SimplifySupportedFromats
from groupdocs_rewriter_cloud.models.supported_conversions_formats import SupportedConversionsFormats

class SimplifyFileRequest(BaseModel):
    """
    SimplifyFileRequest
    """
    language: constr(strict=True, min_length=1) = Field(..., description="Set language of text")
    url: Optional[StrictStr] = None
    origin: Optional[StrictStr] = Field(None, description="Information about SDK user, like a User-Agent")
    original_name: Optional[StrictStr] = Field(None, alias="originalName")
    saving_mode: Optional[FileSavingMode] = Field(None, alias="savingMode")
    output_format: SupportedConversionsFormats = Field(..., alias="outputFormat")
    format: Optional[SimplifySupportedFromats] = None
    __properties = ["language", "url", "origin", "originalName", "savingMode", "outputFormat", "format"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SimplifyFileRequest:
        """Create an instance of SimplifyFileRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SimplifyFileRequest:
        """Create an instance of SimplifyFileRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SimplifyFileRequest.parse_obj(obj)

        _obj = SimplifyFileRequest.parse_obj({
            "language": obj.get("language"),
            "url": obj.get("url"),
            "origin": obj.get("origin"),
            "original_name": obj.get("originalName"),
            "saving_mode": obj.get("savingMode"),
            "output_format": obj.get("outputFormat"),
            "format": obj.get("format")
        })
        return _obj

