"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileAssetPackaging = exports.AssetHashType = void 0;
/**
 * The type of asset hash
 *
 * NOTE: the hash is used in order to identify a specific revision of the asset, and
 * used for optimizing and caching deployment activities related to this asset such as
 * packaging, uploading to Amazon S3, etc.
 */
var AssetHashType;
(function (AssetHashType) {
    /**
     * Based on the content of the source path
     *
     * When bundling, use `SOURCE` when the content of the bundling output is not
     * stable across repeated bundling operations.
     */
    AssetHashType["SOURCE"] = "source";
    /**
     * Based on the content of the bundled path
     *
     * @deprecated use `OUTPUT` instead
     */
    AssetHashType["BUNDLE"] = "bundle";
    /**
     * Based on the content of the bundling output
     *
     * Use `OUTPUT` when the source of the asset is a top level folder containing
     * code and/or dependencies that are not directly linked to the asset.
     */
    AssetHashType["OUTPUT"] = "output";
    /**
     * Use a custom hash
     */
    AssetHashType["CUSTOM"] = "custom";
})(AssetHashType = exports.AssetHashType || (exports.AssetHashType = {}));
/**
 * Packaging modes for file assets.
 */
var FileAssetPackaging;
(function (FileAssetPackaging) {
    /**
     * The asset source path points to a directory, which should be archived using
     * zip and and then uploaded to Amazon S3.
     */
    FileAssetPackaging["ZIP_DIRECTORY"] = "zip";
    /**
     * The asset source path points to a single file, which should be uploaded
     * to Amazon S3.
     */
    FileAssetPackaging["FILE"] = "file";
})(FileAssetPackaging = exports.FileAssetPackaging || (exports.FileAssetPackaging = {}));
//# sourceMappingURL=data:application/json;base64,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