"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnRule = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cfn_element_1 = require("./cfn-element");
const util_1 = require("./util");
/**
 * The Rules that define template constraints in an AWS Service Catalog portfolio describe when
 * end users can use the template and which values they can specify for parameters that are declared
 * in the AWS CloudFormation template used to create the product they are attempting to use. Rules
 * are useful for preventing end users from inadvertently specifying an incorrect value.
 * For example, you can add a rule to verify whether end users specified a valid subnet in a
 * given VPC or used m1.small instance types for test environments. AWS CloudFormation uses
 * rules to validate parameter values before it creates the resources for the product.
 *
 * A rule can include a RuleCondition property and must include an Assertions property.
 * For each rule, you can define only one rule condition; you can define one or more asserts within the Assertions property.
 * You define a rule condition and assertions by using rule-specific intrinsic functions.
 *
 * @link https://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html
 */
class CfnRule extends cfn_element_1.CfnRefElement {
    /**
     * Creates and adds a rule.
     * @param scope The parent construct.
     * @param props The rule props.
     */
    constructor(scope, id, props) {
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_core_CfnRuleProps(props);
        this.ruleCondition = props && props.ruleCondition;
        this.assertions = props && props.assertions;
    }
    /**
     * Adds an assertion to the rule.
     * @param condition The expression to evaluation.
     * @param description The description of the assertion.
     */
    addAssertion(condition, description) {
        jsiiDeprecationWarnings._aws_cdk_core_ICfnConditionExpression(condition);
        if (!this.assertions) {
            this.assertions = [];
        }
        this.assertions.push({
            assert: condition,
            assertDescription: description,
        });
    }
    /**
     * @internal
     */
    _toCloudFormation() {
        return {
            Rules: {
                [this.logicalId]: {
                    RuleCondition: this.ruleCondition,
                    Assertions: util_1.capitalizePropertyNames(this, this.assertions),
                },
            },
        };
    }
}
exports.CfnRule = CfnRule;
_a = JSII_RTTI_SYMBOL_1;
CfnRule[_a] = { fqn: "@aws-cdk/core.CfnRule", version: "1.147.0" };
//# sourceMappingURL=data:application/json;base64,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