"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FeatureFlags = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cxapi = require("@aws-cdk/cx-api");
/**
 * Features that are implemented behind a flag in order to preserve backwards
 * compatibility for existing apps. The list of flags are available in the
 * `@aws-cdk/cx-api` module.
 *
 * The state of the flag for this application is stored as a CDK context variable.
 */
class FeatureFlags {
    constructor(construct) {
        this.construct = construct;
    }
    /**
     * Inspect feature flags on the construct node's context.
     */
    static of(scope) {
        jsiiDeprecationWarnings._aws_cdk_core_Construct(scope);
        return new FeatureFlags(scope);
    }
    /**
     * Check whether a feature flag is enabled. If configured, the flag is present in
     * the construct node context. Falls back to the defaults defined in the `cx-api`
     * module.
     */
    isEnabled(featureFlag) {
        const context = this.construct.node.tryGetContext(featureFlag);
        if (cxapi.FUTURE_FLAGS_EXPIRED.includes(featureFlag)) {
            if (context !== undefined) {
                throw new Error(`Unsupported feature flag '${featureFlag}'. This flag existed on CDKv1 but has been removed in CDKv2.`
                    + ' CDK will now behave as the same as when the flag is enabled.');
            }
            return true;
        }
        return context !== null && context !== void 0 ? context : cxapi.futureFlagDefault(featureFlag);
    }
}
exports.FeatureFlags = FeatureFlags;
_a = JSII_RTTI_SYMBOL_1;
FeatureFlags[_a] = { fqn: "@aws-cdk/core.FeatureFlags", version: "1.147.0" };
//# sourceMappingURL=data:application/json;base64,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