"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/cdk");
const s3 = require("../lib");
// Define a stack with an S3 bucket and export it using `bucket.export()`.
// bucket.export returns an `IBucket` object which can later be used in
// `Bucket.import`.
class Producer extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        const bucket = new s3.Bucket(this, 'MyBucket');
        this.myBucketRef = bucket.export();
    }
}
class ConsumerConstruct extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        props.bucket.addToResourcePolicy(new iam.PolicyStatement().addAction('*'));
    }
}
class Consumer extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id);
        const user = new iam.User(this, 'MyUser');
        const userBucket = s3.Bucket.import(this, 'ImportBucket', props.userBucketRef);
        new ConsumerConstruct(this, 'SomeConstruct', { bucket: userBucket });
        userBucket.grantReadWrite(user);
    }
}
// -------------------------------------------------------
// NOTE: To deploy this, just run `cdk -a "node file.js" deploy`. The stacks
// will be deployed IN-ORDER which means that the producer will be deployed
// first. In the future the toolkit will be able to understand the relationships
// between the stacks and will deploy them in order.
const app = new cdk.App();
const producer = new Producer(app, 'produce');
new Consumer(app, 'consume', {
    userBucketRef: producer.myBucketRef
});
app.run();
//# sourceMappingURL=data:application/json;base64,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