"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CreateSalesInvoiceStatusRequest(str, Enum):
    r"""The status for the invoice to end up in.

    A `draft` invoice is not paid or not sent and can be updated after creation. Setting it to `issued` sends it to
    the recipient so they may then pay through our payment system. To skip our payment process, set this to `paid` to
    mark it as paid. It can then subsequently be sent as well, same as with `issued`.

    A status value that cannot be set but can be returned is `canceled`, for invoices which were
    issued, but then canceled. Currently this can only be done for invoices created in the dashboard.

    Dependent parameters:
    - `paymentDetails` is required if invoice should be set directly to `paid`
    - `customerId` and `mandateId` are required if a recurring payment should be used to set the invoice to `paid`
    - `emailDetails` optional for `issued` and `paid` to send the invoice by email
    """

    DRAFT = "draft"
    ISSUED = "issued"
    PAID = "paid"


class VatSchemeRequest(str, Enum):
    r"""The VAT scheme to create the invoice for. You must be enrolled with One Stop Shop enabled to use it."""

    STANDARD = "standard"
    ONE_STOP_SHOP = "one-stop-shop"


class VatModeRequest(str, Enum):
    r"""The VAT mode to use for VAT calculation. `exclusive` mode means we will apply the relevant VAT on top of the
    price. `inclusive` means the prices you are providing to us already contain the VAT you want to apply.
    """

    EXCLUSIVE = "exclusive"
    INCLUSIVE = "inclusive"


class CreateSalesInvoiceMetadataRequestTypedDict(TypedDict):
    r"""Provide any data you like as a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """


class CreateSalesInvoiceMetadataRequest(BaseModel):
    r"""Provide any data you like as a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """


class CreateSalesInvoicePaymentTermRequest(str, Enum):
    r"""The payment term to be set on the invoice."""

    SEVENDAYS = "7 days"
    FOURTEENDAYS = "14 days"
    THIRTYDAYS = "30 days"
    FORTY_FIVEDAYS = "45 days"
    SIXTYDAYS = "60 days"
    NINETYDAYS = "90 days"
    ONE_HUNDRED_AND_TWENTYDAYS = "120 days"


class CreateSalesInvoiceSourceRequest(str, Enum):
    r"""The way through which the invoice is to be set to paid."""

    MANUAL = "manual"
    PAYMENT_LINK = "payment-link"
    PAYMENT = "payment"


class CreateSalesInvoicePaymentDetailsRequestTypedDict(TypedDict):
    r"""Used when setting an invoice to status of `paid`, and will store a payment that fully pays the invoice with the
    provided details. Required for `paid` status.
    """

    source: CreateSalesInvoiceSourceRequest
    r"""The way through which the invoice is to be set to paid."""
    source_reference: NotRequired[Nullable[str]]
    r"""A reference to the payment the sales invoice is paid by. Required for `source` values `payment-link` and
    `payment`.
    """


class CreateSalesInvoicePaymentDetailsRequest(BaseModel):
    r"""Used when setting an invoice to status of `paid`, and will store a payment that fully pays the invoice with the
    provided details. Required for `paid` status.
    """

    source: CreateSalesInvoiceSourceRequest
    r"""The way through which the invoice is to be set to paid."""

    source_reference: Annotated[
        OptionalNullable[str], pydantic.Field(alias="sourceReference")
    ] = UNSET
    r"""A reference to the payment the sales invoice is paid by. Required for `source` values `payment-link` and
    `payment`.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceReference"]
        nullable_fields = ["sourceReference"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreateSalesInvoiceEmailDetailsRequestTypedDict(TypedDict):
    r"""Used when setting an invoice to status of either `issued` or `paid`. Will be used to issue the invoice to the
    recipient with the provided `subject` and `body`. Required for `issued` status.
    """

    subject: str
    r"""The subject of the email to be sent."""
    body: str
    r"""The body of the email to be sent. To add newline characters, you can use `\n`."""


class CreateSalesInvoiceEmailDetailsRequest(BaseModel):
    r"""Used when setting an invoice to status of either `issued` or `paid`. Will be used to issue the invoice to the
    recipient with the provided `subject` and `body`. Required for `issued` status.
    """

    subject: str
    r"""The subject of the email to be sent."""

    body: str
    r"""The body of the email to be sent. To add newline characters, you can use `\n`."""


class CreateSalesInvoiceRecipientTypeRequest(str, Enum):
    r"""The type of recipient, either `consumer` or `business`. This will determine what further fields are
    required on the `recipient` object.
    """

    CONSUMER = "consumer"
    BUSINESS = "business"


class CreateSalesInvoiceLocaleRequest(str, Enum):
    r"""The locale for the recipient, to be used for translations in PDF generation and payment pages."""

    EN_US = "en_US"
    EN_GB = "en_GB"
    NL_NL = "nl_NL"
    NL_BE = "nl_BE"
    DE_DE = "de_DE"
    DE_AT = "de_AT"
    DE_CH = "de_CH"
    FR_FR = "fr_FR"
    FR_BE = "fr_BE"


class CreateSalesInvoiceRecipientRequestTypedDict(TypedDict):
    type: CreateSalesInvoiceRecipientTypeRequest
    r"""The type of recipient, either `consumer` or `business`. This will determine what further fields are
    required on the `recipient` object.
    """
    email: str
    r"""The email address of the recipient."""
    street_and_number: str
    r"""A street and street number."""
    postal_code: str
    r"""A postal code."""
    city: str
    r"""The recipient's city."""
    country: str
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format."""
    locale: CreateSalesInvoiceLocaleRequest
    r"""The locale for the recipient, to be used for translations in PDF generation and payment pages."""
    title: NotRequired[Nullable[str]]
    r"""The title of the `consumer` type recipient, for example Mr. or Mrs.."""
    given_name: NotRequired[Nullable[str]]
    r"""The given name (first name) of the `consumer` type recipient should be at least two characters and cannot contain
    only numbers.
    """
    family_name: NotRequired[Nullable[str]]
    r"""The given name (last name) of the `consumer` type recipient should be at least two characters and cannot contain
    only numbers.
    """
    organization_name: NotRequired[Nullable[str]]
    r"""The trading name of the `business` type recipient."""
    organization_number: NotRequired[Nullable[str]]
    r"""The Chamber of Commerce number of the organization for a `business` type recipient. Either this or `vatNumber`
    has to be provided.
    """
    vat_number: NotRequired[Nullable[str]]
    r"""The VAT number of the organization for a `business` type recipient. Either this or `organizationNumber`
    has to be provided.
    """
    phone: NotRequired[Nullable[str]]
    r"""The phone number of the recipient."""
    street_additional: NotRequired[Nullable[str]]
    r"""Any additional addressing details, for example an apartment number."""
    region: NotRequired[Nullable[str]]
    r"""The recipient's region."""


class CreateSalesInvoiceRecipientRequest(BaseModel):
    type: CreateSalesInvoiceRecipientTypeRequest
    r"""The type of recipient, either `consumer` or `business`. This will determine what further fields are
    required on the `recipient` object.
    """

    email: str
    r"""The email address of the recipient."""

    street_and_number: Annotated[str, pydantic.Field(alias="streetAndNumber")]
    r"""A street and street number."""

    postal_code: Annotated[str, pydantic.Field(alias="postalCode")]
    r"""A postal code."""

    city: str
    r"""The recipient's city."""

    country: str
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format."""

    locale: CreateSalesInvoiceLocaleRequest
    r"""The locale for the recipient, to be used for translations in PDF generation and payment pages."""

    title: OptionalNullable[str] = UNSET
    r"""The title of the `consumer` type recipient, for example Mr. or Mrs.."""

    given_name: Annotated[OptionalNullable[str], pydantic.Field(alias="givenName")] = (
        UNSET
    )
    r"""The given name (first name) of the `consumer` type recipient should be at least two characters and cannot contain
    only numbers.
    """

    family_name: Annotated[
        OptionalNullable[str], pydantic.Field(alias="familyName")
    ] = UNSET
    r"""The given name (last name) of the `consumer` type recipient should be at least two characters and cannot contain
    only numbers.
    """

    organization_name: Annotated[
        OptionalNullable[str], pydantic.Field(alias="organizationName")
    ] = UNSET
    r"""The trading name of the `business` type recipient."""

    organization_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="organizationNumber")
    ] = UNSET
    r"""The Chamber of Commerce number of the organization for a `business` type recipient. Either this or `vatNumber`
    has to be provided.
    """

    vat_number: Annotated[OptionalNullable[str], pydantic.Field(alias="vatNumber")] = (
        UNSET
    )
    r"""The VAT number of the organization for a `business` type recipient. Either this or `organizationNumber`
    has to be provided.
    """

    phone: OptionalNullable[str] = UNSET
    r"""The phone number of the recipient."""

    street_additional: Annotated[
        OptionalNullable[str], pydantic.Field(alias="streetAdditional")
    ] = UNSET
    r"""Any additional addressing details, for example an apartment number."""

    region: OptionalNullable[str] = UNSET
    r"""The recipient's region."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "title",
            "givenName",
            "familyName",
            "organizationName",
            "organizationNumber",
            "vatNumber",
            "phone",
            "streetAdditional",
            "region",
        ]
        nullable_fields = [
            "title",
            "givenName",
            "familyName",
            "organizationName",
            "organizationNumber",
            "vatNumber",
            "phone",
            "streetAdditional",
            "region",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreateSalesInvoiceUnitPriceRequestTypedDict(TypedDict):
    r"""The price of a single item excluding VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    The unit price can be zero in case of free items.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateSalesInvoiceUnitPriceRequest(BaseModel):
    r"""The price of a single item excluding VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    The unit price can be zero in case of free items.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateSalesInvoiceLineTypeRequest(str, Enum):
    r"""The type of discount."""

    AMOUNT = "amount"
    PERCENTAGE = "percentage"


class CreateSalesInvoiceLineDiscountRequestTypedDict(TypedDict):
    r"""The discount to be applied to the line item."""

    type: CreateSalesInvoiceLineTypeRequest
    r"""The type of discount."""
    value: str
    r"""A string containing an exact monetary amount in the given currency, or the percentage."""


class CreateSalesInvoiceLineDiscountRequest(BaseModel):
    r"""The discount to be applied to the line item."""

    type: CreateSalesInvoiceLineTypeRequest
    r"""The type of discount."""

    value: str
    r"""A string containing an exact monetary amount in the given currency, or the percentage."""


class CreateSalesInvoiceLineRequestTypedDict(TypedDict):
    description: str
    r"""A description of the line item. For example *LEGO 4440 Forest Police Station*."""
    quantity: int
    r"""The number of items."""
    vat_rate: str
    r"""The vat rate to be applied to this line item."""
    unit_price: CreateSalesInvoiceUnitPriceRequestTypedDict
    r"""The price of a single item excluding VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    The unit price can be zero in case of free items.
    """
    discount: NotRequired[Nullable[CreateSalesInvoiceLineDiscountRequestTypedDict]]
    r"""The discount to be applied to the line item."""


class CreateSalesInvoiceLineRequest(BaseModel):
    description: str
    r"""A description of the line item. For example *LEGO 4440 Forest Police Station*."""

    quantity: int
    r"""The number of items."""

    vat_rate: Annotated[str, pydantic.Field(alias="vatRate")]
    r"""The vat rate to be applied to this line item."""

    unit_price: Annotated[
        CreateSalesInvoiceUnitPriceRequest, pydantic.Field(alias="unitPrice")
    ]
    r"""The price of a single item excluding VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    The unit price can be zero in case of free items.
    """

    discount: OptionalNullable[CreateSalesInvoiceLineDiscountRequest] = UNSET
    r"""The discount to be applied to the line item."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["discount"]
        nullable_fields = ["discount"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreateSalesInvoiceDiscountTypeRequest(str, Enum):
    r"""The type of discount."""

    AMOUNT = "amount"
    PERCENTAGE = "percentage"


class CreateSalesInvoiceDiscountRequestTypedDict(TypedDict):
    r"""The discount to be applied to the entire invoice, applied on top of any line item discounts."""

    type: CreateSalesInvoiceDiscountTypeRequest
    r"""The type of discount."""
    value: str
    r"""A string containing an exact monetary amount in the given currency, or the percentage."""


class CreateSalesInvoiceDiscountRequest(BaseModel):
    r"""The discount to be applied to the entire invoice, applied on top of any line item discounts."""

    type: CreateSalesInvoiceDiscountTypeRequest
    r"""The type of discount."""

    value: str
    r"""A string containing an exact monetary amount in the given currency, or the percentage."""


class CreateSalesInvoiceRequestTypedDict(TypedDict):
    status: CreateSalesInvoiceStatusRequest
    r"""The status for the invoice to end up in.

    A `draft` invoice is not paid or not sent and can be updated after creation. Setting it to `issued` sends it to
    the recipient so they may then pay through our payment system. To skip our payment process, set this to `paid` to
    mark it as paid. It can then subsequently be sent as well, same as with `issued`.

    A status value that cannot be set but can be returned is `canceled`, for invoices which were
    issued, but then canceled. Currently this can only be done for invoices created in the dashboard.

    Dependent parameters:
    - `paymentDetails` is required if invoice should be set directly to `paid`
    - `customerId` and `mandateId` are required if a recurring payment should be used to set the invoice to `paid`
    - `emailDetails` optional for `issued` and `paid` to send the invoice by email
    """
    recipient_identifier: str
    r"""An identifier tied to the recipient data. This should be a unique value based on data your system contains,
    so that both you and us know who we're referring to. It is a value you provide to us so that recipient management
    is not required to send a first invoice to a recipient.
    """
    recipient: Nullable[CreateSalesInvoiceRecipientRequestTypedDict]
    lines: Nullable[List[CreateSalesInvoiceLineRequestTypedDict]]
    r"""Provide the line items for the invoice. Each line contains details such as a description of the item
    ordered and its price.

    All lines must have the same currency as the invoice.
    """
    testmode: NotRequired[Nullable[bool]]
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be
    omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting
    `testmode` to `true`.
    """
    profile_id: NotRequired[Nullable[str]]
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted in the creation
    request. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is
    required.
    """
    vat_scheme: NotRequired[VatSchemeRequest]
    r"""The VAT scheme to create the invoice for. You must be enrolled with One Stop Shop enabled to use it."""
    vat_mode: NotRequired[VatModeRequest]
    r"""The VAT mode to use for VAT calculation. `exclusive` mode means we will apply the relevant VAT on top of the
    price. `inclusive` means the prices you are providing to us already contain the VAT you want to apply.
    """
    memo: NotRequired[Nullable[str]]
    r"""A free-form memo you can set on the invoice, and will be shown on the invoice PDF."""
    metadata: NotRequired[Nullable[CreateSalesInvoiceMetadataRequestTypedDict]]
    r"""Provide any data you like as a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """
    payment_term: NotRequired[Nullable[CreateSalesInvoicePaymentTermRequest]]
    r"""The payment term to be set on the invoice."""
    payment_details: NotRequired[
        Nullable[CreateSalesInvoicePaymentDetailsRequestTypedDict]
    ]
    r"""Used when setting an invoice to status of `paid`, and will store a payment that fully pays the invoice with the
    provided details. Required for `paid` status.
    """
    email_details: NotRequired[Nullable[CreateSalesInvoiceEmailDetailsRequestTypedDict]]
    r"""Used when setting an invoice to status of either `issued` or `paid`. Will be used to issue the invoice to the
    recipient with the provided `subject` and `body`. Required for `issued` status.
    """
    customer_id: NotRequired[str]
    r"""The identifier referring to the [customer](get-customer) you want to attempt an automated payment for. If
    provided, `mandateId` becomes required as well. Only allowed for invoices with status `paid`.
    """
    mandate_id: NotRequired[str]
    r"""The identifier referring to the [mandate](get-mandate) you want to use for the automated payment. If provided,
    `customerId` becomes required as well. Only allowed for invoices with status `paid`.
    """
    discount: NotRequired[Nullable[CreateSalesInvoiceDiscountRequestTypedDict]]
    r"""The discount to be applied to the entire invoice, applied on top of any line item discounts."""


class CreateSalesInvoiceRequest(BaseModel):
    status: CreateSalesInvoiceStatusRequest
    r"""The status for the invoice to end up in.

    A `draft` invoice is not paid or not sent and can be updated after creation. Setting it to `issued` sends it to
    the recipient so they may then pay through our payment system. To skip our payment process, set this to `paid` to
    mark it as paid. It can then subsequently be sent as well, same as with `issued`.

    A status value that cannot be set but can be returned is `canceled`, for invoices which were
    issued, but then canceled. Currently this can only be done for invoices created in the dashboard.

    Dependent parameters:
    - `paymentDetails` is required if invoice should be set directly to `paid`
    - `customerId` and `mandateId` are required if a recurring payment should be used to set the invoice to `paid`
    - `emailDetails` optional for `issued` and `paid` to send the invoice by email
    """

    recipient_identifier: Annotated[str, pydantic.Field(alias="recipientIdentifier")]
    r"""An identifier tied to the recipient data. This should be a unique value based on data your system contains,
    so that both you and us know who we're referring to. It is a value you provide to us so that recipient management
    is not required to send a first invoice to a recipient.
    """

    recipient: Nullable[CreateSalesInvoiceRecipientRequest]

    lines: Nullable[List[CreateSalesInvoiceLineRequest]]
    r"""Provide the line items for the invoice. Each line contains details such as a description of the item
    ordered and its price.

    All lines must have the same currency as the invoice.
    """

    testmode: OptionalNullable[bool] = UNSET
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be
    omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting
    `testmode` to `true`.
    """

    profile_id: Annotated[OptionalNullable[str], pydantic.Field(alias="profileId")] = (
        UNSET
    )
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted in the creation
    request. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is
    required.
    """

    vat_scheme: Annotated[
        Optional[VatSchemeRequest], pydantic.Field(alias="vatScheme")
    ] = VatSchemeRequest.STANDARD
    r"""The VAT scheme to create the invoice for. You must be enrolled with One Stop Shop enabled to use it."""

    vat_mode: Annotated[Optional[VatModeRequest], pydantic.Field(alias="vatMode")] = (
        VatModeRequest.EXCLUSIVE
    )
    r"""The VAT mode to use for VAT calculation. `exclusive` mode means we will apply the relevant VAT on top of the
    price. `inclusive` means the prices you are providing to us already contain the VAT you want to apply.
    """

    memo: OptionalNullable[str] = UNSET
    r"""A free-form memo you can set on the invoice, and will be shown on the invoice PDF."""

    metadata: OptionalNullable[CreateSalesInvoiceMetadataRequest] = UNSET
    r"""Provide any data you like as a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """

    payment_term: Annotated[
        OptionalNullable[CreateSalesInvoicePaymentTermRequest],
        pydantic.Field(alias="paymentTerm"),
    ] = CreateSalesInvoicePaymentTermRequest.THIRTYDAYS
    r"""The payment term to be set on the invoice."""

    payment_details: Annotated[
        OptionalNullable[CreateSalesInvoicePaymentDetailsRequest],
        pydantic.Field(alias="paymentDetails"),
    ] = UNSET
    r"""Used when setting an invoice to status of `paid`, and will store a payment that fully pays the invoice with the
    provided details. Required for `paid` status.
    """

    email_details: Annotated[
        OptionalNullable[CreateSalesInvoiceEmailDetailsRequest],
        pydantic.Field(alias="emailDetails"),
    ] = UNSET
    r"""Used when setting an invoice to status of either `issued` or `paid`. Will be used to issue the invoice to the
    recipient with the provided `subject` and `body`. Required for `issued` status.
    """

    customer_id: Annotated[Optional[str], pydantic.Field(alias="customerId")] = None
    r"""The identifier referring to the [customer](get-customer) you want to attempt an automated payment for. If
    provided, `mandateId` becomes required as well. Only allowed for invoices with status `paid`.
    """

    mandate_id: Annotated[Optional[str], pydantic.Field(alias="mandateId")] = None
    r"""The identifier referring to the [mandate](get-mandate) you want to use for the automated payment. If provided,
    `customerId` becomes required as well. Only allowed for invoices with status `paid`.
    """

    discount: OptionalNullable[CreateSalesInvoiceDiscountRequest] = UNSET
    r"""The discount to be applied to the entire invoice, applied on top of any line item discounts."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "testmode",
            "profileId",
            "vatScheme",
            "vatMode",
            "memo",
            "metadata",
            "paymentTerm",
            "paymentDetails",
            "emailDetails",
            "customerId",
            "mandateId",
            "discount",
        ]
        nullable_fields = [
            "testmode",
            "profileId",
            "memo",
            "metadata",
            "paymentTerm",
            "paymentDetails",
            "emailDetails",
            "recipient",
            "lines",
            "discount",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreateSalesInvoiceUnprocessableEntityDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class CreateSalesInvoiceUnprocessableEntityDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class CreateSalesInvoiceUnprocessableEntityLinksTypedDict(TypedDict):
    documentation: CreateSalesInvoiceUnprocessableEntityDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class CreateSalesInvoiceUnprocessableEntityLinks(BaseModel):
    documentation: CreateSalesInvoiceUnprocessableEntityDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class CreateSalesInvoiceUnprocessableEntityHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[
        CreateSalesInvoiceUnprocessableEntityLinks, pydantic.Field(alias="_links")
    ]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class CreateSalesInvoiceUnprocessableEntityHalJSONError(ClientError):
    r"""An error response object."""

    data: CreateSalesInvoiceUnprocessableEntityHalJSONErrorData

    def __init__(
        self,
        data: CreateSalesInvoiceUnprocessableEntityHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class CreateSalesInvoiceNotFoundDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class CreateSalesInvoiceNotFoundDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class CreateSalesInvoiceNotFoundLinksTypedDict(TypedDict):
    documentation: CreateSalesInvoiceNotFoundDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class CreateSalesInvoiceNotFoundLinks(BaseModel):
    documentation: CreateSalesInvoiceNotFoundDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class CreateSalesInvoiceNotFoundHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[CreateSalesInvoiceNotFoundLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class CreateSalesInvoiceNotFoundHalJSONError(ClientError):
    r"""An error response object."""

    data: CreateSalesInvoiceNotFoundHalJSONErrorData

    def __init__(
        self,
        data: CreateSalesInvoiceNotFoundHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class CreateSalesInvoiceStatusResponse(str, Enum):
    r"""The status for the invoice to end up in.

    A `draft` invoice is not paid or not sent and can be updated after creation. Setting it to `issued` sends it to
    the recipient so they may then pay through our payment system. To skip our payment process, set this to `paid` to
    mark it as paid. It can then subsequently be sent as well, same as with `issued`.

    A status value that cannot be set but can be returned is `canceled`, for invoices which were
    issued, but then canceled. Currently this can only be done for invoices created in the dashboard.

    Dependent parameters:
    - `paymentDetails` is required if invoice should be set directly to `paid`
    - `customerId` and `mandateId` are required if a recurring payment should be used to set the invoice to `paid`
    - `emailDetails` optional for `issued` and `paid` to send the invoice by email
    """

    DRAFT = "draft"
    ISSUED = "issued"
    PAID = "paid"


class CreateSalesInvoiceVatSchemeResponse(str, Enum):
    r"""The VAT scheme to create the invoice for. You must be enrolled with One Stop Shop enabled to use it."""

    STANDARD = "standard"
    ONE_STOP_SHOP = "one-stop-shop"


class CreateSalesInvoiceVatModeResponse(str, Enum):
    r"""The VAT mode to use for VAT calculation. `exclusive` mode means we will apply the relevant VAT on top of the
    price. `inclusive` means the prices you are providing to us already contain the VAT you want to apply.
    """

    EXCLUSIVE = "exclusive"
    INCLUSIVE = "inclusive"


class CreateSalesInvoiceMetadataResponseTypedDict(TypedDict):
    r"""Provide any data you like as a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """


class CreateSalesInvoiceMetadataResponse(BaseModel):
    r"""Provide any data you like as a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """


class CreateSalesInvoicePaymentTermResponse(str, Enum):
    r"""The payment term to be set on the invoice."""

    SEVENDAYS = "7 days"
    FOURTEENDAYS = "14 days"
    THIRTYDAYS = "30 days"
    FORTY_FIVEDAYS = "45 days"
    SIXTYDAYS = "60 days"
    NINETYDAYS = "90 days"
    ONE_HUNDRED_AND_TWENTYDAYS = "120 days"


class CreateSalesInvoiceSourceResponse(str, Enum):
    r"""The way through which the invoice is to be set to paid."""

    MANUAL = "manual"
    PAYMENT_LINK = "payment-link"
    PAYMENT = "payment"


class CreateSalesInvoicePaymentDetailsResponseTypedDict(TypedDict):
    r"""Used when setting an invoice to status of `paid`, and will store a payment that fully pays the invoice with the
    provided details. Required for `paid` status.
    """

    source: CreateSalesInvoiceSourceResponse
    r"""The way through which the invoice is to be set to paid."""
    source_reference: NotRequired[Nullable[str]]
    r"""A reference to the payment the sales invoice is paid by. Required for `source` values `payment-link` and
    `payment`.
    """


class CreateSalesInvoicePaymentDetailsResponse(BaseModel):
    r"""Used when setting an invoice to status of `paid`, and will store a payment that fully pays the invoice with the
    provided details. Required for `paid` status.
    """

    source: CreateSalesInvoiceSourceResponse
    r"""The way through which the invoice is to be set to paid."""

    source_reference: Annotated[
        OptionalNullable[str], pydantic.Field(alias="sourceReference")
    ] = UNSET
    r"""A reference to the payment the sales invoice is paid by. Required for `source` values `payment-link` and
    `payment`.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceReference"]
        nullable_fields = ["sourceReference"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreateSalesInvoiceEmailDetailsResponseTypedDict(TypedDict):
    r"""Used when setting an invoice to status of either `issued` or `paid`. Will be used to issue the invoice to the
    recipient with the provided `subject` and `body`. Required for `issued` status.
    """

    subject: str
    r"""The subject of the email to be sent."""
    body: str
    r"""The body of the email to be sent. To add newline characters, you can use `\n`."""


class CreateSalesInvoiceEmailDetailsResponse(BaseModel):
    r"""Used when setting an invoice to status of either `issued` or `paid`. Will be used to issue the invoice to the
    recipient with the provided `subject` and `body`. Required for `issued` status.
    """

    subject: str
    r"""The subject of the email to be sent."""

    body: str
    r"""The body of the email to be sent. To add newline characters, you can use `\n`."""


class CreateSalesInvoiceRecipientTypeResponse(str, Enum):
    r"""The type of recipient, either `consumer` or `business`. This will determine what further fields are
    required on the `recipient` object.
    """

    CONSUMER = "consumer"
    BUSINESS = "business"


class CreateSalesInvoiceLocaleResponse(str, Enum):
    r"""The locale for the recipient, to be used for translations in PDF generation and payment pages."""

    EN_US = "en_US"
    EN_GB = "en_GB"
    NL_NL = "nl_NL"
    NL_BE = "nl_BE"
    DE_DE = "de_DE"
    DE_AT = "de_AT"
    DE_CH = "de_CH"
    FR_FR = "fr_FR"
    FR_BE = "fr_BE"


class CreateSalesInvoiceRecipientResponseTypedDict(TypedDict):
    type: CreateSalesInvoiceRecipientTypeResponse
    r"""The type of recipient, either `consumer` or `business`. This will determine what further fields are
    required on the `recipient` object.
    """
    email: str
    r"""The email address of the recipient."""
    street_and_number: str
    r"""A street and street number."""
    postal_code: str
    r"""A postal code."""
    city: str
    r"""The recipient's city."""
    country: str
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format."""
    locale: CreateSalesInvoiceLocaleResponse
    r"""The locale for the recipient, to be used for translations in PDF generation and payment pages."""
    title: NotRequired[Nullable[str]]
    r"""The title of the `consumer` type recipient, for example Mr. or Mrs.."""
    given_name: NotRequired[Nullable[str]]
    r"""The given name (first name) of the `consumer` type recipient should be at least two characters and cannot contain
    only numbers.
    """
    family_name: NotRequired[Nullable[str]]
    r"""The given name (last name) of the `consumer` type recipient should be at least two characters and cannot contain
    only numbers.
    """
    organization_name: NotRequired[Nullable[str]]
    r"""The trading name of the `business` type recipient."""
    organization_number: NotRequired[Nullable[str]]
    r"""The Chamber of Commerce number of the organization for a `business` type recipient. Either this or `vatNumber`
    has to be provided.
    """
    vat_number: NotRequired[Nullable[str]]
    r"""The VAT number of the organization for a `business` type recipient. Either this or `organizationNumber`
    has to be provided.
    """
    phone: NotRequired[Nullable[str]]
    r"""The phone number of the recipient."""
    street_additional: NotRequired[Nullable[str]]
    r"""Any additional addressing details, for example an apartment number."""
    region: NotRequired[Nullable[str]]
    r"""The recipient's region."""


class CreateSalesInvoiceRecipientResponse(BaseModel):
    type: CreateSalesInvoiceRecipientTypeResponse
    r"""The type of recipient, either `consumer` or `business`. This will determine what further fields are
    required on the `recipient` object.
    """

    email: str
    r"""The email address of the recipient."""

    street_and_number: Annotated[str, pydantic.Field(alias="streetAndNumber")]
    r"""A street and street number."""

    postal_code: Annotated[str, pydantic.Field(alias="postalCode")]
    r"""A postal code."""

    city: str
    r"""The recipient's city."""

    country: str
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format."""

    locale: CreateSalesInvoiceLocaleResponse
    r"""The locale for the recipient, to be used for translations in PDF generation and payment pages."""

    title: OptionalNullable[str] = UNSET
    r"""The title of the `consumer` type recipient, for example Mr. or Mrs.."""

    given_name: Annotated[OptionalNullable[str], pydantic.Field(alias="givenName")] = (
        UNSET
    )
    r"""The given name (first name) of the `consumer` type recipient should be at least two characters and cannot contain
    only numbers.
    """

    family_name: Annotated[
        OptionalNullable[str], pydantic.Field(alias="familyName")
    ] = UNSET
    r"""The given name (last name) of the `consumer` type recipient should be at least two characters and cannot contain
    only numbers.
    """

    organization_name: Annotated[
        OptionalNullable[str], pydantic.Field(alias="organizationName")
    ] = UNSET
    r"""The trading name of the `business` type recipient."""

    organization_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="organizationNumber")
    ] = UNSET
    r"""The Chamber of Commerce number of the organization for a `business` type recipient. Either this or `vatNumber`
    has to be provided.
    """

    vat_number: Annotated[OptionalNullable[str], pydantic.Field(alias="vatNumber")] = (
        UNSET
    )
    r"""The VAT number of the organization for a `business` type recipient. Either this or `organizationNumber`
    has to be provided.
    """

    phone: OptionalNullable[str] = UNSET
    r"""The phone number of the recipient."""

    street_additional: Annotated[
        OptionalNullable[str], pydantic.Field(alias="streetAdditional")
    ] = UNSET
    r"""Any additional addressing details, for example an apartment number."""

    region: OptionalNullable[str] = UNSET
    r"""The recipient's region."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "title",
            "givenName",
            "familyName",
            "organizationName",
            "organizationNumber",
            "vatNumber",
            "phone",
            "streetAdditional",
            "region",
        ]
        nullable_fields = [
            "title",
            "givenName",
            "familyName",
            "organizationName",
            "organizationNumber",
            "vatNumber",
            "phone",
            "streetAdditional",
            "region",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreateSalesInvoiceUnitPriceResponseTypedDict(TypedDict):
    r"""The price of a single item excluding VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    The unit price can be zero in case of free items.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateSalesInvoiceUnitPriceResponse(BaseModel):
    r"""The price of a single item excluding VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    The unit price can be zero in case of free items.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateSalesInvoiceLineTypeResponse(str, Enum):
    r"""The type of discount."""

    AMOUNT = "amount"
    PERCENTAGE = "percentage"


class CreateSalesInvoiceLineDiscountResponseTypedDict(TypedDict):
    r"""The discount to be applied to the line item."""

    type: CreateSalesInvoiceLineTypeResponse
    r"""The type of discount."""
    value: str
    r"""A string containing an exact monetary amount in the given currency, or the percentage."""


class CreateSalesInvoiceLineDiscountResponse(BaseModel):
    r"""The discount to be applied to the line item."""

    type: CreateSalesInvoiceLineTypeResponse
    r"""The type of discount."""

    value: str
    r"""A string containing an exact monetary amount in the given currency, or the percentage."""


class CreateSalesInvoiceLineResponseTypedDict(TypedDict):
    description: str
    r"""A description of the line item. For example *LEGO 4440 Forest Police Station*."""
    quantity: int
    r"""The number of items."""
    vat_rate: str
    r"""The vat rate to be applied to this line item."""
    unit_price: CreateSalesInvoiceUnitPriceResponseTypedDict
    r"""The price of a single item excluding VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    The unit price can be zero in case of free items.
    """
    discount: NotRequired[Nullable[CreateSalesInvoiceLineDiscountResponseTypedDict]]
    r"""The discount to be applied to the line item."""


class CreateSalesInvoiceLineResponse(BaseModel):
    description: str
    r"""A description of the line item. For example *LEGO 4440 Forest Police Station*."""

    quantity: int
    r"""The number of items."""

    vat_rate: Annotated[str, pydantic.Field(alias="vatRate")]
    r"""The vat rate to be applied to this line item."""

    unit_price: Annotated[
        CreateSalesInvoiceUnitPriceResponse, pydantic.Field(alias="unitPrice")
    ]
    r"""The price of a single item excluding VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    The unit price can be zero in case of free items.
    """

    discount: OptionalNullable[CreateSalesInvoiceLineDiscountResponse] = UNSET
    r"""The discount to be applied to the line item."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["discount"]
        nullable_fields = ["discount"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreateSalesInvoiceDiscountTypeResponse(str, Enum):
    r"""The type of discount."""

    AMOUNT = "amount"
    PERCENTAGE = "percentage"


class CreateSalesInvoiceDiscountResponseTypedDict(TypedDict):
    r"""The discount to be applied to the entire invoice, applied on top of any line item discounts."""

    type: CreateSalesInvoiceDiscountTypeResponse
    r"""The type of discount."""
    value: str
    r"""A string containing an exact monetary amount in the given currency, or the percentage."""


class CreateSalesInvoiceDiscountResponse(BaseModel):
    r"""The discount to be applied to the entire invoice, applied on top of any line item discounts."""

    type: CreateSalesInvoiceDiscountTypeResponse
    r"""The type of discount."""

    value: str
    r"""A string containing an exact monetary amount in the given currency, or the percentage."""


class CreateSalesInvoiceAmountDueTypedDict(TypedDict):
    r"""The amount that is left to be paid."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateSalesInvoiceAmountDue(BaseModel):
    r"""The amount that is left to be paid."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateSalesInvoiceSubtotalAmountTypedDict(TypedDict):
    r"""The total amount without VAT before discounts."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateSalesInvoiceSubtotalAmount(BaseModel):
    r"""The total amount without VAT before discounts."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateSalesInvoiceTotalAmountTypedDict(TypedDict):
    r"""The total amount with VAT."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateSalesInvoiceTotalAmount(BaseModel):
    r"""The total amount with VAT."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateSalesInvoiceTotalVatAmountTypedDict(TypedDict):
    r"""The total VAT amount."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateSalesInvoiceTotalVatAmount(BaseModel):
    r"""The total VAT amount."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateSalesInvoiceDiscountedSubtotalAmountTypedDict(TypedDict):
    r"""The total amount without VAT after discounts."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateSalesInvoiceDiscountedSubtotalAmount(BaseModel):
    r"""The total amount without VAT after discounts."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateSalesInvoiceSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateSalesInvoiceSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateSalesInvoiceInvoicePaymentTypedDict(TypedDict):
    r"""The URL your customer should visit to make payment for the invoice. This is where you should redirect the
    customer to unless the `status` is set to `paid`.
    """

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateSalesInvoiceInvoicePayment(BaseModel):
    r"""The URL your customer should visit to make payment for the invoice. This is where you should redirect the
    customer to unless the `status` is set to `paid`.
    """

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateSalesInvoicePdfLinkTypedDict(TypedDict):
    r"""The URL the invoice is available at, if generated."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateSalesInvoicePdfLink(BaseModel):
    r"""The URL the invoice is available at, if generated."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateSalesInvoiceDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateSalesInvoiceDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateSalesInvoiceLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[CreateSalesInvoiceSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    invoice_payment: NotRequired[CreateSalesInvoiceInvoicePaymentTypedDict]
    r"""The URL your customer should visit to make payment for the invoice. This is where you should redirect the
    customer to unless the `status` is set to `paid`.
    """
    pdf_link: NotRequired[Nullable[CreateSalesInvoicePdfLinkTypedDict]]
    r"""The URL the invoice is available at, if generated."""
    documentation: NotRequired[CreateSalesInvoiceDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class CreateSalesInvoiceLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[CreateSalesInvoiceSelf], pydantic.Field(alias="self")] = (
        None
    )
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    invoice_payment: Annotated[
        Optional[CreateSalesInvoiceInvoicePayment],
        pydantic.Field(alias="invoicePayment"),
    ] = None
    r"""The URL your customer should visit to make payment for the invoice. This is where you should redirect the
    customer to unless the `status` is set to `paid`.
    """

    pdf_link: Annotated[
        OptionalNullable[CreateSalesInvoicePdfLink], pydantic.Field(alias="pdfLink")
    ] = UNSET
    r"""The URL the invoice is available at, if generated."""

    documentation: Optional[CreateSalesInvoiceDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["self", "invoicePayment", "pdfLink", "documentation"]
        nullable_fields = ["pdfLink"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreateSalesInvoiceResponseTypedDict(TypedDict):
    r"""The newly created invoice object. For a complete reference of the invoice object, refer to the
    [Get sales invoice endpoint](get-sales-invoice) documentation.
    """

    resource: NotRequired[str]
    r"""Indicates the response contains a sales invoice object. Will always contain the string `sales-invoice` for this
    endpoint.
    """
    id: NotRequired[str]
    r"""The identifier uniquely referring to this invoice. Example: `invoice_4Y0eZitmBnQ6IDoMqZQKh`."""
    invoice_number: NotRequired[Nullable[str]]
    r"""When issued, an invoice number will be set for the sales invoice."""
    status: NotRequired[CreateSalesInvoiceStatusResponse]
    r"""The status for the invoice to end up in.

    A `draft` invoice is not paid or not sent and can be updated after creation. Setting it to `issued` sends it to
    the recipient so they may then pay through our payment system. To skip our payment process, set this to `paid` to
    mark it as paid. It can then subsequently be sent as well, same as with `issued`.

    A status value that cannot be set but can be returned is `canceled`, for invoices which were
    issued, but then canceled. Currently this can only be done for invoices created in the dashboard.

    Dependent parameters:
    - `paymentDetails` is required if invoice should be set directly to `paid`
    - `customerId` and `mandateId` are required if a recurring payment should be used to set the invoice to `paid`
    - `emailDetails` optional for `issued` and `paid` to send the invoice by email
    """
    vat_scheme: NotRequired[CreateSalesInvoiceVatSchemeResponse]
    r"""The VAT scheme to create the invoice for. You must be enrolled with One Stop Shop enabled to use it."""
    vat_mode: NotRequired[CreateSalesInvoiceVatModeResponse]
    r"""The VAT mode to use for VAT calculation. `exclusive` mode means we will apply the relevant VAT on top of the
    price. `inclusive` means the prices you are providing to us already contain the VAT you want to apply.
    """
    memo: NotRequired[Nullable[str]]
    r"""A free-form memo you can set on the invoice, and will be shown on the invoice PDF."""
    metadata: NotRequired[Nullable[CreateSalesInvoiceMetadataResponseTypedDict]]
    r"""Provide any data you like as a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """
    payment_term: NotRequired[Nullable[CreateSalesInvoicePaymentTermResponse]]
    r"""The payment term to be set on the invoice."""
    payment_details: NotRequired[
        Nullable[CreateSalesInvoicePaymentDetailsResponseTypedDict]
    ]
    r"""Used when setting an invoice to status of `paid`, and will store a payment that fully pays the invoice with the
    provided details. Required for `paid` status.
    """
    email_details: NotRequired[
        Nullable[CreateSalesInvoiceEmailDetailsResponseTypedDict]
    ]
    r"""Used when setting an invoice to status of either `issued` or `paid`. Will be used to issue the invoice to the
    recipient with the provided `subject` and `body`. Required for `issued` status.
    """
    customer_id: NotRequired[str]
    r"""The identifier referring to the [customer](get-customer) you want to attempt an automated payment for. If
    provided, `mandateId` becomes required as well. Only allowed for invoices with status `paid`.
    """
    mandate_id: NotRequired[str]
    r"""The identifier referring to the [mandate](get-mandate) you want to use for the automated payment. If provided,
    `customerId` becomes required as well. Only allowed for invoices with status `paid`.
    """
    recipient_identifier: NotRequired[str]
    r"""An identifier tied to the recipient data. This should be a unique value based on data your system contains,
    so that both you and us know who we're referring to. It is a value you provide to us so that recipient management
    is not required to send a first invoice to a recipient.
    """
    recipient: NotRequired[Nullable[CreateSalesInvoiceRecipientResponseTypedDict]]
    lines: NotRequired[Nullable[List[CreateSalesInvoiceLineResponseTypedDict]]]
    r"""Provide the line items for the invoice. Each line contains details such as a description of the item
    ordered and its price.

    All lines must have the same currency as the invoice.
    """
    discount: NotRequired[Nullable[CreateSalesInvoiceDiscountResponseTypedDict]]
    r"""The discount to be applied to the entire invoice, applied on top of any line item discounts."""
    amount_due: NotRequired[CreateSalesInvoiceAmountDueTypedDict]
    r"""The amount that is left to be paid."""
    subtotal_amount: NotRequired[CreateSalesInvoiceSubtotalAmountTypedDict]
    r"""The total amount without VAT before discounts."""
    total_amount: NotRequired[CreateSalesInvoiceTotalAmountTypedDict]
    r"""The total amount with VAT."""
    total_vat_amount: NotRequired[CreateSalesInvoiceTotalVatAmountTypedDict]
    r"""The total VAT amount."""
    discounted_subtotal_amount: NotRequired[
        CreateSalesInvoiceDiscountedSubtotalAmountTypedDict
    ]
    r"""The total amount without VAT after discounts."""
    created_at: NotRequired[str]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    issued_at: NotRequired[Nullable[str]]
    r"""If issued, the date when the sales invoice was issued, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601)
    format.
    """
    paid_at: NotRequired[Nullable[str]]
    r"""If paid, the date when the sales invoice was paid, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601)
    format.
    """
    due_at: NotRequired[Nullable[str]]
    r"""If issued, the date when the sales invoice payment is due, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601)
    format.
    """
    links: NotRequired[CreateSalesInvoiceLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class CreateSalesInvoiceResponse(BaseModel):
    r"""The newly created invoice object. For a complete reference of the invoice object, refer to the
    [Get sales invoice endpoint](get-sales-invoice) documentation.
    """

    resource: Optional[str] = "sales-invoice"
    r"""Indicates the response contains a sales invoice object. Will always contain the string `sales-invoice` for this
    endpoint.
    """

    id: Optional[str] = None
    r"""The identifier uniquely referring to this invoice. Example: `invoice_4Y0eZitmBnQ6IDoMqZQKh`."""

    invoice_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="invoiceNumber")
    ] = UNSET
    r"""When issued, an invoice number will be set for the sales invoice."""

    status: Optional[CreateSalesInvoiceStatusResponse] = None
    r"""The status for the invoice to end up in.

    A `draft` invoice is not paid or not sent and can be updated after creation. Setting it to `issued` sends it to
    the recipient so they may then pay through our payment system. To skip our payment process, set this to `paid` to
    mark it as paid. It can then subsequently be sent as well, same as with `issued`.

    A status value that cannot be set but can be returned is `canceled`, for invoices which were
    issued, but then canceled. Currently this can only be done for invoices created in the dashboard.

    Dependent parameters:
    - `paymentDetails` is required if invoice should be set directly to `paid`
    - `customerId` and `mandateId` are required if a recurring payment should be used to set the invoice to `paid`
    - `emailDetails` optional for `issued` and `paid` to send the invoice by email
    """

    vat_scheme: Annotated[
        Optional[CreateSalesInvoiceVatSchemeResponse], pydantic.Field(alias="vatScheme")
    ] = CreateSalesInvoiceVatSchemeResponse.STANDARD
    r"""The VAT scheme to create the invoice for. You must be enrolled with One Stop Shop enabled to use it."""

    vat_mode: Annotated[
        Optional[CreateSalesInvoiceVatModeResponse], pydantic.Field(alias="vatMode")
    ] = CreateSalesInvoiceVatModeResponse.EXCLUSIVE
    r"""The VAT mode to use for VAT calculation. `exclusive` mode means we will apply the relevant VAT on top of the
    price. `inclusive` means the prices you are providing to us already contain the VAT you want to apply.
    """

    memo: OptionalNullable[str] = UNSET
    r"""A free-form memo you can set on the invoice, and will be shown on the invoice PDF."""

    metadata: OptionalNullable[CreateSalesInvoiceMetadataResponse] = UNSET
    r"""Provide any data you like as a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """

    payment_term: Annotated[
        OptionalNullable[CreateSalesInvoicePaymentTermResponse],
        pydantic.Field(alias="paymentTerm"),
    ] = CreateSalesInvoicePaymentTermResponse.THIRTYDAYS
    r"""The payment term to be set on the invoice."""

    payment_details: Annotated[
        OptionalNullable[CreateSalesInvoicePaymentDetailsResponse],
        pydantic.Field(alias="paymentDetails"),
    ] = UNSET
    r"""Used when setting an invoice to status of `paid`, and will store a payment that fully pays the invoice with the
    provided details. Required for `paid` status.
    """

    email_details: Annotated[
        OptionalNullable[CreateSalesInvoiceEmailDetailsResponse],
        pydantic.Field(alias="emailDetails"),
    ] = UNSET
    r"""Used when setting an invoice to status of either `issued` or `paid`. Will be used to issue the invoice to the
    recipient with the provided `subject` and `body`. Required for `issued` status.
    """

    customer_id: Annotated[Optional[str], pydantic.Field(alias="customerId")] = None
    r"""The identifier referring to the [customer](get-customer) you want to attempt an automated payment for. If
    provided, `mandateId` becomes required as well. Only allowed for invoices with status `paid`.
    """

    mandate_id: Annotated[Optional[str], pydantic.Field(alias="mandateId")] = None
    r"""The identifier referring to the [mandate](get-mandate) you want to use for the automated payment. If provided,
    `customerId` becomes required as well. Only allowed for invoices with status `paid`.
    """

    recipient_identifier: Annotated[
        Optional[str], pydantic.Field(alias="recipientIdentifier")
    ] = None
    r"""An identifier tied to the recipient data. This should be a unique value based on data your system contains,
    so that both you and us know who we're referring to. It is a value you provide to us so that recipient management
    is not required to send a first invoice to a recipient.
    """

    recipient: OptionalNullable[CreateSalesInvoiceRecipientResponse] = UNSET

    lines: OptionalNullable[List[CreateSalesInvoiceLineResponse]] = UNSET
    r"""Provide the line items for the invoice. Each line contains details such as a description of the item
    ordered and its price.

    All lines must have the same currency as the invoice.
    """

    discount: OptionalNullable[CreateSalesInvoiceDiscountResponse] = UNSET
    r"""The discount to be applied to the entire invoice, applied on top of any line item discounts."""

    amount_due: Annotated[
        Optional[CreateSalesInvoiceAmountDue], pydantic.Field(alias="amountDue")
    ] = None
    r"""The amount that is left to be paid."""

    subtotal_amount: Annotated[
        Optional[CreateSalesInvoiceSubtotalAmount],
        pydantic.Field(alias="subtotalAmount"),
    ] = None
    r"""The total amount without VAT before discounts."""

    total_amount: Annotated[
        Optional[CreateSalesInvoiceTotalAmount], pydantic.Field(alias="totalAmount")
    ] = None
    r"""The total amount with VAT."""

    total_vat_amount: Annotated[
        Optional[CreateSalesInvoiceTotalVatAmount],
        pydantic.Field(alias="totalVatAmount"),
    ] = None
    r"""The total VAT amount."""

    discounted_subtotal_amount: Annotated[
        Optional[CreateSalesInvoiceDiscountedSubtotalAmount],
        pydantic.Field(alias="discountedSubtotalAmount"),
    ] = None
    r"""The total amount without VAT after discounts."""

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    issued_at: Annotated[OptionalNullable[str], pydantic.Field(alias="issuedAt")] = (
        UNSET
    )
    r"""If issued, the date when the sales invoice was issued, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601)
    format.
    """

    paid_at: Annotated[OptionalNullable[str], pydantic.Field(alias="paidAt")] = UNSET
    r"""If paid, the date when the sales invoice was paid, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601)
    format.
    """

    due_at: Annotated[OptionalNullable[str], pydantic.Field(alias="dueAt")] = UNSET
    r"""If issued, the date when the sales invoice payment is due, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601)
    format.
    """

    links: Annotated[
        Optional[CreateSalesInvoiceLinks], pydantic.Field(alias="_links")
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "invoiceNumber",
            "status",
            "vatScheme",
            "vatMode",
            "memo",
            "metadata",
            "paymentTerm",
            "paymentDetails",
            "emailDetails",
            "customerId",
            "mandateId",
            "recipientIdentifier",
            "recipient",
            "lines",
            "discount",
            "amountDue",
            "subtotalAmount",
            "totalAmount",
            "totalVatAmount",
            "discountedSubtotalAmount",
            "createdAt",
            "issuedAt",
            "paidAt",
            "dueAt",
            "_links",
        ]
        nullable_fields = [
            "invoiceNumber",
            "memo",
            "metadata",
            "paymentTerm",
            "paymentDetails",
            "emailDetails",
            "recipient",
            "lines",
            "discount",
            "issuedAt",
            "paidAt",
            "dueAt",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
