"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class GetRefundEmbed(str, Enum):
    r"""This endpoint allows embedding related API items by appending the following values via the `embed` query string
    parameter.
    """

    PAYMENT = "payment"


class GetRefundRequestTypedDict(TypedDict):
    payment_id: str
    r"""Provide the ID of the related payment."""
    refund_id: str
    r"""Provide the ID of the related refund."""
    embed: NotRequired[GetRefundEmbed]
    r"""This endpoint allows embedding related API items by appending the following values via the `embed` query string
    parameter.
    """
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class GetRefundRequest(BaseModel):
    payment_id: Annotated[
        str,
        pydantic.Field(alias="paymentId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related payment."""

    refund_id: Annotated[
        str,
        pydantic.Field(alias="refundId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related refund."""

    embed: Annotated[
        Optional[GetRefundEmbed],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""This endpoint allows embedding related API items by appending the following values via the `embed` query string
    parameter.
    """

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["embed", "testmode"]
        nullable_fields = ["testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetRefundNotFoundDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class GetRefundNotFoundDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class GetRefundNotFoundLinksTypedDict(TypedDict):
    documentation: GetRefundNotFoundDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class GetRefundNotFoundLinks(BaseModel):
    documentation: GetRefundNotFoundDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class GetRefundHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[GetRefundNotFoundLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class GetRefundHalJSONError(ClientError):
    r"""An error response object."""

    data: GetRefundHalJSONErrorData

    def __init__(
        self,
        data: GetRefundHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class GetRefundMode(str, Enum):
    r"""Whether this entity was created in live mode or in test mode."""

    LIVE = "live"
    TEST = "test"


class GetRefundAmountTypedDict(TypedDict):
    r"""The amount refunded to your customer with this refund. The amount is allowed to be lower than the original payment
    amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetRefundAmount(BaseModel):
    r"""The amount refunded to your customer with this refund. The amount is allowed to be lower than the original payment
    amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetRefundSettlementAmountTypedDict(TypedDict):
    r"""This optional field will contain the approximate amount that will be deducted from your account balance, converted
    to the currency your account is settled in.

    The amount is a **negative** amount.

    If the refund is not directly processed by Mollie, for example for PayPal refunds, the settlement amount will be
    zero.

    Since the field contains an estimated amount during refund processing, it may change over time. For example, while
    the refund is queued the settlement amount is likely not yet available.

    To retrieve accurate settlement amounts we recommend using the
    [List balance transactions endpoint](list-balance-transactions) instead.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetRefundSettlementAmount(BaseModel):
    r"""This optional field will contain the approximate amount that will be deducted from your account balance, converted
    to the currency your account is settled in.

    The amount is a **negative** amount.

    If the refund is not directly processed by Mollie, for example for PayPal refunds, the settlement amount will be
    zero.

    Since the field contains an estimated amount during refund processing, it may change over time. For example, while
    the refund is queued the settlement amount is likely not yet available.

    To retrieve accurate settlement amounts we recommend using the
    [List balance transactions endpoint](list-balance-transactions) instead.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetRefundMetadataTypedDict(TypedDict):
    pass


class GetRefundMetadata(BaseModel):
    pass


GetRefundMetadataUnionTypedDict = TypeAliasType(
    "GetRefundMetadataUnionTypedDict", Union[GetRefundMetadataTypedDict, str, List[str]]
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
"""


GetRefundMetadataUnion = TypeAliasType(
    "GetRefundMetadataUnion", Union[GetRefundMetadata, str, List[str]]
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
"""


class GetRefundStatus(str, Enum):
    r"""Refunds may take some time to get confirmed."""

    QUEUED = "queued"
    PENDING = "pending"
    PROCESSING = "processing"
    REFUNDED = "refunded"
    FAILED = "failed"
    CANCELED = "canceled"


class GetRefundType(str, Enum):
    r"""Specifies the reference type"""

    ACQUIRER_REFERENCE = "acquirer-reference"


class GetRefundExternalReferenceTypedDict(TypedDict):
    type: NotRequired[GetRefundType]
    r"""Specifies the reference type"""
    id: NotRequired[str]
    r"""Unique reference from the payment provider"""


class GetRefundExternalReference(BaseModel):
    type: Optional[GetRefundType] = None
    r"""Specifies the reference type"""

    id: Optional[str] = None
    r"""Unique reference from the payment provider"""


class GetRefundRoutingReversalAmountTypedDict(TypedDict):
    r"""The amount that will be pulled back."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetRefundRoutingReversalAmount(BaseModel):
    r"""The amount that will be pulled back."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetRefundSourceTypedDict(TypedDict):
    r"""Where the funds will be pulled back from."""

    organization_id: NotRequired[str]
    r"""Required for source type `organization`. The ID of the connected organization the funds should be pulled
    back from.
    """


class GetRefundSource(BaseModel):
    r"""Where the funds will be pulled back from."""

    organization_id: Annotated[
        Optional[str], pydantic.Field(alias="organizationId")
    ] = None
    r"""Required for source type `organization`. The ID of the connected organization the funds should be pulled
    back from.
    """


class GetRefundRoutingReversalTypedDict(TypedDict):
    amount: NotRequired[GetRefundRoutingReversalAmountTypedDict]
    r"""The amount that will be pulled back."""
    source: NotRequired[GetRefundSourceTypedDict]
    r"""Where the funds will be pulled back from."""


class GetRefundRoutingReversal(BaseModel):
    amount: Optional[GetRefundRoutingReversalAmount] = None
    r"""The amount that will be pulled back."""

    source: Optional[GetRefundSource] = None
    r"""Where the funds will be pulled back from."""


class GetRefundSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetRefundSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetRefundPaymentTypedDict(TypedDict):
    r"""The API resource URL of the [payment](get-payment) that this refund belongs to."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetRefundPayment(BaseModel):
    r"""The API resource URL of the [payment](get-payment) that this refund belongs to."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetRefundSettlementTypedDict(TypedDict):
    r"""The API resource URL of the [settlement](get-settlement) this refund has been settled with. Not present if not
    yet settled.
    """

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetRefundSettlement(BaseModel):
    r"""The API resource URL of the [settlement](get-settlement) this refund has been settled with. Not present if not
    yet settled.
    """

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetRefundDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetRefundDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetRefundLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: GetRefundSelfTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    payment: GetRefundPaymentTypedDict
    r"""The API resource URL of the [payment](get-payment) that this refund belongs to."""
    documentation: GetRefundDocumentationTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    settlement: NotRequired[Nullable[GetRefundSettlementTypedDict]]
    r"""The API resource URL of the [settlement](get-settlement) this refund has been settled with. Not present if not
    yet settled.
    """


class GetRefundLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[GetRefundSelf, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    payment: GetRefundPayment
    r"""The API resource URL of the [payment](get-payment) that this refund belongs to."""

    documentation: GetRefundDocumentation
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    settlement: OptionalNullable[GetRefundSettlement] = UNSET
    r"""The API resource URL of the [settlement](get-settlement) this refund has been settled with. Not present if not
    yet settled.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["settlement"]
        nullable_fields = ["settlement"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetRefundResponseTypedDict(TypedDict):
    r"""The payment object."""

    resource: NotRequired[str]
    r"""Indicates the response contains a refund object. Will always contain the string `refund` for this endpoint."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this refund. Mollie assigns this identifier at refund creation time. Mollie
    will always refer to the refund by this ID. Example: `re_4qqhO89gsT`.
    """
    mode: NotRequired[GetRefundMode]
    r"""Whether this entity was created in live mode or in test mode."""
    description: NotRequired[str]
    r"""The description of the refund that may be shown to your customer, depending on the payment method used."""
    amount: NotRequired[GetRefundAmountTypedDict]
    r"""The amount refunded to your customer with this refund. The amount is allowed to be lower than the original payment
    amount.
    """
    settlement_amount: NotRequired[Nullable[GetRefundSettlementAmountTypedDict]]
    r"""This optional field will contain the approximate amount that will be deducted from your account balance, converted
    to the currency your account is settled in.

    The amount is a **negative** amount.

    If the refund is not directly processed by Mollie, for example for PayPal refunds, the settlement amount will be
    zero.

    Since the field contains an estimated amount during refund processing, it may change over time. For example, while
    the refund is queued the settlement amount is likely not yet available.

    To retrieve accurate settlement amounts we recommend using the
    [List balance transactions endpoint](list-balance-transactions) instead.
    """
    metadata: NotRequired[Nullable[GetRefundMetadataUnionTypedDict]]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """
    payment_id: NotRequired[str]
    r"""The unique identifier of the payment this refund was created for.
    The full payment object can be retrieved via the payment URL in the `_links` object.
    """
    settlement_id: NotRequired[Nullable[str]]
    r"""The identifier referring to the settlement this refund was settled with. This field is omitted if the refund is not settled (yet)."""
    status: NotRequired[GetRefundStatus]
    r"""Refunds may take some time to get confirmed."""
    created_at: NotRequired[str]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    external_reference: NotRequired[GetRefundExternalReferenceTypedDict]
    routing_reversals: NotRequired[Nullable[List[GetRefundRoutingReversalTypedDict]]]
    r"""*This feature is only available to marketplace operators.*

    When creating refunds for *routed* payments, by default the full amount is deducted from your balance.

    If you want to pull back funds from the connected merchant(s), you can use this parameter to specify what amount
    needs to be reversed from which merchant(s).

    If you simply want to fully reverse the routed funds, you can also use the `reverseRouting` parameter instead.
    """
    links: NotRequired[GetRefundLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class GetRefundResponse(BaseModel):
    r"""The payment object."""

    resource: Optional[str] = None
    r"""Indicates the response contains a refund object. Will always contain the string `refund` for this endpoint."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this refund. Mollie assigns this identifier at refund creation time. Mollie
    will always refer to the refund by this ID. Example: `re_4qqhO89gsT`.
    """

    mode: Optional[GetRefundMode] = None
    r"""Whether this entity was created in live mode or in test mode."""

    description: Optional[str] = None
    r"""The description of the refund that may be shown to your customer, depending on the payment method used."""

    amount: Optional[GetRefundAmount] = None
    r"""The amount refunded to your customer with this refund. The amount is allowed to be lower than the original payment
    amount.
    """

    settlement_amount: Annotated[
        OptionalNullable[GetRefundSettlementAmount],
        pydantic.Field(alias="settlementAmount"),
    ] = UNSET
    r"""This optional field will contain the approximate amount that will be deducted from your account balance, converted
    to the currency your account is settled in.

    The amount is a **negative** amount.

    If the refund is not directly processed by Mollie, for example for PayPal refunds, the settlement amount will be
    zero.

    Since the field contains an estimated amount during refund processing, it may change over time. For example, while
    the refund is queued the settlement amount is likely not yet available.

    To retrieve accurate settlement amounts we recommend using the
    [List balance transactions endpoint](list-balance-transactions) instead.
    """

    metadata: OptionalNullable[GetRefundMetadataUnion] = UNSET
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """

    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None
    r"""The unique identifier of the payment this refund was created for.
    The full payment object can be retrieved via the payment URL in the `_links` object.
    """

    settlement_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="settlementId")
    ] = UNSET
    r"""The identifier referring to the settlement this refund was settled with. This field is omitted if the refund is not settled (yet)."""

    status: Optional[GetRefundStatus] = None
    r"""Refunds may take some time to get confirmed."""

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    external_reference: Annotated[
        Optional[GetRefundExternalReference], pydantic.Field(alias="externalReference")
    ] = None

    routing_reversals: Annotated[
        OptionalNullable[List[GetRefundRoutingReversal]],
        pydantic.Field(alias="routingReversals"),
    ] = UNSET
    r"""*This feature is only available to marketplace operators.*

    When creating refunds for *routed* payments, by default the full amount is deducted from your balance.

    If you want to pull back funds from the connected merchant(s), you can use this parameter to specify what amount
    needs to be reversed from which merchant(s).

    If you simply want to fully reverse the routed funds, you can also use the `reverseRouting` parameter instead.
    """

    links: Annotated[Optional[GetRefundLinks], pydantic.Field(alias="_links")] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "mode",
            "description",
            "amount",
            "settlementAmount",
            "metadata",
            "paymentId",
            "settlementId",
            "status",
            "createdAt",
            "externalReference",
            "routingReversals",
            "_links",
        ]
        nullable_fields = [
            "settlementAmount",
            "metadata",
            "settlementId",
            "routingReversals",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
