"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListAllMethodsLocale(str, Enum):
    r"""Passing a locale will sort the payment methods in the preferred order
    for the country, and translate the payment method names in the corresponding language.
    """

    EN_US = "en_US"
    EN_GB = "en_GB"
    NL_NL = "nl_NL"
    NL_BE = "nl_BE"
    DE_DE = "de_DE"
    DE_AT = "de_AT"
    DE_CH = "de_CH"
    FR_FR = "fr_FR"
    FR_BE = "fr_BE"
    ES_ES = "es_ES"
    CA_ES = "ca_ES"
    PT_PT = "pt_PT"
    IT_IT = "it_IT"
    NB_NO = "nb_NO"
    SV_SE = "sv_SE"
    FI_FI = "fi_FI"
    DA_DK = "da_DK"
    IS_IS = "is_IS"
    HU_HU = "hu_HU"
    PL_PL = "pl_PL"
    LV_LV = "lv_LV"
    LT_LT = "lt_LT"


class ListAllMethodsAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListAllMethodsAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: Annotated[str, FieldMetadata(query=True)]
    r"""A three-character ISO 4217 currency code."""

    value: Annotated[str, FieldMetadata(query=True)]
    r"""A string containing an exact monetary amount in the given currency."""


class ListAllMethodsInclude(str, Enum):
    r"""This endpoint allows you to include additional information via the
    `include` query string parameter.
    """

    ISSUERS = "issuers"
    PRICING = "pricing"


class ListAllMethodsSequenceType(str, Enum):
    r"""Set this parameter to `first` to only return the methods that
    can be used for the first payment of a recurring sequence.

    Set it to `recurring` to only return methods that can be used for recurring payments or subscriptions.
    """

    ONEOFF = "oneoff"
    FIRST = "first"
    RECURRING = "recurring"


class ListAllMethodsRequestTypedDict(TypedDict):
    locale: NotRequired[ListAllMethodsLocale]
    r"""Passing a locale will sort the payment methods in the preferred order
    for the country, and translate the payment method names in the corresponding language.
    """
    amount: NotRequired[ListAllMethodsAmountTypedDict]
    r"""If supplied, only payment methods that support the amount and currency
    are returned.

    Example: `/v2/methods/all?amount[value]=100.00&amount[currency]=USD`
    """
    include: NotRequired[Nullable[ListAllMethodsInclude]]
    r"""This endpoint allows you to include additional information via the
    `include` query string parameter.
    """
    sequence_type: NotRequired[ListAllMethodsSequenceType]
    r"""Set this parameter to `first` to only return the methods that
    can be used for the first payment of a recurring sequence.

    Set it to `recurring` to only return methods that can be used for recurring payments or subscriptions.
    """
    profile_id: NotRequired[str]
    r"""The identifier referring to the [profile](get-profile) you wish to
    retrieve the resources for.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted. For
    organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
    """
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class ListAllMethodsRequest(BaseModel):
    locale: Annotated[
        Optional[ListAllMethodsLocale],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Passing a locale will sort the payment methods in the preferred order
    for the country, and translate the payment method names in the corresponding language.
    """

    amount: Annotated[
        Optional[ListAllMethodsAmount],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""If supplied, only payment methods that support the amount and currency
    are returned.

    Example: `/v2/methods/all?amount[value]=100.00&amount[currency]=USD`
    """

    include: Annotated[
        OptionalNullable[ListAllMethodsInclude],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""This endpoint allows you to include additional information via the
    `include` query string parameter.
    """

    sequence_type: Annotated[
        Optional[ListAllMethodsSequenceType],
        pydantic.Field(alias="sequenceType"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = ListAllMethodsSequenceType.ONEOFF
    r"""Set this parameter to `first` to only return the methods that
    can be used for the first payment of a recurring sequence.

    Set it to `recurring` to only return methods that can be used for recurring payments or subscriptions.
    """

    profile_id: Annotated[
        Optional[str],
        pydantic.Field(alias="profileId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The identifier referring to the [profile](get-profile) you wish to
    retrieve the resources for.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted. For
    organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
    """

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "locale",
            "amount",
            "include",
            "sequenceType",
            "profileId",
            "testmode",
        ]
        nullable_fields = ["include", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListAllMethodsBadRequestDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class ListAllMethodsBadRequestDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class ListAllMethodsBadRequestLinksTypedDict(TypedDict):
    documentation: ListAllMethodsBadRequestDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class ListAllMethodsBadRequestLinks(BaseModel):
    documentation: ListAllMethodsBadRequestDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class ListAllMethodsHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[ListAllMethodsBadRequestLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class ListAllMethodsHalJSONError(ClientError):
    r"""An error response object."""

    data: ListAllMethodsHalJSONErrorData

    def __init__(
        self,
        data: ListAllMethodsHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class ListAllMethodsID(str, Enum):
    r"""The unique identifier of the payment method. When used during [payment creation](create-payment), the payment
    method selection screen will be skipped.
    """

    ALMA = "alma"
    APPLEPAY = "applepay"
    BACS = "bacs"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    IDEAL = "ideal"
    IN3 = "in3"
    KBC = "kbc"
    KLARNA = "klarna"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    POINTOFSALE = "pointofsale"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class ListAllMethodsMinimumAmountTypedDict(TypedDict):
    r"""The minimum payment amount required to use this payment method."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListAllMethodsMinimumAmount(BaseModel):
    r"""The minimum payment amount required to use this payment method."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListAllMethodsMaximumAmountTypedDict(TypedDict):
    r"""The maximum payment amount allowed when using this payment method. If there is no method-specific maximum, `null`
    is returned instead.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListAllMethodsMaximumAmount(BaseModel):
    r"""The maximum payment amount allowed when using this payment method. If there is no method-specific maximum, `null`
    is returned instead.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListAllMethodsImageTypedDict(TypedDict):
    r"""URLs of images representing the payment method."""

    size1x: str
    r"""The URL pointing to an icon of 32 by 24 pixels."""
    size2x: str
    r"""The URL pointing to an icon of 64 by 48 pixels."""
    svg: str
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can
    scale to any desired size without compromising visual quality.
    """


class ListAllMethodsImage(BaseModel):
    r"""URLs of images representing the payment method."""

    size1x: str
    r"""The URL pointing to an icon of 32 by 24 pixels."""

    size2x: str
    r"""The URL pointing to an icon of 64 by 48 pixels."""

    svg: str
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can
    scale to any desired size without compromising visual quality.
    """


class ListAllMethodsStatus(str, Enum):
    r"""The payment method's activation status for this profile."""

    ACTIVATED = "activated"
    PENDING_BOARDING = "pending-boarding"
    PENDING_REVIEW = "pending-review"
    PENDING_EXTERNAL = "pending-external"
    REJECTED = "rejected"


class ListAllMethodsIssuerImageTypedDict(TypedDict):
    r"""URLs of images representing the issuer.
    required:
    - size1x
    - size2x
    - svg
    """

    size1x: NotRequired[str]
    r"""The URL pointing to an icon of 32 by 24 pixels."""
    size2x: NotRequired[str]
    r"""The URL pointing to an icon of 64 by 48 pixels."""
    svg: NotRequired[str]
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can
    scale to any desired size without compromising visual quality.
    """


class ListAllMethodsIssuerImage(BaseModel):
    r"""URLs of images representing the issuer.
    required:
    - size1x
    - size2x
    - svg
    """

    size1x: Optional[str] = None
    r"""The URL pointing to an icon of 32 by 24 pixels."""

    size2x: Optional[str] = None
    r"""The URL pointing to an icon of 64 by 48 pixels."""

    svg: Optional[str] = None
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can
    scale to any desired size without compromising visual quality.
    """


class ListAllMethodsIssuerTypedDict(TypedDict):
    id: str
    name: str
    r"""The full name of the issuer."""
    image: ListAllMethodsIssuerImageTypedDict
    r"""URLs of images representing the issuer.
    required:
    - size1x
    - size2x
    - svg
    """
    resource: NotRequired[str]


class ListAllMethodsIssuer(BaseModel):
    id: str

    name: str
    r"""The full name of the issuer."""

    image: ListAllMethodsIssuerImage
    r"""URLs of images representing the issuer.
    required:
    - size1x
    - size2x
    - svg
    """

    resource: Optional[str] = "issuer"


class ListAllMethodsMethodSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListAllMethodsMethodSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListAllMethodsMethodDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListAllMethodsMethodDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListAllMethodsMethodLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: ListAllMethodsMethodSelfTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: NotRequired[ListAllMethodsMethodDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListAllMethodsMethodLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[ListAllMethodsMethodSelf, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: Optional[ListAllMethodsMethodDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListAllMethodsFixedTypedDict(TypedDict):
    r"""The fixed price charged per payment."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListAllMethodsFixed(BaseModel):
    r"""The fixed price charged per payment."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class PricingTypedDict(TypedDict):
    description: str
    r"""A description of what the pricing applies to. For example, a specific country (`The Netherlands`) or a
    category of cards (`American Express`). If a `locale` is provided, the description may be translated.
    """
    fixed: ListAllMethodsFixedTypedDict
    r"""The fixed price charged per payment."""
    variable: str
    r"""The variable price charged per payment, as a percentage string."""
    fee_region: NotRequired[Nullable[str]]
    r"""Only present for credit card pricing. It will correspond with the `feeRegion` of credit card payments as
    returned in the [Payments API](get-payment).
    """


class Pricing(BaseModel):
    description: str
    r"""A description of what the pricing applies to. For example, a specific country (`The Netherlands`) or a
    category of cards (`American Express`). If a `locale` is provided, the description may be translated.
    """

    fixed: ListAllMethodsFixed
    r"""The fixed price charged per payment."""

    variable: str
    r"""The variable price charged per payment, as a percentage string."""

    fee_region: Annotated[OptionalNullable[str], pydantic.Field(alias="feeRegion")] = (
        UNSET
    )
    r"""Only present for credit card pricing. It will correspond with the `feeRegion` of credit card payments as
    returned in the [Payments API](get-payment).
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["feeRegion"]
        nullable_fields = ["feeRegion"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListAllMethodsMethodTypedDict(TypedDict):
    resource: str
    r"""Indicates the response contains a payment method object. Will always contain the string `method` for this
    endpoint.
    """
    id: ListAllMethodsID
    r"""The unique identifier of the payment method. When used during [payment creation](create-payment), the payment
    method selection screen will be skipped.
    """
    description: str
    r"""The full name of the payment method.

    If a `locale` parameter is provided, the name is translated to the given locale if possible.
    """
    minimum_amount: ListAllMethodsMinimumAmountTypedDict
    r"""The minimum payment amount required to use this payment method."""
    maximum_amount: Nullable[ListAllMethodsMaximumAmountTypedDict]
    r"""The maximum payment amount allowed when using this payment method. If there is no method-specific maximum, `null`
    is returned instead.
    """
    image: ListAllMethodsImageTypedDict
    r"""URLs of images representing the payment method."""
    status: Nullable[ListAllMethodsStatus]
    r"""The payment method's activation status for this profile."""
    links: ListAllMethodsMethodLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    issuers: NotRequired[List[ListAllMethodsIssuerTypedDict]]
    r"""**Optional include.** Array of objects for each 'issuer' that is available for this payment method. Only relevant
    for iDEAL, KBC/CBC, gift cards, and vouchers.
    """
    pricing: NotRequired[List[PricingTypedDict]]
    r"""**Optional include.** Array of objects describing the pricing configuration applicable for this payment method on
    your account.
    """


class ListAllMethodsMethod(BaseModel):
    resource: str
    r"""Indicates the response contains a payment method object. Will always contain the string `method` for this
    endpoint.
    """

    id: ListAllMethodsID
    r"""The unique identifier of the payment method. When used during [payment creation](create-payment), the payment
    method selection screen will be skipped.
    """

    description: str
    r"""The full name of the payment method.

    If a `locale` parameter is provided, the name is translated to the given locale if possible.
    """

    minimum_amount: Annotated[
        ListAllMethodsMinimumAmount, pydantic.Field(alias="minimumAmount")
    ]
    r"""The minimum payment amount required to use this payment method."""

    maximum_amount: Annotated[
        Nullable[ListAllMethodsMaximumAmount], pydantic.Field(alias="maximumAmount")
    ]
    r"""The maximum payment amount allowed when using this payment method. If there is no method-specific maximum, `null`
    is returned instead.
    """

    image: ListAllMethodsImage
    r"""URLs of images representing the payment method."""

    status: Nullable[ListAllMethodsStatus]
    r"""The payment method's activation status for this profile."""

    links: Annotated[ListAllMethodsMethodLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    issuers: Optional[List[ListAllMethodsIssuer]] = None
    r"""**Optional include.** Array of objects for each 'issuer' that is available for this payment method. Only relevant
    for iDEAL, KBC/CBC, gift cards, and vouchers.
    """

    pricing: Optional[List[Pricing]] = None
    r"""**Optional include.** Array of objects describing the pricing configuration applicable for this payment method on
    your account.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["issuers", "pricing"]
        nullable_fields = ["maximumAmount", "status"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListAllMethodsEmbeddedTypedDict(TypedDict):
    methods: List[ListAllMethodsMethodTypedDict]
    r"""An array of payment method objects. For a complete
    reference of the payment method object, refer to the [Get payment method endpoint](get-method)
    documentation.
    """


class ListAllMethodsEmbedded(BaseModel):
    methods: List[ListAllMethodsMethod]
    r"""An array of payment method objects. For a complete
    reference of the payment method object, refer to the [Get payment method endpoint](get-method)
    documentation.
    """


class ListAllMethodsSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListAllMethodsSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListAllMethodsDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListAllMethodsDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListAllMethodsLinksTypedDict(TypedDict):
    self_: ListAllMethodsSelfTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: ListAllMethodsDocumentationTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListAllMethodsLinks(BaseModel):
    self_: Annotated[ListAllMethodsSelf, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: ListAllMethodsDocumentation
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListAllMethodsResponseTypedDict(TypedDict):
    r"""A list of payment method objects. For a complete reference of the
    payment method object, refer to the [Get payment method endpoint](get-method) documentation.
    """

    count: int
    r"""The number of payment method objects in this result set. Results are **not** paginated."""
    embedded: ListAllMethodsEmbeddedTypedDict
    links: ListAllMethodsLinksTypedDict


class ListAllMethodsResponse(BaseModel):
    r"""A list of payment method objects. For a complete reference of the
    payment method object, refer to the [Get payment method endpoint](get-method) documentation.
    """

    count: int
    r"""The number of payment method objects in this result set. Results are **not** paginated."""

    embedded: Annotated[ListAllMethodsEmbedded, pydantic.Field(alias="_embedded")]

    links: Annotated[ListAllMethodsLinks, pydantic.Field(alias="_links")]
