"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListCapabilitiesStatus(str, Enum):
    UNREQUESTED = "unrequested"
    ENABLED = "enabled"
    DISABLED = "disabled"
    PENDING = "pending"


class ListCapabilitiesStatusReason(str, Enum):
    REQUIREMENT_PAST_DUE = "requirement-past-due"
    ONBOARDING_INFORMATION_NEEDED = "onboarding-information-needed"


class ListCapabilitiesRequirementStatus(str, Enum):
    r"""The status of the requirement depends on its due date.
    If no due date is given, the status will be `requested`.
    """

    CURRENTLY_DUE = "currently-due"
    PAST_DUE = "past-due"
    REQUESTED = "requested"


class ListCapabilitiesDashboardTypedDict(TypedDict):
    r"""If known, a deep link to the Mollie dashboard of the client, where the requirement can be fulfilled.
    For example, where necessary documents are to be uploaded.
    """

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListCapabilitiesDashboard(BaseModel):
    r"""If known, a deep link to the Mollie dashboard of the client, where the requirement can be fulfilled.
    For example, where necessary documents are to be uploaded.
    """

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class CapabilityLinksTypedDict(TypedDict):
    dashboard: NotRequired[ListCapabilitiesDashboardTypedDict]
    r"""If known, a deep link to the Mollie dashboard of the client, where the requirement can be fulfilled.
    For example, where necessary documents are to be uploaded.
    """


class CapabilityLinks(BaseModel):
    dashboard: Optional[ListCapabilitiesDashboard] = None
    r"""If known, a deep link to the Mollie dashboard of the client, where the requirement can be fulfilled.
    For example, where necessary documents are to be uploaded.
    """


class ListCapabilitiesRequirementTypedDict(TypedDict):
    id: NotRequired[str]
    r"""The name of this requirement, referring to the task to be fulfilled by the organization
    to enable or re-enable the capability. The name is unique among other requirements
    of the same capability.
    """
    status: NotRequired[ListCapabilitiesRequirementStatus]
    r"""The status of the requirement depends on its due date.
    If no due date is given, the status will be `requested`.
    """
    due_date: NotRequired[Nullable[str]]
    r"""Due date until the requirement must be fulfilled, if any. The date is shown in ISO-8601 format."""
    links: NotRequired[CapabilityLinksTypedDict]


class ListCapabilitiesRequirement(BaseModel):
    id: Optional[str] = None
    r"""The name of this requirement, referring to the task to be fulfilled by the organization
    to enable or re-enable the capability. The name is unique among other requirements
    of the same capability.
    """

    status: Optional[ListCapabilitiesRequirementStatus] = None
    r"""The status of the requirement depends on its due date.
    If no due date is given, the status will be `requested`.
    """

    due_date: Annotated[OptionalNullable[str], pydantic.Field(alias="dueDate")] = UNSET
    r"""Due date until the requirement must be fulfilled, if any. The date is shown in ISO-8601 format."""

    links: Annotated[Optional[CapabilityLinks], pydantic.Field(alias="_links")] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "status", "dueDate", "_links"]
        nullable_fields = ["dueDate"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CapabilityTypedDict(TypedDict):
    resource: NotRequired[str]
    r"""Always the word `capability` for this resource type."""
    name: NotRequired[str]
    r"""A unique name for this capability like `payments` / `settlements`."""
    status: NotRequired[ListCapabilitiesStatus]
    status_reason: NotRequired[Nullable[ListCapabilitiesStatusReason]]
    requirements: NotRequired[List[ListCapabilitiesRequirementTypedDict]]


class Capability(BaseModel):
    resource: Optional[str] = None
    r"""Always the word `capability` for this resource type."""

    name: Optional[str] = None
    r"""A unique name for this capability like `payments` / `settlements`."""

    status: Optional[ListCapabilitiesStatus] = None

    status_reason: Annotated[
        OptionalNullable[ListCapabilitiesStatusReason],
        pydantic.Field(alias="statusReason"),
    ] = UNSET

    requirements: Optional[List[ListCapabilitiesRequirement]] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["resource", "name", "status", "statusReason", "requirements"]
        nullable_fields = ["statusReason"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListCapabilitiesEmbeddedTypedDict(TypedDict):
    capabilities: NotRequired[List[CapabilityTypedDict]]


class ListCapabilitiesEmbedded(BaseModel):
    capabilities: Optional[List[Capability]] = None


class ListCapabilitiesDocumentationTypedDict(TypedDict):
    href: NotRequired[str]
    type: NotRequired[str]


class ListCapabilitiesDocumentation(BaseModel):
    href: Optional[str] = None

    type: Optional[str] = None


class ListCapabilitiesLinksTypedDict(TypedDict):
    documentation: NotRequired[ListCapabilitiesDocumentationTypedDict]


class ListCapabilitiesLinks(BaseModel):
    documentation: Optional[ListCapabilitiesDocumentation] = None


class ListCapabilitiesResponseTypedDict(TypedDict):
    r"""A list of capabilities."""

    count: NotRequired[int]
    r"""The number of items in this result set."""
    embedded: NotRequired[ListCapabilitiesEmbeddedTypedDict]
    links: NotRequired[ListCapabilitiesLinksTypedDict]


class ListCapabilitiesResponse(BaseModel):
    r"""A list of capabilities."""

    count: Optional[int] = None
    r"""The number of items in this result set."""

    embedded: Annotated[
        Optional[ListCapabilitiesEmbedded], pydantic.Field(alias="_embedded")
    ] = None

    links: Annotated[
        Optional[ListCapabilitiesLinks], pydantic.Field(alias="_links")
    ] = None
