
from __future__ import annotations

from typing import List
from typing_extensions import Required, TypedDict

__all__ = ["FileBatchCreateParams"]


class FileBatchCreateParams(TypedDict, total=False):
    file_ids: Required[List[str]]
    """
    A list of [File](https://platform.sgllm.com/docs/api-reference/files) IDs that
    the vector store should use. Useful for tools like `file_search` that can access
    files.
    """
