
from typing import Optional
from typing_extensions import Literal

from ...._models import BaseModel

__all__ = ["VectorStoreFile", "LastError"]


class LastError(BaseModel):
    code: Literal["internal_error", "file_not_found", "parsing_error", "unhandled_mime_type"]
    """One of `server_error` or `rate_limit_exceeded`."""

    message: str
    """A human-readable description of the error."""


class VectorStoreFile(BaseModel):
    id: str
    """The identifier, which can be referenced in API endpoints."""

    created_at: int
    """The Unix timestamp (in seconds) for when the vector store file was created."""

    last_error: Optional[LastError] = None
    """The last error associated with this vector store file.

    Will be `null` if there are no errors.
    """

    object: Literal["vector_store.file"]
    """The object type, which is always `vector_store.file`."""

    status: Literal["in_progress", "completed", "cancelled", "failed"]
    """
    The status of the vector store file, which can be either `in_progress`,
    `completed`, `cancelled`, or `failed`. The status `completed` indicates that the
    vector store file is ready for use.
    """

    usage_bytes: int
    """The total vector store usage in bytes.

    Note that this may be different from the original file size.
    """

    vector_store_id: str
    """
    The ID of the
    [vector store](https://platform.sgllm.com/docs/api-reference/vector-stores/object)
    that the [File](https://platform.sgllm.com/docs/api-reference/files) is
    attached to.
    """
