# -*- coding: utf-8 -*-

import re

TONES = ('', '\\', '/', '?', '~', '.')

TONE_NAMES = ('?', 'GRAVE', 'ACUTE', 'HOOK ABOVE', 'TILDE', 'DOT BELOW')

CHAR_ORDER_DICT = {'0': 0, '1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, 'a': 10, 'A': 11, 'à': 12, 'À': 13, 'á': 14, 'Á': 15, 'ả': 16, 'Ả': 17, 'ã': 18, 'Ã': 19, 'ạ': 20, 'Ạ': 21, 'ă': 22, 'Ă': 23, 'ằ': 24, 'Ằ': 25, 'ắ': 26, 'Ắ': 27, 'ẳ': 28, 'Ẳ': 29, 'ẵ': 30, 'Ẵ': 31, 'ặ': 32, 'Ặ': 33, 'â': 34, 'Â': 35, 'ầ': 36, 'Ầ': 37, 'ẩ': 38, 'Ẩ': 39, 'ẫ': 40, 'Ẫ': 41, 'ấ': 42, 'Ấ': 43, 'ậ': 44, 'Ậ': 45, 'b': 46, 'B': 47, 'c': 48, 'C': 49, 'd': 50, 'D': 51, 'đ': 52, 'Đ': 53, 'e': 54, 'E': 55, 'è': 56, 'È': 57, 'é': 58, 'É': 59, 'ẻ': 60, 'Ẻ': 61, 'ẽ': 62, 'Ẽ': 63, 'ẹ': 64, 'Ẹ': 65, 'ê': 66, 'Ê': 67, 'ề': 68, 'Ề': 69, 'ế': 70, 'Ế': 71, 'ể': 72, 'Ể': 73, 'ễ': 74, 'Ễ': 75, 'ệ': 76, 'Ệ': 77, 'f': 78, 'F': 79, 'g': 80, 'G': 81, 'h': 82, 'H': 83, 'i': 84, 'I': 85, 'ì': 86, 'Ì': 87, 'í': 88, 'Í': 89, 'ỉ': 90, 'Ỉ': 91, 'ĩ': 92, 'Ĩ': 93, 'ị': 94, 'Ị': 95, 'j': 96, 'J': 97, 'k': 98, 'K': 99, 'l': 100, 'L': 101, 'm': 102,
                   'M': 103, 'n': 104, 'N': 105, 'o': 106, 'O': 107, 'ò': 108, 'Ò': 109, 'ó': 110, 'Ó': 111, 'ỏ': 112, 'Ỏ': 113, 'õ': 114, 'Õ': 115, 'ọ': 116, 'Ọ': 117, 'ô': 118, 'Ô': 119, 'ồ': 120, 'Ồ': 121, 'ố': 122, 'Ố': 123, 'ổ': 124, 'Ổ': 125, 'ỗ': 126, 'Ỗ': 127, 'ộ': 128, 'Ộ': 129, 'ơ': 130, 'Ơ': 131, 'ờ': 132, 'Ờ': 133, 'ớ': 134, 'Ớ': 135, 'ở': 136, 'Ở': 137, 'ỡ': 138, 'Ỡ': 139, 'ợ': 140, 'Ợ': 141, 'p': 142, 'P': 143, 'q': 144, 'Q': 145, 'r': 146, 'R': 147, 's': 148, 'S': 149, 't': 150, 'T': 151, 'u': 152, 'U': 153, 'ù': 154, 'Ù': 155, 'ú': 156, 'Ú': 157, 'ủ': 158, 'Ủ': 159, 'ũ': 160, 'Ũ': 161, 'ụ': 162, 'Ụ': 163, 'ư': 164, 'Ư': 165, 'ừ': 166, 'Ừ': 167, 'ứ': 168, 'Ứ': 169, 'ử': 170, 'Ử': 171, 'ữ': 172, 'Ữ': 173, 'ự': 174, 'Ự': 175, 'v': 176, 'V': 177, 'w': 178, 'W': 179, 'x': 180, 'X': 181, 'y': 182, 'Y': 183, 'ỳ': 184, 'Ỳ': 185, 'ý': 186, 'Ý': 187, 'ỷ': 188, 'Ỷ': 189, 'ỹ': 190, 'Ỹ': 191, 'ỵ': 192, 'Ỵ': 193, 'z': 194, 'Z': 195}

CHAR_ORDER_STRING = r"0123456789aAàÀáÁảẢãÃạẠăĂằẰắẮẳẲẵẴặẶâÂầẦẩẨẫẪấẤậẬbBcCdDđĐeEèÈéÉẻẺẽẼẹẸêÊềỀếẾểỂễỄệỆfFgGhHiIìÌíÍỉỈĩĨịỊjJkKlLmMnNoOòÒóÓỏỎõÕọỌôÔồỒốỐổỔỗỖộỘơƠờỜớỚởỞỡỠợỢpPqQrRsStTuUùÙúÚủỦũŨụỤưƯừỪứỨửỬữỮựỰvVwWxXyYỳỲýÝỷỶỹỸỵỴzZ"

VIETNAMESE_CHARSET_REGEX = re.compile(
    r"[a-z àáảãạăằắẳẵặâầấẩẫậèéẻẽẹêềếểễệđìíỉĩịòóỏõọôồốổỗộơờớởỡợùúủũụưừứửữựỳýỷỹỵ]+", re.IGNORECASE)

NO_TONE_CHAR_TRANS = str.maketrans("àáảãạằắẳẵặầấẩẫậèéẻẽẹềếểễệìíỉĩịòóỏõọồốổỗộờớởỡợùúủũụừứửữựỳýỷỹỵÀÁẢÃẠẰẮẲẴẶẦẤẨẪẬÈÉẺẼẸỀẾỂỄỆÌÍỈĨỊÒÓỎÕỌỒỐỔỖỘỜỚỞỠỢÙÚỦŨỤỪỨỬỮỰỲÝỶỸỴ",
                                   "aaaaaăăăăăâââââeeeeeêêêêêiiiiioooooôôôôôơơơơơuuuuuưưưưưyyyyyAAAAAĂĂĂĂĂÂÂÂÂÂEEEEEÊÊÊÊÊIIIIIOOOOOÔÔÔÔÔƠƠƠƠƠUUUUUƯƯƯƯƯYYYYY")

# The following confusable characters are extracted from a subset of
# Unicode 15.0 confusables:
# https://www.unicode.org/Public/security/15.0.0/confusables.txt
CONFUSABLES = {
    '՝': "'",
    '＇': "'",
    '‘': "'",
    '’': "'",
    '‛': "'",
    '′': "'",
    '‵': "'",
    '՚': "'",
    '`': "'",
    '`': "'",
    '｀': "'",
    '´': "'",
    '΄': "'",
    '´': "'",
    '᾽': "'",
    '᾿': "'",
    '῾': "'",
    'ʹ': "'",
    'ʹ': "'",
    'ˈ': "'",
    'ˊ': "'",
    'ˋ': "'",
    '˴': "'",
    'ʻ': "'",
    'ʽ': "'",
    'ʼ': "'",
    'ʾ': "'",
    'ꞌ': "'",
    'ᑊ': "'",
    'ᛌ': "'",
    '﹍': '_',
    '﹎': '_',
    '﹏': '_',
    'Ꝛ': '2',
    'Ƨ': '2',
    'Ϩ': '2',
    'Ꙅ': '2',
    'ᒿ': '2',
    'ꛯ': '2',
    'Ɜ': '3',
    'Ȝ': '3',
    'Ʒ': '3',
    'Ꝫ': '3',
    'Ⳍ': '3',
    'З': '3',
    'Ӡ': '3',
    'Ꮞ': '4',
    'Ƽ': '5',
    'Ⳓ': '6',
    'б': '6',
    'Ꮾ': '6',
    'ଃ': '8',
    '৪': '8',
    '੪': '8',
    'ȣ': '8',
    'Ȣ': '8',
    '੧': '9',
    '୨': '9',
    '৭': '9',
    '൭': '9',
    'Ꝯ': '9',
    'Ⳋ': '9',
    '⍺': 'a',
    'ａ': 'a',
    'ɑ': 'a',
    'α': 'a',
    'а': 'a',
    'Ａ': 'A',
    'Α': 'A',
    'А': 'A',
    'Ꭺ': 'A',
    'ᗅ': 'A',
    'ꓮ': 'A',
    'Ƅ': 'b',
    'Ь': 'b',
    'Ꮟ': 'b',
    'ᑲ': 'b',
    'ᖯ': 'b',
    'Ｂ': 'B',
    'ℬ': 'B',
    'Ꞵ': 'B',
    'Β': 'B',
    'В': 'B',
    'Ᏼ': 'B',
    'ᗷ': 'B',
    'ꓐ': 'B',
    'ｃ': 'c',
    'ⅽ': 'c',
    'ᴄ': 'c',
    'ϲ': 'c',
    'ⲥ': 'c',
    'с': 'c',
    'ꮯ': 'c',
    'Ｃ': 'C',
    'Ⅽ': 'C',
    'ℂ': 'C',
    'ℭ': 'C',
    'Ϲ': 'C',
    'Ⲥ': 'C',
    'С': 'C',
    'Ꮯ': 'C',
    'ꓚ': 'C',
    'ⅾ': 'd',
    'ⅆ': 'd',
    'ԁ': 'd',
    'Ꮷ': 'd',
    'ᑯ': 'd',
    'ꓒ': 'd',
    'Ⅾ': 'D',
    'ⅅ': 'D',
    'Ꭰ': 'D',
    'ᗞ': 'D',
    'ᗪ': 'D',
    'ꓓ': 'D',
    '℮': 'e',
    'ｅ': 'e',
    'ℯ': 'e',
    'ⅇ': 'e',
    'ꬲ': 'e',
    'е': 'e',
    'ҽ': 'e',
    '⋿': 'E',
    'Ｅ': 'E',
    'ℰ': 'E',
    'Ε': 'E',
    'Е': 'E',
    'ⴹ': 'E',
    'Ꭼ': 'E',
    'ꓰ': 'E',
    'ꬵ': 'f',
    'ꞙ': 'f',
    'ſ': 'f',
    'ẝ': 'f',
    'ք': 'f',
    'ℱ': 'F',
    'Ꞙ': 'F',
    'Ϝ': 'F',
    'ᖴ': 'F',
    'ꓝ': 'F',
    'ｇ': 'g',
    'ℊ': 'g',
    'ɡ': 'g',
    'ᶃ': 'g',
    'ƍ': 'g',
    'ց': 'g',
    'Ԍ': 'G',
    'Ꮐ': 'G',
    'Ᏻ': 'G',
    'ꓖ': 'G',
    'ｈ': 'h',
    'ℎ': 'h',
    'һ': 'h',
    'հ': 'h',
    'Ꮒ': 'h',
    'Ｈ': 'H',
    'ℋ': 'H',
    'ℌ': 'H',
    'ℍ': 'H',
    'Η': 'H',
    'Ⲏ': 'H',
    'Н': 'H',
    'Ꮋ': 'H',
    'ᕼ': 'H',
    'ꓧ': 'H',
    '˛': 'i',
    '⍳': 'i',
    'ｉ': 'i',
    'ⅰ': 'i',
    'ℹ': 'i',
    'ⅈ': 'i',
    'ı': 'i',
    'ɪ': 'i',
    'ɩ': 'i',
    'ι': 'i',
    'ι': 'i',
    'ͺ': 'i',
    'і': 'i',
    'ꙇ': 'i',
    'ӏ': 'i',
    'ꭵ': 'i',
    'Ꭵ': 'i',
    'ｊ': 'j',
    'ⅉ': 'j',
    'ϳ': 'j',
    'ј': 'j',
    'Ｊ': 'J',
    'Ʝ': 'J',
    'Ϳ': 'J',
    'Ј': 'J',
    'Ꭻ': 'J',
    'ᒍ': 'J',
    'ꓙ': 'J',
    'K': 'K',
    'Ｋ': 'K',
    'Κ': 'K',
    'Ⲕ': 'K',
    'К': 'K',
    'Ꮶ': 'K',
    'ᛕ': 'K',
    'ꓗ': 'K',
    '|': 'l',
    '∣': 'l',
    '⏽': 'l',
    '￨': 'l',
    '۱': 'l',
    'I': 'l',
    'Ｉ': 'l',
    'Ⅰ': 'l',
    'ℐ': 'l',
    'ℑ': 'l',
    'Ɩ': 'l',
    'ｌ': 'l',
    'ⅼ': 'l',
    'ℓ': 'l',
    'ǀ': 'l',
    'Ι': 'l',
    'Ⲓ': 'l',
    'І': 'l',
    'Ӏ': 'l',
    'ⵏ': 'l',
    'ᛁ': 'l',
    'ꓲ': 'l',
    'Ⅼ': 'L',
    'ℒ': 'L',
    'Ⳑ': 'L',
    'Ꮮ': 'L',
    'ᒪ': 'L',
    'ꓡ': 'L',
    'Ｍ': 'M',
    'Ⅿ': 'M',
    'ℳ': 'M',
    'Μ': 'M',
    'Ϻ': 'M',
    'Ⲙ': 'M',
    'М': 'M',
    'Ꮇ': 'M',
    'ᗰ': 'M',
    'ᛖ': 'M',
    'ꓟ': 'M',
    'ո': 'n',
    'ռ': 'n',
    'Ｎ': 'N',
    'ℕ': 'N',
    'Ν': 'N',
    'Ⲛ': 'N',
    'ꓠ': 'N',
    'ం': 'o',
    'ಂ': 'o',
    'ം': 'o',
    'ං': 'o',
    '०': 'o',
    '੦': 'o',
    '૦': 'o',
    '௦': 'o',
    '౦': 'o',
    '೦': 'o',
    '൦': 'o',
    '๐': 'o',
    '໐': 'o',
    '၀': 'o',
    '۵': 'o',
    'ｏ': 'o',
    'ℴ': 'o',
    'ᴏ': 'o',
    'ᴑ': 'o',
    'ꬽ': 'o',
    'ο': 'o',
    'σ': 'o',
    'ⲟ': 'o',
    'о': 'o',
    'ჿ': 'o',
    'օ': 'o',
    'ഠ': 'o',
    'ဝ': 'o',
    '0': 'O',
    '০': 'O',
    '୦': 'O',
    '〇': 'O',
    'Ｏ': 'O',
    'Ο': 'O',
    'Ⲟ': 'O',
    'О': 'O',
    'Օ': 'O',
    'ⵔ': 'O',
    'ዐ': 'O',
    'ଠ': 'O',
    'ꓳ': 'O',
    '⍴': 'p',
    'ｐ': 'p',
    'ρ': 'p',
    'ϱ': 'p',
    'ⲣ': 'p',
    'р': 'p',
    'Ｐ': 'P',
    'ℙ': 'P',
    'Ρ': 'P',
    'Ⲣ': 'P',
    'Р': 'P',
    'Ꮲ': 'P',
    'ᑭ': 'P',
    'ꓑ': 'P',
    'ԛ': 'q',
    'գ': 'q',
    'զ': 'q',
    'ℚ': 'Q',
    'ⵕ': 'Q',
    'ꭇ': 'r',
    'ꭈ': 'r',
    'ᴦ': 'r',
    'ⲅ': 'r',
    'г': 'r',
    'ꮁ': 'r',
    'ℛ': 'R',
    'ℜ': 'R',
    'ℝ': 'R',
    'Ʀ': 'R',
    'Ꭱ': 'R',
    'Ꮢ': 'R',
    'ᖇ': 'R',
    'ꓣ': 'R',
    'ｓ': 's',
    'ꜱ': 's',
    'ƽ': 's',
    'ѕ': 's',
    'ꮪ': 's',
    'Ｓ': 'S',
    'Ѕ': 'S',
    'Տ': 'S',
    'Ꮥ': 'S',
    'Ꮪ': 'S',
    'ꓢ': 'S',
    '⊤': 'T',
    '⟙': 'T',
    'Ｔ': 'T',
    'Τ': 'T',
    'Ⲧ': 'T',
    'Т': 'T',
    'Ꭲ': 'T',
    'ꓔ': 'T',
    'ꞟ': 'u',
    'ᴜ': 'u',
    'ꭎ': 'u',
    'ꭒ': 'u',
    'ʋ': 'u',
    'υ': 'u',
    'ս': 'u',
    '∪': 'U',
    '⋃': 'U',
    'Ս': 'U',
    'ሀ': 'U',
    'ᑌ': 'U',
    'ꓴ': 'U',
    '∨': 'v',
    '⋁': 'v',
    'ｖ': 'v',
    'ⅴ': 'v',
    'ᴠ': 'v',
    'ν': 'v',
    'ѵ': 'v',
    'ꮩ': 'v',
    '۷': 'V',
    'Ⅴ': 'V',
    'Ѵ': 'V',
    'ⴸ': 'V',
    'Ꮩ': 'V',
    'ᐯ': 'V',
    'ꛟ': 'V',
    'ꓦ': 'V',
    'ɯ': 'w',
    'ᴡ': 'w',
    'ѡ': 'w',
    'ԝ': 'w',
    'ա': 'w',
    'ꮃ': 'w',
    'Ԝ': 'W',
    'Ꮃ': 'W',
    'Ꮤ': 'W',
    'ꓪ': 'W',
    '᙮': 'x',
    '×': 'x',
    '⤫': 'x',
    '⤬': 'x',
    '⨯': 'x',
    'ｘ': 'x',
    'ⅹ': 'x',
    'х': 'x',
    'ᕁ': 'x',
    'ᕽ': 'x',
    '᙭': 'X',
    '╳': 'X',
    'Ｘ': 'X',
    'Ⅹ': 'X',
    'Ꭓ': 'X',
    'Χ': 'X',
    'Ⲭ': 'X',
    'Х': 'X',
    'ⵝ': 'X',
    'ᚷ': 'X',
    'ꓫ': 'X',
    'ɣ': 'y',
    'ᶌ': 'y',
    'ｙ': 'y',
    'ʏ': 'y',
    'ỿ': 'y',
    'ꭚ': 'y',
    'γ': 'y',
    'ℽ': 'y',
    'у': 'y',
    'ү': 'y',
    'ყ': 'y',
    'Ｙ': 'Y',
    'Υ': 'Y',
    'ϒ': 'Y',
    'Ⲩ': 'Y',
    'У': 'Y',
    'Ү': 'Y',
    'Ꭹ': 'Y',
    'Ꮍ': 'Y',
    'ꓬ': 'Y',
    'ᴢ': 'z',
    'ꮓ': 'z',
    'Ｚ': 'Z',
    'ℤ': 'Z',
    'ℨ': 'Z',
    'Ζ': 'Z',
    'Ꮓ': 'Z',
    'ꓜ': 'Z',
}

CONFUSABLE_OVERRIDES = {
    '“': '"',
    '”': '"',
    'O': '0',
    'ᴀ': 'a',
    'ʙ': 'b',
    'ß': 'b',
    'в': 'b',
    'ᏼ': 'b',
    'ͼ': 'c',
    'ċ': 'c',
    'ᴅ': 'd',
    'ᴆ': 'đ',
    'ᵭ': 'đ',
    'ƌ': 'đ',
    'ꜰ': 'f',
    'ɢ': 'g',
    'ǥ': 'g',
    'н': 'h',
    'ɦ': 'h',
    '𝚒': 'i',
    'เ': 'i',
    'ⱪ': 'k',
    'ᴋ': 'k',
    'к': 'k',
    'Ҝ': 'k',
    '𝚕': 'l',
    'ʟ': 'l',
    '꒒': 'l',
    'ᴍ': 'm',
    'м': 'm',
    'ɴ': 'n',
    'ท': 'n',
    'п': 'n',
    'ṅ': 'n',
    '𝚘': 'o',
    'ѻ': 'o',
    'ք': 'p',
    'ᴘ': 'p',
    'ק': 'p',
    'ꞯ': 'q',
    '𝚚': 'q',
    'ɾ': 'r',
    '𝚜': 's',
    'Ꭶ': 's',
    'т': 't',
    'τ': 't',
    '𝚡': 'x',
    'ÿ': 'y',
    'ɣ': 'y',
}

CONFUSABLE_CHAR_TRANS = str.maketrans({**CONFUSABLES, **CONFUSABLE_OVERRIDES})
