
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.account.privacy_rules import TypeAccountPrivacyRules


if TYPE_CHECKING:
    from ...types.input_privacy_key import TypeInputPrivacyKey
    from ...types.input_privacy_rule import TypeInputPrivacyRule


class SetPrivacy(TLRequest[TypeAccountPrivacyRules]):
    """
    Change privacy settings of current account

    Raises:
        `400`PrivacyKeyInvalidError: The privacy key is invalid.
        `400`PrivacyTooLongError: Too many privacy rules were specified, the current limit is 1000.
        `400`PrivacyValueInvalidError: The specified privacy rule combination is invalid.

    """

    _id = 0XC9F81CE8
    _result_id = 0X27DC01AA

    def __init__(
        self,
        key: 'TypeInputPrivacyKey',
        rules: List['TypeInputPrivacyRule']
    ):

        """
        Change privacy settings of current account

        Args:
            key ('TypeInputPrivacyKey'): New privacy rule
            rules (List['TypeInputPrivacyRule']): Peers to which the privacy rule will apply.
        """

        self.key = key
        self.rules = rules

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe8\x1c\xf8\xc9' if boxed else b'') as writer:
            writer.object(
                self.key,
                group_id=0XA90825F7
            )
            writer.vector(
                self.rules,
                lambda value: writer.object(
                    value,
                    group_id=0XCA2848B1
                )
            )

            return writer.getvalue()