
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...types.wall_paper import TypeWallPaper
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_file import TypeInputFile
    from ...types.wall_paper_settings import TypeWallPaperSettings


class UploadWallPaper(TLRequest[TypeWallPaper]):
    """
    Create and upload a new [wallpaper](https://core.telegram.org/api/wallpapers)

    Raises:
        `400`WallpaperFileInvalidError: The specified wallpaper file is invalid.
        `400`WallpaperMimeInvalidError: The specified wallpaper MIME type is invalid.

    """

    _id = 0XE39A8F03
    _result_id = 0XC6E3E0E2

    def __init__(
        self,
        file: 'TypeInputFile',
        mime_type: str,
        settings: 'TypeWallPaperSettings',
        for_chat: bool = False
    ):

        """
        Create and upload a new [wallpaper](https://core.telegram.org/api/wallpapers)

        Args:
            file ('TypeInputFile'): The JPG/PNG wallpaper
            mime_type (str): MIME type of uploaded wallpaper
            settings ('TypeWallPaperSettings'): Wallpaper settings
            for_chat (bool, optional): Set this flag when uploading wallpapers to be passed to [messages.setChatWallPaper](https://core.telegram.org/method/messages.setChatWallPaper).
        """

        self.file = file
        self.mime_type = mime_type
        self.settings = settings
        self.for_chat = for_chat

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x03\x8f\x9a\xe3' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.for_chat, 0)
                writer.object(
                    self.file,
                    group_id=0XB7247676
                )
                writer.string(self.mime_type)
                writer.object(
                    self.settings,
                    group_id=0X28E332CF
                )

            return writer.getvalue()