
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.auth.login_token import TypeAuthLoginToken


class ExportLoginToken(TLRequest[TypeAuthLoginToken]):
    """
    Generate a login token, for [login via QR code](https://core.telegram.org/api/qr-login). 
    The generated login token should be encoded using base64url, then shown as a tg://login?token=base64encodedtoken [deep link](https://core.telegram.org/api/links#qr-code-login-links) in the QR code.

    Raises:
        `400`ApiIdInvalidError: API ID invalid.
        `400`ApiIdPublishedFloodError: This API id was published somewhere, you can't use it now.

    """

    _id = 0XB7E085FE
    _result_id = 0X4C003CCD

    def __init__(
        self,
        api_id: int,
        api_hash: str,
        except_ids: List[int]
    ):

        """
        Generate a login token, for [login via QR code](https://core.telegram.org/api/qr-login). 
        The generated login token should be encoded using base64url, then shown as a tg://login?token=base64encodedtoken [deep link](https://core.telegram.org/api/links#qr-code-login-links) in the QR code.

        Args:
            api_id (int): Application identifier (see. [App configuration](https://core.telegram.org/myapp))
            api_hash (str): Application identifier hash (see. [App configuration](https://core.telegram.org/myapp))
            except_ids (List[int]): List of already logged-in user IDs, to prevent logging in twice with the same user
        """

        self.api_id = api_id
        self.api_hash = api_hash
        self.except_ids = except_ids

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xfe\x85\xe0\xb7' if boxed else b'') as writer:
            writer.int(self.api_id)
            writer.string(self.api_hash)
            writer.vector(
                self.except_ids,
                writer.long
            )

            return writer.getvalue()