
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_geo_point import TypeInputGeoPoint


class GetLocated(TLRequest[TypeUpdates]):
    """
    Get users and geochats near you, see [here](https://core.telegram.org/api/nearby) for more info.

    Raises:
        `406`BusinessAddressActiveError: The user is currently advertising a [Business Location](https://core.telegram.org/api/business#location), the location may only be changed (or removed) using [account.updateBusinessLocation &raquo;](https://core.telegram.org/method/account.updateBusinessLocation).  .
        `406`UserpicPrivacyRequiredError: You need to disable privacy settings for your profile picture in order to make your geolocation public.
        `406`UserpicUploadRequiredError: You must have a profile picture to publish your geolocation.
        `400`GeoPointInvalidError: Invalid geoposition provided.

    """

    _id = 0XD348BC44
    _result_id = 0XD68D29C0

    def __init__(
        self,
        geo_point: 'TypeInputGeoPoint',
        background: bool = False,
        self_expires: Optional[int] = None
    ):

        """
        Get users and geochats near you, see [here](https://core.telegram.org/api/nearby) for more info.

        Args:
            geo_point ('TypeInputGeoPoint'): Geolocation
            background (bool, optional): While the geolocation of the current user is public, clients should update it in the background every half-an-hour or so, while setting this flag. Do this only if the new location is more than 1 KM away from the previous one, or if the previous location is unknown.
            self_expires (Optional[int], optional): If set, the geolocation of the current user will be public for the specified number of seconds; pass 0x7fffffff to disable expiry, 0 to make the current geolocation private; if the flag isn't set, no changes will be applied.
        """

        self.geo_point = geo_point
        self.background = background
        self.self_expires = self_expires

    def to_bytes(self, boxed: bool=True):
        with Writer(b'D\xbcH\xd3' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.background, 1)
                writer.object(
                    self.geo_point,
                    group_id=0XF78B3873
                )

                if flags(self.self_expires, 0):
                    writer.int(self.self_expires)

            return writer.getvalue()