
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, TypeVar, Optional
from ...gadgets.tlobject import TLRequest
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..types.jsonvalue import TypeJSONValue
    from ..types.input_client_proxy import TypeInputClientProxy


X = TypeVar('X')


class InitConnection(TLRequest[X]):
    """
    Initialize connection

    **Bots can use this method**

    Raises:
        `400`ConnectionLayerInvalidError: Layer invalid.

    """

    _id = 0XC1CD5EA9

    def __init__(
        self,
        api_id: int,
        device_model: str,
        system_version: str,
        app_version: str,
        system_lang_code: str,
        lang_pack: str,
        lang_code: str,
        query: TLRequest[X],
        proxy: Optional['TypeInputClientProxy'] = None,
        params: Optional['TypeJSONValue'] = None
    ):

        """
        Initialize connection

        **Bots can use this method**

        Args:
            api_id (int): Application identifier (see. [App configuration](https://core.telegram.org/myapp))
            device_model (str): Device model
            system_version (str): Operation system version
            app_version (str): Application version
            system_lang_code (str): Code for the language used on the device's OS, ISO 639-1 standard
            lang_pack (str): Platform identifier (i.e. android, tdesktop, etc).
            lang_code (str): Either an ISO 639-1 language code or a language pack name obtained from a [language pack link](https://core.telegram.org/api/links#language-pack-links).
            query (TLRequest[X]): The query itself
            proxy (Optional['TypeInputClientProxy'], optional): Info about an MTProto proxy
            params (Optional['TypeJSONValue'], optional): Additional initConnection parameters. For now, only the tz_offset field is supported, for specifying the timezone offset in seconds.
        """

        self.api_id = api_id
        self.device_model = device_model
        self.system_version = system_version
        self.app_version = app_version
        self.system_lang_code = system_lang_code
        self.lang_pack = lang_pack
        self.lang_code = lang_code
        self.query = query
        self.proxy = proxy
        self.params = params

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa9^\xcd\xc1' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.int(self.api_id)
                writer.string(self.device_model)
                writer.string(self.system_version)
                writer.string(self.app_version)
                writer.string(self.system_lang_code)
                writer.string(self.lang_pack)
                writer.string(self.lang_code)

                if flags(self.proxy, 0):
                    writer.object(
                        self.proxy,
                        group_id=0X990960D5
                    )

                if flags(self.params, 1):
                    writer.object(
                        self.params,
                        group_id=0XBBD8AEDA
                    )
                writer.object(
                    self.query,
                    base_type=TLRequest
                )

            return writer.getvalue()