
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.lang_pack_string import TypeLangPackString


class GetStrings(TLRequest[List[TypeLangPackString]]):
    """
    Get strings from a language pack

    Raises:
        `400`LangCodeNotSupportedError: The specified language code is not supported.
        `400`LangPackInvalidError: The provided language pack is invalid.

    """

    _id = 0XEFEA3803

    def __init__(
        self,
        lang_pack: str,
        lang_code: str,
        keys: List[str]
    ):

        """
        Get strings from a language pack

        Args:
            lang_pack (str): Platform identifier (i.e. android, tdesktop, etc).
            lang_code (str): Either an ISO 639-1 language code or a language pack name obtained from a [language pack link](https://core.telegram.org/api/links#language-pack-links).
            keys (List[str]): Strings to get
        """

        self.lang_pack = lang_pack
        self.lang_code = lang_code
        self.keys = keys

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x038\xea\xef' if boxed else b'') as writer:
            writer.string(self.lang_pack)
            writer.string(self.lang_code)
            writer.vector(
                self.keys,
                writer.string
            )

            return writer.getvalue()