
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List, Optional
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.invited_users import TypeMessagesInvitedUsers


if TYPE_CHECKING:
    from ...types.input_user import TypeInputUser


class CreateChat(TLRequest[TypeMessagesInvitedUsers]):
    """
    Creates a new chat.

    Raises:
        `500`ChatIdGenerateFailedError: Failure while generating the chat ID.
        `400`ChatInvalidError: Invalid chat.
        `400`ChatTitleEmptyError: No chat title provided.
        `400`InputUserDeactivatedError: The specified user was deleted.
        `400`TtlPeriodInvalidError: The specified TTL period is invalid.
        `400`UsersTooFewError: Not enough users (to create a chat, for example).
        `406`UserRestrictedError: You're spamreported, you can't create channels or chats.

    """

    _id = 0X92CEDDD4
    _result_id = 0X5D9C0B42

    def __init__(
        self,
        users: List['TypeInputUser'],
        title: str,
        ttl_period: Optional[int] = None
    ):

        """
        Creates a new chat.

        Args:
            users (List['TypeInputUser']): List of user IDs to be invited
            title (str): Chat name
            ttl_period (Optional[int], optional): Time-to-live of all messages that will be sent in the chat: once message.date+message.ttl_period === time(), the message will be deleted on the server, and must be deleted locally as well. You can use [messages.setDefaultHistoryTTL](https://core.telegram.org/method/messages.setDefaultHistoryTTL) to edit this value later.
        """

        self.users = users
        self.title = title
        self.ttl_period = ttl_period

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd4\xdd\xce\x92' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.vector(
                    self.users,
                    lambda value: writer.object(
                        value,
                        group_id=0XB628962F
                    )
                )
                writer.string(self.title)

                if flags(self.ttl_period, 0):
                    writer.int(self.ttl_period)

            return writer.getvalue()