
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List, Optional
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_media import TypeInputMedia
    from ...types.reply_markup import TypeReplyMarkup
    from ...types.message_entity import TypeMessageEntity
    from ...types.input_bot_inline_message_id import TypeInputBotInlineMessageID


class EditInlineBotMessage(TLRequest[bool]):
    """
    Edit an inline bot message

    **Bots can use this method**

    Raises:
        `400`ButtonDataInvalidError: The data of one or more of the buttons you provided is invalid.
        `400`EntityBoundsInvalidError: A specified [entity offset or length](https://core.telegram.org/api/entities#entity-length) is invalid, see [here &raquo;](https://core.telegram.org/api/entities#entity-length) for info on how to properly compute the entity offset/length.
        `400`MessageIdInvalidError: The provided message id is invalid.
        `400`MessageNotModifiedError: The provided message data is identical to the previous message data, the message wasn't modified.

    """

    _id = 0X83557DBA
    _result_id = 0X43B904E1

    def __init__(
        self,
        id: 'TypeInputBotInlineMessageID',
        no_webpage: bool = False,
        invert_media: bool = False,
        message: Optional[str] = None,
        media: Optional['TypeInputMedia'] = None,
        reply_markup: Optional['TypeReplyMarkup'] = None,
        entities: Optional[List['TypeMessageEntity']] = None
    ):

        """
        Edit an inline bot message

        **Bots can use this method**

        Args:
            id ('TypeInputBotInlineMessageID'): Sent inline message ID
            no_webpage (bool, optional): Disable webpage preview
            invert_media (bool, optional): If set, any eventual webpage preview will be shown on top of the message instead of at the bottom.
            message (Optional[str], optional): Message
            media (Optional['TypeInputMedia'], optional): Media
            reply_markup (Optional['TypeReplyMarkup'], optional): Reply markup for inline keyboards
            entities (Optional[List['TypeMessageEntity']], optional): [Message entities for styled text](https://core.telegram.org/api/entities)
        """

        self.id = id
        self.no_webpage = no_webpage
        self.invert_media = invert_media
        self.message = message
        self.media = media
        self.reply_markup = reply_markup
        self.entities = entities

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xba}U\x83' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.no_webpage, 1)
                flags(self.invert_media, 16)
                writer.object(
                    self.id,
                    group_id=0XE8D574CF
                )

                if flags(self.message, 11):
                    writer.string(self.message)

                if flags(self.media, 14):
                    writer.object(
                        self.media,
                        group_id=0XCEC6DE21
                    )

                if flags(self.reply_markup, 2):
                    writer.object(
                        self.reply_markup,
                        group_id=0X146C1631
                    )

                if flags(self.entities, 3):
                    writer.vector(
                        self.entities,
                        lambda value: writer.object(
                            value,
                            group_id=0X3CDFF38A
                        )
                    )

            return writer.getvalue()