
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.messages import TypeMessagesMessages


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer


class GetHistory(TLRequest[TypeMessagesMessages]):
    """
    Returns the conversation history with one interlocutor / within a chat

    Raises:
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`ChatIdInvalidError: The provided chat id is invalid.
        `400`MsgIdInvalidError: Invalid message ID provided.
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`TakeoutInvalidError: The specified takeout ID is invalid.
        `406`ChannelPrivateError: You haven't joined this channel/supergroup.

    """

    _id = 0X4423E6C5
    _result_id = 0XC8BB9188

    def __init__(
        self,
        peer: 'TypeInputPeer',
        offset_id: int,
        offset_date: int,
        add_offset: int,
        limit: int,
        max_id: int,
        min_id: int,
        hash: int
    ):

        """
        Returns the conversation history with one interlocutor / within a chat

        Args:
            peer ('TypeInputPeer'): Target peer
            offset_id (int): Only return messages starting from the specified message ID
            offset_date (int): Only return messages sent before the specified date
            add_offset (int): Number of list elements to be skipped, negative values are also accepted.
            limit (int): Number of results to return
            max_id (int): If a positive value was transferred, the method will return only messages with IDs less than max_id
            min_id (int): If a positive value was transferred, the method will return only messages with IDs more than min_id
            hash (int): [Result hash](https://core.telegram.org/api/offsets)
        """

        self.peer = peer
        self.offset_id = offset_id
        self.offset_date = offset_date
        self.add_offset = add_offset
        self.limit = limit
        self.max_id = max_id
        self.min_id = min_id
        self.hash = hash

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc5\xe6#D' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0X995DB9DF
            )
            writer.int(self.offset_id)
            writer.int(self.offset_date)
            writer.int(self.add_offset)
            writer.int(self.limit)
            writer.int(self.max_id)
            writer.int(self.min_id)
            writer.long(self.hash)

            return writer.getvalue()