
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.message_reactions_list import TypeMessagesMessageReactionsList


if TYPE_CHECKING:
    from ...types.reaction import TypeReaction
    from ...types.input_peer import TypeInputPeer


class GetMessageReactionsList(TLRequest[TypeMessagesMessageReactionsList]):
    """
    Get [message reaction](https://core.telegram.org/api/reactions) list, along with the sender of each reaction.

    Raises:
        `403`BroadcastForbiddenError: Channel poll voters and reactions cannot be fetched to prevent deanonymization.
        `400`MsgIdInvalidError: Invalid message ID provided.

    """

    _id = 0X461B3F48
    _result_id = 0X533A36D2

    def __init__(
        self,
        peer: 'TypeInputPeer',
        id: int,
        limit: int,
        reaction: Optional['TypeReaction'] = None,
        offset: Optional[str] = None
    ):

        """
        Get [message reaction](https://core.telegram.org/api/reactions) list, along with the sender of each reaction.

        Args:
            peer ('TypeInputPeer'): Peer
            id (int): Message ID
            limit (int): Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
            reaction (Optional['TypeReaction'], optional): Get only reactions of this type
            offset (Optional[str], optional): Offset for pagination (taken from the next_offset field of the returned [messages.MessageReactionsList](https://core.telegram.org/type/messages.MessageReactionsList)); empty in the first request.
        """

        self.peer = peer
        self.id = id
        self.limit = limit
        self.reaction = reaction
        self.offset = offset

    def to_bytes(self, boxed: bool=True):
        with Writer(b'H?\x1bF' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )
                writer.int(self.id)

                if flags(self.reaction, 0):
                    writer.object(
                        self.reaction,
                        group_id=0X19F930D1
                    )

                if flags(self.offset, 1):
                    writer.string(self.offset)
                writer.int(self.limit)

            return writer.getvalue()